/*
 * Decompiled with CFR 0.152.
 */
package com.adarshr.gradle.testlogger.logger;

import com.adarshr.gradle.testlogger.TestDescriptorWrapper;
import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.TestResultWrapper;
import com.adarshr.gradle.testlogger.logger.ConsoleLogger;
import com.adarshr.gradle.testlogger.logger.OutputCollector;
import com.adarshr.gradle.testlogger.logger.TestLogger;
import com.adarshr.gradle.testlogger.theme.Theme;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;

public class TestLoggerAdapter
implements TestLogger,
GroovyObject {
    protected final Theme theme;
    protected final ConsoleLogger logger;
    protected final OutputCollector outputCollector;
    protected final TestLoggerExtension testLoggerExtension;
    private final Deque<TestDescriptorWrapper> ancestors;
    private final Map<String, TestDescriptorWrapper> descriptorCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public TestLoggerAdapter(Logger logger, TestLoggerExtension testLoggerExtension, Theme theme) {
        OutputCollector outputCollector;
        Theme theme2;
        TestLoggerExtension testLoggerExtension2;
        ConsoleLogger consoleLogger;
        MetaClass metaClass;
        ConcurrentHashMap<String, TestDescriptorWrapper> concurrentHashMap = new ConcurrentHashMap<String, TestDescriptorWrapper>();
        this.descriptorCache = concurrentHashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.logger = consoleLogger = new ConsoleLogger(logger, testLoggerExtension.getLogLevel());
        this.testLoggerExtension = testLoggerExtension2 = testLoggerExtension;
        this.theme = theme2 = theme;
        this.outputCollector = outputCollector = new OutputCollector();
        ArrayDeque<TestDescriptorWrapper> arrayDeque = new ArrayDeque<TestDescriptorWrapper>();
        this.ancestors = arrayDeque;
    }

    public final void beforeSuite(TestDescriptor descriptor) {
        TestDescriptorWrapper wrappedDescriptor = this.checkAndWrap(descriptor);
        this.ancestors.push(wrappedDescriptor);
        if (this.isGradleSuite(wrappedDescriptor.getName())) {
            this.ancestors.clear();
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)descriptor.getParent())) {
            this.logger.logNewLine();
        }
        this.beforeSuite(wrappedDescriptor);
    }

    protected void beforeSuite(TestDescriptorWrapper descriptor) {
    }

    public final void afterSuite(TestDescriptor descriptor, TestResult result) {
        if (!this.ancestors.isEmpty()) {
            this.ancestors.pop();
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)descriptor.getParent())) {
            this.ancestors.clear();
        }
        this.afterSuite(this.checkAndWrap(descriptor), this.wrap(result));
        this.descriptorCache.remove(TestLoggerAdapter.id(descriptor));
    }

    protected void afterSuite(TestDescriptorWrapper descriptor, TestResultWrapper result) {
    }

    public final void beforeTest(TestDescriptor descriptor) {
        this.beforeTest(this.checkAndWrap(descriptor));
    }

    protected void beforeTest(TestDescriptorWrapper descriptor) {
    }

    public final void afterTest(TestDescriptor descriptor, TestResult result) {
        this.afterTest(this.checkAndWrap(descriptor), this.wrap(result));
        this.descriptorCache.remove(TestLoggerAdapter.id(descriptor));
    }

    protected void afterTest(TestDescriptorWrapper descriptor, TestResultWrapper result) {
    }

    public void onOutput(TestDescriptor descriptor, TestOutputEvent outputEvent) {
        Boolean bl = this.testLoggerExtension.getShowStandardStreams();
        if (bl == null ? false : bl) {
            this.outputCollector.collect(this.checkAndWrap(descriptor), outputEvent.getMessage());
        }
    }

    private TestDescriptorWrapper checkAndWrap(TestDescriptor descriptor) {
        Reference descriptor2 = new Reference((Object)descriptor);
        public final class _checkAndWrap_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference descriptor;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _checkAndWrap_closure1(Object _outerInstance, Object _thisObject, Reference descriptor) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.descriptor = reference = descriptor;
            }

            public TestDescriptorWrapper doCall(Object it) {
                return (TestDescriptorWrapper)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((TestLoggerAdapter)this.getThisObject()), (String)"wrap", (Object)new Object[]{this.descriptor.get()}), TestDescriptorWrapper.class);
            }

            @Generated
            public TestDescriptor getDescriptor() {
                return (TestDescriptor)ScriptBytecodeAdapter.castToType((Object)this.descriptor.get(), TestDescriptor.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public TestDescriptorWrapper doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkAndWrap_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (TestDescriptorWrapper)ScriptBytecodeAdapter.castToType((Object)this.descriptorCache.computeIfAbsent(TestLoggerAdapter.id((TestDescriptor)descriptor2.get()), (Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _checkAndWrap_closure1(this, this, descriptor2)), Function.class)), TestDescriptorWrapper.class);
    }

    private static String id(TestDescriptor descriptor) {
        CallSite[] callSiteArray = TestLoggerAdapter.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)descriptor)));
    }

    protected TestDescriptorWrapper wrap(TestDescriptor descriptor) {
        return new TestDescriptorWrapper(descriptor, this.testLoggerExtension, DefaultGroovyMethods.reverse((List)DefaultGroovyMethods.toList(this.ancestors)));
    }

    protected TestResultWrapper wrap(TestResult result) {
        return new TestResultWrapper(result, this.testLoggerExtension);
    }

    protected boolean isGradleSuite(String name) {
        return name.startsWith("Gradle Test Executor") || name.startsWith("Gradle suite") || name.startsWith("Gradle test");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TestLoggerAdapter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "id";
        stringArray[1] = "properties";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[2];
        TestLoggerAdapter.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(TestLoggerAdapter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = TestLoggerAdapter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

