/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.RevokedCertificate;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRL
implements ASN1Object,
Externalizable {
    private ASN1Sequence tbsCertList = null;
    private AlgorithmIdentifier sigAlgID = null;
    private byte[] sigBytes = null;
    private X500Name issuer;
    private Date thisUpdate = new Date();
    private Date nextUpdate = null;
    private LinkedHashMap<BigInteger, RevokedCertificate> revokedCertificates = null;
    private X509ExtensionSet extensions = null;
    private PrivateKey privKey;
    private oracle.security.crypto.core.PublicKey pubKey;
    private X509Certificate issuerCert;
    private int version;
    private ASN1Sequence contents = null;
    X509CRLImpl crlImpl = new X509CRLImpl();

    public CRL() {
    }

    public CRL(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public CRL(File f) throws IOException {
        this(new FileInputStream(f));
    }

    public CRL(URL url) throws IOException {
        this(url.openStream());
    }

    public CRL(X509 issuer) {
        this.setIssuer(issuer.getSubject());
        this.setPublicKey(issuer.getPublicKey());
    }

    public CRL(X509 issuer, InputStream is) throws IOException {
        this(issuer);
        this.input(is);
    }

    public CRL(X509 issuer, File f) throws FileNotFoundException, IOException {
        this(issuer);
        FileInputStream fis = new FileInputStream(f);
        this.input(fis);
        fis.close();
    }

    public CRL(X509 issuer, URL url) throws IOException {
        this(issuer);
        InputStream uis = url.openStream();
        this.input(uis);
        uis.close();
    }

    public CRL(X500Name issuer, oracle.security.crypto.core.PrivateKey privKey, Date thisUpdate, Date nextUpdate, Vector<? extends RevokedCertificate> revokedCertificates) {
        this(issuer, privKey, thisUpdate, nextUpdate, (List<? extends RevokedCertificate>)revokedCertificates);
    }

    public CRL(X500Name issuer, oracle.security.crypto.core.PrivateKey privKey, Date thisUpdate, Date nextUpdate, List<? extends RevokedCertificate> revokedCertificates) {
        this(issuer, privKey);
        this.setDates(thisUpdate, nextUpdate);
        this.setRevokedCertificates(revokedCertificates);
    }

    public CRL(X500Name issuer, oracle.security.crypto.core.PrivateKey privKey, int days) {
        this(issuer, privKey);
        if (days > 0) {
            this.setDates(days);
        }
    }

    public CRL(X500Name issuer, oracle.security.crypto.core.PrivateKey privKey, int days, AlgorithmIdentifier sigAlg) {
        this(issuer, privKey, days);
        this.setSigAlgID(sigAlg);
    }

    public CRL(X500Name issuer, oracle.security.crypto.core.PrivateKey privKey) {
        this.setIssuer(issuer);
        this.setPrivateKey(privKey);
    }

    public static CRL toCRL(X509CRL crl) {
        if (crl instanceof X509CRLImpl) {
            return ((X509CRLImpl)crl).toCRL();
        }
        try {
            return new CRL((InputStream)new UnsyncByteArrayInputStream(crl.getEncoded()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (CRLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setIssuer(X500Name issuer) {
        this.issuer = issuer;
        this.reset();
    }

    public void setIssuerCertificate(X509 issuerCert) {
        this.setIssuerCertificate(issuerCert.toX509Certificate());
    }

    public void setIssuerCertificate(X509Certificate ic) {
        this.issuerCert = ic;
        if (this.issuer == null) {
            if (ic instanceof X509.X509CertificateImpl) {
                this.setIssuer(((X509.X509CertificateImpl)ic).toX509().getIssuer());
            } else {
                this.setIssuer(X500Name.toX500Name(ic.getIssuerX500Principal()));
            }
        }
        this.setPublicKey(this.issuerCert.getPublicKey());
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public void setPublicKey(oracle.security.crypto.core.PublicKey key) {
        this.setPublicKey((PublicKey)key);
    }

    public void setPublicKey(PublicKey key) {
        this.pubKey = CryptoUtils.fromJCEPublicKey((PublicKey)key);
    }

    public void setPrivateKey(oracle.security.crypto.core.PrivateKey key) {
        this.setPrivateKey((PrivateKey)key, null);
    }

    public void setPrivateKey(oracle.security.crypto.core.PrivateKey key, AlgorithmIdentifier sigAlgID) {
        this.setPrivateKey((PrivateKey)key, sigAlgID);
    }

    public void setPrivateKey(PrivateKey key, AlgorithmIdentifier sigAlgID) {
        this.privKey = key;
        this.setSigAlgID(sigAlgID);
    }

    public void setSigAlgID(AlgorithmIdentifier sigAlgID) {
        this.sigAlgID = sigAlgID;
        this.reset();
    }

    public Date getDate() {
        return this.thisUpdate;
    }

    public Date getNextDate() {
        return this.nextUpdate;
    }

    @Deprecated
    public Vector<RevokedCertificate> getRevokedCertificates() {
        ArrayList<RevokedCertificate> l = this.getRevokedCertificatesAsList();
        return l == null ? null : new VectorOverArrayList(l);
    }

    public ArrayList<RevokedCertificate> getRevokedCertificatesAsList() {
        return this.revokedCertificates == null ? null : new ArrayList<RevokedCertificate>(this.revokedCertificates.values());
    }

    public Map<BigInteger, RevokedCertificate> getRevokedCertificatesAsMap() {
        return this.revokedCertificates;
    }

    public Enumeration<BigInteger> revokedSerialNos() {
        return this.revokedCertificates != null ? new Vector<BigInteger>(this.revokedCertificates.keySet()).elements() : new Vector().elements();
    }

    public void setRevokedCertificates(Vector<? extends RevokedCertificate> rcs) {
        this.setRevokedCertificates((List<? extends RevokedCertificate>)rcs);
    }

    public void setRevokedCertificates(List<? extends RevokedCertificate> rcs) {
        if (rcs != null && rcs.size() > 0) {
            this.revokedCertificates = new LinkedHashMap();
            for (RevokedCertificate revokedCertificate : rcs) {
                this.revokedCertificates.put(revokedCertificate.getSerialNo(), revokedCertificate);
            }
            this.reset();
        }
    }

    public void setDate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
        this.reset();
    }

    public void setDates(Date thisUpdate, Date nextUpdate) {
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.reset();
    }

    public void setDates(int days) {
        this.setDates(new Date(), Utils.daysFromNow((int)days));
    }

    public void addCertificate(BigInteger sn) {
        this.addCertificate(sn, new Date());
    }

    public void addCertificate(BigInteger sn, Date d) {
        this.addCertificate(new RevokedCertificate(sn, d));
    }

    public void addCertificate(RevokedCertificate rc) {
        if (this.revokedCertificates == null) {
            this.revokedCertificates = new LinkedHashMap();
        }
        this.revokedCertificates.put(rc.getSerialNo(), rc);
        this.reset();
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public X509Extension getExtension(ASN1ObjectID type) {
        return this.extensions != null ? this.extensions.getExtension(type) : null;
    }

    public void setExtensions(X509ExtensionSet exts) {
        this.extensions = exts;
        this.reset();
    }

    public void addExtension(X509Extension ext) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(ext);
        this.reset();
    }

    public RevokedCertificate getRevokedCertificate(BigInteger sn) {
        return this.revokedCertificates != null ? this.revokedCertificates.get(sn) : null;
    }

    public Date revocationDate(BigInteger sn) {
        RevokedCertificate rc = this.getRevokedCertificate(sn);
        return rc != null ? rc.getRevocationDate() : null;
    }

    public boolean isRevoked(BigInteger sn) {
        return this.getRevokedCertificate(sn) != null;
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (this.extensions != null && this.extensions.hasUnrecognizedCriticalExtension()) {
            return true;
        }
        if (this.revokedCertificates != null) {
            for (RevokedCertificate rc : this.revokedCertificates.values()) {
                X509ExtensionSet extSet;
                if (rc == null || (extSet = rc.getExtensionSet()) == null || !extSet.hasUnrecognizedCriticalExtension()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verify() throws AuthenticationException {
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyDate()) {
            return false;
        }
        return this.verifySignature();
    }

    public boolean verifyDate() {
        Date now = new Date();
        if (now.before(this.thisUpdate)) {
            return false;
        }
        return this.nextUpdate == null || !now.after(this.nextUpdate);
    }

    public boolean verifySignature() throws AuthenticationException {
        ASN1Sequence tbs = this.getTBSCertListSeq();
        try {
            Signature sig = JCEUtil.getSignatureInstance((String)CryptoUtils.getSignatureAlg((AlgorithmIdentifier)this.sigAlgID));
            sig.initVerify((PublicKey)this.pubKey);
            sig.update(Utils.toBytes((Streamable)tbs));
            return sig.verify(this.getSignature());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
        catch (java.security.SignatureException ex) {
            throw new AuthenticationException((Throwable)ex);
        }
    }

    public void sign() throws SignatureException {
        ASN1Sequence tbs = this.getTBSCertListSeq();
        try {
            Signature sig = JCEUtil.getSignatureInstance((String)CryptoUtils.getSignatureAlg((AlgorithmIdentifier)this.sigAlgID));
            sig.initSign(this.privKey);
            sig.update(Utils.toBytes((Streamable)tbs));
            this.sigBytes = sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException((Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException((Throwable)ex);
        }
        catch (java.security.SignatureException ex) {
            throw new SignatureException((Throwable)ex);
        }
        finally {
            this.resetContents();
        }
    }

    public void sign(RandomBitsSource rbs) throws SignatureException {
        this.sign();
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    private ASN1Sequence getTBSCertListSeq() {
        if (this.tbsCertList == null) {
            ASN1Sequence s = new ASN1Sequence();
            if (this.extensions != null && this.extensions.size() > 0) {
                s.addElement((ASN1Object)new ASN1Integer(1L));
            } else if (this.revokedCertificates != null && this.revokedCertificates.size() > 0) {
                for (RevokedCertificate r : this.revokedCertificates.values()) {
                    if (r.getExtensionsAsList() == null || r.getExtensionsAsList().size() <= 0) continue;
                    s.addElement((ASN1Object)new ASN1Integer(1L));
                    break;
                }
            }
            if (this.sigAlgID == null && this.privKey != null) {
                if (this.privKey.getAlgorithm().equals("RSA")) {
                    this.sigAlgID = AlgID.sha256WithRSAEncryption;
                } else if (this.privKey.getAlgorithm().equals("DSA")) {
                    this.sigAlgID = AlgID.dsaWithSHA1;
                } else if (this.privKey.getAlgorithm().equals("EC")) {
                    int bit = ((ECPrivateKey)this.privKey).getParams().getCurve().getField().getFieldSize();
                    switch (bit) {
                        case 256: {
                            this.sigAlgID = AlgID.ecdsaWithSHA256;
                            break;
                        }
                        case 384: {
                            this.sigAlgID = AlgID.ecdsaWithSHA384;
                            break;
                        }
                        case 512: {
                            this.sigAlgID = AlgID.ecdsaWithSHA512;
                            break;
                        }
                        default: {
                            this.sigAlgID = AlgID.ecdsaWithSHA1;
                        }
                    }
                }
            }
            s.addElement((ASN1Object)this.sigAlgID);
            s.addElement((ASN1Object)this.issuer);
            Calendar t = Calendar.getInstance();
            t.setTime(this.thisUpdate);
            s.addElement((ASN1Object)new ASN1Date(this.thisUpdate, t.get(1) > 2049));
            if (this.nextUpdate != null) {
                Calendar n = Calendar.getInstance();
                n.setTime(this.nextUpdate);
                s.addElement((ASN1Object)new ASN1Date(this.nextUpdate, n.get(1) > 2049));
            }
            if (this.revokedCertificates != null && this.revokedCertificates.size() > 0) {
                ASN1Sequence rcl = new ASN1Sequence();
                for (RevokedCertificate r : this.revokedCertificates.values()) {
                    rcl.addElement((ASN1Object)r);
                }
                s.addElement((ASN1Object)rcl);
            }
            if (this.extensions != null && this.extensions.size() > 0) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.extensions, 0));
            }
            this.tbsCertList = s;
        }
        return this.tbsCertList;
    }

    private ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)this.getTBSCertListSeq());
            seq.addElement((ASN1Object)this.sigAlgID);
            seq.addElement((ASN1Object)new ASN1BitString(this.getSigBytes()));
            this.contents = seq;
        }
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        try {
            this.toASN1Sequence().output(os);
        }
        catch (SignatureException ex) {
            throw new OutputGenerationException(ex.toString());
        }
    }

    public void input(InputStream is) throws IOException {
        AlgorithmIdentifier tbsSigAlgID;
        this.reset();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.tbsCertList = new ASN1Sequence((InputStream)sis);
        this.sigAlgID = new AlgorithmIdentifier((InputStream)sis);
        this.sigBytes = ASN1BitString.inputValue((InputStream)sis);
        sis.terminate();
        ASN1SequenceInputStream tbs = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.tbsCertList));
        if (tbs.getCurrentTag() == 2) {
            BigInteger v = ASN1Integer.inputValue((InputStream)tbs);
            this.version = v.intValue() + 1;
        }
        if (!(tbsSigAlgID = new AlgorithmIdentifier((InputStream)tbs)).equals((Object)this.sigAlgID)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name issuer2 = new X500Name((InputStream)tbs);
        if (this.issuer == null) {
            this.issuer = issuer2;
        } else if (!this.issuer.equals(issuer2)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + issuer2 + "}");
        }
        this.thisUpdate = ASN1Date.inputValue((InputStream)tbs);
        this.nextUpdate = tbs.getCurrentTag() == 23 || tbs.getCurrentTag() == 24 ? ASN1Date.inputValue((InputStream)tbs) : null;
        if (tbs.getCurrentTag() == 16) {
            ASN1SequenceInputStream crl = new ASN1SequenceInputStream((InputStream)tbs);
            this.revokedCertificates = new LinkedHashMap();
            while (crl.hasMoreData()) {
                RevokedCertificate rc = new RevokedCertificate((InputStream)crl);
                this.revokedCertificates.put(rc.getSerialNo(), rc);
            }
            crl.terminate();
        } else {
            this.revokedCertificates = null;
        }
        if (tbs.getCurrentTag() == 0) {
            ASN1ConstructedInputStream ext = new ASN1ConstructedInputStream((InputStream)tbs);
            this.extensions = new X509ExtensionSet((InputStream)ext);
            ext.terminate();
        } else {
            this.extensions = null;
        }
        tbs.terminate();
    }

    private void reset() {
        this.resetContents();
        this.tbsCertList = null;
        this.sigBytes = null;
    }

    private void resetContents() {
        this.contents = null;
    }

    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof CRL) {
            return this.equals((CRL)o);
        }
        return false;
    }

    private boolean equals(CRL c) {
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)c));
    }

    public String toString() {
        String s = "issuer = " + this.issuer + ", thisUpdate = " + this.thisUpdate;
        if (this.nextUpdate != null) {
            s = s + ", nextUpdate = " + this.nextUpdate;
        }
        s = s + ", revokedCertificates = {";
        if (this.revokedCertificates != null) {
            Iterator<RevokedCertificate> i = this.revokedCertificates.values().iterator();
            while (i.hasNext()) {
                RevokedCertificate r = i.next();
                s = s + "(" + r + ")";
                if (!i.hasNext()) continue;
                s = s + ", ";
            }
        }
        s = s + "}";
        if (this.extensions != null && this.extensions.size() > 0) {
            s = s + ", extensions = " + this.extensions;
        }
        return s;
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes((Streamable)this.toASN1Sequence());
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        return this.getIssuer().toX500Principal();
    }

    public Date getNextUpdate() {
        return this.getNextDate();
    }

    public X509CRLEntry getRevokedCertificate(X509Certificate certificate) {
        return null;
    }

    public String getSigAlgName() {
        return CryptoUtils.getSignatureAlg((AlgorithmIdentifier)this.sigAlgID);
    }

    public String getSigAlgOID() {
        return this.sigAlgID.getOID().toStringCompact();
    }

    public byte[] getSigAlgParams() {
        return Utils.toBytes((Streamable)this.sigAlgID.getParameters());
    }

    public byte[] getSignature() {
        try {
            return this.getSigBytes();
        }
        catch (SignatureException ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] getTBSCertList() throws CRLException {
        return Utils.toBytes((Streamable)this.getTBSCertListSeq());
    }

    public Date getThisUpdate() {
        return this.getDate();
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Arrays.hashCode(Utils.toBytes((Streamable)this));
    }

    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        Signature sigObj = sigProvider != null && !TransitionMode.isFIPS140ModeEnabled() ? Signature.getInstance(this.getSigAlgName(), sigProvider) : JCEUtil.getSignatureInstance((String)this.getSigAlgName());
        sigObj.initVerify(key);
        sigObj.update(this.getTBSCertList());
        boolean result = sigObj.verify(this.getSignature());
        if (!result) {
            throw new java.security.SignatureException("Public key does not match");
        }
    }

    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        this.verify(key, null);
    }

    public boolean isRevoked(Certificate cert) {
        BigInteger sn = ((X509Certificate)cert).getSerialNumber();
        return sn != null && this.revokedCertificates.containsKey(sn);
    }

    public Set<String> getCriticalExtensionOIDs() {
        return this.extensions.getCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String oid) {
        return this.extensions.getExtensionValue(oid);
    }

    public Set<String> getNonCriticalExtensionOIDs() {
        return this.extensions.getNonCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.hasUnrecognizedCriticalExtension();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }

    public X509CRL toX509CRL() {
        return this.crlImpl;
    }

    class X509CRLImpl
    extends X509CRL {
        X509CRLImpl() {
        }

        @Override
        public boolean equals(Object other) {
            return CRL.this.equals(other);
        }

        @Override
        public byte[] getEncoded() throws CRLException {
            return CRL.this.getEncoded();
        }

        @Override
        public Principal getIssuerDN() {
            return CRL.this.getIssuerDN();
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            return CRL.this.getIssuerX500Principal();
        }

        @Override
        public Date getNextUpdate() {
            return CRL.this.getNextUpdate();
        }

        @Override
        public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
            return CRL.this.getRevokedCertificate(serialNumber);
        }

        @Override
        public X509CRLEntry getRevokedCertificate(X509Certificate certificate) {
            return CRL.this.getRevokedCertificate(certificate);
        }

        @Override
        public Set<? extends X509CRLEntry> getRevokedCertificates() {
            return new LinkedHashSet<RevokedCertificate>(CRL.this.getRevokedCertificatesAsList());
        }

        @Override
        public String getSigAlgName() {
            return CRL.this.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return CRL.this.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return CRL.this.getSigAlgParams();
        }

        @Override
        public byte[] getSignature() {
            return CRL.this.getSignature();
        }

        @Override
        public byte[] getTBSCertList() throws CRLException {
            return CRL.this.getTBSCertList();
        }

        @Override
        public Date getThisUpdate() {
            return CRL.this.getThisUpdate();
        }

        @Override
        public int getVersion() {
            return CRL.this.getVersion();
        }

        @Override
        public int hashCode() {
            return CRL.this.hashCode();
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
            CRL.this.verify(key, sigProvider);
        }

        @Override
        public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
            CRL.this.verify(key);
        }

        @Override
        public boolean isRevoked(Certificate cert) {
            return CRL.this.isRevoked(cert);
        }

        @Override
        public String toString() {
            return CRL.this.toString();
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return CRL.this.getCriticalExtensionOIDs();
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return CRL.this.getExtensionValue(oid);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return CRL.this.getNonCriticalExtensionOIDs();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return CRL.this.hasUnsupportedCriticalExtension();
        }

        public CRL toCRL() {
            return CRL.this;
        }
    }
}

