/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CalendarView;
import javafx.scene.control.Cell;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.text.Text;

public class DateCellSkin
extends CellSkinBase<CalendarView.DateCell> {
    private static final double DEFAULT_CELL_SIZE = 24.0;

    public DateCellSkin(CalendarView.DateCell control) {
        super((Cell)control);
        control.setMaxWidth(Double.MAX_VALUE);
    }

    protected void updateChildren() {
        super.updateChildren();
        Text secondaryText = (Text)((CalendarView.DateCell)this.getSkinnable()).getProperties().get((Object)"DateCell.secondaryText");
        if (secondaryText != null) {
            secondaryText.setManaged(false);
            this.getChildren().add((Object)secondaryText);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        Text secondaryText = (Text)((CalendarView.DateCell)this.getSkinnable()).getProperties().get((Object)"DateCell.secondaryText");
        if (secondaryText != null) {
            double textX = x + w - this.snapSizeX(((CalendarView.DateCell)this.getSkinnable()).getLabelPadding().getRight()) - secondaryText.getLayoutBounds().getWidth();
            double textY = y + h - this.snapSizeY(((CalendarView.DateCell)this.getSkinnable()).getLabelPadding().getBottom()) - secondaryText.getLayoutBounds().getHeight();
            secondaryText.relocate(this.snapPositionX(textX), this.snapPositionY(textY));
        }
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double pref = super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
        return this.snapSizeX(Math.max(pref, this.cellSize()));
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double pref = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        return this.snapSizeY(Math.max(pref, this.cellSize()));
    }

    private double cellSize() {
        double cellSize = this.getCellSize();
        Text secondaryText = (Text)((CalendarView.DateCell)this.getSkinnable()).getProperties().get((Object)"DateCell.secondaryText");
        if (secondaryText != null && cellSize == 24.0) {
            cellSize = 36.0;
        }
        return cellSize;
    }
}

