/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview;

import com.dlsc.gemsfx.treeview.TreeNode;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class TreeNodeCell<T>
extends BorderPane {
    private static final boolean DEFAULT_EXPANDED = true;
    private static final String DEFAULT_STYLE_CLASS = "tree-node-cell";
    private static final PseudoClass EXPANDED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"expanded");
    private static final PseudoClass COLLAPSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"collapsed");
    private InvalidationListener invalidationListener;
    private final Label innerLabel;
    private final StackPane arrowWrapper;
    private final ObjectProperty<T> item = new SimpleObjectProperty((Object)this, "item");
    private final ReadOnlyObjectWrapper<TreeNode<T>> treeNode = new ReadOnlyObjectWrapper((Object)this, "treeNode");
    private final BooleanProperty expanded = new SimpleBooleanProperty((Object)this, "expanded", true);
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
    private final StringProperty text = new SimpleStringProperty((Object)this, "text");

    public TreeNodeCell() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.innerLabel = new Label();
        this.innerLabel.getStyleClass().add((Object)"tree-node-cell-label");
        this.innerLabel.graphicProperty().bind(this.graphicProperty());
        this.innerLabel.textProperty().bind((ObservableValue)this.textProperty());
        this.innerLabel.setMaxWidth(Double.MAX_VALUE);
        Region arrow = new Region();
        arrow.getStyleClass().setAll((Object[])new String[]{"disclosure-arrow"});
        this.arrowWrapper = new StackPane(new Node[]{arrow});
        this.arrowWrapper.getStyleClass().setAll((Object[])new String[]{"arrow-wrapper"});
        this.arrowWrapper.managedProperty().bind((ObservableValue)this.arrowWrapper.visibleProperty());
        this.arrowWrapper.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.getTreeNode() != null && !this.getTreeNode().getChildren().isEmpty(), (Observable[])new Observable[]{this.treeNodeProperty()}));
        this.arrowWrapper.setOnMousePressed(event -> {
            if (this.getTreeNode() != null && !this.getTreeNode().getChildren().isEmpty()) {
                this.setExpanded(!this.isExpanded());
            }
            event.consume();
        });
        this.setCenter((Node)this.innerLabel);
        this.setRight((Node)this.arrowWrapper);
        this.itemProperty().addListener((ob, ov, nv) -> this.updateItem(nv));
        this.treeNodeProperty().addListener((ob, oldTreeNode, newTreeNode) -> {
            if (oldTreeNode != null && this.invalidationListener != null) {
                this.expandedProperty().unbindBidirectional((Property)oldTreeNode.expandedProperty());
                oldTreeNode.getChildren().removeListener(this.invalidationListener);
            }
            if (newTreeNode != null) {
                this.expandedProperty().bindBidirectional((Property)newTreeNode.expandedProperty());
                this.invalidationListener = it -> this.updateItem(this.getItem());
                newTreeNode.getChildren().addListener(this.invalidationListener);
            }
            this.updateItem(this.getItem());
        });
        this.expandedProperty().addListener((ob, ov, newExpanded) -> {
            this.pseudoClassStateChanged(EXPANDED_PSEUDOCLASS_STATE, (boolean)newExpanded);
            this.pseudoClassStateChanged(COLLAPSED_PSEUDOCLASS_STATE, newExpanded == false);
            this.updateItem(this.getItem());
        });
    }

    public TreeNodeCell(T item) {
        this();
        this.setItem(item);
    }

    public T getItem() {
        return (T)this.item.get();
    }

    public ObjectProperty<T> itemProperty() {
        return this.item;
    }

    public void setItem(T item) {
        this.item.set(item);
    }

    public TreeNode<T> getTreeNode() {
        return (TreeNode)this.treeNode.get();
    }

    public ReadOnlyObjectProperty<TreeNode<T>> treeNodeProperty() {
        return this.treeNode.getReadOnlyProperty();
    }

    protected void setTreeNode(TreeNode<T> treeNode) {
        this.treeNode.set(treeNode);
    }

    public boolean isExpanded() {
        return this.expanded.get();
    }

    public BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded.set(expanded);
    }

    public Node getGraphic() {
        return (Node)this.graphic.get();
    }

    public ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public void setGraphic(Node graphic) {
        this.graphic.set((Object)graphic);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    protected void updateItem(T item) {
        if (item != null) {
            this.setText(item.toString());
        } else {
            this.setText("");
        }
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(TreeNodeCell.class.getResource("tree-view.css")).toExternalForm();
    }
}

