/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import com.dlsc.gemsfx.util.EnumUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.apache.commons.lang3.StringUtils;

public class UIUtil {
    private UIUtil() {
    }

    public static void addClassIfAbsent(Styleable node, String styleClass) {
        Optional.ofNullable(node).ifPresent(n -> {
            if (!n.getStyleClass().contains((Object)styleClass)) {
                n.getStyleClass().add((Object)styleClass);
            }
        });
    }

    public static void addClassesIfAbsent(Styleable node, String ... styleClasses) {
        List<String> list = Arrays.stream(styleClasses).filter(styleClass -> !node.getStyleClass().contains(styleClass)).toList();
        node.getStyleClass().addAll(list);
    }

    public static void toggleClass(Styleable node, String styleClass) {
        if (node.getStyleClass().contains((Object)styleClass)) {
            node.getStyleClass().remove((Object)styleClass);
        } else {
            node.getStyleClass().add((Object)styleClass);
        }
    }

    public static void toggleClassOnCondition(Styleable node, String styleClass, boolean condition) {
        if (condition) {
            UIUtil.addClassIfAbsent(node, styleClass);
        } else {
            node.getStyleClass().remove((Object)styleClass);
        }
    }

    public static void toggleClassBasedOnObservable(Styleable node, String styleClass, ObservableValue<Boolean> booleanObservableValue) {
        UIUtil.toggleClassOnCondition(node, styleClass, (Boolean)booleanObservableValue.getValue());
        booleanObservableValue.addListener((obs, oldVal, newVal) -> UIUtil.toggleClassOnCondition(node, styleClass, newVal));
    }

    public static void updateStyles(Styleable node, List<String> stylesToRemove, String styleToAdd) {
        UIUtil.addClassIfAbsent(node, styleToAdd);
        node.getStyleClass().removeAll(stylesToRemove.stream().filter(style -> !style.equals(styleToAdd)).toList());
    }

    public static void updateStyles(Styleable node, String[] stylesToRemove, String styleToAdd) {
        UIUtil.updateStyles(node, Arrays.asList(stylesToRemove), styleToAdd);
    }

    public static <T extends Enum<T>> void updateStyleFromEnum(Styleable node, T enumValue) {
        UIUtil.updateStyles(node, EnumUtil.convertAllToStylesClassName(enumValue.getClass()), EnumUtil.convertToStyleClassName(enumValue));
    }

    public static <T extends Enum<T>> void clearStylesByEnum(Styleable node, Class<T> enumClass) {
        node.getStyleClass().removeAll((Object[])EnumUtil.convertAllToStylesClassName(enumClass));
    }

    public static double getInsetsHeight(Insets insets) {
        return insets == null ? 0.0 : insets.getTop() + insets.getBottom();
    }

    public static double getInsetsWidth(Insets insets) {
        return insets == null ? 0.0 : insets.getLeft() + insets.getRight();
    }

    public static String camelCaseToNaturalCase(String camelCaseString) {
        return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)camelCaseString), (String)" "));
    }

    public static void copyToClipboard(String copyContent) {
        ClipboardContent content = new ClipboardContent();
        content.putString(copyContent);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public static boolean isClickOnNode(MouseEvent event) {
        return UIUtil.isClickOnNode(event, false);
    }

    public static boolean isClickOnNode(MouseEvent event, boolean isSingleClick) {
        if (event.getEventType() != MouseEvent.MOUSE_CLICKED) {
            throw new IllegalArgumentException("The event must be a mouse clicked event.");
        }
        return event.getButton() == MouseButton.PRIMARY && event.isStillSincePress() && (!isSingleClick || event.getClickCount() == 1);
    }
}

