/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.internal.util.IOUtilities;

public final class CSSUtilities {
    public static void writeStylesheet(DOMOutputOptions options, OutputStream cssOutputStream) {
        Properties cssProperties = options.getInlineCSSProperties();
        if (cssProperties == null) {
            cssProperties = CSSUtilities.readBuiltinInlineCSSProperties();
        }
        CSSUtilities.writeStylesheet(cssProperties, cssOutputStream);
    }

    public static String writeDefaultStylesheet() {
        return CSSUtilities.writeStylesheet(CSSUtilities.readBuiltinInlineCSSProperties());
    }

    public static String writeStylesheet(Properties cssProperties) {
        StringWriter resultWriter = new StringWriter();
        CSSUtilities.writeStylesheet(cssProperties, resultWriter);
        return resultWriter.toString();
    }

    public static void writeDefaultStylesheet(OutputStream cssOutputStream) {
        CSSUtilities.writeStylesheet(CSSUtilities.readBuiltinInlineCSSProperties(), cssOutputStream);
    }

    public static void writeStylesheet(Properties cssProperties, OutputStream cssOutputStream) {
        CSSUtilities.writeStylesheet(cssProperties, new OutputStreamWriter(cssOutputStream, Charset.forName("UTF-8")));
    }

    public static void writeStylesheet(Properties cssProperties, Writer cssOutputWriter) {
        PrintWriter writer = new PrintWriter(new BufferedWriter(cssOutputWriter));
        writer.println("/* SnuggleTeX CSS File (autogenerated) */");
        for (Map.Entry<Object, Object> entry : cssProperties.entrySet()) {
            writer.print("\n");
            writer.print(entry.getKey());
            writer.print(" {\n");
            String value = ((String)entry.getValue()).trim();
            if (value.length() != 0) {
                writer.print("  ");
                writer.print(value.replaceFirst("(?!;)$", ";").replaceAll(";\\s*(?=.)", ";\n  "));
                writer.print("\n");
            }
            writer.print("}\n");
        }
        writer.close();
    }

    public static Properties readBuiltinInlineCSSProperties() {
        Properties builtinInlineCSSProperties = new Properties();
        try {
            builtinInlineCSSProperties.load(CSSUtilities.class.getClassLoader().getResourceAsStream("uk/ac/ed/ph/snuggletex/css.properties"));
        }
        catch (IOException e) {
            throw new SnuggleRuntimeException("Could not load CSS properties file via ClassLoader uk/ac/ed/ph/snuggletex/css.properties");
        }
        return builtinInlineCSSProperties;
    }

    public static Properties readInlineCSSProperties(DOMOutputOptions options) {
        Properties properties = options.getInlineCSSProperties();
        if (properties == null) {
            properties = CSSUtilities.readBuiltinInlineCSSProperties();
        }
        return properties;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: specify a File that the default SnuggleTeX CSS will be written to");
            System.exit(1);
        }
        File outputFile = new File(args[0]);
        IOUtilities.ensureFileCreated(outputFile);
        CSSUtilities.writeDefaultStylesheet(new FileOutputStream(outputFile));
    }
}

