/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestStructureElement;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.javascript.testing.JSTestNamePatternComponentJoiner;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTestRunnerUtil {
    private JSTestRunnerUtil() {
    }

    @NotNull
    public static String getTestPattern(@NotNull List<String> testNames, boolean suite) {
        if (testNames == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(0);
        }
        return JSTestRunnerUtil.getTestNamesPattern(Collections.singletonList(JSTestNamePattern.toLiteralList(testNames)), suite);
    }

    @NotNull
    public static String getTestsPattern(@NotNull Collection<List<String>> testNamesCollection, boolean suite) {
        if (testNamesCollection == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(1);
        }
        return JSTestRunnerUtil.getTestNamesPattern(ContainerUtil.map(testNamesCollection, JSTestNamePattern::toLiteralList), suite);
    }

    @NotNull
    public static String getTestsPattern(@NotNull Collection<List<String>> testNamesCollection, @NotNull JSTestNamePatternComponentJoiner testNamePatternComponentJoiner, boolean suite) {
        if (testNamesCollection == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(2);
        }
        if (testNamePatternComponentJoiner == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(3);
        }
        return JSTestRunnerUtil.getTestNamesPattern(ContainerUtil.map(testNamesCollection, JSTestNamePattern::toLiteralList), testNamePatternComponentJoiner, suite);
    }

    @NotNull
    public static String getTestNamesPattern(@NotNull Collection<List<JSTestNamePattern>> testNamesCollection, boolean suite) {
        if (testNamesCollection == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(4);
        }
        return JSTestRunnerUtil.getTestNamesPattern(testNamesCollection, new JSTestNamePatternComponentJoiner(), suite);
    }

    @NotNull
    public static String getTestNamesPattern(@NotNull Collection<List<JSTestNamePattern>> testNamesCollection, @NotNull JSTestNamePatternComponentJoiner testComponentJoiner, boolean suite) {
        List patterns;
        if (testNamesCollection == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(5);
        }
        if (testComponentJoiner == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(6);
        }
        if (testNamesCollection.size() > 1) {
            testNamesCollection = new LinkedHashSet<List<JSTestNamePattern>>(testNamesCollection);
        }
        if ((patterns = ContainerUtil.map(testNamesCollection, testFqn -> testComponentJoiner.join(ContainerUtil.map((Collection)testFqn, name -> JSTestRunnerUtil.createPattern(name)), suite))).isEmpty()) {
            return "$^";
        }
        Object pattern = patterns.size() == 1 ? (String)patterns.get(0) : "(" + StringUtil.join((Collection)patterns, (String)"|") + ")";
        String string = "^" + (String)pattern + (suite ? "" : "$");
        if (string == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String createPattern(@NotNull JSTestNamePattern namePattern) {
        if (namePattern == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(8);
        }
        StringBuilder builder2 = new StringBuilder();
        for (JSTestNamePattern.Range range : namePattern.getRanges()) {
            if (range instanceof JSTestNamePattern.Literal) {
                builder2.append(JSTestRunnerUtil.escapeJavaScriptRegexp(((JSTestNamePattern.Literal)range).getLiteral()));
                continue;
            }
            builder2.append(".*");
        }
        String string = builder2.toString();
        if (string == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String escapeJavaScriptRegexp(@NotNull String str) {
        if (str == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(10);
        }
        return JSTestRunnerUtil.escapeJavaScriptRegexp(str, "\\.?*+^$[](){}|");
    }

    @NotNull
    public static String escapeJavaScriptRegexp(@NotNull String str, @NotNull String charsToEscape) {
        if (str == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(11);
        }
        if (charsToEscape == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(12);
        }
        for (int i = 0; i < charsToEscape.length(); ++i) {
            char ch = charsToEscape.charAt(i);
            str = str.replace(String.valueOf(ch), "\\" + ch);
        }
        String string = str;
        if (string == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String buildTestNamesPattern(@NotNull Project project, @NotNull JsTestFrameworkDetector testFrameworkDetector, @NotNull String testFilePath, @NotNull List<String> parsedTestNames, boolean suite) {
        if (project == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(14);
        }
        if (testFrameworkDetector == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(15);
        }
        if (testFilePath == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(16);
        }
        if (parsedTestNames == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(17);
        }
        return JSTestRunnerUtil.buildTestNamesPattern(project, testFrameworkDetector, testFilePath, parsedTestNames, new JSTestNamePatternComponentJoiner(), suite);
    }

    @NotNull
    public static String buildTestNamesPattern(@NotNull Project project, @NotNull JsTestFrameworkDetector testFrameworkDetector, @NotNull String testFilePath, @NotNull List<String> parsedTestNames, @NotNull JSTestNamePatternComponentJoiner testNamePatternComponentJoiner, boolean suite) {
        List<JSTestNamePattern> patterns;
        if (project == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(18);
        }
        if (testFrameworkDetector == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(19);
        }
        if (testFilePath == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(20);
        }
        if (parsedTestNames == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(21);
        }
        if (testNamePatternComponentJoiner == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(22);
        }
        if ((patterns = JSTestRunnerUtil.findTestNamesPatterns(project, testFrameworkDetector, testFilePath, parsedTestNames, suite)) == null) {
            patterns = JSTestNamePattern.toLiteralList(parsedTestNames);
        }
        return JSTestRunnerUtil.getTestNamesPattern(Collections.singletonList(patterns), testNamePatternComponentJoiner, suite);
    }

    @Nullable
    private static List<JSTestNamePattern> findTestNamesPatterns(@NotNull Project project, @NotNull JsTestFrameworkDetector testFrameworkDetector, @NotNull String testFilePath, @NotNull List<String> parsedTestNames, boolean suite) {
        if (project == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(23);
        }
        if (testFrameworkDetector == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(24);
        }
        if (testFilePath == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(25);
        }
        if (parsedTestNames == null) {
            JSTestRunnerUtil.$$$reportNull$$$0(26);
        }
        return (List)ReadAction.compute(() -> {
            JsTestSelector testSelector;
            AbstractTestStructureElement<?> testStructureElement;
            JSFile jsFile;
            AbstractTestFileStructure testStructure;
            VirtualFile testFile = LocalFileSystem.getInstance().findFileByPath(testFilePath);
            if (testFile == null) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(testFile);
            if (psiFile instanceof JSFile && (testStructure = testFrameworkDetector.findTestsStructure(jsFile = (JSFile)psiFile)) != null && (testStructureElement = testStructure.findStructureElement(testSelector = new JsTestSelector(parsedTestNames, suite))) instanceof AbstractJasmineElement) {
                AbstractJasmineElement jasmineElement = (AbstractJasmineElement)testStructureElement;
                return jasmineElement.getTestTreePathPatterns();
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNamesCollection";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNamePatternComponentJoiner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testComponentJoiner";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JSTestRunnerUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsToEscape";
                break;
            }
            case 14: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkDetector";
                break;
            }
            case 16: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePath";
                break;
            }
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedTestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JSTestRunnerUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamesPattern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPattern";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeJavaScriptRegexp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestsPattern";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamesPattern";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPattern";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "escapeJavaScriptRegexp";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildTestNamesPattern";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findTestNamesPatterns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 13 -> new IllegalStateException(string);
        };
    }
}

