/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.ActionScriptStubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.gist.JSStubElementGist;
import com.intellij.lang.javascript.index.gist.JSVariableBaseData;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementType;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSCachingNamespaceOwner;
import com.intellij.lang.javascript.psi.impl.JSCachingTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariableBaseImpl<T extends JSVariableStubBase<T2>, T2 extends JSVariable>
extends JSQualifiedNamedElementBaseImpl<T>
implements JSVariable,
JSCachingTypeOwner,
JSCachingNamespaceOwner {
    protected String myName;
    public static final TokenSet IDENTIFIER_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.JS_IDENTIFIER_TOKENS_SET, JSKeywordSets.AS_IDENTIFIER_TOKENS_SET, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION})});
    private static final TokenSet PROPERTY_NAME_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.IDENTIFIER_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION})});
    private static final IElementType[] TYPES_TO_SKIP = new IElementType[]{JSTokenTypes.DOC_COMMENT, JSStubElementTypes.ATTRIBUTE_LIST, ActionScriptStubElementTypes.ACTIONSCRIPT_ATTRIBUTE_LIST, JSElementTypes.REFERENCE_EXPRESSION, JSTokenTypes.WHITE_SPACE, JSTokenTypes.AWAIT_KEYWORD};
    private static final int MAX_LENGTH_FOR_LITERAL_INITIALIZER_TEXT = 256;

    protected JSVariableBaseImpl(@NotNull ASTNode node) {
        if (node == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    protected <PsiT extends JSVariable> JSVariableBaseImpl(@NotNull T stub, @NotNull JSElementType<PsiT> elementType) {
        if (stub == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(1);
        }
        if (elementType == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(2);
        }
        super(stub, elementType);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myName = null;
        JSExpression initializer = this.getInitializerOrStub();
        if (initializer instanceof JSFunctionExpression && initializer instanceof JSStubElementImpl) {
            ((JSStubElementImpl)((Object)initializer)).clearCaches();
        }
    }

    @Override
    public boolean hasOwnInitializer() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasOwnInitializer();
        }
        return this.getInitializer() != null;
    }

    @Override
    public boolean hasInitializer() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasInitializer();
        }
        return this.getInitializer() != null;
    }

    @Override
    @Nullable
    public JSVarStatement getStatement() {
        return (JSVarStatement)ObjectUtils.tryCast((Object)JSDestructuringUtil.getParentSkippingDestructuring(this), JSVarStatement.class);
    }

    @Override
    @Nullable
    public JSExpression getInitializerOrStub() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getStub();
        if (stub != null) {
            if (!stub.keepsInitializerStub()) {
                return null;
            }
            StubElement<?> initializerStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, false);
            return initializerStub != null ? (JSExpression)initializerStub.getPsi() : null;
        }
        return this.getInitializer();
    }

    @Override
    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    @Override
    @Nullable
    public String getLiteralOrReferenceInitializerText() {
        return this.getGistData().getLiteralOrReferenceInitializerText();
    }

    @NotNull
    protected JSVariableBaseData getGistData() {
        JSVariableBaseData jSVariableBaseData = JSStubElementGist.getInstance(this.getProject()).getData(this);
        if (jSVariableBaseData == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(3);
        }
        return jSVariableBaseData;
    }

    @Nullable
    public String calculateLiteralOrReferenceInitializerText() {
        JSExpression expression = this.getInitializer();
        return JSVariableBaseImpl.isLiteralOnlyExpression(expression) && !(expression instanceof JSXmlLiteralExpression) && expression.getTextLength() < 256 || JSSymbolUtil.isAccurateReferenceExpression(expression) ? expression.getText() : null;
    }

    private static boolean isLiteralOnlyExpression(@Nullable JSExpression expression) {
        IElementType sign;
        if (expression instanceof JSLiteralExpression) {
            return true;
        }
        return expression instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)expression).getOperationSign()) == JSTokenTypes.MINUS || sign == JSTokenTypes.PLUS) && ((JSPrefixExpression)expression).getExpression() instanceof JSLiteralExpression;
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope;
        if (this.hasBlockScope() && (declarationScope = this.getDeclarationScope()) != null && this.useLocalSearchScope(declarationScope)) {
            return new LocalSearchScope(declarationScope);
        }
        SearchScope searchScope = JSUseScopeProvider.findUseScope(this);
        if (searchScope == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(4);
        }
        return searchScope;
    }

    protected boolean useLocalSearchScope(@Nullable PsiElement declarationScope) {
        return !(declarationScope instanceof PsiFile);
    }

    @Override
    public String getName() {
        if (this.myName == null) {
            this.myName = this.doGetName();
        }
        return this.myName;
    }

    @Nullable
    protected String doGetName() {
        String result2;
        ASTNode firstChildNode;
        String nameFromComputed;
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)((Object)this)).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        ASTNode name = this.findNameIdentifier();
        boolean computed = false;
        if (name == null) {
            name = JSPsiImplUtils.getComputedNameOfVariable(this.getNode(), false);
            boolean bl = computed = name != null;
        }
        if (name == null) {
            name = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode());
        }
        if (name == null && (firstChildNode = this.getNode().getFirstChildNode()) != null) {
            name = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(firstChildNode);
        }
        if ((result2 = JSVariableBaseImpl.getResultNameFromNameNode(name, computed)) == null && !computed) {
            result2 = name != null ? JSPsiImplUtils.getNameFromIdentifier(name) : "";
        }
        return result2;
    }

    @Nullable
    protected static String getResultNameFromNameNode(ASTNode nameNode, boolean computed) {
        if (nameNode != null) {
            String referencedName;
            if (nameNode.getElementType() == JSTokenTypes.STRING_LITERAL) {
                return JSStringUtil.unquoteAndUnescapeStringLiteralValue(nameNode.getText());
            }
            PsiElement element2 = nameNode.getPsi();
            if (computed && element2 instanceof ES6ComputedName) {
                return ((ES6ComputedName)element2).getExpressionAsPropertyName();
            }
            if (element2 instanceof JSReferenceExpression && (referencedName = ((JSReferenceExpression)element2).getReferencedName()) != null) {
                return referencedName;
            }
        }
        return null;
    }

    @Override
    public ASTNode findNameIdentifier() {
        return JSVariableBaseImpl.findVariableNameIdentifier(this.getNode());
    }

    @Nullable
    public static ASTNode findVariableNameIdentifier(@NotNull ASTNode node) {
        if (node == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(5);
        }
        return node.findChildByType(PROPERTY_NAME_TOKENS_SET);
    }

    @Override
    public JSAttributeList getAttributeList() {
        PsiElement parent = this.getParent();
        while (parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement) {
            parent = parent.getParent();
        }
        if (!(parent instanceof JSVarStatementBase)) {
            Logger.getInstance((String)this.getClass().getName()).error("Containing var statement was not found for variable:" + this.getText() + " in " + this.getContainingFile().getName());
            return null;
        }
        return (JSAttributeList)JSStubBasedPsiTreeUtil.getStubOrPsiChild((JSVarStatementBase)parent, JSStubElementTypes.ATTRIBUTE_LISTS, Holder.AFTER_ATTRIBUTE_LIST_TOKEN_SET);
    }

    @Override
    public PsiElement getTypeElement() {
        return JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    @Override
    @Nullable
    public JSType calculateType() {
        JSType type2;
        JSType explicitlyDeclaredType = this.doGetExplicitlyDeclaredType();
        if (explicitlyDeclaredType != null) {
            return explicitlyDeclaredType;
        }
        JSDestructuringContext destructuringContext = JSTypeEvaluator.findDestructuringParents(this);
        JSInitializerOwner initializerOwner = destructuringContext.getOuterElement();
        if (initializerOwner != null && (type2 = this.getTypeFromInitializer(initializerOwner.getInitializer())) != null) {
            return this.applyDestructuringForInitializer(destructuringContext, type2);
        }
        return null;
    }

    @Nullable
    protected JSType applyDestructuringForInitializer(@NotNull JSDestructuringContext context2, @Nullable JSType type2) {
        if (context2 == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(6);
        }
        return context2.applyToOuterType(type2);
    }

    @Nullable
    public JSType doGetExplicitlyDeclaredType() {
        return JSVariableBaseImpl.doGetExplicitlyDeclaredType(this);
    }

    @Nullable
    public static JSType doGetExplicitlyDeclaredType(@NotNull JSVariable var) {
        JSType typeFromDeclaration;
        if (var == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(7);
        }
        if ((typeFromDeclaration = JSPsiImplUtils.getTypeFromDeclaration(var)) != null) {
            return typeFromDeclaration;
        }
        return JSDocumentationUtils.findTypeFromComments(var);
    }

    public static boolean hasExplicitlyDeclaredType(@NotNull JSVariable var) {
        if (var == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(8);
        }
        return JSPsiImplUtils.getTypeElementFromDeclarationIncludingAS(var) != null || JSDocumentationUtils.findTypeFromComments(var) != null;
    }

    @Nullable
    private JSType getTypeFromInitializer(@Nullable JSExpression initializer) {
        if (initializer == null) {
            return null;
        }
        return JSDialectSpecificHandlersFactory.forElement(this).getTypeHelper().getTypeForIndexing(initializer, this);
    }

    @Override
    public boolean requiresTypeChecking() {
        return this.getGistData().requiresTypeChecking();
    }

    public boolean calculateRequiresTypeChecking() {
        return DialectDetector.hasFeature(this, JSLanguageFeature.TYPES) || this.doGetExplicitlyDeclaredType() != null || this.getInitializer() instanceof JSFunction;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(9);
        }
        if (JSVariableBaseImpl.setComputedPropertyName(name, this)) {
            return this;
        }
        ASTNode nameNode = this.findNameIdentifier();
        if (nameNode == null) {
            ASTNode firstChildNode;
            nameNode = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode());
            if (nameNode == null && (firstChildNode = this.getNode().getFirstChildNode()) != null) {
                nameNode = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(firstChildNode);
            }
            if (nameNode == null) {
                return this;
            }
        }
        ASTNode nameElement = JSChangeUtil.createPropertyNameWithContext(name, nameNode);
        nameNode.getTreeParent().replaceChild(nameNode, nameElement);
        return this;
    }

    public static boolean setComputedPropertyName(@NotNull String name, PsiElement owner) {
        JSExpression computedNameExpression;
        ES6ComputedName computedName;
        if (name == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(10);
        }
        if (owner instanceof JSComputedPropertyNameOwner && (computedName = ((JSComputedPropertyNameOwner)owner).getComputedPropertyName()) != null && (computedNameExpression = computedName.getExpression()) instanceof JSLiteralExpression) {
            char quote = computedNameExpression.getText().charAt(0);
            ASTNode expr = JSChangeUtil.createExpressionFromText(owner.getProject(), (String)(name.startsWith("\"") || name.startsWith("'") ? name : quote + name + quote));
            ASTNode node = computedNameExpression.getNode();
            node.getTreeParent().replaceChild(node, expr);
            return true;
        }
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(11);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSVariable(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean isConst() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConst();
        }
        ASTNode parent = JSDestructuringUtil.getParentSkippingDestructuring(this.getNode());
        if (parent == null) {
            return false;
        }
        if (JSElementTypes.VAR_STATEMENTS.contains(parent.getElementType())) {
            ASTNode node;
            for (node = parent.getFirstChildNode(); node != null && ArrayUtil.contains((Object)node.getElementType(), (Object[])TYPES_TO_SKIP); node = node.getTreeNext()) {
            }
            if (node != null && (node.getElementType() == JSTokenTypes.CONST_KEYWORD || node.getElementType() == JSTokenTypes.USING_KEYWORD)) {
                return true;
            }
        }
        return JSDocumentationUtils.calculateConst(this);
    }

    @Override
    public boolean isLocal() {
        return this.getNamespace() == null && !this.isNamespaceExplicitlyDeclared() && JSDocumentationUtils.isClassOrInterface(this) == JSElementBase.ClassOrInterface.NONE && (PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSFunction.class}) != null || this.hasBlockScope() && PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSBlockStatement.class}) != null);
    }

    @Override
    public boolean hasBlockScope() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasBlockScope();
        }
        return JSVariableBaseImpl.hasBlockScope(this.getNode());
    }

    public static boolean hasBlockScope(@NotNull ASTNode varNode) {
        IElementType varKeyword;
        ASTNode varStatement;
        if (varNode == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(12);
        }
        if ((varStatement = JSDestructuringUtil.getParentSkippingDestructuring(varNode)) == null) {
            return false;
        }
        ASTNode varModifier = varStatement.findChildByType(JSTokenTypes.VAR_MODIFIERS);
        IElementType iElementType = varKeyword = varModifier != null ? varModifier.getElementType() : null;
        if (varStatement.getElementType() != JSStubElementTypes.VAR_STATEMENT) {
            return false;
        }
        if (varKeyword == null || varKeyword == JSTokenTypes.VAR_KEYWORD || varKeyword == JSTokenTypes.CONST_KEYWORD && JSTreeUtil.getLanguage(varNode) == FlexSupportLoader.ECMA_SCRIPT_L4) {
            return false;
        }
        return JSTreeUtil.isInBlockScope(varStatement);
    }

    @Override
    public boolean isDeprecated() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        return JSDocumentationUtils.calculateDeprecated(this);
    }

    @Override
    public PsiElement getDeclarationScope() {
        if (this.hasBlockScope()) {
            return JSUseScopeProvider.getBlockScopeElement(this);
        }
        return JSUseScopeProvider.getExecOrClassContext(this);
    }

    public Icon getIcon(int flags) {
        JSExpression initializer;
        Icon baseIcon = JSClassUtils.isClassMember(this) ? IconManager.getInstance().getPlatformIcon(PlatformIcons.Field) : ((initializer = JSPsiImplUtils.getRightmostInitializer(this)) instanceof JSFunctionItem ? JSFunctionImpl.getFunctionBaseIcon((JSFunctionItem)((Object)initializer)) : IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable));
        return JSVariableBaseImpl.getIcon(this, baseIcon, flags);
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (JSVarStatementBase.handleChildDeletion(this)) {
            return;
        }
        if (parent instanceof JSDestructuringArrayRestElement && parent.getParent() instanceof JSDestructuringArray) {
            JSVariableBaseImpl.removeDestructuringArrayItem((JSDestructuringArray)parent.getParent(), parent);
            return;
        }
        if (parent instanceof JSDestructuringArray) {
            JSVariableBaseImpl.removeDestructuringArrayItem((JSDestructuringArray)parent, this);
            return;
        }
        ASTNode parentAstNode = this.getNode().getTreeParent();
        if (JSStubElementTypes.DESTRUCTURING_PROPERTIES.contains(parentAstNode.getElementType())) {
            parent.delete();
            return;
        }
        throw new IncorrectOperationException("Cannot delete variable from parent : " + String.valueOf(parentAstNode.getElementType()));
    }

    static void removeDestructuringArrayItem(@NotNull JSDestructuringArray arrayPattern, @NotNull PsiElement arrayElement) {
        if (arrayPattern == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(13);
        }
        if (arrayElement == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(14);
        }
        if (JSDestructuringUtil.hasSingleElement(arrayPattern)) {
            arrayPattern.getParent().delete();
            return;
        }
        Object[] elements = arrayPattern.getElements();
        int index = ArrayUtil.indexOf((Object[])elements, (Object)arrayElement);
        PsiElement comma = null;
        if ((arrayElement instanceof JSDestructuringArrayRestElement || index == elements.length - 1 && arrayPattern.getRestElement() == null) && PsiUtilCore.getElementType((PsiElement)(comma = PsiTreeUtil.skipWhitespacesBackward((PsiElement)arrayElement))) != JSTokenTypes.COMMA) {
            comma = null;
        }
        arrayElement.replace((PsiElement)JSChangeUtil.createEmptyExpression(arrayElement));
        if (comma != null) {
            comma.delete();
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(17);
        }
        return processor.execute((PsiElement)this, state);
    }

    @Override
    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return this.getJSNamespace().getQualifiedName();
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getJSNamespace().isSourceStrict();
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return true;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                JSVariableBaseImpl.$$$reportNull$$$0(18);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = this.calcAccessType();
        if (accessType == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(19);
        }
        return accessType;
    }

    @NotNull
    protected JSAttributeList.AccessType calcAccessType() {
        JSAttributeList.AccessType accessType = JSPsiImplUtils.getAccessType(this);
        if (accessType == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(20);
        }
        return accessType;
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSVariableBaseImpl.$$$reportNull$$$0(21);
            }
            return jSContext;
        }
        JSContext jSContext = this.getJSNamespace().getJSContext();
        if (jSContext == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(22);
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = (JSNamespace)JSVariableBaseImpl.getCachedValueStubBuildOptimized(this, NAMESPACE_PROVIDER_KEY, STUB_BUILDING_NAMESPACE_PROVIDER_KEY, NAMESPACE_PROVIDER, this);
        if (jSNamespace == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(23);
        }
        return jSNamespace;
    }

    @Override
    @Nullable
    public JSType calculateDeclarationTypeStubSafe() {
        JSTypeDeclaration declaration = JSPsiImplUtils.getTypeElementFromDeclaration(this);
        return JSPsiImplUtils.getTypeFromElement((PsiElement)declaration, this);
    }

    @Nullable
    public static PsiElement getDeclarationScope(@NotNull PsiElement var, boolean hasBlockScope) {
        if (var == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(24);
        }
        if (hasBlockScope) {
            return PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{JSBlockStatement.class, JSExecutionScope.class, JSSwitchStatement.class, JSLoopStatement.class});
        }
        return JSUseScopeProvider.getExecOrClassContext(var);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof JSElement && JSUtils.areElementsEquivalent(this, another);
    }

    @Override
    public boolean shouldSerializeType() {
        JSTypeDeclarationOwner declarationOwner;
        if (this.getTypeElement() instanceof JSTypeDeclaration) {
            return false;
        }
        JSDestructuringContext owner = JSTypeEvaluator.findDestructuringParents(this);
        JSInitializerOwner initializerOwner = owner.getOuterElement();
        return !(initializerOwner instanceof JSTypeDeclarationOwner) || !((declarationOwner = (JSTypeDeclarationOwner)((Object)initializerOwner)).getTypeElement() instanceof JSTypeDeclaration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 18, 19, 20, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: 
            case 4: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varNode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayPattern";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGistData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAccessType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findVariableNameIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyDestructuringForInitializer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGetExplicitlyDeclaredType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitlyDeclaredType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setComputedPropertyName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasBlockScope";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeDestructuringArrayItem";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 18, 19, 20, 21, 22, 23 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        private static final TokenSet AFTER_ATTRIBUTE_LIST_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.VAR_MODIFIERS, JSVarStatementBase.VARIABLES_AND_DESTRUCTURING_CONTAINERS});

        private Holder() {
        }
    }
}

