/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.intellij.plugins.postcss.PostCssBundle;
import org.intellij.plugins.postcss.inspections.PostCssBaseInspection;
import org.intellij.plugins.postcss.psi.PostCssPsiUtil;
import org.jetbrains.annotations.NotNull;

public final class PostCssMediaRangeInspection
extends PostCssBaseInspection {
    private static final Logger LOG = Logger.getInstance(PostCssMediaRangeInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PostCssMediaRangeInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            public void visitMediaFeature(@NotNull CssMediaFeature mediaFeature) {
                if (mediaFeature == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!PostCssPsiUtil.isInsidePostCss((PsiElement)mediaFeature) || PsiTreeUtil.hasErrorElements((PsiElement)mediaFeature)) {
                    return;
                }
                List<? extends PsiElement> comparisonOperators = PostCssPsiUtil.findAllComparisonOperators(mediaFeature);
                if (comparisonOperators.size() != 2) {
                    return;
                }
                boolean hasEqualSign = false;
                for (PsiElement psiElement : comparisonOperators) {
                    if (PostCssMediaRangeInspection.getComparisonOperatorDirection(psiElement) != 0) continue;
                    holder.registerProblem(psiElement, PostCssBundle.message("annotator.equal.operator.is.not.allowed.in.this.context", new Object[0]), new LocalQuickFix[0]);
                    hasEqualSign = true;
                }
                if (hasEqualSign) {
                    return;
                }
                if (PostCssMediaRangeInspection.getComparisonOperatorDirection(comparisonOperators.get(0)) != PostCssMediaRangeInspection.getComparisonOperatorDirection(comparisonOperators.get(1))) {
                    holder.registerProblem(comparisonOperators.get(1), PostCssBundle.message("annotator.media.query.range.operators.should.have.equal.direction", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeature", "org/intellij/plugins/postcss/inspections/PostCssMediaRangeInspection$1", "visitMediaFeature"));
            }
        };
    }

    private static int getComparisonOperatorDirection(@NotNull PsiElement comparisonOperator) {
        IElementType type;
        if (comparisonOperator == null) {
            PostCssMediaRangeInspection.$$$reportNull$$$0(1);
        }
        if ((type = comparisonOperator.getNode().getElementType()) == CssElementTypes.CSS_GT || type == CssElementTypes.CSS_GE) {
            return 1;
        }
        if (type == CssElementTypes.CSS_LT || type == CssElementTypes.CSS_LE) {
            return -1;
        }
        if (type == CssElementTypes.CSS_EQ) {
            return 0;
        }
        LOG.error("Expected comparison operator, got " + String.valueOf(type));
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonOperator";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/postcss/inspections/PostCssMediaRangeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getComparisonOperatorDirection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

