/***************************************************************************
                          icmp.h  -  description
                             -------------------
    begin                : Fri Dec 7 2001
    copyright            : (C) 2001 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef  _ICMP_H
#define  _ICMP_H

#include "wand.h"

#ifndef _NETINET_IP_H
#include <netinet/ip.h>
#endif

/* this is all basically from ip_icmp.h with a little changes */

/*
 * Lower bounds on packet lengths for various types.
 * For the error advice packets must first insure that the
 * packet is large enough to contain the returned ip header.
 * Only then can we do the check to see if 64 bits of packet
 * data have been returned, since we need to check the returned
 * ip header length.
 */
#define	ICMP_MINLEN	8				                          /* abs minimum */
#define	ICMP_TSLEN	(8 + 3 * sizeof (n_time))	        /* timestamp */
#define	ICMP_MASKLEN	12				                      /* address mask */
#define	ICMP_ADVLENMIN	(8 + sizeof (struct ip) + 8)	/* min */

#ifndef _IP_VHL
#define	ICMP_ADVLEN(p)	(8 + ((p)->icmp_ip.ip_hl << 2) + 8)
	/* N.B.: must separately check that ip_hl >= 5 */
#else
#define	ICMP_ADVLEN(p)	(8 + (IP_VHL_HL((p)->icmp_ip.ip_vhl) << 2) + 8)
	/* N.B.: must separately check that header length >= 5 */
#endif


/* Definition of type and code fields. */
#define ICMP_ECHOREPLY		   0	/* Echo Reply			*/
#define	ICMP_DEST_UNREACH		 3		/* dest unreachable, codes: */
#define	ICMP_SOURCE_QUENCH	 4		/* packet lost, slow down */
#define ICMP_REDIRECT		     5	/* Redirect (change route)	*/
#define ICMP_ECHO		         8	/* Echo Request			*/
#define	ICMP_ROUTERADVERT	   9		/* router advertisement */
#define	ICMP_ROUTERSOLICIT	10		/* router solicitation */
#define	ICMP_TIMXCEED		    11		/* time exceeded, code: */
#define	ICMP_PARAMPROB		  12		/* ip header bad */
#define	ICMP_TSTAMP		      13		/* timestamp request */
#define	ICMP_TSTAMPREPLY	  14		/* timestamp reply */
#define	ICMP_IREQ		        15		/* information request */
#define	ICMP_IREQREPLY		  16		/* information reply */
#define	ICMP_MASKREQ		    17		/* address mask request */
#define	ICMP_MASKREPLY		  18		/* address mask reply */
#define	ICMP_MAXTYPE		    18

/* UNREACH codes */
#define	ICMP_UNREACH_NET	               0	/* bad net */
#define	ICMP_UNREACH_HOST	               1	/* bad host */
#define	ICMP_UNREACH_PROTOCOL	           2	/* bad protocol */
#define	ICMP_UNREACH_PORT	               3	/* bad port */
#define	ICMP_UNREACH_NEEDFRAG	           4	/* IP_DF caused drop */
#define	ICMP_UNREACH_SRCFAIL	           5	/* src route failed */
#define	ICMP_UNREACH_NET_UNKNOWN         6	/* unknown net */
#define	ICMP_UNREACH_HOST_UNKNOWN        7	/* unknown host */
#define	ICMP_UNREACH_ISOLATED	           8	/* src host isolated */
#define	ICMP_UNREACH_NET_PROHIB	         9	/* net denied */
#define	ICMP_UNREACH_HOST_PROHIB        10	/* host denied */
#define	ICMP_UNREACH_TOSNET	            11	/* bad tos for net */
#define	ICMP_UNREACH_TOSHOST	          12	/* bad tos for host */
#define	ICMP_UNREACH_FILTER_PROHIB      13	/* admin prohib */
#define	ICMP_UNREACH_HOST_PRECEDENCE    14	/* host prec vio. */
#define	ICMP_UNREACH_PRECEDENCE_CUTOFF  15	/* prec cutoff */

/* REDIRECT codes */
#define	ICMP_REDIRECT_NET	    0		/* for network */
#define	ICMP_REDIRECT_HOST	  1		/* for host */
#define	ICMP_REDIRECT_TOSNET	2		/* for tos and net */
#define	ICMP_REDIRECT_TOSHOST	3		/* for tos and host */

/* TIMEXCEED codes */
#define	ICMP_TIMXCEED_INTRANS	0		/* ttl==0 in transit */
#define	ICMP_TIMXCEED_REASS	  1		/* ttl==0 in reass */

/* PARAMPROB code */
#define	ICMP_PARAMPROB_OPTABSENT 1		/* req. opt. absent */

#define	ICMP_INFOTYPE(type) \
	((type) == ICMP_ECHOREPLY || (type) == ICMP_ECHO || \
	(type) == ICMP_ROUTERADVERT || (type) == ICMP_ROUTERSOLICIT || \
	(type) == ICMP_TSTAMP || (type) == ICMP_TSTAMPREPLY || \
	(type) == ICMP_IREQ || (type) == ICMP_IREQREPLY || \
	(type) == ICMP_MASKREQ || (type) == ICMP_MASKREPLY)


/* for ICMP packets */
struct icmp{

  u_char icmp_type; /* ICMP type */
  u_char icmp_code; /* ICMP sub-code */
  u_int icmp_cksum; /* ICMP checksum */

 union
 {

    u_char paramprob; /* ICMP parameter problem */
    struct in_addr gwaddr; /* gateway address */
    struct seqid{
      u_short id;
      u_short seq;
    }seqid;

    u_int icmp_void;

    /* ICMP_UNREACH_NEEDFRAG -- Path MTU Discovery (RFC 1191) */
    struct pmtu{
      u_short ic_void;
      u_short nextmtu;
    }pmtu;

    /* Router Advertisement */
    struct rtradv{

      u_char num_addr;
      u_char wpa;
      u_short lifetime;
    }rtradv;

 }icmp_ex;

 union
 {

   struct id_ts{

     u_int otime;
     u_int rtime;
     u_int ttime;
   }id_ts;

   struct id_ip{

     struct ip idip;
   }id_ip;

   /* internal of router advertisement */
   struct icmp_rtradv{
     u_int ra_addr;
     u_int ra_pref;
   }icmp_rtradv;

   u_int id_mask;
   u_char id_data[1];

 }icmp_mex;

};

#define S_ICMP    sizeof(struct icmp)

#ifdef _CON_

int get_icmp_arg(char *arg, char *next_arg, struct icmp *eyec);

#endif /* _CON_ */

#ifdef _GTK_


void icmp_spell();

#endif /* _GTK_ */


#endif /* _ICMP_H */

