/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.io.WriteableBinary;

public abstract class WriteableArrayBinary<V>
implements WriteableBinary {
    public V[] value;

    public WriteableArrayBinary(V[] list) {
        this.value = list;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        if (this.value == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.value.length);
            for (V v : this.value) {
                this.writeValue(v, out);
            }
        }
    }

    protected abstract void writeValue(V var1, DataOutput var2) throws IOException;

    @Override
    public byte[] binaryHeader() {
        return this.value.getClass().getName().getBytes();
    }
}

