/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.function.context;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.util.data.Context;
import org.openimaj.util.function.Function;
import org.openimaj.util.function.context.ContextExtractor;
import org.openimaj.util.function.context.KeyContextExtractor;

public class ContextListTransformFunction<IN, OUT>
implements Function<List<Context>, OUT> {
    private ContextExtractor<IN> extractor;
    private Function<List<IN>, OUT> inner;

    public ContextListTransformFunction(ContextExtractor<IN> extract, Function<List<IN>, OUT> inner) {
        this.extractor = extract;
        this.inner = inner;
    }

    public ContextListTransformFunction(String key, Function<List<IN>, OUT> inner) {
        this.extractor = new KeyContextExtractor<IN>(key);
        this.inner = inner;
    }

    @Override
    public OUT apply(List<Context> in) {
        ArrayList<IN> ret = new ArrayList<IN>();
        for (Context context : in) {
            ret.add(this.extractor.extract(context));
        }
        return this.inner.apply(ret);
    }
}

