/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.util.Arrays;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.Vertex;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.utils.SmoothingFilterInitializer;

public class SmoothingFilter
implements IVertexValuator {
    final double[] zArray;
    final double zMin;
    final double zMax;
    private final double timeToConstructFilter;

    public SmoothingFilter(IIncrementalTin tin) {
        long time0 = System.nanoTime();
        SmoothingFilterInitializer smInit = new SmoothingFilterInitializer(tin, 25);
        this.zArray = smInit.result;
        double z0 = Double.POSITIVE_INFINITY;
        double z1 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.zArray.length; ++i) {
            double z = this.zArray[i];
            if (z < z0) {
                z0 = z;
            }
            if (!(z > z1)) continue;
            z1 = z;
        }
        this.zMin = z0;
        this.zMax = z1;
        long time1 = System.nanoTime();
        this.timeToConstructFilter = (double)(time1 - time0) / 1000000.0;
    }

    public double getTimeToConstructFilter() {
        return this.timeToConstructFilter;
    }

    @Override
    public double value(Vertex v) {
        int index = v.getIndex();
        return this.zArray[index];
    }

    public double[] getVertexAdjustments() {
        return Arrays.copyOf(this.zArray, this.zArray.length);
    }

    public void setVertexAdjustments(double[] adjustments) {
        if (adjustments.length != this.zArray.length) {
            throw new IllegalArgumentException("Adjustment size " + adjustments.length + " does not match internal value " + this.zArray.length);
        }
        System.arraycopy(adjustments, 0, this.zArray, 0, adjustments.length);
    }

    public double getMinZ() {
        return this.zMin;
    }

    public double getMaxZ() {
        return this.zMax;
    }
}

