package org.mozilla.javascript;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mozilla.javascript.testutils.Utils;

class BuiltinPrototypePropertyTest {
    @ParameterizedTest(name = "{0} should not have a prototype property")
    @ValueSource(
            strings = {
                "decodeURI",
                "decodeURIComponent",
                "encodeURI",
                "encodeURIComponent",
                "eval",
                "isFinite",
                "isNaN",
                "parseFloat",
                "parseInt",
                "Array.from",
                "Array.isArray",
                "Array.of",
                "Object.getOwnPropertyDescriptor(Array, Symbol.species).get",
                "Array.prototype.at",
                "Array.prototype.concat",
                "Array.prototype.copyWithin",
                "Array.prototype.entries",
                "Array.prototype.every",
                "Array.prototype.fill",
                "Array.prototype.filter",
                "Array.prototype.find",
                "Array.prototype.findIndex",
                "Array.prototype.findLast",
                "Array.prototype.findLastIndex",
                "Array.prototype.flat",
                "Array.prototype.flatMap",
                "Array.prototype.forEach",
                "Array.prototype.includes",
                "Array.prototype.indexOf",
                "Array.prototype.join",
                "Array.prototype.keys",
                "Array.prototype.lastIndexOf",
                "Array.prototype.map",
                "Array.prototype.pop",
                "Array.prototype.push",
                "Array.prototype.reduce",
                "Array.prototype.reduceRight",
                "Array.prototype.reverse",
                "Array.prototype.shift",
                "Array.prototype.slice",
                "Array.prototype.some",
                "Array.prototype.sort",
                "Array.prototype.splice",
                "Array.prototype.toLocaleString",
                "Array.prototype.toReversed",
                "Array.prototype.toSorted",
                "Array.prototype.toSpliced",
                "Array.prototype.toString",
                "Array.prototype.unshift",
                "Array.prototype.values",
                "Array.prototype.with",
                "Array.prototype[Symbol.iterator]",
                "Array.prototype[Symbol.unscopables]",
                "ArrayBuffer.isView",
                "ArrayBuffer.prototype.slice",
                "ArrayBuffer.prototype.transfer",
                "ArrayBuffer.prototype.transferToFixedLength",
                "ArrayBuffer.prototype[Symbol.toStringTag]",
                "BigInt.asIntN",
                "BigInt.asUintN",
                "BigInt.prototype.toLocaleString",
                "BigInt.prototype.toString",
                "BigInt.prototype.valueOf",
                "BigInt.prototype[Symbol.toStringTag]",
                "BigInt64Array.from",
                "BigInt64Array.of",
                "BigInt64Array.prototype.at",
                "BigInt64Array.prototype.copyWithin",
                "BigInt64Array.prototype.entries",
                "BigInt64Array.prototype.every",
                "BigInt64Array.prototype.fill",
                "BigInt64Array.prototype.filter",
                "BigInt64Array.prototype.find",
                "BigInt64Array.prototype.findIndex",
                "BigInt64Array.prototype.findLast",
                "BigInt64Array.prototype.findLastIndex",
                "BigInt64Array.prototype.forEach",
                "BigInt64Array.prototype.includes",
                "BigInt64Array.prototype.indexOf",
                "BigInt64Array.prototype.join",
                "BigInt64Array.prototype.keys",
                "BigInt64Array.prototype.lastIndexOf",
                "BigInt64Array.prototype.map",
                "BigInt64Array.prototype.reduce",
                "BigInt64Array.prototype.reduceRight",
                "BigInt64Array.prototype.reverse",
                "BigInt64Array.prototype.set",
                "BigInt64Array.prototype.slice",
                "BigInt64Array.prototype.some",
                "BigInt64Array.prototype.sort",
                "BigInt64Array.prototype.subarray",
                "BigInt64Array.prototype.toLocaleString",
                "BigInt64Array.prototype.toReversed",
                "BigInt64Array.prototype.toSorted",
                "BigInt64Array.prototype.toString",
                "BigInt64Array.prototype.values",
                "BigInt64Array.prototype.with",
                "BigInt64Array.prototype[Symbol.iterator]",
                "BigUint64Array.from",
                "BigUint64Array.of",
                "BigUint64Array.prototype.at",
                "BigUint64Array.prototype.copyWithin",
                "BigUint64Array.prototype.entries",
                "BigUint64Array.prototype.every",
                "BigUint64Array.prototype.fill",
                "BigUint64Array.prototype.filter",
                "BigUint64Array.prototype.find",
                "BigUint64Array.prototype.findIndex",
                "BigUint64Array.prototype.findLast",
                "BigUint64Array.prototype.findLastIndex",
                "BigUint64Array.prototype.forEach",
                "BigUint64Array.prototype.includes",
                "BigUint64Array.prototype.indexOf",
                "BigUint64Array.prototype.join",
                "BigUint64Array.prototype.keys",
                "BigUint64Array.prototype.lastIndexOf",
                "BigUint64Array.prototype.map",
                "BigUint64Array.prototype.reduce",
                "BigUint64Array.prototype.reduceRight",
                "BigUint64Array.prototype.reverse",
                "BigUint64Array.prototype.set",
                "BigUint64Array.prototype.slice",
                "BigUint64Array.prototype.some",
                "BigUint64Array.prototype.sort",
                "BigUint64Array.prototype.subarray",
                "BigUint64Array.prototype.toLocaleString",
                "BigUint64Array.prototype.toReversed",
                "BigUint64Array.prototype.toSorted",
                "BigUint64Array.prototype.toString",
                "BigUint64Array.prototype.values",
                "BigUint64Array.prototype.with",
                "BigUint64Array.prototype[Symbol.iterator]",
                "Boolean.prototype.toString",
                "Boolean.prototype.valueOf",
                // Not implemented
                // "DataView.prototype.getBigInt64",
                // "DataView.prototype.getBigUint64",
                "DataView.prototype.getFloat32",
                "DataView.prototype.getFloat64",
                "DataView.prototype.getInt16",
                "DataView.prototype.getInt32",
                "DataView.prototype.getInt8",
                "DataView.prototype.getUint16",
                "DataView.prototype.getUint32",
                "DataView.prototype.getUint8",
                // Not implemented
                // "DataView.prototype.setBigInt64",
                // "DataView.prototype.setBigUint64",
                "DataView.prototype.setFloat32",
                "DataView.prototype.setFloat64",
                "DataView.prototype.setInt16",
                "DataView.prototype.setInt32",
                "DataView.prototype.setInt8",
                "DataView.prototype.setUint16",
                "DataView.prototype.setUint32",
                "DataView.prototype.setUint8",
                "DataView.prototype[Symbol.toStringTag]",
                "Date.UTC",
                "Date.now",
                "Date.parse",
                "Date.prototype.getDate",
                "Date.prototype.getDay",
                "Date.prototype.getFullYear",
                "Date.prototype.getHours",
                "Date.prototype.getMilliseconds",
                "Date.prototype.getMinutes",
                "Date.prototype.getMonth",
                "Date.prototype.getSeconds",
                "Date.prototype.getTime",
                "Date.prototype.getTimezoneOffset",
                "Date.prototype.getUTCDate",
                "Date.prototype.getUTCDay",
                "Date.prototype.getUTCFullYear",
                "Date.prototype.getUTCHours",
                "Date.prototype.getUTCMilliseconds",
                "Date.prototype.getUTCMinutes",
                "Date.prototype.getUTCMonth",
                "Date.prototype.getUTCSeconds",
                "Date.prototype.setDate",
                "Date.prototype.setFullYear",
                "Date.prototype.setHours",
                "Date.prototype.setMilliseconds",
                "Date.prototype.setMinutes",
                "Date.prototype.setMonth",
                "Date.prototype.setSeconds",
                "Date.prototype.setTime",
                "Date.prototype.setUTCDate",
                "Date.prototype.setUTCFullYear",
                "Date.prototype.setUTCHours",
                "Date.prototype.setUTCMilliseconds",
                "Date.prototype.setUTCMinutes",
                "Date.prototype.setUTCMonth",
                "Date.prototype.setUTCSeconds",
                "Date.prototype.toDateString",
                "Date.prototype.toGMTString",
                "Date.prototype.toISOString",
                "Date.prototype.toJSON",
                "Date.prototype.toLocaleDateString",
                "Date.prototype.toLocaleString",
                "Date.prototype.toLocaleTimeString",
                "Date.prototype.toString",
                "Date.prototype.toTimeString",
                "Date.prototype.toUTCString",
                "Date.prototype.valueOf",
                "Error.prototype.toString",
                "EvalError.prototype.toString",
                "Float32Array.from",
                "Float32Array.of",
                "Float32Array.prototype.at",
                "Float32Array.prototype.copyWithin",
                "Float32Array.prototype.entries",
                "Float32Array.prototype.every",
                "Float32Array.prototype.fill",
                "Float32Array.prototype.filter",
                "Float32Array.prototype.find",
                "Float32Array.prototype.findIndex",
                "Float32Array.prototype.findLast",
                "Float32Array.prototype.findLastIndex",
                "Float32Array.prototype.forEach",
                "Float32Array.prototype.includes",
                "Float32Array.prototype.indexOf",
                "Float32Array.prototype.join",
                "Float32Array.prototype.keys",
                "Float32Array.prototype.lastIndexOf",
                "Float32Array.prototype.map",
                "Float32Array.prototype.reduce",
                "Float32Array.prototype.reduceRight",
                "Float32Array.prototype.reverse",
                "Float32Array.prototype.set",
                "Float32Array.prototype.slice",
                "Float32Array.prototype.some",
                "Float32Array.prototype.sort",
                "Float32Array.prototype.subarray",
                "Float32Array.prototype.toLocaleString",
                "Float32Array.prototype.toReversed",
                "Float32Array.prototype.toSorted",
                "Float32Array.prototype.toString",
                "Float32Array.prototype.values",
                "Float32Array.prototype.with",
                "Float32Array.prototype[Symbol.iterator]",
                "Float64Array.from",
                "Float64Array.of",
                "Float64Array.prototype.at",
                "Float64Array.prototype.copyWithin",
                "Float64Array.prototype.entries",
                "Float64Array.prototype.every",
                "Float64Array.prototype.fill",
                "Float64Array.prototype.filter",
                "Float64Array.prototype.find",
                "Float64Array.prototype.findIndex",
                "Float64Array.prototype.findLast",
                "Float64Array.prototype.findLastIndex",
                "Float64Array.prototype.forEach",
                "Float64Array.prototype.includes",
                "Float64Array.prototype.indexOf",
                "Float64Array.prototype.join",
                "Float64Array.prototype.keys",
                "Float64Array.prototype.lastIndexOf",
                "Float64Array.prototype.map",
                "Float64Array.prototype.reduce",
                "Float64Array.prototype.reduceRight",
                "Float64Array.prototype.reverse",
                "Float64Array.prototype.set",
                "Float64Array.prototype.slice",
                "Float64Array.prototype.some",
                "Float64Array.prototype.sort",
                "Float64Array.prototype.subarray",
                "Float64Array.prototype.toLocaleString",
                "Float64Array.prototype.toReversed",
                "Float64Array.prototype.toSorted",
                "Float64Array.prototype.toString",
                "Float64Array.prototype.values",
                "Float64Array.prototype.with",
                "Float64Array.prototype[Symbol.iterator]",
                "Function.prototype.apply",
                "Function.prototype.bind",
                "Function.prototype.call",
                "Function.prototype.toString",
                "Int16Array.from",
                "Int16Array.of",
                "Int16Array.prototype.at",
                "Int16Array.prototype.copyWithin",
                "Int16Array.prototype.entries",
                "Int16Array.prototype.every",
                "Int16Array.prototype.fill",
                "Int16Array.prototype.filter",
                "Int16Array.prototype.find",
                "Int16Array.prototype.findIndex",
                "Int16Array.prototype.findLast",
                "Int16Array.prototype.findLastIndex",
                "Int16Array.prototype.forEach",
                "Int16Array.prototype.includes",
                "Int16Array.prototype.indexOf",
                "Int16Array.prototype.join",
                "Int16Array.prototype.keys",
                "Int16Array.prototype.lastIndexOf",
                "Int16Array.prototype.map",
                "Int16Array.prototype.reduce",
                "Int16Array.prototype.reduceRight",
                "Int16Array.prototype.reverse",
                "Int16Array.prototype.set",
                "Int16Array.prototype.slice",
                "Int16Array.prototype.some",
                "Int16Array.prototype.sort",
                "Int16Array.prototype.subarray",
                "Int16Array.prototype.toLocaleString",
                "Int16Array.prototype.toReversed",
                "Int16Array.prototype.toSorted",
                "Int16Array.prototype.toString",
                "Int16Array.prototype.values",
                "Int16Array.prototype.with",
                "Int16Array.prototype[Symbol.iterator]",
                "Int32Array.from",
                "Int32Array.of",
                "Int32Array.prototype.at",
                "Int32Array.prototype.copyWithin",
                "Int32Array.prototype.entries",
                "Int32Array.prototype.every",
                "Int32Array.prototype.fill",
                "Int32Array.prototype.filter",
                "Int32Array.prototype.find",
                "Int32Array.prototype.findIndex",
                "Int32Array.prototype.findLast",
                "Int32Array.prototype.findLastIndex",
                "Int32Array.prototype.forEach",
                "Int32Array.prototype.includes",
                "Int32Array.prototype.indexOf",
                "Int32Array.prototype.join",
                "Int32Array.prototype.keys",
                "Int32Array.prototype.lastIndexOf",
                "Int32Array.prototype.map",
                "Int32Array.prototype.reduce",
                "Int32Array.prototype.reduceRight",
                "Int32Array.prototype.reverse",
                "Int32Array.prototype.set",
                "Int32Array.prototype.slice",
                "Int32Array.prototype.some",
                "Int32Array.prototype.sort",
                "Int32Array.prototype.subarray",
                "Int32Array.prototype.toLocaleString",
                "Int32Array.prototype.toReversed",
                "Int32Array.prototype.toSorted",
                "Int32Array.prototype.toString",
                "Int32Array.prototype.values",
                "Int32Array.prototype.with",
                "Int32Array.prototype[Symbol.iterator]",
                "Int8Array.from",
                "Int8Array.of",
                "Int8Array.prototype.at",
                "Int8Array.prototype.copyWithin",
                "Int8Array.prototype.entries",
                "Int8Array.prototype.every",
                "Int8Array.prototype.fill",
                "Int8Array.prototype.filter",
                "Int8Array.prototype.find",
                "Int8Array.prototype.findIndex",
                "Int8Array.prototype.findLast",
                "Int8Array.prototype.findLastIndex",
                "Int8Array.prototype.forEach",
                "Int8Array.prototype.includes",
                "Int8Array.prototype.indexOf",
                "Int8Array.prototype.join",
                "Int8Array.prototype.keys",
                "Int8Array.prototype.lastIndexOf",
                "Int8Array.prototype.map",
                "Int8Array.prototype.reduce",
                "Int8Array.prototype.reduceRight",
                "Int8Array.prototype.reverse",
                "Int8Array.prototype.set",
                "Int8Array.prototype.slice",
                "Int8Array.prototype.some",
                "Int8Array.prototype.sort",
                "Int8Array.prototype.subarray",
                "Int8Array.prototype.toLocaleString",
                "Int8Array.prototype.toReversed",
                "Int8Array.prototype.toSorted",
                "Int8Array.prototype.toString",
                "Int8Array.prototype.values",
                "Int8Array.prototype.with",
                "Int8Array.prototype[Symbol.iterator]",
                "JSON.parse",
                "JSON.stringify",
                "JSON[Symbol.toStringTag]",
                "Map.prototype.clear",
                "Map.prototype.delete",
                "Map.prototype.entries",
                "Map.prototype.forEach",
                "Map.prototype.get",
                "Map.prototype.has",
                "Map.prototype.keys",
                "Map.prototype.set",
                "Map.prototype.values",
                "Map.prototype[Symbol.iterator]",
                "Map.prototype[Symbol.toStringTag]",
                "Object.getOwnPropertyDescriptor(Map.prototype, 'size').get",
                "Math.abs",
                "Math.acos",
                "Math.acosh",
                "Math.asin",
                "Math.asinh",
                "Math.atan",
                "Math.atan2",
                "Math.atanh",
                "Math.cbrt",
                "Math.ceil",
                "Math.clz32",
                "Math.cos",
                "Math.cosh",
                "Math.exp",
                "Math.expm1",
                "Math.floor",
                "Math.fround",
                "Math.hypot",
                "Math.imul",
                "Math.log",
                "Math.log10",
                "Math.log1p",
                "Math.log2",
                "Math.max",
                "Math.min",
                "Math.pow",
                "Math.random",
                "Math.round",
                "Math.sign",
                "Math.sin",
                "Math.sinh",
                "Math.sqrt",
                "Math.tan",
                "Math.tanh",
                "Math.trunc",
                "Math[Symbol.toStringTag]",
                "Number.isFinite",
                "Number.isInteger",
                "Number.isNaN",
                "Number.isSafeInteger",
                "Number.parseFloat",
                "Number.parseInt",
                "Number.prototype.toExponential",
                "Number.prototype.toFixed",
                "Number.prototype.toLocaleString",
                "Number.prototype.toPrecision",
                "Number.prototype.toString",
                "Number.prototype.valueOf",
                "Object.assign",
                "Object.create",
                "Object.defineProperties",
                "Object.defineProperty",
                "Object.entries",
                "Object.freeze",
                "Object.fromEntries",
                "Object.getOwnPropertyDescriptor",
                "Object.getOwnPropertyDescriptors",
                "Object.getOwnPropertyNames",
                "Object.getOwnPropertySymbols",
                "Object.getPrototypeOf",
                "Object.groupBy",
                "Object.hasOwn",
                "Object.is",
                "Object.isExtensible",
                "Object.isFrozen",
                "Object.isSealed",
                "Object.keys",
                "Object.preventExtensions",
                "Object.prototype.hasOwnProperty",
                "Object.prototype.isPrototypeOf",
                "Object.prototype.propertyIsEnumerable",
                "Object.prototype.toLocaleString",
                "Object.prototype.toString",
                "Object.prototype.valueOf",
                "Object.seal",
                "Object.setPrototypeOf",
                "Object.values",
                "Promise.all",
                "Promise.allSettled",
                "Promise.any",
                "Promise.prototype.catch",
                "Promise.prototype.finally",
                "Promise.prototype.then",
                "Promise.prototype[Symbol.toStringTag]",
                "Promise.race",
                "Promise.reject",
                "Promise.resolve",
                "RangeError.prototype.toString",
                "ReferenceError.prototype.toString",
                "Reflect.apply",
                "Reflect.construct",
                "Reflect.defineProperty",
                "Reflect.deleteProperty",
                "Reflect.get",
                "Reflect.getOwnPropertyDescriptor",
                "Reflect.getPrototypeOf",
                "Reflect.has",
                "Reflect.isExtensible",
                "Reflect.ownKeys",
                "Reflect.preventExtensions",
                "Reflect.set",
                "Reflect.setPrototypeOf",
                "Reflect[Symbol.toStringTag]",
                "RegExp.prototype.exec",
                "RegExp.prototype.test",
                "RegExp.prototype.toString",
                "RegExp.prototype[Symbol.matchAll]",
                "RegExp.prototype[Symbol.match]",
                "RegExp.prototype[Symbol.replace]",
                "RegExp.prototype[Symbol.search]",
                "RegExp.prototype[Symbol.split]",
                "Set.prototype.add",
                "Set.prototype.clear",
                "Set.prototype.delete",
                "Set.prototype.difference",
                "Set.prototype.entries",
                "Set.prototype.forEach",
                "Set.prototype.has",
                "Set.prototype.intersection",
                "Set.prototype.isDisjointFrom",
                "Set.prototype.isSubsetOf",
                "Set.prototype.isSupersetOf",
                "Set.prototype.keys",
                "Set.prototype.symmetricDifference",
                "Set.prototype.union",
                "Set.prototype.values",
                "Set.prototype[Symbol.iterator]",
                "Set.prototype[Symbol.toStringTag]",
                "Object.getOwnPropertyDescriptor(Set.prototype, 'size').get",
                "String.fromCharCode",
                "String.fromCodePoint",
                "String.prototype.anchor",
                "String.prototype.at",
                "String.prototype.big",
                "String.prototype.blink",
                "String.prototype.bold",
                "String.prototype.charAt",
                "String.prototype.charCodeAt",
                "String.prototype.codePointAt",
                "String.prototype.concat",
                "String.prototype.endsWith",
                "String.prototype.fixed",
                "String.prototype.fontcolor",
                "String.prototype.fontsize",
                "String.prototype.includes",
                "String.prototype.indexOf",
                "String.prototype.isWellFormed",
                "String.prototype.italics",
                "String.prototype.lastIndexOf",
                "String.prototype.link",
                "String.prototype.localeCompare",
                "String.prototype.match",
                "String.prototype.matchAll",
                "String.prototype.normalize",
                "String.prototype.padEnd",
                "String.prototype.padStart",
                "String.prototype.repeat",
                "String.prototype.replace",
                "String.prototype.replaceAll",
                "String.prototype.search",
                "String.prototype.slice",
                "String.prototype.small",
                "String.prototype.split",
                "String.prototype.startsWith",
                "String.prototype.strike",
                "String.prototype.sub",
                "String.prototype.substr",
                "String.prototype.substring",
                "String.prototype.sup",
                "String.prototype.toLocaleLowerCase",
                "String.prototype.toLocaleUpperCase",
                "String.prototype.toLowerCase",
                "String.prototype.toString",
                "String.prototype.toUpperCase",
                "String.prototype.toWellFormed",
                "String.prototype.trim",
                "String.prototype.trimEnd",
                "String.prototype.trimLeft",
                "String.prototype.trimRight",
                "String.prototype.trimStart",
                "String.prototype.valueOf",
                "String.prototype[Symbol.iterator]",
                "String.raw",
                "Symbol.for",
                "Symbol.keyFor",
                "Symbol.prototype.toString",
                "Symbol.prototype.valueOf",
                "Symbol.prototype[Symbol.toPrimitive]",
                "Symbol.prototype[Symbol.toStringTag]",
                "SyntaxError.prototype.toString",
                "TypeError.prototype.toString",
                "URIError.prototype.toString",
                "Uint16Array.from",
                "Uint16Array.of",
                "Uint16Array.prototype.at",
                "Uint16Array.prototype.copyWithin",
                "Uint16Array.prototype.entries",
                "Uint16Array.prototype.every",
                "Uint16Array.prototype.fill",
                "Uint16Array.prototype.filter",
                "Uint16Array.prototype.find",
                "Uint16Array.prototype.findIndex",
                "Uint16Array.prototype.findLast",
                "Uint16Array.prototype.findLastIndex",
                "Uint16Array.prototype.forEach",
                "Uint16Array.prototype.includes",
                "Uint16Array.prototype.indexOf",
                "Uint16Array.prototype.join",
                "Uint16Array.prototype.keys",
                "Uint16Array.prototype.lastIndexOf",
                "Uint16Array.prototype.map",
                "Uint16Array.prototype.reduce",
                "Uint16Array.prototype.reduceRight",
                "Uint16Array.prototype.reverse",
                "Uint16Array.prototype.set",
                "Uint16Array.prototype.slice",
                "Uint16Array.prototype.some",
                "Uint16Array.prototype.sort",
                "Uint16Array.prototype.subarray",
                "Uint16Array.prototype.toLocaleString",
                "Uint16Array.prototype.toReversed",
                "Uint16Array.prototype.toSorted",
                "Uint16Array.prototype.toString",
                "Uint16Array.prototype.values",
                "Uint16Array.prototype.with",
                "Uint16Array.prototype[Symbol.iterator]",
                "Uint32Array.from",
                "Uint32Array.of",
                "Uint32Array.prototype.at",
                "Uint32Array.prototype.copyWithin",
                "Uint32Array.prototype.entries",
                "Uint32Array.prototype.every",
                "Uint32Array.prototype.fill",
                "Uint32Array.prototype.filter",
                "Uint32Array.prototype.find",
                "Uint32Array.prototype.findIndex",
                "Uint32Array.prototype.findLast",
                "Uint32Array.prototype.findLastIndex",
                "Uint32Array.prototype.forEach",
                "Uint32Array.prototype.includes",
                "Uint32Array.prototype.indexOf",
                "Uint32Array.prototype.join",
                "Uint32Array.prototype.keys",
                "Uint32Array.prototype.lastIndexOf",
                "Uint32Array.prototype.map",
                "Uint32Array.prototype.reduce",
                "Uint32Array.prototype.reduceRight",
                "Uint32Array.prototype.reverse",
                "Uint32Array.prototype.set",
                "Uint32Array.prototype.slice",
                "Uint32Array.prototype.some",
                "Uint32Array.prototype.sort",
                "Uint32Array.prototype.subarray",
                "Uint32Array.prototype.toLocaleString",
                "Uint32Array.prototype.toReversed",
                "Uint32Array.prototype.toSorted",
                "Uint32Array.prototype.toString",
                "Uint32Array.prototype.values",
                "Uint32Array.prototype.with",
                "Uint32Array.prototype[Symbol.iterator]",
                "Uint8Array.from",
                "Uint8Array.of",
                "Uint8Array.prototype.at",
                "Uint8Array.prototype.copyWithin",
                "Uint8Array.prototype.entries",
                "Uint8Array.prototype.every",
                "Uint8Array.prototype.fill",
                "Uint8Array.prototype.filter",
                "Uint8Array.prototype.find",
                "Uint8Array.prototype.findIndex",
                "Uint8Array.prototype.findLast",
                "Uint8Array.prototype.findLastIndex",
                "Uint8Array.prototype.forEach",
                "Uint8Array.prototype.includes",
                "Uint8Array.prototype.indexOf",
                "Uint8Array.prototype.join",
                "Uint8Array.prototype.keys",
                "Uint8Array.prototype.lastIndexOf",
                "Uint8Array.prototype.map",
                "Uint8Array.prototype.reduce",
                "Uint8Array.prototype.reduceRight",
                "Uint8Array.prototype.reverse",
                "Uint8Array.prototype.set",
                "Uint8Array.prototype.slice",
                "Uint8Array.prototype.some",
                "Uint8Array.prototype.sort",
                "Uint8Array.prototype.subarray",
                "Uint8Array.prototype.toLocaleString",
                "Uint8Array.prototype.toReversed",
                "Uint8Array.prototype.toSorted",
                "Uint8Array.prototype.toString",
                "Uint8Array.prototype.values",
                "Uint8Array.prototype.with",
                "Uint8Array.prototype[Symbol.iterator]",
                "Uint8ClampedArray.from",
                "Uint8ClampedArray.of",
                "Uint8ClampedArray.prototype.at",
                "Uint8ClampedArray.prototype.copyWithin",
                "Uint8ClampedArray.prototype.entries",
                "Uint8ClampedArray.prototype.every",
                "Uint8ClampedArray.prototype.fill",
                "Uint8ClampedArray.prototype.filter",
                "Uint8ClampedArray.prototype.find",
                "Uint8ClampedArray.prototype.findIndex",
                "Uint8ClampedArray.prototype.findLast",
                "Uint8ClampedArray.prototype.findLastIndex",
                "Uint8ClampedArray.prototype.forEach",
                "Uint8ClampedArray.prototype.includes",
                "Uint8ClampedArray.prototype.indexOf",
                "Uint8ClampedArray.prototype.join",
                "Uint8ClampedArray.prototype.keys",
                "Uint8ClampedArray.prototype.lastIndexOf",
                "Uint8ClampedArray.prototype.map",
                "Uint8ClampedArray.prototype.reduce",
                "Uint8ClampedArray.prototype.reduceRight",
                "Uint8ClampedArray.prototype.reverse",
                "Uint8ClampedArray.prototype.set",
                "Uint8ClampedArray.prototype.slice",
                "Uint8ClampedArray.prototype.some",
                "Uint8ClampedArray.prototype.sort",
                "Uint8ClampedArray.prototype.subarray",
                "Uint8ClampedArray.prototype.toLocaleString",
                "Uint8ClampedArray.prototype.toReversed",
                "Uint8ClampedArray.prototype.toSorted",
                "Uint8ClampedArray.prototype.toString",
                "Uint8ClampedArray.prototype.values",
                "Uint8ClampedArray.prototype.with",
                "Uint8ClampedArray.prototype[Symbol.iterator]",
                "WeakMap.prototype.delete",
                "WeakMap.prototype.get",
                "WeakMap.prototype.has",
                "WeakMap.prototype.set",
                "WeakMap.prototype[Symbol.toStringTag]",
                "WeakSet.prototype.add",
                "WeakSet.prototype.delete",
                "WeakSet.prototype.has",
                "WeakSet.prototype[Symbol.toStringTag]",
            })
    void builtinShouldNotHavePrototypeProperty(String name) {
        Utils.assertWithAllModes_ES6("undefined", String.format("typeof %s.prototype ", name));
    }
}
