/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authz.AuthorizationService;

public class TransportGetUserPrivilegesAction
extends HandledTransportAction<GetUserPrivilegesRequest, GetUserPrivilegesResponse> {
    private final ThreadPool threadPool;
    private final AuthorizationService authorizationService;
    private final SecurityContext securityContext;

    @Inject
    public TransportGetUserPrivilegesAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, AuthorizationService authorizationService, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/user/list_privileges", transportService, actionFilters, GetUserPrivilegesRequest::new);
        this.threadPool = threadPool;
        this.authorizationService = authorizationService;
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, GetUserPrivilegesRequest request, ActionListener<GetUserPrivilegesResponse> listener) {
        String username = request.username();
        Authentication authentication = this.securityContext.getAuthentication();
        User user = this.securityContext.getUser();
        if (authentication == null || user == null) {
            listener.onFailure((Exception)new IllegalArgumentException("cannot list privileges as there is no active user"));
            return;
        }
        if (!user.principal().equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("users may only list the privileges of their own account"));
            return;
        }
        this.authorizationService.retrieveUserPrivileges(authentication, request, listener);
    }
}

