/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.privilege;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestPutPrivilegesAction
extends SecurityBaseRestHandler {
    public RestPutPrivilegesAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_security/privilege/").replaces(RestRequest.Method.PUT, "/_xpack/security/privilege/", RestApiVersion.V_7).build(), (Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/privilege/").replaces(RestRequest.Method.POST, "/_xpack/security/privilege/", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_put_privileges_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutPrivilegesRequestBuilder requestBuilder = (PutPrivilegesRequestBuilder)new SecurityClient((ElasticsearchClient)client).preparePutPrivileges(request.requiredContent(), request.getXContentType()).setRefreshPolicy(request.param("refresh"));
        return RestPutPrivilegesAction.execute(requestBuilder);
    }

    static BaseRestHandler.RestChannelConsumer execute(final PutPrivilegesRequestBuilder requestBuilder) {
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<PutPrivilegesResponse>(channel){

            public RestResponse buildResponse(PutPrivilegesResponse response, XContentBuilder builder) throws Exception {
                List privileges = ((PutPrivilegesRequest)requestBuilder.request()).getPrivileges();
                HashMap result = new HashMap();
                privileges.stream().map(ApplicationPrivilegeDescriptor::getApplication).distinct().forEach(a -> result.put(a, new HashMap()));
                privileges.forEach(privilege -> {
                    String name = privilege.getName();
                    boolean created = response.created().getOrDefault(privilege.getApplication(), Collections.emptyList()).contains(name);
                    ((Map)result.get(privilege.getApplication())).put(name, Collections.singletonMap("created", created));
                });
                builder.map(result);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

