/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class IndexOfFunctionProcessor
implements Processor {
    public static final String NAME = "siof";
    private final Processor input;
    private final Processor substring;
    private final Processor start;
    private final boolean caseInsensitive;

    public IndexOfFunctionProcessor(Processor input, Processor substring, Processor start, boolean caseInsensitive) {
        this.input = input;
        this.substring = substring;
        this.start = start;
        this.caseInsensitive = caseInsensitive;
    }

    public IndexOfFunctionProcessor(StreamInput in) throws IOException {
        this.input = (Processor)in.readNamedWriteable(Processor.class);
        this.substring = (Processor)in.readNamedWriteable(Processor.class);
        this.start = (Processor)in.readNamedWriteable(Processor.class);
        this.caseInsensitive = in.readBoolean();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.input);
        out.writeNamedWriteable((NamedWriteable)this.substring);
        out.writeNamedWriteable((NamedWriteable)this.start);
        out.writeBoolean(this.caseInsensitive);
    }

    public Object process(Object o) {
        return IndexOfFunctionProcessor.doProcess(this.input.process(o), this.substring.process(o), this.start.process(o), this.isCaseInsensitive());
    }

    public static Object doProcess(Object input, Object substring, Object start, boolean caseInsensitive) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof String) && !(input instanceof Character)) {
            throw new EqlIllegalArgumentException("A string/char is required; received [{}]", input);
        }
        if (substring == null) {
            return null;
        }
        if (!(substring instanceof String) && !(substring instanceof Character)) {
            throw new EqlIllegalArgumentException("A string/char is required; received [{}]", substring);
        }
        if (start != null && !(start instanceof Number)) {
            throw new EqlIllegalArgumentException("A number is required; received [{}]", start);
        }
        int startIndex = start == null ? 0 : ((Number)start).intValue();
        int result = !caseInsensitive ? input.toString().indexOf(substring.toString(), startIndex) : input.toString().toLowerCase(Locale.ROOT).indexOf(substring.toString().toLowerCase(Locale.ROOT), startIndex);
        return result < 0 ? null : Integer.valueOf(result);
    }

    protected Processor input() {
        return this.input;
    }

    protected Processor substring() {
        return this.substring;
    }

    protected Processor start() {
        return this.start;
    }

    protected boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IndexOfFunctionProcessor other = (IndexOfFunctionProcessor)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.substring(), other.substring()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.isCaseInsensitive(), other.isCaseInsensitive());
    }

    public int hashCode() {
        return Objects.hash(this.input(), this.substring(), this.start(), this.isCaseInsensitive());
    }

    public String getWriteableName() {
        return NAME;
    }
}

