/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureAction;
import org.elasticsearch.xpack.core.textstructure.structurefinder.TextStructure;

public class TextStructureOverrides {
    public static final TextStructureOverrides EMPTY_OVERRIDES = new Builder().build();
    private final String charset;
    private final TextStructure.Format format;
    private final List<String> columnNames;
    private final Boolean hasHeaderRow;
    private final Character delimiter;
    private final Character quote;
    private final Boolean shouldTrimFields;
    private final String grokPattern;
    private final String timestampFormat;
    private final String timestampField;

    public TextStructureOverrides(FindStructureAction.Request request) {
        this(request.getCharset(), request.getFormat(), request.getColumnNames(), request.getHasHeaderRow(), request.getDelimiter(), request.getQuote(), request.getShouldTrimFields(), request.getGrokPattern(), request.getTimestampFormat(), request.getTimestampField());
    }

    private TextStructureOverrides(String charset, TextStructure.Format format, List<String> columnNames, Boolean hasHeaderRow, Character delimiter, Character quote, Boolean shouldTrimFields, String grokPattern, String timestampFormat, String timestampField) {
        this.charset = charset;
        this.format = format;
        this.columnNames = columnNames == null ? null : Collections.unmodifiableList(new ArrayList<String>(columnNames));
        this.hasHeaderRow = hasHeaderRow;
        this.delimiter = delimiter;
        this.quote = quote;
        this.shouldTrimFields = shouldTrimFields;
        this.grokPattern = grokPattern;
        this.timestampFormat = timestampFormat;
        this.timestampField = timestampField;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCharset() {
        return this.charset;
    }

    public TextStructure.Format getFormat() {
        return this.format;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Boolean getHasHeaderRow() {
        return this.hasHeaderRow;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public Character getQuote() {
        return this.quote;
    }

    public Boolean getShouldTrimFields() {
        return this.shouldTrimFields;
    }

    public String getGrokPattern() {
        return this.grokPattern;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public int hashCode() {
        return Objects.hash(this.charset, this.format, this.columnNames, this.hasHeaderRow, this.delimiter, this.quote, this.shouldTrimFields, this.grokPattern, this.timestampFormat, this.timestampField);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TextStructureOverrides that = (TextStructureOverrides)other;
        return Objects.equals(this.charset, that.charset) && Objects.equals(this.format, that.format) && Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.hasHeaderRow, that.hasHeaderRow) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.quote, that.quote) && Objects.equals(this.shouldTrimFields, that.shouldTrimFields) && Objects.equals(this.grokPattern, that.grokPattern) && Objects.equals(this.timestampFormat, that.timestampFormat) && Objects.equals(this.timestampField, that.timestampField);
    }

    public static class Builder {
        private String charset;
        private TextStructure.Format format;
        private List<String> columnNames;
        private Boolean hasHeaderRow;
        private Character delimiter;
        private Character quote;
        private Boolean shouldTrimFields;
        private String grokPattern;
        private String timestampFormat;
        private String timestampField;

        public Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder setFormat(TextStructure.Format format) {
            this.format = format;
            return this;
        }

        public Builder setColumnNames(List<String> columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        public Builder setHasHeaderRow(Boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
            return this;
        }

        public Builder setDelimiter(Character delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder setQuote(Character quote) {
            this.quote = quote;
            return this;
        }

        public Builder setShouldTrimFields(Boolean shouldTrimFields) {
            this.shouldTrimFields = shouldTrimFields;
            return this;
        }

        public Builder setGrokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
            return this;
        }

        public Builder setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public Builder setTimestampField(String timestampField) {
            this.timestampField = timestampField;
            return this;
        }

        public TextStructureOverrides build() {
            return new TextStructureOverrides(this.charset, this.format, this.columnNames, this.hasHeaderRow, this.delimiter, this.quote, this.shouldTrimFields, this.grokPattern, this.timestampFormat, this.timestampField);
        }
    }
}

