/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.SetUpgradeModeAction;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class TransportSetUpgradeModeAction
extends AcknowledgedTransportMasterNodeAction<SetUpgradeModeAction.Request> {
    private static final Set<String> ML_TASK_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("xpack/ml/job", "xpack/ml/datafeed", "xpack/ml/data_frame/analytics")));
    private static final Logger logger = LogManager.getLogger(TransportSetUpgradeModeAction.class);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final PersistentTasksClusterService persistentTasksClusterService;
    private final PersistentTasksService persistentTasksService;
    private final ClusterService clusterService;
    private final OriginSettingClient client;

    @Inject
    public TransportSetUpgradeModeAction(TransportService transportService, ThreadPool threadPool, ClusterService clusterService, PersistentTasksClusterService persistentTasksClusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, PersistentTasksService persistentTasksService) {
        super("cluster:admin/xpack/ml/upgrade_mode", transportService, clusterService, threadPool, actionFilters, SetUpgradeModeAction.Request::new, indexNameExpressionResolver, "same");
        this.persistentTasksClusterService = persistentTasksClusterService;
        this.clusterService = clusterService;
        this.client = new OriginSettingClient(client, "ml");
        this.persistentTasksService = persistentTasksService;
    }

    protected void masterOperation(final SetUpgradeModeAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (!this.isRunning.compareAndSet(false, true)) {
            String msg = "Attempted to set [upgrade_mode] to [" + request.isEnabled() + "] from [" + MlMetadata.getMlMetadata((ClusterState)state).isUpgradeMode() + "] while previous request was processing.";
            IllegalStateException detail = new IllegalStateException(msg);
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot change [upgrade_mode]. Previous request is still being processed.", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]));
            return;
        }
        if (request.isEnabled() == MlMetadata.getMlMetadata((ClusterState)state).isUpgradeMode()) {
            this.isRunning.set(false);
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        ActionListener wrappedListener = ActionListener.wrap(r -> {
            this.isRunning.set(false);
            listener.onResponse(r);
        }, e -> {
            this.isRunning.set(false);
            listener.onFailure(e);
        });
        PersistentTasksCustomMetadata tasksCustomMetadata = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        ActionListener unassignPersistentTasksListener = ActionListener.wrap(unassignedPersistentTasks -> ((ListTasksRequestBuilder)((ListTasksRequestBuilder)this.client.admin().cluster().prepareListTasks(new String[0]).setActions((String[])ML_TASK_NAMES.stream().map(taskName -> taskName + "[c]").toArray(String[]::new))).setWaitForCompletion(true).setTimeout(request.timeout())).execute(ActionListener.wrap(r -> {
            try {
                ExceptionsHelper.rethrowAndSuppress((List)r.getNodeFailures());
                wrappedListener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
            catch (ElasticsearchException ex) {
                wrappedListener.onFailure((Exception)((Object)ex));
            }
        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0))), arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0));
        ActionListener isolateDatafeedListener = ActionListener.wrap(isolatedDatafeeds -> this.unassignPersistentTasks(tasksCustomMetadata, unassignPersistentTasksListener), arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0));
        ActionListener clusterStateUpdateListener = ActionListener.wrap(acknowledgedResponse -> {
            if (!acknowledgedResponse.isAcknowledged()) {
                wrappedListener.onFailure((Exception)new ElasticsearchTimeoutException("Unknown error occurred while updating cluster state", new Object[0]));
                return;
            }
            if (tasksCustomMetadata == null || tasksCustomMetadata.tasks().isEmpty()) {
                wrappedListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            if (request.isEnabled()) {
                this.isolateDatafeeds(tasksCustomMetadata, (ActionListener<List<IsolateDatafeedAction.Response>>)isolateDatafeedListener);
            } else {
                this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetadata -> persistentTasksCustomMetadata.tasks().stream().noneMatch(t -> ML_TASK_NAMES.contains(t.getTaskName()) && t.getAssignment().equals((Object)MlTasks.AWAITING_UPGRADE)), request.timeout(), ActionListener.wrap(r -> wrappedListener.onResponse((Object)AcknowledgedResponse.TRUE), arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
            }
        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0));
        this.clusterService.submitStateUpdateTask("ml-set-upgrade-mode", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, clusterStateUpdateListener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return AcknowledgedResponse.of((boolean)acknowledged);
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                MlMetadata.Builder builder = new MlMetadata.Builder((MlMetadata)currentState.metadata().custom("ml"));
                builder.isUpgradeMode(request.isEnabled());
                ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
                newState.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("ml", (Metadata.Custom)builder.build()).build());
                return newState.build();
            }
        });
    }

    protected ClusterBlockException checkBlock(SetUpgradeModeAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void unassignPersistentTasks(PersistentTasksCustomMetadata tasksCustomMetadata, ActionListener<List<PersistentTasksCustomMetadata.PersistentTask<?>>> listener) {
        List mlTasks = tasksCustomMetadata.tasks().stream().filter(persistentTask -> ML_TASK_NAMES.contains(persistentTask.getTaskName())).sorted(Comparator.comparing(PersistentTasksCustomMetadata.PersistentTask::getTaskName)).collect(Collectors.toList());
        logger.info("Un-assigning persistent tasks : " + mlTasks.stream().map(PersistentTasksCustomMetadata.PersistentTask::getId).collect(Collectors.joining(", ", "[ ", " ]")));
        TypedChainTaskExecutor<PersistentTasksCustomMetadata.PersistentTask> chainTaskExecutor = new TypedChainTaskExecutor<PersistentTasksCustomMetadata.PersistentTask>(this.client.threadPool().executor(this.executor), r -> true, ex -> !(org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)ex) instanceof ResourceNotFoundException));
        for (PersistentTasksCustomMetadata.PersistentTask task : mlTasks) {
            chainTaskExecutor.add(chainedTask -> this.persistentTasksClusterService.unassignPersistentTask(task.getId(), task.getAllocationId(), MlTasks.AWAITING_UPGRADE.getExplanation(), chainedTask));
        }
        chainTaskExecutor.execute(listener);
    }

    private void isolateDatafeeds(PersistentTasksCustomMetadata tasksCustomMetadata, ActionListener<List<IsolateDatafeedAction.Response>> listener) {
        Set datafeedsToIsolate = MlTasks.startedDatafeedIds((PersistentTasksCustomMetadata)tasksCustomMetadata);
        logger.info("Isolating datafeeds: " + datafeedsToIsolate.toString());
        TypedChainTaskExecutor<IsolateDatafeedAction.Response> isolateDatafeedsExecutor = new TypedChainTaskExecutor<IsolateDatafeedAction.Response>(this.client.threadPool().executor(this.executor), r -> true, ex -> true);
        datafeedsToIsolate.forEach(datafeedId -> {
            IsolateDatafeedAction.Request isolationRequest = new IsolateDatafeedAction.Request(datafeedId);
            isolateDatafeedsExecutor.add(isolateListener -> this.client.execute((ActionType)IsolateDatafeedAction.INSTANCE, (ActionRequest)isolationRequest, isolateListener));
        });
        isolateDatafeedsExecutor.execute(listener);
    }
}

