/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.constantkeyword.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.RegExp;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.termsenum.action.SimpleTermCountEnum;
import org.elasticsearch.xpack.core.termsenum.action.TermCount;

public class ConstantKeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "constant_keyword";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));

    private static ConstantKeywordFieldMapper toType(FieldMapper in) {
        return (ConstantKeywordFieldMapper)in;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    ConstantKeywordFieldMapper(String simpleName, MappedFieldType mappedFieldType) {
        super(simpleName, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    public ConstantKeywordFieldType fieldType() {
        return (ConstantKeywordFieldType)super.fieldType();
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        String value = parser.textOrNull();
        if (value == null) {
            throw new IllegalArgumentException("[constant_keyword] field [" + this.name() + "] doesn't accept [null] values");
        }
        if (this.fieldType().value == null) {
            ConstantKeywordFieldType newFieldType = new ConstantKeywordFieldType(this.fieldType().name(), value, this.fieldType().meta());
            ConstantKeywordFieldMapper update = new ConstantKeywordFieldMapper(this.simpleName(), (MappedFieldType)newFieldType);
            context.addDynamicMapper((Mapper)update);
        } else if (!Objects.equals(this.fieldType().value, value)) {
            throw new IllegalArgumentException("[constant_keyword] field [" + this.name() + "] only accepts values that are equal to the value defined in the mappings [" + this.fieldType().value() + "], but got [" + value + "]");
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<String> value = new FieldMapper.Parameter("value", true, () -> null, (n, c, o) -> {
            if (!(o instanceof Number) && !(o instanceof CharSequence)) {
                throw new MapperParsingException("Property [value] on field [" + n + "] must be a number or a string, but got [" + o + "]");
            }
            return o.toString();
        }, m -> ConstantKeywordFieldType.access$100(ConstantKeywordFieldMapper.toType(m).fieldType()));
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
            this.value.setSerializerCheck((id, ic, v) -> v != null);
            this.value.setMergeValidator((previous, current, c) -> previous == null || Objects.equals(previous, current));
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.value, this.meta);
        }

        public ConstantKeywordFieldMapper build(MapperBuilderContext context) {
            return new ConstantKeywordFieldMapper(this.name, (MappedFieldType)new ConstantKeywordFieldType(context.buildFullName(this.name), (String)this.value.getValue(), (Map)this.meta.getValue()));
        }
    }

    public static final class ConstantKeywordFieldType
    extends ConstantFieldType {
        private final String value;

        public ConstantKeywordFieldType(String name, String value, Map<String, String> meta) {
            super(name, meta);
            this.value = value;
        }

        public ConstantKeywordFieldType(String name, String value) {
            this(name, value, Collections.emptyMap());
        }

        public String value() {
            return this.value;
        }

        public String typeName() {
            return ConstantKeywordFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "keyword";
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new ConstantIndexFieldData.Builder(this.value, this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return this.value == null ? (lookup, ignoredValues) -> Collections.emptyList() : (lookup, ignoredValues) -> Collections.singletonList(this.value);
        }

        public TermsEnum getTerms(boolean caseInsensitive, String string, SearchExecutionContext queryShardContext, String searchAfter) throws IOException {
            boolean matches;
            boolean bl = matches = caseInsensitive ? this.value.toLowerCase(Locale.ROOT).startsWith(string.toLowerCase(Locale.ROOT)) : this.value.startsWith(string);
            if (!matches) {
                return null;
            }
            if (searchAfter != null && searchAfter.compareTo(this.value) >= 0) {
                return null;
            }
            int docCount = queryShardContext.searcher().getIndexReader().maxDoc();
            return new SimpleTermCountEnum(new TermCount(this.value, (long)docCount));
        }

        protected boolean matches(String pattern, boolean caseInsensitive, SearchExecutionContext context) {
            if (this.value == null) {
                return false;
            }
            return Regex.simpleMatch((String)pattern, (String)this.value, (boolean)caseInsensitive);
        }

        public Query existsQuery(SearchExecutionContext context) {
            return this.value != null ? new MatchAllDocsQuery() : new MatchNoDocsQuery();
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            BytesRef valueAsBytesRef = new BytesRef((CharSequence)this.value);
            if (lowerTerm != null && BytesRefs.toBytesRef((Object)lowerTerm).compareTo(valueAsBytesRef) >= (includeLower ? 1 : 0)) {
                return new MatchNoDocsQuery();
            }
            if (upperTerm != null && valueAsBytesRef.compareTo(BytesRefs.toBytesRef((Object)upperTerm)) >= (includeUpper ? 1 : 0)) {
                return new MatchNoDocsQuery();
            }
            return new MatchAllDocsQuery();
        }

        public Query fuzzyQuery(Object term, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context) {
            String prefix;
            int cp;
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            String termAsString = BytesRefs.toString((Object)term);
            int maxEdits = fuzziness.asDistance(termAsString);
            int[] termText = new int[termAsString.codePointCount(0, termAsString.length())];
            int j = 0;
            for (int i = 0; i < termAsString.length(); i += Character.charCount(cp)) {
                termText[j++] = cp = termAsString.codePointAt(i);
            }
            int termLength = termText.length;
            String suffix = UnicodeUtil.newString((int[])termText, (int)(prefixLength = Math.min(prefixLength, termLength)), (int)(termText.length - prefixLength));
            LevenshteinAutomata builder = new LevenshteinAutomata(suffix, transpositions);
            Automaton automaton = builder.toAutomaton(maxEdits, prefix = UnicodeUtil.newString((int[])termText, (int)0, (int)prefixLength));
            CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton);
            if (runAutomaton.run(this.value)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }

        public Query regexpQuery(String regexp, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            Automaton automaton = new RegExp(regexp, syntaxFlags, matchFlags).toAutomaton(maxDeterminizedStates);
            CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton);
            if (runAutomaton.run(this.value)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }
    }
}

