/*

Copyright 2006 Suzanne Skinner, John Spray

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#include "util.h"

uint16 ll_lookup[0x10000] = {
        0,     0,     0,     0,     0,     0,     0,  8192,     0,     0,
        0,  4096,     0,     0,     0, 12288,     0,     0,     0,     0,
        0,     0,     0,  8192,     0,     0,     0,  4096,     0,     0,
        0, 12288,     0,     0,     0,     0,     0,     0,     0,  8192,
        0,     0,     0,  4096,     0,     0,     0, 12288,     0,     0,
        0,     0,     0,     0,     0,  8192,     0,     0,     0,  4096,
        0,     0,     0, 12288,     0,     0,     0,     0,     0,     0,
        0,  8192,     0,     0,     0,  4096,     0,     0,     0, 12288,
        0,     0,     0,     0,     0,     0,     0,  8192,     0,     0,
        0,  4096,     0,     0,     0, 12288,     0,     0,     0,     0,
        0,     0,     0,  8192,     0,     0,     0,  4096,     0,     0,
        0, 12288,   512,   512,   512,   512,   512,   512,   512,  8704,
      512,   512,   512,  4608,   512,   512,   512, 12800,     0,     0,
        0,     0,     0,     0,     0,  8192,     0,     0,     0,  4096,
        0,     0,     0, 12288,     0,     0,     0,     0,     0,     0,
        0,  8192,     0,     0,     0,  4096,     0,     0,     0, 12288,
        0,     0,     0,     0,     0,     0,     0,  8192,     0,     0,
        0,  4096,     0,     0,     0, 12288,   256,   256,   256,   256,
      256,   256,   256,  8448,   256,   256,   256,  4352,   256,   256,
      256, 12544,     0,     0,     0,     0,     0,     0,     0,  8192,
        0,     0,     0,  4096,     0,     0,     0, 12288,     0,     0,
        0,     0,     0,     0,     0,  8192,     0,     0,     0,  4096,
        0,     0,     0, 12288,     0,     0,     0,     0,     0,     0,
        0,  8192,     0,     0,     0,  4096,     0,     0,     0, 12288,
      768,   768,   768,   768,   768,   768,   768,  8960,   768,   768,
      768,  4864,   768,   768,   768, 13056,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096,  8192,
        0, 12288, 12288,     0,   768,   768,   768, 13056,   768,  8960,
     8960,  4864,   768,  4864,  4864,  8960,   768, 13056, 13056,   768,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,  4096,
     4096,  8192,     0, 12288, 12288,     0,   512,   512,   512, 12800,
      512,  8704,  8704,  4608,   512,  4608,  4608,  8704,   512, 12800,
    12800,   512,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,   256,   256,
      256, 12544,   256,  8448,  8448,  4352,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      256,   256,   256, 12544,   256,  8448,  8448,  4352,   256,  4352,
     4352,  8448,   256, 12544, 12544,   256,   256,   256,   256, 12544,
      256,  8448,  8448,  4352,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,   768,   768,   768, 13056,   768,  8960,  8960,  4864,
      768,  4864,  4864,  8960,   768, 13056, 13056,   768,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096,  8192,
        0, 12288, 12288,     0,   768,   768,   768, 13056,   768,  8960,
     8960,  4864,   768,  4864,  4864,  8960,   768, 13056, 13056,   768,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,   256,   256,   256, 12544,
      256,  8448,  8448,  4352,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096,  8192,
        0, 12288, 12288,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,   768,   768,   768, 13056,   768,  8960,
     8960,  4864,   768,  4864,  4864,  8960,   768, 13056, 13056,   768,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,  4096,
     4096,  8192,     0, 12288, 12288,     0,   256,   256,   256, 12544,
      256,  8448,  8448,  4352,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,   256,   256,   256, 12544,   256,  8448,  8448,  4352,
      256,  4352,  4352,  8448,   256, 12544, 12544,   256,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,   768,   768,   768, 13056,
      768,  8960,  8960,  4864,   768,  4864,  4864,  8960,   768, 13056,
    13056,   768,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      256, 12544, 12544,   256,  8448,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,     0,     0,  8192,     0,  8192,
     8192,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,     0,     0,  8192,     0,  8192,  8192,     0,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,     0,     0,  8192,
        0,  8192,  8192,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,   512,   512,   512,  8704,   512,  8704,  8704,   512,
      512,   512,   512, 12800,   512,  8704,  8704,  4608,     0,     0,
        0,  8192,     0,  8192,  8192,     0,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,   512,   512,   512,  8704,   512,  8704,
     8704,   512,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,   512,   512,  8704,   512,  8704,  8704,   512,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,     0,     0,     0,  8192,
        0,  8192,  8192,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,     0,     0,  8192,     0,  8192,  8192,     0,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,     0,
        0,  8192,     0,  8192,  8192,     0,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,     0,     0,  8192,     0,  8192,
     8192,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
      768,   768,   768,  8960,   768,  8960,  8960,   768,   768,   768,
      768, 13056,   768,  8960,  8960,  4864,     0,     0,     0,  8192,
        0,  8192,  8192,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,   512,   512,   512,  8704,   512,  8704,  8704,   512,
      512,   512,   512, 12800,   512,  8704,  8704,  4608,   512,   512,
      512,  8704,   512,  8704,  8704,   512,   512,   512,   512, 12800,
      512,  8704,  8704,  4608,   256,   256,   256,  8448,   256,  8448,
     8448,   256,   256,   256,   256, 12544,   256,  8448,  8448,  4352,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,   512,  8704,  8704,  4608,
     8704,   512,   512,  4608,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,   512,  8704,  8704,  4608,  8704,   512,
      512,  4608,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,   256,  8448,  8448,  4352,  8448,   256,   256,  4352,
      256, 12544, 12544,   256,  8448,  4352,  4352,   256,     0,  8192,
     8192,  4096,  8192,     0,     0,  4096,     0, 12288, 12288,     0,
     8192,  4096,  4096,     0,   768,  8960,  8960,  4864,  8960,   768,
      768,  4864,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,   256,  8448,  8448,  4352,
     8448,   256,   256,  4352,   256, 12544, 12544,   256,  8448,  4352,
     4352,   256,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,   256,  8448,  8448,  4352,  8448,   256,
      256,  4352,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
      256,  8448,  8448,  4352,  8448,   256,   256,  4352,   256, 12544,
    12544,   256,  8448,  4352,  4352,   256,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,   512, 12800, 12800,   512,
     8704,  4608,  4608,   512,   768,  8960,  8960,  4864,  8960,   768,
      768,  4864,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
      512,  8704,  8704,  4608,  8704,   512,   512,  4608,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,   512,  8704,  8704,  4608,
     8704,   512,   512,  4608,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,     0,  8192,  8192,  4096,  8192,     0,
        0,  4096,     0, 12288, 12288,     0,  8192,  4096,  4096,     0,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,   768,  8960,  8960,  4864,
     8960,   768,   768,  4864,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,   512, 12800, 12800,   512,
     8704,  4608,  4608,   512,   768,  8960,  8960,  4864,  8960,   768,
      768,  4864,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8960,  4864,
     4864,   768,   768,  4864,  4864,   768, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,  4864,  4864,   768,   768,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8704,  4608,  4608,   512,
      512,  4608,  4608,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8960,  4864,  4864,   768,
      768,  4864,  4864,   768, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8960,  4864,  4864,   768,   768,  4864,  4864,   768,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8960,  4864,  4864,   768,   768,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,  4096,     0,     0,     0, 12288,     0,  4096,  4096,     0,
        0,  4096,  4096,  8192,     0,     0,     0,  4096,     0,     0,
        0, 12288,     0,  4096,  4096,     0,     0,  4096,  4096,  8192,
        0,     0,     0,  4096,     0,     0,     0, 12288,     0,  4096,
     4096,     0,     0,  4096,  4096,  8192,   256,   256,   256,  4352,
      256,   256,   256, 12544,   256,  4352,  4352,   256,   256,  4352,
     4352,  8448,     0,     0,     0,  4096,     0,     0,     0, 12288,
        0,  4096,  4096,     0,     0,  4096,  4096,  8192,     0,     0,
        0,  4096,     0,     0,     0, 12288,     0,  4096,  4096,     0,
        0,  4096,  4096,  8192,     0,     0,     0,  4096,     0,     0,
        0, 12288,     0,  4096,  4096,     0,     0,  4096,  4096,  8192,
      768,   768,   768,  4864,   768,   768,   768, 13056,   768,  4864,
     4864,   768,   768,  4864,  4864,  8960,     0,     0,     0,  4096,
        0,     0,     0, 12288,     0,  4096,  4096,     0,     0,  4096,
     4096,  8192,   256,   256,   256,  4352,   256,   256,   256, 12544,
      256,  4352,  4352,   256,   256,  4352,  4352,  8448,   256,   256,
      256,  4352,   256,   256,   256, 12544,   256,  4352,  4352,   256,
      256,  4352,  4352,  8448,     0,     0,     0,  4096,     0,     0,
        0, 12288,     0,  4096,  4096,     0,     0,  4096,  4096,  8192,
        0,     0,     0,  4096,     0,     0,     0, 12288,     0,  4096,
     4096,     0,     0,  4096,  4096,  8192,   256,   256,   256,  4352,
      256,   256,   256, 12544,   256,  4352,  4352,   256,   256,  4352,
     4352,  8448,   256,   256,   256,  4352,   256,   256,   256, 12544,
      256,  4352,  4352,   256,   256,  4352,  4352,  8448,   512,   512,
      512,  4608,   512,   512,   512, 12800,   512,  4608,  4608,   512,
      512,  4608,  4608,  8704,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
      256,  4352,  4352,  8448,   256, 12544, 12544,   256,  4352,   256,
      256,  8448,  4352,  8448,  8448,   256,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   768,  4864,  4864,  8960,   768, 13056, 13056,   768,
     4864,   768,   768,  8960,  4864,  8960,  8960,   768,     0,  4096,
     4096,  8192,     0, 12288, 12288,     0,  4096,     0,     0,  8192,
     4096,  8192,  8192,     0,   768,  4864,  4864,  8960,   768, 13056,
    13056,   768,  4864,   768,   768,  8960,  4864,  8960,  8960,   768,
      768,  4864,  4864,  8960,   768, 13056, 13056,   768,  4864,   768,
      768,  8960,  4864,  8960,  8960,   768,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   256,  4352,
     4352,  8448,   256, 12544, 12544,   256,  4352,   256,   256,  8448,
     4352,  8448,  8448,   256,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,  4352,   256,   256,  8448,  4352,  8448,  8448,   256,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   768,  4864,  4864,  8960,   768, 13056, 13056,   768,
     4864,   768,   768,  8960,  4864,  8960,  8960,   768,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,  4864,   768,   768,  8960,
     4864,  8960,  8960,   768,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   512,  4608,
     4608,  8704,   512, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
      768,  4864,  4864,  8960,   768, 13056, 13056,   768,  4864,   768,
      768,  8960,  4864,  8960,  8960,   768,   768,  4864,  4864,  8960,
      768, 13056, 13056,   768,  4864,   768,   768,  8960,  4864,  8960,
     8960,   768,   512,  4608,  4608,  8704,   512, 12800, 12800,   512,
     4608,   512,   512,  8704,  4608,  8704,  8704,   512,   256,  4352,
     4352,  8448,   256, 12544, 12544,   256,  4352,   256,   256,  8448,
     4352,  8448,  8448,   256,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,  4608,   512,   512,  8704,  4608,  8704,
     8704,   512,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   512,  4608,
     4608,  8704,   512, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,   512,  4608,  4608,  8704,   512, 12800,
    12800,   512,  4608,   512,   512,  8704,  4608,  8704,  8704,   512,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256,  8448,  8448,   256,  8448,   256,
      256,   256,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768,  8960,  8960,   768,  8960,   768,   768,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768,  8960,
     8960,   768,  8960,   768,   768,   768,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,   768,  8960,  8960,   768,  8960,   768,
      768,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768,  8960,  8960,   768,  8960,   768,   768,   768,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,     0,  8192,  8192,     0,
     8192,     0,     0,     0,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   256,  8448,  8448,   256,  8448,   256,   256,   256,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096,  8192,
        0, 12288, 12288,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,   256,   256,   256, 12544,   256,  8448,
     8448,  4352,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,  4096,
     4096,  8192,     0, 12288, 12288,     0,   256,   256,   256, 12544,
      256,  8448,  8448,  4352,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,   256,   256,   256, 12544,   256,  8448,  8448,  4352,
      256,  4352,  4352,  8448,   256, 12544, 12544,   256,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,   768,   768,   768, 13056,
      768,  8960,  8960,  4864,   768,  4864,  4864,  8960,   768, 13056,
    13056,   768,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   256, 12544,
    12544,   256,  8448,  4352,  4352,   256,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256, 12544, 12544,   256,  8448,  4352,
     4352,   256,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256, 12544, 12544,   256,  8448,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,     0, 12288, 12288,     0,
     8192,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8960,   768,
      768,   768,   768,   768,   768,   768, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,   768,   768,   768,   768,   768,
      768,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8960,   768,   768,   768,   768,   768,   768,   768,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8960,   768,   768,   768,
      768,   768,   768,   768, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,  4096,  4096, 12288,     0, 12288,
    12288,  4096,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096, 12288,     0, 12288, 12288,  4096,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096, 12288,
        0, 12288, 12288,  4096,   768,   768,   768, 13056,   768,  8960,
     8960,  4864,   768,  4864,  4864, 13056,   768, 13056, 13056,  4864,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,  4096,
     4096, 12288,     0, 12288, 12288,  4096,   512,   512,   512, 12800,
      512,  8704,  8704,  4608,   512,  4608,  4608, 12800,   512, 12800,
    12800,  4608,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608, 12800,   512, 12800, 12800,  4608,   256,   256,
      256, 12544,   256,  8448,  8448,  4352,   256,  4352,  4352, 12544,
      256, 12544, 12544,  4352,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096, 12288,     0, 12288, 12288,  4096,
      256,   256,   256, 12544,   256,  8448,  8448,  4352,   256,  4352,
     4352, 12544,   256, 12544, 12544,  4352,   256,   256,   256, 12544,
      256,  8448,  8448,  4352,   256,  4352,  4352, 12544,   256, 12544,
    12544,  4352,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608, 12800,   512, 12800, 12800,  4608,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096, 12288,
        0, 12288, 12288,  4096,   768,   768,   768, 13056,   768,  8960,
     8960,  4864,   768,  4864,  4864, 13056,   768, 13056, 13056,  4864,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864, 13056,   768, 13056, 13056,  4864,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,  4096,  4096, 12288,     0, 12288,
    12288,  4096,     0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,   768, 13056,
    13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056, 13056,   768,
    13056,  4864,  4864,   768,   768, 13056, 13056,  4864,  8960,  4864,
     4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
      256, 12544, 12544,  4352,  8448,  4352,  4352,  4352,  4352, 12544,
    12544,   256, 12544,  4352,  4352,   256,   512, 12800, 12800,  4608,
     8704,  4608,  4608,  4608,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,   256, 12544, 12544,  4352,  8448,  4352,  4352,  4352,
     4352, 12544, 12544,   256, 12544,  4352,  4352,   256,   256, 12544,
    12544,  4352,  8448,  4352,  4352,  4352,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,   256, 12544, 12544,  4352,  8448,  4352,
     4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,  4352,   256,
      256, 12544, 12544,  4352,  8448,  4352,  4352,  4352,  4352, 12544,
    12544,   256, 12544,  4352,  4352,   256,   768, 13056, 13056,  4864,
     8960,  4864,  4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,
     4864,   768,   768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,
     4864, 13056, 13056,   768, 13056,  4864,  4864,   768,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,   768, 13056, 13056,  4864,  8960,  4864,
     4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
      256, 12544, 12544,  4352,  8448,  4352,  4352,  4352,  4352, 12544,
    12544,   256, 12544,  4352,  4352,   256,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,
     4352,   256,     0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,   768, 13056, 13056,  4864,  8960,  4864,
     4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,   512, 12800, 12800,  4608,
     8704,  4608,  4608,  4608,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   768, 13056,
    13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056, 13056,   768,
    13056,  4864,  4864,   768,   768, 13056, 13056,  4864,  8960,  4864,
     4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
        0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,
     4352,   256,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   512, 12800,
    12800,  4608,  8704,  4608,  4608,  4608,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,   512, 12800, 12800,  4608,  8704,  4608,
     4608,  4608,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,   512, 12800, 12800,  4608,
     8704,  4608,  4608,  4608,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    13056,  4864,  4864,   768,  4864,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768, 13056,  4864,  4864,   768,
     4864,  4864,  4864,   768, 13056,   768,   768,   768,  4864,   768,
      768,   768, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 13056,  4864,
     4864,   768,  4864,  4864,  4864,   768, 13056,   768,   768,   768,
     4864,   768,   768,   768, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
    13056,   768,   768,   768,  4864,   768,   768,   768, 12800,  4608,
     4608,   512,  4608,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 13056,  4864,  4864,   768,
     4864,  4864,  4864,   768, 13056,   768,   768,   768,  4864,   768,
      768,   768, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,   512,  8704,  8704,  4608,
     8704,   512,   512,  4608,   512, 12800, 12800,  4608,  8704,  4608,
     4608,  4608,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,   512,  8704,  8704,  4608,  8704,   512,
      512,  4608,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,  4096,  8192,  4096,
     4096,  4096,   256,  8448,  8448,  4352,  8448,   256,   256,  4352,
      256, 12544, 12544,  4352,  8448,  4352,  4352,  4352,     0,  8192,
     8192,  4096,  8192,     0,     0,  4096,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,   768,  8960,  8960,  4864,  8960,   768,
      768,  4864,   768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,  4864,  8960,  4864,  4864,  4864,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,  4096,  8192,  4096,
     4096,  4096,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,   256,  8448,  8448,  4352,  8448,   256,
      256,  4352,   256, 12544, 12544,  4352,  8448,  4352,  4352,  4352,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  8704,  4608,  4608,  4608,
      512,  4608,  4608,  4608, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8448,  4352,  4352,  4352,
      256,  4352,  4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8960,  4864,  4864,  4864,   768,  4864,
     4864,  4864, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
     8448,  4352,  4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256,  8448,  4352,  4352,  4352,
      256,  4352,  4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8448,  4352,  4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8704,  4608,  4608,  4608,   512,  4608,  4608,  4608,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512,  8960,  4864,
     4864,  4864,   768,  4864,  4864,  4864, 13056,  4864,  4864,   768,
     4864,  4864,  4864,   768,  8960,  4864,  4864,  4864,   768,  4864,
     4864,  4864, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8704,  4608,  4608,  4608,
      512,  4608,  4608,  4608, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8192,  4096,  4096,  4096,     0,  4096,
     4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
     8960,  4864,  4864,  4864,   768,  4864,  4864,  4864, 13056,  4864,
     4864,   768,  4864,  4864,  4864,   768,  8704,  4608,  4608,  4608,
      512,  4608,  4608,  4608, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512,  8704,  4608,  4608,  4608,   512,  4608,  4608,  4608,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512,  8192,  4096,
     4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0,  8960,  4864,  4864,  4864,   768,  4864,
     4864,  4864, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  4864,  4864,
     4864,   768,  4864,  4864,  4864,   768,  4864,   768,   768,   768,
     4864,   768,   768,   768,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4864,  4864,  4864,   768,
     4864,  4864,  4864,   768,  4864,   768,   768,   768,  4864,   768,
      768,   768,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,  4096,  4096, 12288,     0, 12288,
    12288,  4096,  4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,
      256,  4352,  4352, 12544,   256, 12544, 12544,  4352,  4352,  4352,
     4352,  8448,  4352, 12544, 12544,   256,   256,  4352,  4352, 12544,
      256, 12544, 12544,  4352,  4352,  4352,  4352,  8448,  4352, 12544,
    12544,   256,   512,  4608,  4608, 12800,   512, 12800, 12800,  4608,
     4608,  4608,  4608,  8704,  4608, 12800, 12800,   512,     0,  4096,
     4096, 12288,     0, 12288, 12288,  4096,  4096,  4096,  4096,  8192,
     4096, 12288, 12288,     0,   768,  4864,  4864, 13056,   768, 13056,
    13056,  4864,  4864,  4864,  4864,  8960,  4864, 13056, 13056,   768,
      768,  4864,  4864, 13056,   768, 13056, 13056,  4864,  4864,  4864,
     4864,  8960,  4864, 13056, 13056,   768,     0,  4096,  4096, 12288,
        0, 12288, 12288,  4096,  4096,  4096,  4096,  8192,  4096, 12288,
    12288,     0,   256,  4352,  4352, 12544,   256, 12544, 12544,  4352,
     4352,  4352,  4352,  8448,  4352, 12544, 12544,   256,     0,  4096,
     4096, 12288,     0, 12288, 12288,  4096,  4096,  4096,  4096,  8192,
     4096, 12288, 12288,     0,     0,  4096,  4096, 12288,     0, 12288,
    12288,  4096,  4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,
      512,  4608,  4608, 12800,   512, 12800, 12800,  4608,  4608,  4608,
     4608,  8704,  4608, 12800, 12800,   512,   256,  4352,  4352, 12544,
      256, 12544, 12544,  4352,  4352,  4352,  4352,  8448,  4352, 12544,
    12544,   256,   512,  4608,  4608, 12800,   512, 12800, 12800,  4608,
     4608,  4608,  4608,  8704,  4608, 12800, 12800,   512,   512,  4608,
     4608, 12800,   512, 12800, 12800,  4608,  4608,  4608,  4608,  8704,
     4608, 12800, 12800,   512,     0,  4096,  4096, 12288,     0, 12288,
    12288,  4096,  4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,
     4352, 12544, 12544,   256, 12544,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,  4864, 13056, 13056,   768,
    13056,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,  4864, 13056, 13056,   768, 13056,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
     4352, 12544, 12544,   256, 12544,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,  4352, 12544,
    12544,   256, 12544,  4352,  4352,   256,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,  4608, 12800,
    12800,   512, 12800,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
     4864, 13056, 13056,   768, 13056,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,  4608, 12800,
    12800,   512, 12800,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,   768,   768,   768,   768,   768,
      768,   768, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,   768, 13056, 13056,  4864,  8960,  4864,
     4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   256, 12544,
    12544,  4352,  8448,  4352,  4352,  4352,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,   256, 12544, 12544,  4352,  8448,  4352,
     4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,  4352,   256,
        0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,
     4352,   256,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   512, 12800,
    12800,  4608,  8704,  4608,  4608,  4608,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,     0, 12288, 12288,  4096,  8192,  4096,
     4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,     0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
    13056,   768,   768,   768,  4864,   768,   768,   768, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    13056,  4864,  4864,   768,  4864,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768, 12800,  4608,  4608,   512,
     4608,  4608,  4608,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12800,  4608,
     4608,   512,  4608,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512, 12800,   512,
      512,   512,  4608,   512,   512,   512, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  4864,   768,   768,   768,
     4864,   768,   768,   768,   768,   768,   768,   768,   768,   768,
      768,   768,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4608,   512,   512,   512,  4608,   512,
      512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0, 12288,     0,  8192,  8192, 12288,
        0,  4096,  4096,  8192,     0, 12288, 12288,  8192,     0,     0,
        0, 12288,     0,  8192,  8192, 12288,     0,  4096,  4096,  8192,
        0, 12288, 12288,  8192,     0,     0,     0, 12288,     0,  8192,
     8192, 12288,     0,  4096,  4096,  8192,     0, 12288, 12288,  8192,
      768,   768,   768, 13056,   768,  8960,  8960, 13056,   768,  4864,
     4864,  8960,   768, 13056, 13056,  8960,     0,     0,     0, 12288,
        0,  8192,  8192, 12288,     0,  4096,  4096,  8192,     0, 12288,
    12288,  8192,   512,   512,   512, 12800,   512,  8704,  8704, 12800,
      512,  4608,  4608,  8704,   512, 12800, 12800,  8704,   512,   512,
      512, 12800,   512,  8704,  8704, 12800,   512,  4608,  4608,  8704,
      512, 12800, 12800,  8704,   256,   256,   256, 12544,   256,  8448,
     8448, 12544,   256,  4352,  4352,  8448,   256, 12544, 12544,  8448,
        0,     0,     0, 12288,     0,  8192,  8192, 12288,     0,  4096,
     4096,  8192,     0, 12288, 12288,  8192,   256,   256,   256, 12544,
      256,  8448,  8448, 12544,   256,  4352,  4352,  8448,   256, 12544,
    12544,  8448,   256,   256,   256, 12544,   256,  8448,  8448, 12544,
      256,  4352,  4352,  8448,   256, 12544, 12544,  8448,   512,   512,
      512, 12800,   512,  8704,  8704, 12800,   512,  4608,  4608,  8704,
      512, 12800, 12800,  8704,     0,     0,     0, 12288,     0,  8192,
     8192, 12288,     0,  4096,  4096,  8192,     0, 12288, 12288,  8192,
      768,   768,   768, 13056,   768,  8960,  8960, 13056,   768,  4864,
     4864,  8960,   768, 13056, 13056,  8960,   768,   768,   768, 13056,
      768,  8960,  8960, 13056,   768,  4864,  4864,  8960,   768, 13056,
    13056,  8960,     0,     0,     0, 12288,     0,  8192,  8192, 12288,
        0,  4096,  4096,  8192,     0, 12288, 12288,  8192,     0, 12288,
    12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,   768, 13056, 13056,  8960,  8960, 13056,
    13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,  8960,   768,
      768, 13056, 13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   256, 12544, 12544,  8448,
     8448, 12544, 12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,
     8448,   256,   512, 12800, 12800,  8704,  8704, 12800, 12800,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   256, 12544,
    12544,  8448,  8448, 12544, 12544,   256,  4352,  8448,  8448,  8448,
    12544,  8448,  8448,   256,   256, 12544, 12544,  8448,  8448, 12544,
    12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256, 12544, 12544,  8448,  8448, 12544, 12544,   256,  4352,  8448,
     8448,  8448, 12544,  8448,  8448,   256,   256, 12544, 12544,  8448,
     8448, 12544, 12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,
     8448,   256,   768, 13056, 13056,  8960,  8960, 13056, 13056,   768,
     4864,  8960,  8960,  8960, 13056,  8960,  8960,   768,   768, 13056,
    13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,  8960,  8960,
    13056,  8960,  8960,   768,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
      768, 13056, 13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   256, 12544, 12544,  8448,
     8448, 12544, 12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,
     8448,   256,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
     4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,     0, 12288,
    12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
      768, 13056, 13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,   512, 12800, 12800,  8704,  8704, 12800, 12800,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   768, 13056, 13056,  8960,  8960, 13056,
    13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,  8960,   768,
      768, 13056, 13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,     0, 12288, 12288,  8192,
     8192, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
     4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512, 12800, 12800,  8704,  8704, 12800,
    12800,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
      512, 12800, 12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,   512, 12800, 12800,  8704,  8704, 12800, 12800,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 13056,  8960,  8960,   768,
    13056,   768,   768,   768,  8960,  8960,  8960,   768,  8960,   768,
      768,   768, 13056,  8960,  8960,   768, 13056,   768,   768,   768,
     8960,  8960,  8960,   768,  8960,   768,   768,   768, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 13056,  8960,  8960,   768, 13056,   768,
      768,   768,  8960,  8960,  8960,   768,  8960,   768,   768,   768,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8448,  8448,
     8448,   256,  8448,   256,   256,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768, 12800,  8704,  8704,   512, 12800,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 13056,  8960,  8960,   768, 13056,   768,   768,   768,
     8960,  8960,  8960,   768,  8960,   768,   768,   768, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,     0,  8192,  8192, 12288,
     8192,  8192,  8192,  4096,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,   512,  8704,  8704, 12800,  8704,  8704,  8704,  4608,
      512, 12800, 12800,  8704,  8704, 12800, 12800,   512,   512,  8704,
     8704, 12800,  8704,  8704,  8704,  4608,   512, 12800, 12800,  8704,
     8704, 12800, 12800,   512,   256,  8448,  8448, 12544,  8448,  8448,
     8448,  4352,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
      512,  8704,  8704, 12800,  8704,  8704,  8704,  4608,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,     0,  8192,  8192, 12288,
     8192,  8192,  8192,  4096,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,     0,  8192,  8192, 12288,  8192,  8192,  8192,  4096,
        0, 12288, 12288,  8192,  8192, 12288, 12288,     0,   256,  8448,
     8448, 12544,  8448,  8448,  8448,  4352,   256, 12544, 12544,  8448,
     8448, 12544, 12544,   256,     0,  8192,  8192, 12288,  8192,  8192,
     8192,  4096,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
      768,  8960,  8960, 13056,  8960,  8960,  8960,  4864,   768, 13056,
    13056,  8960,  8960, 13056, 13056,   768,   768,  8960,  8960, 13056,
     8960,  8960,  8960,  4864,   768, 13056, 13056,  8960,  8960, 13056,
    13056,   768,     0,  8192,  8192, 12288,  8192,  8192,  8192,  4096,
        0, 12288, 12288,  8192,  8192, 12288, 12288,     0,   512,  8704,
     8704, 12800,  8704,  8704,  8704,  4608,   512, 12800, 12800,  8704,
     8704, 12800, 12800,   512,   256,  8448,  8448, 12544,  8448,  8448,
     8448,  4352,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
      256,  8448,  8448, 12544,  8448,  8448,  8448,  4352,   256, 12544,
    12544,  8448,  8448, 12544, 12544,   256,     0,  8192,  8192, 12288,
     8192,  8192,  8192,  4096,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  8704, 12800, 12800,   512,  8704,  4608,  4608,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8448, 12544, 12544,   256,  8448,  4352,  4352,   256,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8960, 13056, 13056,   768,  8960,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8448, 12544, 12544,   256,
     8448,  4352,  4352,   256, 12544,  8448,  8448,   256, 12544,   256,
      256,   256,  8448, 12544, 12544,   256,  8448,  4352,  4352,   256,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256,  8448, 12544, 12544,   256,
     8448,  4352,  4352,   256, 12544,  8448,  8448,   256, 12544,   256,
      256,   256,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8704, 12800,
    12800,   512,  8704,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8960, 13056, 13056,   768,  8960,  4864,
     4864,   768, 13056,  8960,  8960,   768, 13056,   768,   768,   768,
     8960, 13056, 13056,   768,  8960,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8704, 12800, 12800,   512,  8704,  4608,  4608,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8192, 12288, 12288,     0,  8192,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8960, 13056, 13056,   768,
     8960,  4864,  4864,   768, 13056,  8960,  8960,   768, 13056,   768,
      768,   768,  8704, 12800, 12800,   512,  8704,  4608,  4608,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704, 12800,
    12800,   512,  8704,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8192, 12288, 12288,     0,  8192,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8960, 13056, 13056,   768,  8960,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8960,   768,   768,   768,   768,   768,   768,   768,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,   256,   256,   256,
      256,   256,   256,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,  8192,  4096,     0,
        0,  8192,  4096,  8192,  8192,  8192,   256,  4352,  4352,  8448,
      256, 12544, 12544,  8448,  4352,   256,   256,  8448,  4352,  8448,
     8448,  8448,   256,  4352,  4352,  8448,   256, 12544, 12544,  8448,
     4352,   256,   256,  8448,  4352,  8448,  8448,  8448,   512,  4608,
     4608,  8704,   512, 12800, 12800,  8704,  4608,   512,   512,  8704,
     4608,  8704,  8704,  8704,     0,  4096,  4096,  8192,     0, 12288,
    12288,  8192,  4096,     0,     0,  8192,  4096,  8192,  8192,  8192,
      768,  4864,  4864,  8960,   768, 13056, 13056,  8960,  4864,   768,
      768,  8960,  4864,  8960,  8960,  8960,   768,  4864,  4864,  8960,
      768, 13056, 13056,  8960,  4864,   768,   768,  8960,  4864,  8960,
     8960,  8960,     0,  4096,  4096,  8192,     0, 12288, 12288,  8192,
     4096,     0,     0,  8192,  4096,  8192,  8192,  8192,   256,  4352,
     4352,  8448,   256, 12544, 12544,  8448,  4352,   256,   256,  8448,
     4352,  8448,  8448,  8448,     0,  4096,  4096,  8192,     0, 12288,
    12288,  8192,  4096,     0,     0,  8192,  4096,  8192,  8192,  8192,
        0,  4096,  4096,  8192,     0, 12288, 12288,  8192,  4096,     0,
        0,  8192,  4096,  8192,  8192,  8192,   512,  4608,  4608,  8704,
      512, 12800, 12800,  8704,  4608,   512,   512,  8704,  4608,  8704,
     8704,  8704,   256,  4352,  4352,  8448,   256, 12544, 12544,  8448,
     4352,   256,   256,  8448,  4352,  8448,  8448,  8448,   512,  4608,
     4608,  8704,   512, 12800, 12800,  8704,  4608,   512,   512,  8704,
     4608,  8704,  8704,  8704,   512,  4608,  4608,  8704,   512, 12800,
    12800,  8704,  4608,   512,   512,  8704,  4608,  8704,  8704,  8704,
        0,  4096,  4096,  8192,     0, 12288, 12288,  8192,  4096,     0,
        0,  8192,  4096,  8192,  8192,  8192,  4352,  8448,  8448,  8448,
    12544,  8448,  8448,   256,   256,  8448,  8448,  8448,  8448,  8448,
     8448,   256,  4864,  8960,  8960,  8960, 13056,  8960,  8960,   768,
      768,  8960,  8960,  8960,  8960,  8960,  8960,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768,  8960,  8960,  8960,
     8960,  8960,  8960,   768,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4864,  8960,  8960,  8960, 13056,  8960,  8960,   768,   768,  8960,
     8960,  8960,  8960,  8960,  8960,   768,  4352,  8448,  8448,  8448,
    12544,  8448,  8448,   256,   256,  8448,  8448,  8448,  8448,  8448,
     8448,   256,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256,  8448,  8448,  8448,  8448,  8448,  8448,   256,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,  4352,  8448,  8448,  8448, 12544,  8448,
     8448,   256,   256,  8448,  8448,  8448,  8448,  8448,  8448,   256,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768,  8960,  8960,  8960,
     8960,  8960,  8960,   768,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0,  8192,  8192,  8192,  8192,  8192,
     8192,     0,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256,  8448,  8448,  8448,  8448,  8448,  8448,   256,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,  4864,  8960,  8960,  8960,
    13056,  8960,  8960,   768,   768,  8960,  8960,  8960,  8960,  8960,
     8960,   768,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  8960,  8960,
     8960,   768,  8960,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8960,  8960,  8960,   768,  8960,   768,   768,   768,
     8960,  8960,  8960,   768,  8960,   768,   768,   768,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
      768, 13056, 13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   256, 12544, 12544,  8448,  8448, 12544,
    12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256, 12544, 12544,  8448,  8448, 12544, 12544,   256,  4352,  8448,
     8448,  8448, 12544,  8448,  8448,   256,     0, 12288, 12288,  8192,
     8192, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
     4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512, 12800, 12800,  8704,  8704, 12800,
    12800,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
        0, 12288, 12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0, 12288,
    12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12544,  8448,  8448,   256, 12544,   256,
      256,   256,  8448,  8448,  8448,   256,  8448,   256,   256,   256,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8448,  8448,
     8448,   256,  8448,   256,   256,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 13056,  8960,  8960,   768,
    13056,   768,   768,   768,  8960,  8960,  8960,   768,  8960,   768,
      768,   768, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12800,  8704,  8704,   512, 12800,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8960,   768,   768,   768,   768,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8448,   256,   256,   256,
      256,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,     0, 12288,
    12288, 12288,  8192, 12288, 12288,  4096,  4096, 12288, 12288,  8192,
    12288, 12288, 12288,     0,   768, 13056, 13056, 13056,  8960, 13056,
    13056,  4864,  4864, 13056, 13056,  8960, 13056, 13056, 13056,   768,
      768, 13056, 13056, 13056,  8960, 13056, 13056,  4864,  4864, 13056,
    13056,  8960, 13056, 13056, 13056,   768,     0, 12288, 12288, 12288,
     8192, 12288, 12288,  4096,  4096, 12288, 12288,  8192, 12288, 12288,
    12288,     0,   512, 12800, 12800, 12800,  8704, 12800, 12800,  4608,
     4608, 12800, 12800,  8704, 12800, 12800, 12800,   512,   256, 12544,
    12544, 12544,  8448, 12544, 12544,  4352,  4352, 12544, 12544,  8448,
    12544, 12544, 12544,   256,   256, 12544, 12544, 12544,  8448, 12544,
    12544,  4352,  4352, 12544, 12544,  8448, 12544, 12544, 12544,   256,
        0, 12288, 12288, 12288,  8192, 12288, 12288,  4096,  4096, 12288,
    12288,  8192, 12288, 12288, 12288,     0,   256, 12544, 12544, 12544,
     8448, 12544, 12544,  4352,  4352, 12544, 12544,  8448, 12544, 12544,
    12544,   256,   512, 12800, 12800, 12800,  8704, 12800, 12800,  4608,
     4608, 12800, 12800,  8704, 12800, 12800, 12800,   512,   512, 12800,
    12800, 12800,  8704, 12800, 12800,  4608,  4608, 12800, 12800,  8704,
    12800, 12800, 12800,   512,     0, 12288, 12288, 12288,  8192, 12288,
    12288,  4096,  4096, 12288, 12288,  8192, 12288, 12288, 12288,     0,
      768, 13056, 13056, 13056,  8960, 13056, 13056,  4864,  4864, 13056,
    13056,  8960, 13056, 13056, 13056,   768,     0, 12288, 12288, 12288,
     8192, 12288, 12288,  4096,  4096, 12288, 12288,  8192, 12288, 12288,
    12288,     0,     0, 12288, 12288, 12288,  8192, 12288, 12288,  4096,
     4096, 12288, 12288,  8192, 12288, 12288, 12288,     0,     0, 12288,
    12288, 12288,  8192, 12288, 12288,  4096,  4096, 12288, 12288,  8192,
    12288, 12288, 12288,     0, 13056, 13056, 13056,   768, 13056,  4864,
     4864,   768, 13056,  8960,  8960,   768, 13056,   768,   768,   768,
    12544, 12544, 12544,   256, 12544,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256, 12544, 12544, 12544,   256,
    12544,  4352,  4352,   256, 12544,  8448,  8448,   256, 12544,   256,
      256,   256, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12544, 12544,
    12544,   256, 12544,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256, 12544, 12544, 12544,   256, 12544,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
    12544, 12544, 12544,   256, 12544,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 13056, 13056, 13056,   768, 13056,  4864,  4864,   768,
    13056,  8960,  8960,   768, 13056,   768,   768,   768, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12544, 12544, 12544,   256,
    12544,  4352,  4352,   256, 12544,  8448,  8448,   256, 12544,   256,
      256,   256, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    13056, 13056, 13056,   768, 13056,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768, 12800, 12800, 12800,   512,
    12800,  4608,  4608,   512, 12800,  8704,  8704,   512, 12800,   512,
      512,   512, 12800, 12800, 12800,   512, 12800,  4608,  4608,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 13056, 13056, 13056,   768, 13056,  4864,
     4864,   768, 13056,  8960,  8960,   768, 13056,   768,   768,   768,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12800, 12800,
    12800,   512, 12800,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512, 12800, 12800, 12800,   512, 12800,  4608,
     4608,   512, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
    12800, 12800, 12800,   512, 12800,  4608,  4608,   512, 12800,  8704,
     8704,   512, 12800,   512,   512,   512, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12800, 12800, 12800,   512, 12800,  4608,  4608,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,   768,   768,   768,   768,   768,
      768,   768, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8704, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
    12800, 12800, 12800,   512, 12800,  4608,  4608,   512,  8448, 12544,
    12544,  4352,  8448,  4352,  4352,  4352, 12544, 12544, 12544,   256,
    12544,  4352,  4352,   256,  8448, 12544, 12544,  4352,  8448,  4352,
     4352,  4352, 12544, 12544, 12544,   256, 12544,  4352,  4352,   256,
     8192, 12288, 12288,  4096,  8192,  4096,  4096,  4096, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0,  8192, 12288, 12288,  4096,
     8192,  4096,  4096,  4096, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0,  8448, 12544, 12544,  4352,  8448,  4352,  4352,  4352,
    12544, 12544, 12544,   256, 12544,  4352,  4352,   256,  8448, 12544,
    12544,  4352,  8448,  4352,  4352,  4352, 12544, 12544, 12544,   256,
    12544,  4352,  4352,   256,  8192, 12288, 12288,  4096,  8192,  4096,
     4096,  4096, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
     8960, 13056, 13056,  4864,  8960,  4864,  4864,  4864, 13056, 13056,
    13056,   768, 13056,  4864,  4864,   768,  8192, 12288, 12288,  4096,
     8192,  4096,  4096,  4096, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0,  8192, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0,  8192, 12288,
    12288,  4096,  8192,  4096,  4096,  4096, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0,  8448, 12544, 12544,  4352,  8448,  4352,
     4352,  4352, 12544, 12544, 12544,   256, 12544,  4352,  4352,   256,
     8192, 12288, 12288,  4096,  8192,  4096,  4096,  4096, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0,  8192, 12288, 12288,  4096,
     8192,  4096,  4096,  4096, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0,  8192, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4352, 12544, 12544,  8448,
    12544, 12544, 12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,
     8448,   256,  4608, 12800, 12800,  8704, 12800, 12800, 12800,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,  4608, 12800,
    12800,  8704, 12800, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,  4096, 12288, 12288,  8192, 12288, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
     4864, 13056, 13056,  8960, 13056, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,  4096, 12288, 12288,  8192,
    12288, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,  4096, 12288, 12288,  8192, 12288, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,  4096, 12288,
    12288,  8192, 12288, 12288, 12288,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,  4096, 12288, 12288,  8192, 12288, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
     4608, 12800, 12800,  8704, 12800, 12800, 12800,   512,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,  4608, 12800, 12800,  8704,
    12800, 12800, 12800,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,  4096, 12288, 12288,  8192, 12288, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,  4608, 12800,
    12800,  8704, 12800, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,  4096, 12288, 12288,  8192, 12288, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
     4096, 12288, 12288,  8192, 12288, 12288, 12288,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,  4096, 12288, 12288,  8192,
    12288, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0, 13056,  8960,  8960,   768, 13056,   768,   768,   768,
     8960,  8960,  8960,   768,  8960,   768,   768,   768, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12800,  8704,  8704,   512, 12800,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    13056, 13056, 13056,   768, 13056,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12544, 12544, 12544,   256, 12544,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12800, 12800,
    12800,   512, 12800,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,  8192,     0,  8192,
     8192,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,     0,     0,  8192,     0,  8192,  8192,     0,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,     0,     0,  8192,
        0,  8192,  8192,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,   512,   512,   512,  8704,   512,  8704,  8704,   512,
      512,   512,   512, 12800,   512,  8704,  8704,  4608,     0,     0,
        0,  8192,     0,  8192,  8192,     0,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,   512,   512,   512,  8704,   512,  8704,
     8704,   512,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,   512,   512,  8704,   512,  8704,  8704,   512,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,     0,     0,     0,  8192,
        0,  8192,  8192,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,     0,     0,  8192,     0,  8192,  8192,     0,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,     0,
        0,  8192,     0,  8192,  8192,     0,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,     0,     0,  8192,     0,  8192,
     8192,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
      768,   768,   768,  8960,   768,  8960,  8960,   768,   768,   768,
      768, 13056,   768,  8960,  8960,  4864,     0,     0,     0,  8192,
        0,  8192,  8192,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,   512,   512,   512,  8704,   512,  8704,  8704,   512,
      512,   512,   512, 12800,   512,  8704,  8704,  4608,   512,   512,
      512,  8704,   512,  8704,  8704,   512,   512,   512,   512, 12800,
      512,  8704,  8704,  4608,   256,   256,   256,  8448,   256,  8448,
     8448,   256,   256,   256,   256, 12544,   256,  8448,  8448,  4352,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,   512,  8704,  8704,  4608,
     8704,   512,   512,  4608,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,   512,  8704,  8704,  4608,  8704,   512,
      512,  4608,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,   256,  8448,  8448,  4352,  8448,   256,   256,  4352,
      256, 12544, 12544,   256,  8448,  4352,  4352,   256,     0,  8192,
     8192,  4096,  8192,     0,     0,  4096,     0, 12288, 12288,     0,
     8192,  4096,  4096,     0,   768,  8960,  8960,  4864,  8960,   768,
      768,  4864,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,   256,  8448,  8448,  4352,
     8448,   256,   256,  4352,   256, 12544, 12544,   256,  8448,  4352,
     4352,   256,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,   256,  8448,  8448,  4352,  8448,   256,
      256,  4352,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
      256,  8448,  8448,  4352,  8448,   256,   256,  4352,   256, 12544,
    12544,   256,  8448,  4352,  4352,   256,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,   512, 12800, 12800,   512,
     8704,  4608,  4608,   512,   768,  8960,  8960,  4864,  8960,   768,
      768,  4864,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
      512,  8704,  8704,  4608,  8704,   512,   512,  4608,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,   512,  8704,  8704,  4608,
     8704,   512,   512,  4608,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,     0,  8192,  8192,  4096,  8192,     0,
        0,  4096,     0, 12288, 12288,     0,  8192,  4096,  4096,     0,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,   768,  8960,  8960,  4864,
     8960,   768,   768,  4864,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,   512, 12800, 12800,   512,
     8704,  4608,  4608,   512,   768,  8960,  8960,  4864,  8960,   768,
      768,  4864,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8960,  4864,
     4864,   768,   768,  4864,  4864,   768, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,  4864,  4864,   768,   768,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8704,  4608,  4608,   512,
      512,  4608,  4608,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8960,  4864,  4864,   768,
      768,  4864,  4864,   768, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8960,  4864,  4864,   768,   768,  4864,  4864,   768,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8960,  4864,  4864,   768,   768,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,     0,  8192,
     8192,     0,  8192,     0,     0,     0,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,   512,  8704,  8704,   512,  8704,   512,
      512,   512,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512,  8704,  8704,   512,  8704,   512,   512,   512,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,     0,  8192,  8192,     0,
     8192,     0,     0,     0,     0,  8192,  8192,  4096,  8192,     0,
        0,  4096,   512,  8704,  8704,   512,  8704,   512,   512,   512,
      512,  8704,  8704,  4608,  8704,   512,   512,  4608,     0,  8192,
     8192,     0,  8192,     0,     0,     0,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0,  8192,  8192,     0,  8192,     0,
        0,     0,     0,  8192,  8192,  4096,  8192,     0,     0,  4096,
        0,  8192,  8192,     0,  8192,     0,     0,     0,     0,  8192,
     8192,  4096,  8192,     0,     0,  4096,     0,  8192,  8192,     0,
     8192,     0,     0,     0,     0,  8192,  8192,  4096,  8192,     0,
        0,  4096,   512,  8704,  8704,   512,  8704,   512,   512,   512,
      512,  8704,  8704,  4608,  8704,   512,   512,  4608,   512,  8704,
     8704,   512,  8704,   512,   512,   512,   512,  8704,  8704,  4608,
     8704,   512,   512,  4608,   256,  8448,  8448,   256,  8448,   256,
      256,   256,   256,  8448,  8448,  4352,  8448,   256,   256,  4352,
      512,  8704,  8704,   512,  8704,   512,   512,   512,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,     0,  8192,  8192,     0,
     8192,     0,     0,     0,     0,  8192,  8192,  4096,  8192,     0,
        0,  4096,     0,  8192,  8192,     0,  8192,     0,     0,     0,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,   256,  8448,
     8448,   256,  8448,   256,   256,   256,   256,  8448,  8448,  4352,
     8448,   256,   256,  4352,  8704,   512,   512,  4608,   512,   512,
      512,  4608,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
     8192,     0,     0,  4096,     0,     0,     0,  4096,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0,  8192,     0,     0,  4096,
        0,     0,     0,  4096,  8192,  4096,  4096,     0,     0,  4096,
     4096,     0,  8448,   256,   256,  4352,   256,   256,   256,  4352,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256,  8192,     0,
        0,  4096,     0,     0,     0,  4096,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0,  8192,     0,     0,  4096,     0,     0,
        0,  4096,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
     8192,     0,     0,  4096,     0,     0,     0,  4096,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0,  8448,   256,   256,  4352,
      256,   256,   256,  4352,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256,  8704,   512,   512,  4608,   512,   512,   512,  4608,
     8704,  4608,  4608,   512,   512,  4608,  4608,   512,  8448,   256,
      256,  4352,   256,   256,   256,  4352,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256,  8448,   256,   256,  4352,   256,   256,
      256,  4352,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
     8448,   256,   256,  4352,   256,   256,   256,  4352,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256,  8192,     0,     0,  4096,
        0,     0,     0,  4096,  8192,  4096,  4096,     0,     0,  4096,
     4096,     0,  8448,   256,   256,  4352,   256,   256,   256,  4352,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256,  8448,   256,
      256,  4352,   256,   256,   256,  4352,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256,  8448,   256,   256,  4352,   256,   256,
      256,  4352,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
     8704,   512,   512,  4608,   512,   512,   512,  4608,  8704,  4608,
     4608,   512,   512,  4608,  4608,   512,  8704,   512,   512,  4608,
      512,   512,   512,  4608,  8704,  4608,  4608,   512,   512,  4608,
     4608,   512,  8704,   512,   512,  4608,   512,   512,   512,  4608,
     8704,  4608,  4608,   512,   512,  4608,  4608,   512,  8448,   256,
      256,  4352,   256,   256,   256,  4352,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256,  8704,   512,   512,  4608,   512,   512,
      512,  4608,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
     8192,     0,     0,  4096,     0,     0,     0,  4096,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0,  8192,     0,     0,  4096,
        0,     0,     0,  4096,  8192,  4096,  4096,     0,     0,  4096,
     4096,     0,  8448,   256,   256,  4352,   256,   256,   256,  4352,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256,  8704,   512,
      512,  4608,   512,   512,   512,  4608,  8704,  4608,  4608,   512,
      512,  4608,  4608,   512,  8960,   768,   768,  4864,   768,   768,
      768,  4864,  8960,  4864,  4864,   768,   768,  4864,  4864,   768,
     8960,   768,   768,  4864,   768,   768,   768,  4864,  8960,  4864,
     4864,   768,   768,  4864,  4864,   768,  8192,     0,     0,  4096,
        0,     0,     0,  4096,  8192,  4096,  4096,     0,     0,  4096,
     4096,     0,  8704,   512,   512,  4608,   512,   512,   512,  4608,
     8704,  4608,  4608,   512,   512,  4608,  4608,   512,  8448,   256,
      256,  4352,   256,   256,   256,  4352,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256,  8448,   256,   256,  4352,   256,   256,
      256,  4352,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
     8192,     0,     0,  4096,     0,     0,     0,  4096,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0,   512,  4608,  4608,   512,
      512,  4608,  4608,   512,  4608,   512,   512,   512,  4608,   512,
      512,   512,   256,  4352,  4352,   256,   256,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,  4352,
     4352,   256,   256,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,   256,  4352,  4352,   256,   256,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
        0,  4096,  4096,     0,     0,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,   256,  4352,  4352,   256,
      256,  4352,  4352,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,  4352,  4352,   256,   256,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,  4352,
     4352,   256,   256,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,   768,  4864,  4864,   768,   768,  4864,
     4864,   768,  4864,   768,   768,   768,  4864,   768,   768,   768,
      256,  4352,  4352,   256,   256,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,   256,  4352,  4352,   256,
      256,  4352,  4352,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,     0,  4096,  4096,     0,     0,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,   256,  4352,
     4352,   256,   256,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,   256,  4352,  4352,   256,   256,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
      256,  4352,  4352,   256,   256,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,     0,  4096,  4096,     0,
        0,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096,  8192,
        0, 12288, 12288,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,   256,   256,   256, 12544,   256,  8448,
     8448,  4352,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,  4096,
     4096,  8192,     0, 12288, 12288,     0,   256,   256,   256, 12544,
      256,  8448,  8448,  4352,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,   256,   256,   256, 12544,   256,  8448,  8448,  4352,
      256,  4352,  4352,  8448,   256, 12544, 12544,   256,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,   768,   768,   768, 13056,
      768,  8960,  8960,  4864,   768,  4864,  4864,  8960,   768, 13056,
    13056,   768,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   256, 12544,
    12544,   256,  8448,  4352,  4352,   256,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256, 12544, 12544,   256,  8448,  4352,
     4352,   256,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256, 12544, 12544,   256,  8448,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,     0, 12288, 12288,     0,
     8192,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8960,   768,
      768,   768,   768,   768,   768,   768, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,   768,   768,   768,   768,   768,
      768,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8960,   768,   768,   768,   768,   768,   768,   768,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8960,   768,   768,   768,
      768,   768,   768,   768, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,   512, 12800, 12800,   512,
     8704,  4608,  4608,   512,   256,  8448,  8448,  4352,  8448,   256,
      256,  4352,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
      512,  8704,  8704,  4608,  8704,   512,   512,  4608,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,     0,  8192,  8192,  4096,  8192,     0,     0,  4096,
        0, 12288, 12288,     0,  8192,  4096,  4096,     0,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,     0,  8192,  8192,  4096,  8192,     0,
        0,  4096,     0, 12288, 12288,     0,  8192,  4096,  4096,     0,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,   768,  8960,  8960,  4864,
     8960,   768,   768,  4864,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,     0,  8192,  8192,  4096,  8192,     0,     0,  4096,
        0, 12288, 12288,     0,  8192,  4096,  4096,     0,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,   512, 12800, 12800,   512,
     8704,  4608,  4608,   512,   256,  8448,  8448,  4352,  8448,   256,
      256,  4352,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
      256,  8448,  8448,  4352,  8448,   256,   256,  4352,   256, 12544,
    12544,   256,  8448,  4352,  4352,   256,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8704,  4608,
     4608,   512,   512,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8960,  4864,  4864,   768,   768,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8192,  4096,  4096,     0,     0,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8960,  4864,  4864,   768,
      768,  4864,  4864,   768, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,  4608,
     4608,   512,   512,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8192,  4096,  4096,     0,     0,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  4864,   768,   768,   768,  4864,   768,
      768,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4352,   256,
      256,   256,  4352,   256,   256,   256,   256,   256,   256,   256,
      256,   256,   256,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4864,   768,   768,   768,  4864,   768,   768,   768,
      768,   768,   768,   768,   768,   768,   768,   768,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4352,   256,   256,   256,
     4352,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,   512,  8704,  8704,  4608,
     8704,   512,   512,  4608,   512, 12800, 12800,  4608,  8704,  4608,
     4608,  4608,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,   512,  8704,  8704,  4608,  8704,   512,
      512,  4608,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,  4096,  8192,  4096,
     4096,  4096,   256,  8448,  8448,  4352,  8448,   256,   256,  4352,
      256, 12544, 12544,  4352,  8448,  4352,  4352,  4352,     0,  8192,
     8192,  4096,  8192,     0,     0,  4096,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,   768,  8960,  8960,  4864,  8960,   768,
      768,  4864,   768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,  4864,  8960,  4864,  4864,  4864,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,  4096,  8192,  4096,
     4096,  4096,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,   256,  8448,  8448,  4352,  8448,   256,
      256,  4352,   256, 12544, 12544,  4352,  8448,  4352,  4352,  4352,
        0,  8192,  8192,  4096,  8192,     0,     0,  4096,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  8704,  4608,  4608,  4608,
      512,  4608,  4608,  4608, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8448,  4352,  4352,  4352,
      256,  4352,  4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8960,  4864,  4864,  4864,   768,  4864,
     4864,  4864, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
     8448,  4352,  4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256,  8448,  4352,  4352,  4352,
      256,  4352,  4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8448,  4352,  4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8704,  4608,  4608,  4608,   512,  4608,  4608,  4608,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512,  8960,  4864,
     4864,  4864,   768,  4864,  4864,  4864, 13056,  4864,  4864,   768,
     4864,  4864,  4864,   768,  8960,  4864,  4864,  4864,   768,  4864,
     4864,  4864, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8704,  4608,  4608,  4608,
      512,  4608,  4608,  4608, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8192,  4096,  4096,  4096,     0,  4096,
     4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
     8960,  4864,  4864,  4864,   768,  4864,  4864,  4864, 13056,  4864,
     4864,   768,  4864,  4864,  4864,   768,  8704,  4608,  4608,  4608,
      512,  4608,  4608,  4608, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512,  8704,  4608,  4608,  4608,   512,  4608,  4608,  4608,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512,  8192,  4096,
     4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0,  8960,  4864,  4864,  4864,   768,  4864,
     4864,  4864, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  4864,  4864,
     4864,   768,  4864,  4864,  4864,   768,  4864,   768,   768,   768,
     4864,   768,   768,   768,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4864,  4864,  4864,   768,
     4864,  4864,  4864,   768,  4864,   768,   768,   768,  4864,   768,
      768,   768,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  8704,   512,   512,  4608,   512,   512,
      512,  4608,  8704,  4608,  4608,  4608,   512,  4608,  4608,  4608,
     8192,     0,     0,  4096,     0,     0,     0,  4096,  8192,  4096,
     4096,  4096,     0,  4096,  4096,  4096,  8192,     0,     0,  4096,
        0,     0,     0,  4096,  8192,  4096,  4096,  4096,     0,  4096,
     4096,  4096,  8448,   256,   256,  4352,   256,   256,   256,  4352,
     8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,  8192,     0,
        0,  4096,     0,     0,     0,  4096,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096,  8192,     0,     0,  4096,     0,     0,
        0,  4096,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
     8192,     0,     0,  4096,     0,     0,     0,  4096,  8192,  4096,
     4096,  4096,     0,  4096,  4096,  4096,  8448,   256,   256,  4352,
      256,   256,   256,  4352,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352,  8704,   512,   512,  4608,   512,   512,   512,  4608,
     8704,  4608,  4608,  4608,   512,  4608,  4608,  4608,  8448,   256,
      256,  4352,   256,   256,   256,  4352,  8448,  4352,  4352,  4352,
      256,  4352,  4352,  4352,  8448,   256,   256,  4352,   256,   256,
      256,  4352,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
     8192,     0,     0,  4096,     0,     0,     0,  4096,  8192,  4096,
     4096,  4096,     0,  4096,  4096,  4096,  8192,     0,     0,  4096,
        0,     0,     0,  4096,  8192,  4096,  4096,  4096,     0,  4096,
     4096,  4096,  8448,   256,   256,  4352,   256,   256,   256,  4352,
     8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,  8448,   256,
      256,  4352,   256,   256,   256,  4352,  8448,  4352,  4352,  4352,
      256,  4352,  4352,  4352,  8192,     0,     0,  4096,     0,     0,
        0,  4096,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
        0,  4096,  4096,  4096,     0,  4096,  4096,  4096,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,   256,  4352,  4352,  4352,
      256,  4352,  4352,  4352,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,  4352,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,   256,  4352,
     4352,  4352,   256,  4352,  4352,  4352,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,     0,  4096,  4096,  4096,     0,  4096,
     4096,  4096,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
      256,  4352,  4352,  4352,   256,  4352,  4352,  4352,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,   256,  4352,  4352,  4352,
      256,  4352,  4352,  4352,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,  4352,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,   256,  4352,
     4352,  4352,   256,  4352,  4352,  4352,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,   256,  4352,  4352,  4352,   256,  4352,
     4352,  4352,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
      256,  4352,  4352,  4352,   256,  4352,  4352,  4352,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,     0,  4096,  4096,  4096,
        0,  4096,  4096,  4096,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,   256,  4352,  4352,  4352,   256,  4352,  4352,  4352,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,   256,  4352,
     4352,  4352,   256,  4352,  4352,  4352,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,   256,  4352,  4352,  4352,   256,  4352,
     4352,  4352,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
        0,  4096,  4096,  4096,     0,  4096,  4096,  4096,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,   512,  4608,  4608,  4608,
      512,  4608,  4608,  4608,  4608,  4608,  4608,   512,  4608,  4608,
     4608,   512,   256,  4352,  4352,  4352,   256,  4352,  4352,  4352,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,   256,  4352,
     4352,  4352,   256,  4352,  4352,  4352,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,     0,  4096,  4096,  4096,     0,  4096,
     4096,  4096,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
        0,  4096,  4096,  4096,     0,  4096,  4096,  4096,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,   256,  4352,  4352,  4352,
      256,  4352,  4352,  4352,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,  4352,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,     0,  4096,
     4096,  4096,     0,  4096,  4096,  4096,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,   768,  4864,  4864,  4864,   768,  4864,
     4864,  4864,  4864,  4864,  4864,   768,  4864,  4864,  4864,   768,
        0,  4096,  4096,  4096,     0,  4096,  4096,  4096,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,     0,  4096,  4096,  4096,
        0,  4096,  4096,  4096,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,   256,  4352,
     4352,  4352,   256,  4352,  4352,  4352,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,     0,  4096,  4096,  4096,     0,  4096,
     4096,  4096,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
        0,  4096,  4096,  4096,     0,  4096,  4096,  4096,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,     0,  4096,  4096,  4096,
        0,  4096,  4096,  4096,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,   768, 13056, 13056,  4864,  8960,  4864,
     4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   256, 12544,
    12544,  4352,  8448,  4352,  4352,  4352,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,   256, 12544, 12544,  4352,  8448,  4352,
     4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,  4352,   256,
        0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,
     4352,   256,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   512, 12800,
    12800,  4608,  8704,  4608,  4608,  4608,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,     0, 12288, 12288,  4096,  8192,  4096,
     4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,     0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
    13056,   768,   768,   768,  4864,   768,   768,   768, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    13056,  4864,  4864,   768,  4864,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768, 12800,  4608,  4608,   512,
     4608,  4608,  4608,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12800,  4608,
     4608,   512,  4608,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512, 12800,   512,
      512,   512,  4608,   512,   512,   512, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  4864,   768,   768,   768,
     4864,   768,   768,   768,   768,   768,   768,   768,   768,   768,
      768,   768,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4608,   512,   512,   512,  4608,   512,
      512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  8704,  4608,  4608,  4608,   512,  4608,  4608,  4608,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8192,  4096,  4096,  4096,     0,  4096,
     4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
     8960,  4864,  4864,  4864,   768,  4864,  4864,  4864, 13056,  4864,
     4864,   768,  4864,  4864,  4864,   768,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  8192,  4096,
     4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4864,  4864,  4864,   768,  4864,  4864,
     4864,   768,  4864,   768,   768,   768,  4864,   768,   768,   768,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4608,  4608,  4608,   512,  4608,  4608,  4608,   512,
     4608,   512,   512,   512,  4608,   512,   512,   512,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,  8192,  8192, 12288,
     8192,  8192,  8192,  4096,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,   512,  8704,  8704, 12800,  8704,  8704,  8704,  4608,
      512, 12800, 12800,  8704,  8704, 12800, 12800,   512,   512,  8704,
     8704, 12800,  8704,  8704,  8704,  4608,   512, 12800, 12800,  8704,
     8704, 12800, 12800,   512,   256,  8448,  8448, 12544,  8448,  8448,
     8448,  4352,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
      512,  8704,  8704, 12800,  8704,  8704,  8704,  4608,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,     0,  8192,  8192, 12288,
     8192,  8192,  8192,  4096,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,     0,  8192,  8192, 12288,  8192,  8192,  8192,  4096,
        0, 12288, 12288,  8192,  8192, 12288, 12288,     0,   256,  8448,
     8448, 12544,  8448,  8448,  8448,  4352,   256, 12544, 12544,  8448,
     8448, 12544, 12544,   256,     0,  8192,  8192, 12288,  8192,  8192,
     8192,  4096,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
      768,  8960,  8960, 13056,  8960,  8960,  8960,  4864,   768, 13056,
    13056,  8960,  8960, 13056, 13056,   768,   768,  8960,  8960, 13056,
     8960,  8960,  8960,  4864,   768, 13056, 13056,  8960,  8960, 13056,
    13056,   768,     0,  8192,  8192, 12288,  8192,  8192,  8192,  4096,
        0, 12288, 12288,  8192,  8192, 12288, 12288,     0,   512,  8704,
     8704, 12800,  8704,  8704,  8704,  4608,   512, 12800, 12800,  8704,
     8704, 12800, 12800,   512,   256,  8448,  8448, 12544,  8448,  8448,
     8448,  4352,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
      256,  8448,  8448, 12544,  8448,  8448,  8448,  4352,   256, 12544,
    12544,  8448,  8448, 12544, 12544,   256,     0,  8192,  8192, 12288,
     8192,  8192,  8192,  4096,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  8704, 12800, 12800,   512,  8704,  4608,  4608,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8448, 12544, 12544,   256,  8448,  4352,  4352,   256,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8960, 13056, 13056,   768,  8960,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8448, 12544, 12544,   256,
     8448,  4352,  4352,   256, 12544,  8448,  8448,   256, 12544,   256,
      256,   256,  8448, 12544, 12544,   256,  8448,  4352,  4352,   256,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256,  8448, 12544, 12544,   256,
     8448,  4352,  4352,   256, 12544,  8448,  8448,   256, 12544,   256,
      256,   256,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8704, 12800,
    12800,   512,  8704,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8960, 13056, 13056,   768,  8960,  4864,
     4864,   768, 13056,  8960,  8960,   768, 13056,   768,   768,   768,
     8960, 13056, 13056,   768,  8960,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8704, 12800, 12800,   512,  8704,  4608,  4608,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8192, 12288, 12288,     0,  8192,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8960, 13056, 13056,   768,
     8960,  4864,  4864,   768, 13056,  8960,  8960,   768, 13056,   768,
      768,   768,  8704, 12800, 12800,   512,  8704,  4608,  4608,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704, 12800,
    12800,   512,  8704,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8192, 12288, 12288,     0,  8192,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8960, 13056, 13056,   768,  8960,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8960,   768,   768,   768,   768,   768,   768,   768,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,   256,   256,   256,
      256,   256,   256,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,  8704,  8704,  4608,  8704,   512,   512,  4608,  8704, 12800,
    12800,   512,  8704,  4608,  4608,   512,  8192,  8192,  8192,  4096,
     8192,     0,     0,  4096,  8192, 12288, 12288,     0,  8192,  4096,
     4096,     0,  8192,  8192,  8192,  4096,  8192,     0,     0,  4096,
     8192, 12288, 12288,     0,  8192,  4096,  4096,     0,  8448,  8448,
     8448,  4352,  8448,   256,   256,  4352,  8448, 12544, 12544,   256,
     8448,  4352,  4352,   256,  8192,  8192,  8192,  4096,  8192,     0,
        0,  4096,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
     8192,  8192,  8192,  4096,  8192,     0,     0,  4096,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0,  8192,  8192,  8192,  4096,
     8192,     0,     0,  4096,  8192, 12288, 12288,     0,  8192,  4096,
     4096,     0,  8448,  8448,  8448,  4352,  8448,   256,   256,  4352,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256,  8704,  8704,
     8704,  4608,  8704,   512,   512,  4608,  8704, 12800, 12800,   512,
     8704,  4608,  4608,   512,  8448,  8448,  8448,  4352,  8448,   256,
      256,  4352,  8448, 12544, 12544,   256,  8448,  4352,  4352,   256,
     8448,  8448,  8448,  4352,  8448,   256,   256,  4352,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256,  8192,  8192,  8192,  4096,
     8192,     0,     0,  4096,  8192, 12288, 12288,     0,  8192,  4096,
     4096,     0,  8192,  8192,  8192,  4096,  8192,     0,     0,  4096,
     8192, 12288, 12288,     0,  8192,  4096,  4096,     0,  8448,  8448,
     8448,  4352,  8448,   256,   256,  4352,  8448, 12544, 12544,   256,
     8448,  4352,  4352,   256,  8448,  8448,  8448,  4352,  8448,   256,
      256,  4352,  8448, 12544, 12544,   256,  8448,  4352,  4352,   256,
     8192,  8192,  8192,  4096,  8192,     0,     0,  4096,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8192,  4096,  4096,     0,     0,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8192,  4096,  4096,     0,     0,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8192,  4096,  4096,     0,     0,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8192,  4096,  4096,     0,     0,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  4352,   256,
      256,   256,  4352,   256,   256,   256,   256,   256,   256,   256,
      256,   256,   256,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4352,   256,   256,   256,  4352,   256,   256,   256,
      256,   256,   256,   256,   256,   256,   256,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,   256,   256,   256,   256,
      256,   256,   256,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4352,   256,   256,   256,
     4352,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
      768, 13056, 13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   256, 12544, 12544,  8448,  8448, 12544,
    12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256, 12544, 12544,  8448,  8448, 12544, 12544,   256,  4352,  8448,
     8448,  8448, 12544,  8448,  8448,   256,     0, 12288, 12288,  8192,
     8192, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
     4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512, 12800, 12800,  8704,  8704, 12800,
    12800,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
        0, 12288, 12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0, 12288,
    12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12544,  8448,  8448,   256, 12544,   256,
      256,   256,  8448,  8448,  8448,   256,  8448,   256,   256,   256,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8448,  8448,
     8448,   256,  8448,   256,   256,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 13056,  8960,  8960,   768,
    13056,   768,   768,   768,  8960,  8960,  8960,   768,  8960,   768,
      768,   768, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12800,  8704,  8704,   512, 12800,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8960,   768,   768,   768,   768,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8448,   256,   256,   256,
      256,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8704, 12800,
    12800,   512,  8704,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8192, 12288, 12288,     0,  8192,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8960, 13056, 13056,   768,
     8960,  4864,  4864,   768, 13056,  8960,  8960,   768, 13056,   768,
      768,   768,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192, 12288, 12288,     0,  8192,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,   256,   256,   256,
      256,   256,   256,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,   256,   256,   256,   256,   256,   256,   256, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8960,   768,
      768,   768,   768,   768,   768,   768, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  8704, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
    12800, 12800, 12800,   512, 12800,  4608,  4608,   512,  8448, 12544,
    12544,  4352,  8448,  4352,  4352,  4352, 12544, 12544, 12544,   256,
    12544,  4352,  4352,   256,  8448, 12544, 12544,  4352,  8448,  4352,
     4352,  4352, 12544, 12544, 12544,   256, 12544,  4352,  4352,   256,
     8192, 12288, 12288,  4096,  8192,  4096,  4096,  4096, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0,  8192, 12288, 12288,  4096,
     8192,  4096,  4096,  4096, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0,  8448, 12544, 12544,  4352,  8448,  4352,  4352,  4352,
    12544, 12544, 12544,   256, 12544,  4352,  4352,   256,  8448, 12544,
    12544,  4352,  8448,  4352,  4352,  4352, 12544, 12544, 12544,   256,
    12544,  4352,  4352,   256,  8192, 12288, 12288,  4096,  8192,  4096,
     4096,  4096, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
     8960, 13056, 13056,  4864,  8960,  4864,  4864,  4864, 13056, 13056,
    13056,   768, 13056,  4864,  4864,   768,  8192, 12288, 12288,  4096,
     8192,  4096,  4096,  4096, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0,  8192, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0,  8192, 12288,
    12288,  4096,  8192,  4096,  4096,  4096, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0,  8448, 12544, 12544,  4352,  8448,  4352,
     4352,  4352, 12544, 12544, 12544,   256, 12544,  4352,  4352,   256,
     8192, 12288, 12288,  4096,  8192,  4096,  4096,  4096, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0,  8192, 12288, 12288,  4096,
     8192,  4096,  4096,  4096, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0,  8192, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8192,  4096,  4096,  4096,     0,  4096,
     4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8448,  4352,  4352,  4352,
      256,  4352,  4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8192,  4096,
     4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8192,  4096,  4096,  4096,     0,  4096,
     4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4352,   256,
      256,   256,  4352,   256,   256,   256,   256,   256,   256,   256,
      256,   256,   256,   256,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    13056, 13056, 13056,   768, 13056,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12544, 12544, 12544,   256, 12544,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12800, 12800,
    12800,   512, 12800,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,  4096,     0,     0,     0, 12288,     0,  4096,  4096,     0,
        0,  4096,  4096,  8192,     0,     0,     0,  4096,     0,     0,
        0, 12288,     0,  4096,  4096,     0,     0,  4096,  4096,  8192,
        0,     0,     0,  4096,     0,     0,     0, 12288,     0,  4096,
     4096,     0,     0,  4096,  4096,  8192,   256,   256,   256,  4352,
      256,   256,   256, 12544,   256,  4352,  4352,   256,   256,  4352,
     4352,  8448,     0,     0,     0,  4096,     0,     0,     0, 12288,
        0,  4096,  4096,     0,     0,  4096,  4096,  8192,     0,     0,
        0,  4096,     0,     0,     0, 12288,     0,  4096,  4096,     0,
        0,  4096,  4096,  8192,     0,     0,     0,  4096,     0,     0,
        0, 12288,     0,  4096,  4096,     0,     0,  4096,  4096,  8192,
      768,   768,   768,  4864,   768,   768,   768, 13056,   768,  4864,
     4864,   768,   768,  4864,  4864,  8960,     0,     0,     0,  4096,
        0,     0,     0, 12288,     0,  4096,  4096,     0,     0,  4096,
     4096,  8192,   256,   256,   256,  4352,   256,   256,   256, 12544,
      256,  4352,  4352,   256,   256,  4352,  4352,  8448,   256,   256,
      256,  4352,   256,   256,   256, 12544,   256,  4352,  4352,   256,
      256,  4352,  4352,  8448,     0,     0,     0,  4096,     0,     0,
        0, 12288,     0,  4096,  4096,     0,     0,  4096,  4096,  8192,
        0,     0,     0,  4096,     0,     0,     0, 12288,     0,  4096,
     4096,     0,     0,  4096,  4096,  8192,   256,   256,   256,  4352,
      256,   256,   256, 12544,   256,  4352,  4352,   256,   256,  4352,
     4352,  8448,   256,   256,   256,  4352,   256,   256,   256, 12544,
      256,  4352,  4352,   256,   256,  4352,  4352,  8448,   512,   512,
      512,  4608,   512,   512,   512, 12800,   512,  4608,  4608,   512,
      512,  4608,  4608,  8704,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
      256,  4352,  4352,  8448,   256, 12544, 12544,   256,  4352,   256,
      256,  8448,  4352,  8448,  8448,   256,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   768,  4864,  4864,  8960,   768, 13056, 13056,   768,
     4864,   768,   768,  8960,  4864,  8960,  8960,   768,     0,  4096,
     4096,  8192,     0, 12288, 12288,     0,  4096,     0,     0,  8192,
     4096,  8192,  8192,     0,   768,  4864,  4864,  8960,   768, 13056,
    13056,   768,  4864,   768,   768,  8960,  4864,  8960,  8960,   768,
      768,  4864,  4864,  8960,   768, 13056, 13056,   768,  4864,   768,
      768,  8960,  4864,  8960,  8960,   768,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   256,  4352,
     4352,  8448,   256, 12544, 12544,   256,  4352,   256,   256,  8448,
     4352,  8448,  8448,   256,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,  4352,   256,   256,  8448,  4352,  8448,  8448,   256,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   768,  4864,  4864,  8960,   768, 13056, 13056,   768,
     4864,   768,   768,  8960,  4864,  8960,  8960,   768,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,  4864,   768,   768,  8960,
     4864,  8960,  8960,   768,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   512,  4608,
     4608,  8704,   512, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
      768,  4864,  4864,  8960,   768, 13056, 13056,   768,  4864,   768,
      768,  8960,  4864,  8960,  8960,   768,   768,  4864,  4864,  8960,
      768, 13056, 13056,   768,  4864,   768,   768,  8960,  4864,  8960,
     8960,   768,   512,  4608,  4608,  8704,   512, 12800, 12800,   512,
     4608,   512,   512,  8704,  4608,  8704,  8704,   512,   256,  4352,
     4352,  8448,   256, 12544, 12544,   256,  4352,   256,   256,  8448,
     4352,  8448,  8448,   256,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,  4608,   512,   512,  8704,  4608,  8704,
     8704,   512,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   512,  4608,
     4608,  8704,   512, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,   512,  4608,  4608,  8704,   512, 12800,
    12800,   512,  4608,   512,   512,  8704,  4608,  8704,  8704,   512,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256,  8448,  8448,   256,  8448,   256,
      256,   256,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768,  8960,  8960,   768,  8960,   768,   768,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768,  8960,
     8960,   768,  8960,   768,   768,   768,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,   768,  8960,  8960,   768,  8960,   768,
      768,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768,  8960,  8960,   768,  8960,   768,   768,   768,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,     0,  8192,  8192,     0,
     8192,     0,     0,     0,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   256,  8448,  8448,   256,  8448,   256,   256,   256,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096,  8192,
        0, 12288, 12288,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,   256,   256,   256, 12544,   256,  8448,
     8448,  4352,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,  4096,
     4096,  8192,     0, 12288, 12288,     0,   256,   256,   256, 12544,
      256,  8448,  8448,  4352,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,   256,   256,   256, 12544,   256,  8448,  8448,  4352,
      256,  4352,  4352,  8448,   256, 12544, 12544,   256,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,   768,   768,   768, 13056,
      768,  8960,  8960,  4864,   768,  4864,  4864,  8960,   768, 13056,
    13056,   768,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   256, 12544,
    12544,   256,  8448,  4352,  4352,   256,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256, 12544, 12544,   256,  8448,  4352,
     4352,   256,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256, 12544, 12544,   256,  8448,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,     0, 12288, 12288,     0,
     8192,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8960,   768,
      768,   768,   768,   768,   768,   768, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,   768,   768,   768,   768,   768,
      768,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8960,   768,   768,   768,   768,   768,   768,   768,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8960,   768,   768,   768,
      768,   768,   768,   768, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,     0,  4096,  4096,     0,
        0,  4096,  4096,  8192,  4096,     0,     0,     0,  4096,     0,
        0,  8192,   256,  4352,  4352,   256,   256,  4352,  4352,  8448,
     4352,   256,   256,   256,  4352,   256,   256,  8448,   256,  4352,
     4352,   256,   256,  4352,  4352,  8448,  4352,   256,   256,   256,
     4352,   256,   256,  8448,     0,  4096,  4096,     0,     0,  4096,
     4096,  8192,  4096,     0,     0,     0,  4096,     0,     0,  8192,
        0,  4096,  4096,     0,     0,  4096,  4096,  8192,  4096,     0,
        0,     0,  4096,     0,     0,  8192,   256,  4352,  4352,   256,
      256,  4352,  4352,  8448,  4352,   256,   256,   256,  4352,   256,
      256,  8448,   256,  4352,  4352,   256,   256,  4352,  4352,  8448,
     4352,   256,   256,   256,  4352,   256,   256,  8448,   512,  4608,
     4608,   512,   512,  4608,  4608,  8704,  4608,   512,   512,   512,
     4608,   512,   512,  8704,   256,  4352,  4352,   256,   256,  4352,
     4352,  8448,  4352,   256,   256,   256,  4352,   256,   256,  8448,
        0,  4096,  4096,     0,     0,  4096,  4096,  8192,  4096,     0,
        0,     0,  4096,     0,     0,  8192,     0,  4096,  4096,     0,
        0,  4096,  4096,  8192,  4096,     0,     0,     0,  4096,     0,
        0,  8192,     0,  4096,  4096,     0,     0,  4096,  4096,  8192,
     4096,     0,     0,     0,  4096,     0,     0,  8192,   256,  4352,
     4352,   256,   256,  4352,  4352,  8448,  4352,   256,   256,   256,
     4352,   256,   256,  8448,     0,  4096,  4096,     0,     0,  4096,
     4096,  8192,  4096,     0,     0,     0,  4096,     0,     0,  8192,
        0,  4096,  4096,     0,     0,  4096,  4096,  8192,  4096,     0,
        0,     0,  4096,     0,     0,  8192,   512,  4608,  4608,   512,
      512,  4608,  4608,  8704,  4608,   512,   512,   512,  4608,   512,
      512,  8704,  4352,   256,   256,  8448,  4352,  8448,  8448,   256,
      256,   256,   256,  8448,   256,  8448,  8448,   256,  4352,   256,
      256,  8448,  4352,  8448,  8448,   256,   256,   256,   256,  8448,
      256,  8448,  8448,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   256,   256,   256,  8448,   256,  8448,  8448,   256,
     4608,   512,   512,  8704,  4608,  8704,  8704,   512,   512,   512,
      512,  8704,   512,  8704,  8704,   512,  4352,   256,   256,  8448,
     4352,  8448,  8448,   256,   256,   256,   256,  8448,   256,  8448,
     8448,   256,  4864,   768,   768,  8960,  4864,  8960,  8960,   768,
      768,   768,   768,  8960,   768,  8960,  8960,   768,  4864,   768,
      768,  8960,  4864,  8960,  8960,   768,   768,   768,   768,  8960,
      768,  8960,  8960,   768,  4096,     0,     0,  8192,  4096,  8192,
     8192,     0,     0,     0,     0,  8192,     0,  8192,  8192,     0,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   256,   256,
      256,  8448,   256,  8448,  8448,   256,  4096,     0,     0,  8192,
     4096,  8192,  8192,     0,     0,     0,     0,  8192,     0,  8192,
     8192,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,     0,     0,  8192,     0,  8192,  8192,     0,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,   512,   512,   512,  8704,
      512,  8704,  8704,   512,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   256,   256,   256,  8448,   256,  8448,  8448,   256,
     4608,   512,   512,  8704,  4608,  8704,  8704,   512,   512,   512,
      512,  8704,   512,  8704,  8704,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,   512,   512,   512,  8704,   512,  8704,
     8704,   512,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,     0,     0,  8192,     0,  8192,  8192,     0,  4352,   256,
      256,  8448,  4352,  8448,  8448,   256,   256,   256,   256,  8448,
      256,  8448,  8448,   256,  4096,     0,     0,  8192,  4096,  8192,
     8192,     0,     0,     0,     0,  8192,     0,  8192,  8192,     0,
     4096,     0,     0,  8192,  4096,  8192,  8192,     0,     0,     0,
        0,  8192,     0,  8192,  8192,     0,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,   512,   512,   512,  8704,   512,  8704,
     8704,   512,  4352,   256,   256,  8448,  4352,  8448,  8448,   256,
      256,   256,   256,  8448,   256,  8448,  8448,   256,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,   512,   512,   512,  8704,
      512,  8704,  8704,   512,  4608,   512,   512,  8704,  4608,  8704,
     8704,   512,   512,   512,   512,  8704,   512,  8704,  8704,   512,
     4608,   512,   512,  8704,  4608,  8704,  8704,   512,   512,   512,
      512,  8704,   512,  8704,  8704,   512,  4096,     0,     0,  8192,
     4096,  8192,  8192,     0,     0,     0,     0,  8192,     0,  8192,
     8192,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,     0,     0,  8192,     0,  8192,  8192,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,     0,     0,     0,  8192,
        0,  8192,  8192,     0,  4608,   512,   512,  8704,  4608,  8704,
     8704,   512,   512,   512,   512,  8704,   512,  8704,  8704,   512,
     4096,     0,     0,  8192,  4096,  8192,  8192,     0,     0,     0,
        0,  8192,     0,  8192,  8192,     0,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,   512,   512,   512,  8704,   512,  8704,
     8704,   512,  4608,   512,   512,  8704,  4608,  8704,  8704,   512,
      512,   512,   512,  8704,   512,  8704,  8704,   512,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,   512,   512,   512,  8704,
      512,  8704,  8704,   512,   256,  8448,  8448,   256,  8448,   256,
      256,   256,   256,  8448,  8448,   256,  8448,   256,   256,   256,
      512,  8704,  8704,   512,  8704,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,   768,  8960,
     8960,   768,  8960,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,   512,  8704,  8704,   512,  8704,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,     0,  8192,  8192,     0,
     8192,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
        0,  8192,  8192,     0,  8192,     0,     0,     0,   512,  8704,
     8704,   512,  8704,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,     0,  8192,  8192,     0,  8192,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   512,  4608,
     4608,  8704,   512, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
      768,  4864,  4864,  8960,   768, 13056, 13056,   768,  4864,   768,
      768,  8960,  4864,  8960,  8960,   768,   768,  4864,  4864,  8960,
      768, 13056, 13056,   768,  4864,   768,   768,  8960,  4864,  8960,
     8960,   768,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
     4096,     0,     0,  8192,  4096,  8192,  8192,     0,   256,  4352,
     4352,  8448,   256, 12544, 12544,   256,  4352,   256,   256,  8448,
     4352,  8448,  8448,   256,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,  4608,   512,   512,  8704,  4608,  8704,
     8704,   512,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   512,  4608,
     4608,  8704,   512, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,   512,  4608,  4608,  8704,   512, 12800,
    12800,   512,  4608,   512,   512,  8704,  4608,  8704,  8704,   512,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256,  8448,  8448,   256,  8448,   256,
      256,   256,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768,  8960,  8960,   768,  8960,   768,   768,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768,  8960,
     8960,   768,  8960,   768,   768,   768,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256,  8448,  8448,   256,  8448,   256,
      256,   256,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256,  8448,  8448,   256,  8448,   256,   256,   256,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,     0,  8192,  8192,     0,
     8192,     0,     0,     0,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   256,  8448,  8448,   256,  8448,   256,   256,   256,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
        0,  8192,  8192,     0,  8192,     0,     0,     0,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,     0,  8192,
     8192,     0,  8192,     0,     0,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256,  8448,  8448,   256,  8448,   256,   256,   256,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,   768,  8960,  8960,   768,  8960,   768,
      768,   768,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,     0,  8192,
     8192,     0,  8192,     0,     0,     0,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
        0,  8192,  8192,     0,  8192,     0,     0,     0,  8960,   768,
      768,   768,   768,   768,   768,   768,  8960,   768,   768,   768,
      768,   768,   768,   768,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8960,   768,   768,   768,   768,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8704,   512,   512,   512,
      512,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,     0,  4096,  4096, 12288,     0, 12288,
    12288,  4096,  4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,
      256,  4352,  4352, 12544,   256, 12544, 12544,  4352,  4352,  4352,
     4352,  8448,  4352, 12544, 12544,   256,   256,  4352,  4352, 12544,
      256, 12544, 12544,  4352,  4352,  4352,  4352,  8448,  4352, 12544,
    12544,   256,   512,  4608,  4608, 12800,   512, 12800, 12800,  4608,
     4608,  4608,  4608,  8704,  4608, 12800, 12800,   512,     0,  4096,
     4096, 12288,     0, 12288, 12288,  4096,  4096,  4096,  4096,  8192,
     4096, 12288, 12288,     0,   768,  4864,  4864, 13056,   768, 13056,
    13056,  4864,  4864,  4864,  4864,  8960,  4864, 13056, 13056,   768,
      768,  4864,  4864, 13056,   768, 13056, 13056,  4864,  4864,  4864,
     4864,  8960,  4864, 13056, 13056,   768,     0,  4096,  4096, 12288,
        0, 12288, 12288,  4096,  4096,  4096,  4096,  8192,  4096, 12288,
    12288,     0,   256,  4352,  4352, 12544,   256, 12544, 12544,  4352,
     4352,  4352,  4352,  8448,  4352, 12544, 12544,   256,     0,  4096,
     4096, 12288,     0, 12288, 12288,  4096,  4096,  4096,  4096,  8192,
     4096, 12288, 12288,     0,     0,  4096,  4096, 12288,     0, 12288,
    12288,  4096,  4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,
      512,  4608,  4608, 12800,   512, 12800, 12800,  4608,  4608,  4608,
     4608,  8704,  4608, 12800, 12800,   512,   256,  4352,  4352, 12544,
      256, 12544, 12544,  4352,  4352,  4352,  4352,  8448,  4352, 12544,
    12544,   256,   512,  4608,  4608, 12800,   512, 12800, 12800,  4608,
     4608,  4608,  4608,  8704,  4608, 12800, 12800,   512,   512,  4608,
     4608, 12800,   512, 12800, 12800,  4608,  4608,  4608,  4608,  8704,
     4608, 12800, 12800,   512,     0,  4096,  4096, 12288,     0, 12288,
    12288,  4096,  4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,
     4352, 12544, 12544,   256, 12544,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,  4864, 13056, 13056,   768,
    13056,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,  4864, 13056, 13056,   768, 13056,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
     4352, 12544, 12544,   256, 12544,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,  4352, 12544,
    12544,   256, 12544,  4352,  4352,   256,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,  4608, 12800,
    12800,   512, 12800,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
     4864, 13056, 13056,   768, 13056,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,  4608, 12800,
    12800,   512, 12800,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,  4608, 12800, 12800,   512, 12800,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,   768,   768,   768,   768,   768,
      768,   768, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,   768, 13056, 13056,  4864,  8960,  4864,
     4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   256, 12544,
    12544,  4352,  8448,  4352,  4352,  4352,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,   256, 12544, 12544,  4352,  8448,  4352,
     4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,  4352,   256,
        0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,
     4352,   256,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   512, 12800,
    12800,  4608,  8704,  4608,  4608,  4608,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,     0, 12288, 12288,  4096,  8192,  4096,
     4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,     0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
    13056,   768,   768,   768,  4864,   768,   768,   768, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    13056,  4864,  4864,   768,  4864,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768, 12800,  4608,  4608,   512,
     4608,  4608,  4608,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12800,  4608,
     4608,   512,  4608,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512, 12800,   512,
      512,   512,  4608,   512,   512,   512, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  4864,   768,   768,   768,
     4864,   768,   768,   768,   768,   768,   768,   768,   768,   768,
      768,   768,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4608,   512,   512,   512,  4608,   512,
      512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4352,  4352,  4352,  8448,  4352, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,  4096,  4096,
     4096,  8192,  4096, 12288, 12288,     0,  4096,     0,     0,  8192,
     4096,  8192,  8192,     0,  4096,  4096,  4096,  8192,  4096, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
     4608,  4608,  4608,  8704,  4608, 12800, 12800,   512,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,  4352,  4352,  4352,  8448,
     4352, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,  4608,  4608,  4608,  8704,  4608, 12800, 12800,   512,
     4608,   512,   512,  8704,  4608,  8704,  8704,   512,  4608,  4608,
     4608,  8704,  4608, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,  4096,  4096,  4096,  8192,  4096, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
     4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,  4096,  4096,  4096,  8192,
     4096, 12288, 12288,     0,  4096,     0,     0,  8192,  4096,  8192,
     8192,     0,  4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,
     4096,     0,     0,  8192,  4096,  8192,  8192,     0,  4608,  4608,
     4608,  8704,  4608, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,  4096,  4096,  4096,  8192,  4096, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
     4608,  4608,  4608,  8704,  4608, 12800, 12800,   512,  4608,   512,
      512,  8704,  4608,  8704,  8704,   512,  4608,  4608,  4608,  8704,
     4608, 12800, 12800,   512,  4608,   512,   512,  8704,  4608,  8704,
     8704,   512,  4096,  4096,  4096,  8192,  4096, 12288, 12288,     0,
     4096,     0,     0,  8192,  4096,  8192,  8192,     0,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,   256,  8448,  8448,   256,
     8448,   256,   256,   256,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768,  8960,  8960,   768,  8960,   768,   768,   768,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,     0,  8192,  8192,     0,
     8192,     0,     0,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,     0,  8192,
     8192,     0,  8192,     0,     0,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
        0,  8192,  8192,     0,  8192,     0,     0,     0,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,     0,  8192,  8192,     0,
     8192,     0,     0,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
        0,  8192,  8192,     0,  8192,     0,     0,     0,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,  4608, 12800,
    12800,   512, 12800,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4864, 13056, 13056,   768, 13056,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,  4608, 12800,
    12800,   512, 12800,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,   512,   512,   512,   512,   512,   512,
      512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,   512,   512,   512,   512,   512,   512,   512,   512,
      512,   512,   512,   512,   512,   512,   512,   512,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,  8192,  4096,     0,
        0,  8192,  4096,  8192,  8192,  8192,   256,  4352,  4352,  8448,
      256, 12544, 12544,  8448,  4352,   256,   256,  8448,  4352,  8448,
     8448,  8448,   256,  4352,  4352,  8448,   256, 12544, 12544,  8448,
     4352,   256,   256,  8448,  4352,  8448,  8448,  8448,   512,  4608,
     4608,  8704,   512, 12800, 12800,  8704,  4608,   512,   512,  8704,
     4608,  8704,  8704,  8704,     0,  4096,  4096,  8192,     0, 12288,
    12288,  8192,  4096,     0,     0,  8192,  4096,  8192,  8192,  8192,
      768,  4864,  4864,  8960,   768, 13056, 13056,  8960,  4864,   768,
      768,  8960,  4864,  8960,  8960,  8960,   768,  4864,  4864,  8960,
      768, 13056, 13056,  8960,  4864,   768,   768,  8960,  4864,  8960,
     8960,  8960,     0,  4096,  4096,  8192,     0, 12288, 12288,  8192,
     4096,     0,     0,  8192,  4096,  8192,  8192,  8192,   256,  4352,
     4352,  8448,   256, 12544, 12544,  8448,  4352,   256,   256,  8448,
     4352,  8448,  8448,  8448,     0,  4096,  4096,  8192,     0, 12288,
    12288,  8192,  4096,     0,     0,  8192,  4096,  8192,  8192,  8192,
        0,  4096,  4096,  8192,     0, 12288, 12288,  8192,  4096,     0,
        0,  8192,  4096,  8192,  8192,  8192,   512,  4608,  4608,  8704,
      512, 12800, 12800,  8704,  4608,   512,   512,  8704,  4608,  8704,
     8704,  8704,   256,  4352,  4352,  8448,   256, 12544, 12544,  8448,
     4352,   256,   256,  8448,  4352,  8448,  8448,  8448,   512,  4608,
     4608,  8704,   512, 12800, 12800,  8704,  4608,   512,   512,  8704,
     4608,  8704,  8704,  8704,   512,  4608,  4608,  8704,   512, 12800,
    12800,  8704,  4608,   512,   512,  8704,  4608,  8704,  8704,  8704,
        0,  4096,  4096,  8192,     0, 12288, 12288,  8192,  4096,     0,
        0,  8192,  4096,  8192,  8192,  8192,  4352,  8448,  8448,  8448,
    12544,  8448,  8448,   256,   256,  8448,  8448,  8448,  8448,  8448,
     8448,   256,  4864,  8960,  8960,  8960, 13056,  8960,  8960,   768,
      768,  8960,  8960,  8960,  8960,  8960,  8960,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768,  8960,  8960,  8960,
     8960,  8960,  8960,   768,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4864,  8960,  8960,  8960, 13056,  8960,  8960,   768,   768,  8960,
     8960,  8960,  8960,  8960,  8960,   768,  4352,  8448,  8448,  8448,
    12544,  8448,  8448,   256,   256,  8448,  8448,  8448,  8448,  8448,
     8448,   256,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256,  8448,  8448,  8448,  8448,  8448,  8448,   256,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,  4352,  8448,  8448,  8448, 12544,  8448,
     8448,   256,   256,  8448,  8448,  8448,  8448,  8448,  8448,   256,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768,  8960,  8960,  8960,
     8960,  8960,  8960,   768,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0,  8192,  8192,  8192,  8192,  8192,
     8192,     0,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256,  8448,  8448,  8448,  8448,  8448,  8448,   256,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,  4864,  8960,  8960,  8960,
    13056,  8960,  8960,   768,   768,  8960,  8960,  8960,  8960,  8960,
     8960,   768,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  8960,  8960,
     8960,   768,  8960,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8960,  8960,  8960,   768,  8960,   768,   768,   768,
     8960,  8960,  8960,   768,  8960,   768,   768,   768,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
      768, 13056, 13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   256, 12544, 12544,  8448,  8448, 12544,
    12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256, 12544, 12544,  8448,  8448, 12544, 12544,   256,  4352,  8448,
     8448,  8448, 12544,  8448,  8448,   256,     0, 12288, 12288,  8192,
     8192, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
     4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512, 12800, 12800,  8704,  8704, 12800,
    12800,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
        0, 12288, 12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0, 12288,
    12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12544,  8448,  8448,   256, 12544,   256,
      256,   256,  8448,  8448,  8448,   256,  8448,   256,   256,   256,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8448,  8448,
     8448,   256,  8448,   256,   256,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 13056,  8960,  8960,   768,
    13056,   768,   768,   768,  8960,  8960,  8960,   768,  8960,   768,
      768,   768, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12800,  8704,  8704,   512, 12800,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8960,   768,   768,   768,   768,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8448,   256,   256,   256,
      256,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  4352,   256,
      256,  8448,  4352,  8448,  8448,  8448,   256,   256,   256,  8448,
      256,  8448,  8448,  8448,  4096,     0,     0,  8192,  4096,  8192,
     8192,  8192,     0,     0,     0,  8192,     0,  8192,  8192,  8192,
     4096,     0,     0,  8192,  4096,  8192,  8192,  8192,     0,     0,
        0,  8192,     0,  8192,  8192,  8192,  4608,   512,   512,  8704,
     4608,  8704,  8704,  8704,   512,   512,   512,  8704,   512,  8704,
     8704,  8704,  4352,   256,   256,  8448,  4352,  8448,  8448,  8448,
      256,   256,   256,  8448,   256,  8448,  8448,  8448,  4608,   512,
      512,  8704,  4608,  8704,  8704,  8704,   512,   512,   512,  8704,
      512,  8704,  8704,  8704,  4608,   512,   512,  8704,  4608,  8704,
     8704,  8704,   512,   512,   512,  8704,   512,  8704,  8704,  8704,
     4096,     0,     0,  8192,  4096,  8192,  8192,  8192,     0,     0,
        0,  8192,     0,  8192,  8192,  8192,  4096,     0,     0,  8192,
     4096,  8192,  8192,  8192,     0,     0,     0,  8192,     0,  8192,
     8192,  8192,  4096,     0,     0,  8192,  4096,  8192,  8192,  8192,
        0,     0,     0,  8192,     0,  8192,  8192,  8192,  4096,     0,
        0,  8192,  4096,  8192,  8192,  8192,     0,     0,     0,  8192,
        0,  8192,  8192,  8192,  4608,   512,   512,  8704,  4608,  8704,
     8704,  8704,   512,   512,   512,  8704,   512,  8704,  8704,  8704,
     4096,     0,     0,  8192,  4096,  8192,  8192,  8192,     0,     0,
        0,  8192,     0,  8192,  8192,  8192,  4608,   512,   512,  8704,
     4608,  8704,  8704,  8704,   512,   512,   512,  8704,   512,  8704,
     8704,  8704,  4608,   512,   512,  8704,  4608,  8704,  8704,  8704,
      512,   512,   512,  8704,   512,  8704,  8704,  8704,  4096,     0,
        0,  8192,  4096,  8192,  8192,  8192,     0,     0,     0,  8192,
        0,  8192,  8192,  8192,   256,  8448,  8448,  8448,  8448,  8448,
     8448,   256,   256,  8448,  8448,  8448,  8448,  8448,  8448,   256,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,   768,  8960,
     8960,  8960,  8960,  8960,  8960,   768,   768,  8960,  8960,  8960,
     8960,  8960,  8960,   768,     0,  8192,  8192,  8192,  8192,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,     0,  8192,  8192,  8192,  8192,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,     0,  8192,  8192,  8192,  8192,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256,  8448,  8448,  8448,  8448,  8448,  8448,   256,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4864,  8960,  8960,  8960,
    13056,  8960,  8960,   768,   768,  8960,  8960,  8960,  8960,  8960,
     8960,   768,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0,  8192,  8192,  8192,  8192,  8192,
     8192,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  8960,  8960,
     8960,   768,  8960,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8448,  8448,  8448,   256,  8448,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  4352, 12544, 12544,  8448,
    12544, 12544, 12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,
     8448,   256,  4608, 12800, 12800,  8704, 12800, 12800, 12800,   512,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,  4608, 12800,
    12800,  8704, 12800, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,  4096, 12288, 12288,  8192, 12288, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
     4864, 13056, 13056,  8960, 13056, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,  4096, 12288, 12288,  8192,
    12288, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,  4096, 12288, 12288,  8192, 12288, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,  4096, 12288,
    12288,  8192, 12288, 12288, 12288,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,  4096, 12288, 12288,  8192, 12288, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
     4608, 12800, 12800,  8704, 12800, 12800, 12800,   512,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,  4608, 12800, 12800,  8704,
    12800, 12800, 12800,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,  4096, 12288, 12288,  8192, 12288, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,  4608, 12800,
    12800,  8704, 12800, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,  4096, 12288, 12288,  8192, 12288, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
     4096, 12288, 12288,  8192, 12288, 12288, 12288,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,  4096, 12288, 12288,  8192,
    12288, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0, 13056,  8960,  8960,   768, 13056,   768,   768,   768,
     8960,  8960,  8960,   768,  8960,   768,   768,   768, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12800,  8704,  8704,   512, 12800,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    13056, 13056, 13056,   768, 13056,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12544, 12544, 12544,   256, 12544,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12800, 12800,
    12800,   512, 12800,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,   512,  8704,
     8704,  8704,  8704,  8704,  8704,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0,  8192,  8192,  8192,  8192,  8192,
     8192,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0,     0,
        0, 12288,     0,  8192,  8192,  4096,     0,  4096,  4096,  8192,
        0, 12288, 12288,     0,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,     0,     0,     0, 12288,
        0,  8192,  8192,  4096,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,   512,   512,   512, 12800,   512,  8704,  8704,  4608,
      512,  4608,  4608,  8704,   512, 12800, 12800,   512,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,   256,   256,   256, 12544,   256,  8448,
     8448,  4352,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
        0,     0,     0, 12288,     0,  8192,  8192,  4096,     0,  4096,
     4096,  8192,     0, 12288, 12288,     0,   256,   256,   256, 12544,
      256,  8448,  8448,  4352,   256,  4352,  4352,  8448,   256, 12544,
    12544,   256,   256,   256,   256, 12544,   256,  8448,  8448,  4352,
      256,  4352,  4352,  8448,   256, 12544, 12544,   256,   512,   512,
      512, 12800,   512,  8704,  8704,  4608,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,     0,     0,     0, 12288,     0,  8192,
     8192,  4096,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
      768,   768,   768, 13056,   768,  8960,  8960,  4864,   768,  4864,
     4864,  8960,   768, 13056, 13056,   768,   768,   768,   768, 13056,
      768,  8960,  8960,  4864,   768,  4864,  4864,  8960,   768, 13056,
    13056,   768,     0,     0,     0, 12288,     0,  8192,  8192,  4096,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   256, 12544,
    12544,   256,  8448,  4352,  4352,   256,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256, 12544, 12544,   256,  8448,  4352,
     4352,   256,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256, 12544, 12544,   256,  8448,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   768, 13056, 13056,   768,  8960,  4864,  4864,   768,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,     0, 12288, 12288,     0,
     8192,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,   512, 12800, 12800,   512,  8704,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8960,   768,
      768,   768,   768,   768,   768,   768, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,   768,   768,   768,   768,   768,
      768,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8960,   768,   768,   768,   768,   768,   768,   768,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8960,   768,   768,   768,
      768,   768,   768,   768, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,   512,  8704,  8704,  4608,  8704,   512,   512,  4608,
      512, 12800, 12800,   512,  8704,  4608,  4608,   512,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,   512, 12800, 12800,   512,
     8704,  4608,  4608,   512,   256,  8448,  8448,  4352,  8448,   256,
      256,  4352,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
      512,  8704,  8704,  4608,  8704,   512,   512,  4608,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,     0,  8192,  8192,  4096,  8192,     0,     0,  4096,
        0, 12288, 12288,     0,  8192,  4096,  4096,     0,   256,  8448,
     8448,  4352,  8448,   256,   256,  4352,   256, 12544, 12544,   256,
     8448,  4352,  4352,   256,     0,  8192,  8192,  4096,  8192,     0,
        0,  4096,     0, 12288, 12288,     0,  8192,  4096,  4096,     0,
      768,  8960,  8960,  4864,  8960,   768,   768,  4864,   768, 13056,
    13056,   768,  8960,  4864,  4864,   768,   768,  8960,  8960,  4864,
     8960,   768,   768,  4864,   768, 13056, 13056,   768,  8960,  4864,
     4864,   768,     0,  8192,  8192,  4096,  8192,     0,     0,  4096,
        0, 12288, 12288,     0,  8192,  4096,  4096,     0,   512,  8704,
     8704,  4608,  8704,   512,   512,  4608,   512, 12800, 12800,   512,
     8704,  4608,  4608,   512,   256,  8448,  8448,  4352,  8448,   256,
      256,  4352,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
      256,  8448,  8448,  4352,  8448,   256,   256,  4352,   256, 12544,
    12544,   256,  8448,  4352,  4352,   256,     0,  8192,  8192,  4096,
     8192,     0,     0,  4096,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,  4352,  4352,   256,   256,  4352,  4352,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,  4352,  4352,   256,   256,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,  4352,  4352,   256,
      256,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8704,  4608,
     4608,   512,   512,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8960,  4864,  4864,   768,   768,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8448,  4352,
     4352,   256,   256,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,  4352,  4352,   256,   256,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8192,  4096,  4096,     0,     0,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8960,  4864,  4864,   768,
      768,  4864,  4864,   768, 13056,   768,   768,   768,  4864,   768,
      768,   768,  8704,  4608,  4608,   512,   512,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,  4608,
     4608,   512,   512,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8192,  4096,  4096,     0,     0,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8960,  4864,  4864,   768,   768,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8192,  4096,  4096,     0,
        0,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,  4096,  4096,     0,     0,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,  4096,
     4096,     0,     0,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  4864,   768,   768,   768,  4864,   768,
      768,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4352,   256,
      256,   256,  4352,   256,   256,   256,   256,   256,   256,   256,
      256,   256,   256,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4864,   768,   768,   768,  4864,   768,   768,   768,
      768,   768,   768,   768,   768,   768,   768,   768,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4352,   256,   256,   256,
     4352,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,   256,  4352,  4352,  8448,
      256, 12544, 12544,   256,  4352,   256,   256,  8448,  4352,  8448,
     8448,   256,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   512,  4608,
     4608,  8704,   512, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
      768,  4864,  4864,  8960,   768, 13056, 13056,   768,  4864,   768,
      768,  8960,  4864,  8960,  8960,   768,   768,  4864,  4864,  8960,
      768, 13056, 13056,   768,  4864,   768,   768,  8960,  4864,  8960,
     8960,   768,     0,  4096,  4096,  8192,     0, 12288, 12288,     0,
     4096,     0,     0,  8192,  4096,  8192,  8192,     0,   256,  4352,
     4352,  8448,   256, 12544, 12544,   256,  4352,   256,   256,  8448,
     4352,  8448,  8448,   256,     0,  4096,  4096,  8192,     0, 12288,
    12288,     0,  4096,     0,     0,  8192,  4096,  8192,  8192,     0,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,   512,  4608,  4608,  8704,
      512, 12800, 12800,   512,  4608,   512,   512,  8704,  4608,  8704,
     8704,   512,   256,  4352,  4352,  8448,   256, 12544, 12544,   256,
     4352,   256,   256,  8448,  4352,  8448,  8448,   256,   512,  4608,
     4608,  8704,   512, 12800, 12800,   512,  4608,   512,   512,  8704,
     4608,  8704,  8704,   512,   512,  4608,  4608,  8704,   512, 12800,
    12800,   512,  4608,   512,   512,  8704,  4608,  8704,  8704,   512,
        0,  4096,  4096,  8192,     0, 12288, 12288,     0,  4096,     0,
        0,  8192,  4096,  8192,  8192,     0,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256,  8448,  8448,   256,  8448,   256,
      256,   256,  4864,  8960,  8960,   768, 13056,   768,   768,   768,
      768,  8960,  8960,   768,  8960,   768,   768,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4864,  8960,  8960,   768, 13056,   768,   768,   768,   768,  8960,
     8960,   768,  8960,   768,   768,   768,  4352,  8448,  8448,   256,
    12544,   256,   256,   256,   256,  8448,  8448,   256,  8448,   256,
      256,   256,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256,  8448,  8448,   256,  8448,   256,   256,   256,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,     0,  8192,  8192,     0,
     8192,     0,     0,     0,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,   256,  8448,  8448,   256,  8448,   256,   256,   256,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
        0,  8192,  8192,     0,  8192,     0,     0,     0,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768,  8960,  8960,   768,
     8960,   768,   768,   768,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,     0,  8192,
     8192,     0,  8192,     0,     0,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0,  8192,  8192,     0,  8192,     0,
        0,     0,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256,  8448,  8448,   256,  8448,   256,   256,   256,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4864,  8960,  8960,   768,
    13056,   768,   768,   768,   768,  8960,  8960,   768,  8960,   768,
      768,   768,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,     0,  8192,  8192,     0,  8192,     0,     0,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,     0,  8192,
     8192,     0,  8192,     0,     0,     0,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
      512,  8704,  8704,   512,  8704,   512,   512,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,   512,  8704,  8704,   512,
     8704,   512,   512,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,   512,  8704,  8704,   512,  8704,   512,   512,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,   512,  8704,
     8704,   512,  8704,   512,   512,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512,  8704,  8704,   512,  8704,   512,
      512,   512,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
        0,  8192,  8192,     0,  8192,     0,     0,     0,  8960,   768,
      768,   768,   768,   768,   768,   768,  8960,   768,   768,   768,
      768,   768,   768,   768,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8960,   768,   768,   768,   768,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8704,   512,   512,   512,
      512,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
      768, 13056, 13056,   768,  8960,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,     0, 12288, 12288,     0,  8192,  4096,  4096,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   256, 12544, 12544,   256,  8448,  4352,
     4352,   256,  4352,  8448,  8448,   256, 12544,   256,   256,   256,
      256, 12544, 12544,   256,  8448,  4352,  4352,   256,  4352,  8448,
     8448,   256, 12544,   256,   256,   256,     0, 12288, 12288,     0,
     8192,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,   256, 12544, 12544,   256,  8448,  4352,  4352,   256,
     4352,  8448,  8448,   256, 12544,   256,   256,   256,   512, 12800,
    12800,   512,  8704,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,   512, 12800, 12800,   512,  8704,  4608,
     4608,   512,  4608,  8704,  8704,   512, 12800,   512,   512,   512,
        0, 12288, 12288,     0,  8192,  4096,  4096,     0,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,   768, 13056, 13056,   768,
     8960,  4864,  4864,   768,  4864,  8960,  8960,   768, 13056,   768,
      768,   768,     0, 12288, 12288,     0,  8192,  4096,  4096,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,     0, 12288,
    12288,     0,  8192,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,     0, 12288, 12288,     0,  8192,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8960,   768,
      768,   768,   768,   768,   768,   768, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,   256,   256,   256,   256,   256,   256,   256, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 13056,   768,
      768,   768,  4864,   768,   768,   768,  8960,   768,   768,   768,
      768,   768,   768,   768, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,   256,   256,   256,   256,   256,   256,   256, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 13056,   768,   768,   768,
     4864,   768,   768,   768,  8960,   768,   768,   768,   768,   768,
      768,   768, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8960,   768,
      768,   768,   768,   768,   768,   768, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,   768,   768,   768,   768,   768,   768,   768,   768,
      768,   768,   768,   768,   768,   768,   768,   768,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
      512,   512,   512,   512,   512,   512,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,   768, 13056, 13056,  4864,  8960,  4864,
     4864,  4864,  4864, 13056, 13056,   768, 13056,  4864,  4864,   768,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   256, 12544,
    12544,  4352,  8448,  4352,  4352,  4352,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,   256, 12544, 12544,  4352,  8448,  4352,
     4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,  4352,   256,
        0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,   256, 12544, 12544,  4352,
     8448,  4352,  4352,  4352,  4352, 12544, 12544,   256, 12544,  4352,
     4352,   256,   512, 12800, 12800,  4608,  8704,  4608,  4608,  4608,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,   512, 12800,
    12800,  4608,  8704,  4608,  4608,  4608,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,     0, 12288, 12288,  4096,  8192,  4096,
     4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
      768, 13056, 13056,  4864,  8960,  4864,  4864,  4864,  4864, 13056,
    13056,   768, 13056,  4864,  4864,   768,     0, 12288, 12288,  4096,
     8192,  4096,  4096,  4096,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,     0, 12288, 12288,  4096,  8192,  4096,  4096,  4096,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,     0, 12288,
    12288,  4096,  8192,  4096,  4096,  4096,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256, 12544,   256,
      256,   256,  4352,   256,   256,   256, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 13056,  4864,  4864,   768,  4864,  4864,  4864,   768,
    13056,   768,   768,   768,  4864,   768,   768,   768, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    13056,  4864,  4864,   768,  4864,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768, 12800,  4608,  4608,   512,
     4608,  4608,  4608,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 13056,  4864,  4864,   768,  4864,  4864,
     4864,   768, 13056,   768,   768,   768,  4864,   768,   768,   768,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12800,  4608,
     4608,   512,  4608,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512, 12800,  4608,  4608,   512,  4608,  4608,
     4608,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512, 12800,   512,
      512,   512,  4608,   512,   512,   512, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12800,  4608,  4608,   512,  4608,  4608,  4608,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  4864,   768,   768,   768,
     4864,   768,   768,   768,   768,   768,   768,   768,   768,   768,
      768,   768,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4608,   512,   512,   512,  4608,   512,
      512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  8704,  4608,  4608,  4608,   512,  4608,  4608,  4608,
    12800,  4608,  4608,   512,  4608,  4608,  4608,   512,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8448,  4352,  4352,  4352,   256,  4352,  4352,  4352,
    12544,  4352,  4352,   256,  4352,  4352,  4352,   256,  8448,  4352,
     4352,  4352,   256,  4352,  4352,  4352, 12544,  4352,  4352,   256,
     4352,  4352,  4352,   256,  8192,  4096,  4096,  4096,     0,  4096,
     4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
     8960,  4864,  4864,  4864,   768,  4864,  4864,  4864, 13056,  4864,
     4864,   768,  4864,  4864,  4864,   768,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  8192,  4096,
     4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0,  8448,  4352,  4352,  4352,   256,  4352,
     4352,  4352, 12544,  4352,  4352,   256,  4352,  4352,  4352,   256,
     8192,  4096,  4096,  4096,     0,  4096,  4096,  4096, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0,  8192,  4096,  4096,  4096,
        0,  4096,  4096,  4096, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0,  8192,  4096,  4096,  4096,     0,  4096,  4096,  4096,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4352,  4352,  4352,   256,  4352,  4352,  4352,   256,
     4352,   256,   256,   256,  4352,   256,   256,   256,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4352,  4352,  4352,   256,  4352,  4352,
     4352,   256,  4352,   256,   256,   256,  4352,   256,   256,   256,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4352,  4352,  4352,   256,
     4352,  4352,  4352,   256,  4352,   256,   256,   256,  4352,   256,
      256,   256,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4352,  4352,  4352,   256,  4352,  4352,  4352,   256,  4352,   256,
      256,   256,  4352,   256,   256,   256,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4864,  4864,  4864,   768,  4864,  4864,
     4864,   768,  4864,   768,   768,   768,  4864,   768,   768,   768,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4352,  4352,
     4352,   256,  4352,  4352,  4352,   256,  4352,   256,   256,   256,
     4352,   256,   256,   256,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4608,  4608,  4608,   512,  4608,  4608,  4608,   512,
     4608,   512,   512,   512,  4608,   512,   512,   512,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4096,  4096,  4096,     0,  4096,  4096,  4096,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,  4096,  4096,  4096,     0,
     4096,  4096,  4096,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,  4096,  4096,  4096,     0,  4096,  4096,  4096,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,  4096,  4096,
     4096,     0,  4096,  4096,  4096,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,  4096,  4096,  4096,     0,  4096,  4096,
     4096,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4352, 12544, 12544,   256,
    12544,  4352,  4352,   256,  4352,  8448,  8448,   256, 12544,   256,
      256,   256,  4608, 12800, 12800,   512, 12800,  4608,  4608,   512,
     4608,  8704,  8704,   512, 12800,   512,   512,   512,  4608, 12800,
    12800,   512, 12800,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4864, 13056, 13056,   768, 13056,  4864,  4864,   768,  4864,  8960,
     8960,   768, 13056,   768,   768,   768,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,  4096, 12288,
    12288,     0, 12288,  4096,  4096,     0,  4096,  8192,  8192,     0,
    12288,     0,     0,     0,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4608, 12800, 12800,   512, 12800,  4608,  4608,   512,  4608,  8704,
     8704,   512, 12800,   512,   512,   512,  4608, 12800, 12800,   512,
    12800,  4608,  4608,   512,  4608,  8704,  8704,   512, 12800,   512,
      512,   512,  4096, 12288, 12288,     0, 12288,  4096,  4096,     0,
     4096,  8192,  8192,     0, 12288,     0,     0,     0,  4608, 12800,
    12800,   512, 12800,  4608,  4608,   512,  4608,  8704,  8704,   512,
    12800,   512,   512,   512,  4096, 12288, 12288,     0, 12288,  4096,
     4096,     0,  4096,  8192,  8192,     0, 12288,     0,     0,     0,
     4096, 12288, 12288,     0, 12288,  4096,  4096,     0,  4096,  8192,
     8192,     0, 12288,     0,     0,     0,  4096, 12288, 12288,     0,
    12288,  4096,  4096,     0,  4096,  8192,  8192,     0, 12288,     0,
        0,     0, 13056,   768,   768,   768,  4864,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12800,   512,   512,   512,  4608,   512,
      512,   512,  8704,   512,   512,   512,   512,   512,   512,   512,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12800,   512,   512,   512,
     4608,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,   512,   512,   512,   512,   512,   512,
      512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,   512,   512,   512,   512,   512,   512,   512,   512,
      512,   512,   512,   512,   512,   512,   512,   512,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    13056,  4864,  4864,   768,  4864,  4864,  4864,   768, 13056,   768,
      768,   768,  4864,   768,   768,   768, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12800,  4608,
     4608,   512,  4608,  4608,  4608,   512, 12800,   512,   512,   512,
     4608,   512,   512,   512, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  4352,   256,   256,   256,
     4352,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4608,   512,   512,   512,  4608,   512,   512,   512,
      512,   512,   512,   512,   512,   512,   512,   512,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4608,   512,   512,   512,  4608,   512,   512,   512,   512,   512,
      512,   512,   512,   512,   512,   512,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
      768, 13056, 13056,  8960,  8960, 13056, 13056,   768,  4864,  8960,
     8960,  8960, 13056,  8960,  8960,   768,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   256, 12544, 12544,  8448,  8448, 12544,
    12544,   256,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256, 12544, 12544,  8448,  8448, 12544, 12544,   256,  4352,  8448,
     8448,  8448, 12544,  8448,  8448,   256,     0, 12288, 12288,  8192,
     8192, 12288, 12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,   256, 12544, 12544,  8448,  8448, 12544, 12544,   256,
     4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,   512, 12800,
    12800,  8704,  8704, 12800, 12800,   512,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512, 12800, 12800,  8704,  8704, 12800,
    12800,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
        0, 12288, 12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,   768, 13056, 13056,  8960,
     8960, 13056, 13056,   768,  4864,  8960,  8960,  8960, 13056,  8960,
     8960,   768,     0, 12288, 12288,  8192,  8192, 12288, 12288,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0, 12288,
    12288,  8192,  8192, 12288, 12288,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0, 12288, 12288,  8192,  8192, 12288,
    12288,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12544,  8448,  8448,   256, 12544,   256,
      256,   256,  8448,  8448,  8448,   256,  8448,   256,   256,   256,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8448,  8448,
     8448,   256,  8448,   256,   256,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448,  8448,  8448,   256,  8448,   256,
      256,   256, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 13056,  8960,
     8960,   768, 13056,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 13056,  8960,  8960,   768,
    13056,   768,   768,   768,  8960,  8960,  8960,   768,  8960,   768,
      768,   768, 12800,  8704,  8704,   512, 12800,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    13056,  8960,  8960,   768, 13056,   768,   768,   768,  8960,  8960,
     8960,   768,  8960,   768,   768,   768, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12800,  8704,  8704,   512, 12800,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
    12800,  8704,  8704,   512, 12800,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8960,   768,   768,   768,   768,   768,   768,   768,
     8960,   768,   768,   768,   768,   768,   768,   768,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8448,   256,   256,   256,
      256,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8704, 12800,
    12800,   512,  8704,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8448, 12544,
    12544,   256,  8448,  4352,  4352,   256, 12544,  8448,  8448,   256,
    12544,   256,   256,   256,  8448, 12544, 12544,   256,  8448,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
     8192, 12288, 12288,     0,  8192,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8960, 13056, 13056,   768,
     8960,  4864,  4864,   768, 13056,  8960,  8960,   768, 13056,   768,
      768,   768,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192, 12288, 12288,     0,  8192,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8448, 12544, 12544,   256,  8448,  4352,  4352,   256, 12544,  8448,
     8448,   256, 12544,   256,   256,   256,  8192, 12288, 12288,     0,
     8192,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192, 12288, 12288,     0,  8192,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192, 12288,
    12288,     0,  8192,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12544,   256,
      256,   256,  4352,   256,   256,   256,  8448,   256,   256,   256,
      256,   256,   256,   256, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12544,   256,   256,   256,  4352,   256,   256,   256,
     8448,   256,   256,   256,   256,   256,   256,   256, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    13056,   768,   768,   768,  4864,   768,   768,   768,  8960,   768,
      768,   768,   768,   768,   768,   768, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12544,   256,   256,   256,  4352,   256,
      256,   256,  8448,   256,   256,   256,   256,   256,   256,   256,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12800,   512,
      512,   512,  4608,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4352,  8448,  8448,  8448, 12544,  8448,  8448,   256,
      256,  8448,  8448,  8448,  8448,  8448,  8448,   256,  4608,  8704,
     8704,  8704, 12800,  8704,  8704,   512,   512,  8704,  8704,  8704,
     8704,  8704,  8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4864,  8960,  8960,  8960,
    13056,  8960,  8960,   768,   768,  8960,  8960,  8960,  8960,  8960,
     8960,   768,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,  4096,  8192,  8192,  8192, 12288,  8192,
     8192,     0,     0,  8192,  8192,  8192,  8192,  8192,  8192,     0,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4608,  8704,  8704,  8704,
    12800,  8704,  8704,   512,   512,  8704,  8704,  8704,  8704,  8704,
     8704,   512,  4608,  8704,  8704,  8704, 12800,  8704,  8704,   512,
      512,  8704,  8704,  8704,  8704,  8704,  8704,   512,  4096,  8192,
     8192,  8192, 12288,  8192,  8192,     0,     0,  8192,  8192,  8192,
     8192,  8192,  8192,     0,  4608,  8704,  8704,  8704, 12800,  8704,
     8704,   512,   512,  8704,  8704,  8704,  8704,  8704,  8704,   512,
     4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,     0,  8192,
     8192,  8192,  8192,  8192,  8192,     0,  4096,  8192,  8192,  8192,
    12288,  8192,  8192,     0,     0,  8192,  8192,  8192,  8192,  8192,
     8192,     0,  4096,  8192,  8192,  8192, 12288,  8192,  8192,     0,
        0,  8192,  8192,  8192,  8192,  8192,  8192,     0,  8960,  8960,
     8960,   768,  8960,   768,   768,   768,  8960,  8960,  8960,   768,
     8960,   768,   768,   768,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8448,  8448,  8448,   256,  8448,   256,   256,   256,
     8448,  8448,  8448,   256,  8448,   256,   256,   256,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8704,  8704,  8704,   512,  8704,   512,   512,   512,  8704,  8704,
     8704,   512,  8704,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8704,  8704,  8704,   512,
     8704,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 13056,  8960,  8960,   768,
    13056,   768,   768,   768,  8960,  8960,  8960,   768,  8960,   768,
      768,   768, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12544,  8448,  8448,   256, 12544,   256,   256,   256,  8448,  8448,
     8448,   256,  8448,   256,   256,   256, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12800,  8704,  8704,   512, 12800,   512,
      512,   512,  8704,  8704,  8704,   512,  8704,   512,   512,   512,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0,  8448,   256,   256,   256,   256,   256,   256,   256,
     8448,   256,   256,   256,   256,   256,   256,   256,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8448,   256,   256,   256,
      256,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8704,   512,   512,   512,
      512,   512,   512,   512,  8704,   512,   512,   512,   512,   512,
      512,   512,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    13056, 13056, 13056,   768, 13056,  4864,  4864,   768, 13056,  8960,
     8960,   768, 13056,   768,   768,   768, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12544, 12544, 12544,   256, 12544,  4352,
     4352,   256, 12544,  8448,  8448,   256, 12544,   256,   256,   256,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12800, 12800,
    12800,   512, 12800,  4608,  4608,   512, 12800,  8704,  8704,   512,
    12800,   512,   512,   512, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12288, 12288, 12288,     0,
    12288,  4096,  4096,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0, 12288, 12288, 12288,     0, 12288,  4096,  4096,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0, 12288, 12288,
    12288,     0, 12288,  4096,  4096,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0, 12288, 12288, 12288,     0, 12288,  4096,
     4096,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
    12288, 12288, 12288,     0, 12288,  4096,  4096,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0, 12544,   256,   256,   256,
     4352,   256,   256,   256,  8448,   256,   256,   256,   256,   256,
      256,   256, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12544,   256,   256,   256,  4352,   256,   256,   256,  8448,   256,
      256,   256,   256,   256,   256,   256, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12800,   512,   512,   512,  4608,   512,   512,   512,
     8704,   512,   512,   512,   512,   512,   512,   512, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12800,   512,   512,   512,  4608,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0, 12544,  4352,  4352,   256,  4352,  4352,
     4352,   256, 12544,   256,   256,   256,  4352,   256,   256,   256,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12544,  4352,
     4352,   256,  4352,  4352,  4352,   256, 12544,   256,   256,   256,
     4352,   256,   256,   256, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
    12288,  4096,  4096,     0,  4096,  4096,  4096,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0, 12288,  4096,  4096,     0,
     4096,  4096,  4096,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0, 12288,  4096,  4096,     0,  4096,  4096,  4096,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0, 12288,  4096,
     4096,     0,  4096,  4096,  4096,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0, 12288,  4096,  4096,     0,  4096,  4096,
     4096,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     4352,   256,   256,   256,  4352,   256,   256,   256,   256,   256,
      256,   256,   256,   256,   256,   256,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4352,   256,   256,   256,  4352,   256,
      256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,  4096,     0,     0,     0,  4096,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,  4096,     0,
        0,     0,  4096,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,  4096,     0,     0,     0,  4096,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     4096,     0,     0,     0,  4096,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,  4096,     0,     0,     0,
     4096,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0, 12800,  8704,
     8704,   512, 12800,   512,   512,   512,  8704,  8704,  8704,   512,
     8704,   512,   512,   512, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12800,  8704,  8704,   512,
    12800,   512,   512,   512,  8704,  8704,  8704,   512,  8704,   512,
      512,   512, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0, 12288,  8192,  8192,     0, 12288,     0,
        0,     0,  8192,  8192,  8192,     0,  8192,     0,     0,     0,
    12288,  8192,  8192,     0, 12288,     0,     0,     0,  8192,  8192,
     8192,     0,  8192,     0,     0,     0, 12288,  8192,  8192,     0,
    12288,     0,     0,     0,  8192,  8192,  8192,     0,  8192,     0,
        0,     0, 12288,  8192,  8192,     0, 12288,     0,     0,     0,
     8192,  8192,  8192,     0,  8192,     0,     0,     0, 12288,  8192,
     8192,     0, 12288,     0,     0,     0,  8192,  8192,  8192,     0,
     8192,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8704,   512,   512,   512,   512,   512,   512,   512,  8704,   512,
      512,   512,   512,   512,   512,   512,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8704,   512,
      512,   512,   512,   512,   512,   512,  8704,   512,   512,   512,
      512,   512,   512,   512,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0, 12288,     0,
        0,     0,  4096,     0,     0,     0,  8192,     0,     0,     0,
        0,     0,     0,     0, 12288,     0,     0,     0,  4096,     0,
        0,     0,  8192,     0,     0,     0,     0,     0,     0,     0,
    12288,     0,     0,     0,  4096,     0,     0,     0,  8192,     0,
        0,     0,     0,     0,     0,     0, 12288,     0,     0,     0,
     4096,     0,     0,     0,  8192,     0,     0,     0,     0,     0,
        0,     0, 12288,     0,     0,     0,  4096,     0,     0,     0,
     8192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
        0,     0,     0,     0,     0,     0
};
