/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.jni;

import java.io.File;
import org.eso.cpl.CPLException;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameList;
import org.eso.cpl.Parameter;
import org.eso.cpl.ParameterConstraint;
import org.eso.cpl.ParameterImp;
import org.eso.cpl.ParameterType;
import org.eso.cpl.ParameterValueException;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;
import org.eso.cpl.jni.CPLControl;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.PluginLibrary;

public class JNIRecipe
implements Recipe {
    private final byte[] nativeState_;
    private final PluginLibrary pluglib_;
    private final Parameter[] defaultParams_;
    private String author_;
    private String copyright_;
    private String description_;
    private String email_;
    private String name_;
    private String synopsis_;
    private long version_;
    private boolean isClosed_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JNIRecipe(byte[] nativeState, PluginLibrary pluglib) throws CPLException {
        this.nativeState_ = nativeState;
        this.pluglib_ = pluglib;
        pluglib.register();
        Object object = CPLControl.LOCK;
        synchronized (object) {
            this.initialize();
            Parameter[] nativeParams = this.nativeGetParameterArray();
            int nparam = nativeParams.length;
            this.defaultParams_ = new Parameter[nparam];
            for (int i = 0; i < nparam; ++i) {
                this.defaultParams_[i] = this.copyParameter(nativeParams[i]);
            }
            this.deinitialize();
        }
    }

    public void close() throws LTDLException {
        if (!this.isClosed_) {
            this.pluglib_.deregister();
            this.isClosed_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Parameter[] getDefaultParameters() {
        int nparam = this.defaultParams_.length;
        Parameter[] params = new Parameter[nparam];
        for (int i = 0; i < nparam; ++i) {
            params[i] = this.copyParameter(this.defaultParams_[i]);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameList execute(Parameter[] params, FrameList inFrames, File productRoot) throws CPLException {
        FrameList outFrames;
        int execStatus;
        if (productRoot != null) {
            if (!productRoot.exists() || !productRoot.isDirectory()) {
                throw new CPLException("No such directory " + productRoot);
            }
            if (!productRoot.canWrite()) {
                throw new CPLException("Directory " + productRoot + " is not writable");
            }
        }
        String execDir = productRoot == null ? null : productRoot.getPath();
        String currentDir = System.getProperty("user.dir");
        Object object = CPLControl.LOCK;
        synchronized (object) {
            this.initialize();
            this.nativeSetFrameArray(inFrames.toFrameArray());
            this.copyParameterValues(params, this.nativeGetParameterArray());
            execStatus = this.nativeExecute(currentDir, execDir);
            outFrames = new FrameList(this.nativeGetFrameArray());
            this.deinitialize();
        }
        if (execStatus != 0) {
            throw new CPLException("Execution failed with code " + execStatus);
        }
        FrameList retFrames = new FrameList();
        for (Frame frm : outFrames) {
            if (frm.getGroup() != FrameGroup.PRODUCT) continue;
            retFrames.add(frm);
        }
        if (productRoot != null) {
            for (Frame frm : outFrames) {
                frm.setFile(new File(productRoot, frm.getFile().getPath()));
            }
        }
        return retFrames;
    }

    @Override
    public String getAuthor() {
        return this.author_;
    }

    @Override
    public String getCopyright() {
        return this.copyright_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    @Override
    public String getEmail() {
        return this.email_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getSynopsis() {
        return this.synopsis_;
    }

    @Override
    public long getVersion() {
        return this.version_;
    }

    @Override
    public RecipeLibrary getLibrary() {
        return this.pluglib_;
    }

    public String toString() {
        return new StringBuffer().append(this.getName()).append(" v").append(this.getVersion()).append(": ").append(this.getSynopsis()).toString();
    }

    private void initialize() throws CPLException {
        int status = this.nativeInitialize();
        if (status != 0) {
            throw new CPLException("Initialization of " + this.getThisObjName() + " failed with code " + status);
        }
    }

    private void deinitialize() throws CPLException {
        int status = this.nativeDeinitialize();
        if (status != 0) {
            throw new CPLException("Deinitialization of " + this.getThisObjName() + " failed with code " + status);
        }
    }

    private String getThisObjName() {
        if (this.pluglib_ != null) {
            return this.pluglib_.getName();
        }
        return "?";
    }

    private Parameter copyParameter(Parameter param) {
        final ParameterConstraint constraint = param.getConstraint();
        final String context = param.getContext();
        final String help = param.getHelp();
        final Object initial = param.getDefault();
        final String name = param.getName();
        final String tag = param.getTag();
        final ParameterType type = param.getType();
        try {
            return new Parameter(new ParameterImp(){

                @Override
                public ParameterConstraint getConstraint() {
                    return constraint;
                }

                @Override
                public String getContext() {
                    return context;
                }

                @Override
                public String getHelp() {
                    return help;
                }

                @Override
                public Object getInitialValue() {
                    return initial;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getTag() {
                    return tag;
                }

                @Override
                public ParameterType getType() {
                    return type;
                }

                @Override
                public void setValue(Object value) {
                }
            });
        }
        catch (ParameterValueException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    private void copyParameterValues(Parameter[] src, Parameter[] dest) {
        int nparam = src.length;
        if (nparam != dest.length) {
            throw new IllegalArgumentException("Parameter count mismatch");
        }
        for (int i = 0; i < nparam; ++i) {
            Parameter s = src[i];
            Parameter d2 = dest[i];
            if (!s.getName().equals(d2.getName()) || !s.getType().equals(d2.getType())) {
                throw new IllegalArgumentException("Parameter mismatch" + s + " != " + d2);
            }
            try {
                d2.setValue(s.getValue());
                continue;
            }
            catch (ParameterValueException e2) {
                throw (IllegalArgumentException)new IllegalArgumentException("Constraint mismatch: " + s + ", " + d2 + "?").initCause(e2);
            }
        }
    }

    private synchronized native int nativeInitialize();

    private synchronized native int nativeDeinitialize();

    private synchronized native int nativeExecute(String var1, String var2) throws CPLException;

    private synchronized native Parameter[] nativeGetParameterArray();

    private synchronized native Frame[] nativeGetFrameArray();

    private synchronized native void nativeSetFrameArray(Frame[] var1);

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj != null && obj instanceof Recipe) {
            Recipe rec = (Recipe)obj;
            rc = rec.getName().equals(this.getName()) && rec.getVersion() == this.getVersion();
        }
        return rc;
    }
}

