/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eso.gasgano.datamodel.DataModelChangeListener;
import org.eso.gasgano.datamodel.DataModelChangeNotifier;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.FrameInfo;
import org.eso.gasgano.datamodel.ReductionBlock;
import org.eso.gasgano.datamodel.ReductionBlockCommon;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.gui.DFSTextFileDisplay;
import org.eso.gasgano.datamodel.gui.FitsFileOBComponent;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.properties.PropertyDB;

public class ReductionBlockOBComponent
extends OBComponent
implements DataModelChangeListener,
ReductionBlockCommon {
    private ReductionBlock myFile = null;
    private DataModelChangeNotifier eventSource = null;
    private static JLabel dataLabel = new JLabel(new ImageIcon(ReductionBlockOBComponent.class.getResource("/org/eso/gasgano/gui/icons/data.gif")), 0);

    public ReductionBlockOBComponent(String address) {
        this.myFile = new ReductionBlock(address);
        this.insertInDataModel();
    }

    private void insertInDataModel() {
        Enumeration e2;
        DFSDataModel dm = DFSDataModel.getDataModel();
        String progId = null;
        String obId = null;
        String telescopeId = null;
        DataModelChangeNotifier notifier = null;
        OBComponent dataSource = null;
        Vector dataSourceSet = null;
        if (this.myFile.getStatus() == 2) {
            return;
        }
        if (!dm.passFilter(this)) {
            this.myFile.setStatus(4);
            return;
        }
        dataSourceSet = dm.getObComponentByBaseName(this.myFile.getProductBaseName(), this.myFile.getProductDirectory());
        if (dataSourceSet != null && !dataSourceSet.isEmpty()) {
            e2 = dataSourceSet.elements();
            while (dataSource == null && e2.hasMoreElements()) {
                dataSource = (OBComponent)e2.nextElement();
                if (dataSource == null || dataSource instanceof FitsFileOBComponent) continue;
                dataSource = null;
            }
        }
        if (dataSource == null) {
            progId = "Unknown Program";
            obId = "Unknown Observation";
            telescopeId = "Unknown Telescope";
            notifier = dm;
        } else {
            FrameInfo frameInfo = new FrameInfo();
            dm.provideFrameInfo((KeywordContainerOBComponent)dataSource, frameInfo);
            telescopeId = frameInfo.telescopeId;
            progId = frameInfo.programId;
            obId = frameInfo.obsId;
            notifier = dataSource;
        }
        if (!(this.storeProgram != null && this.storeProgram.equals(progId) && this.storeObservation != null && this.storeObservation.equals(obId) && this.storeTelescope != null && this.storeTelescope.equals(telescopeId))) {
            if (this.eventSource != null) {
                this.storeProgram = null;
                this.storeObservation = null;
                this.removeFromDataModel();
            }
            if (this.getStatus() == 3) {
                String dir = this.myFile.getPath().getParent();
                dm.addObComponent(progId, obId, dir, telescopeId, this);
                this.storeProgram = this.storeProgram == null ? progId : this.storeProgram;
                this.storeObservation = this.storeObservation == null ? obId : this.storeObservation;
                this.storeTelescope = this.storeTelescope == null ? telescopeId : this.storeTelescope;
                this.registerToNotifier(notifier);
            }
        }
        if (this.eventSource != null) {
            OBComponent obc;
            this.addAssociatedReductionBlock(this);
            if (dataSourceSet != null && !dataSourceSet.isEmpty()) {
                e2 = dataSourceSet.elements();
                while (e2.hasMoreElements()) {
                    obc = (OBComponent)e2.nextElement();
                    if (obc == null || !obc.isPipeProduct()) continue;
                    obc.addAssociatedReductionBlock(this);
                }
            }
            if ((dataSourceSet = this.myFile.getInputFileNames()) != null && !dataSourceSet.isEmpty()) {
                e2 = dataSourceSet.elements();
                while (e2.hasMoreElements()) {
                    obc = dm.getObComponentByArcname((String)e2.nextElement());
                    if (obc == null) continue;
                    obc.addAssociatedReductionBlock(this);
                }
            }
            if ((dataSourceSet = this.myFile.getMasterCalibFileNames()) != null && !dataSourceSet.isEmpty()) {
                e2 = dataSourceSet.elements();
                while (e2.hasMoreElements()) {
                    obc = dm.getObComponentByName((String)e2.nextElement());
                    if (obc == null) continue;
                    obc.addAssociatedReductionBlock(this);
                }
            }
        }
    }

    private void removeFileAssociations() {
        OBComponent obc;
        Enumeration e2;
        DFSDataModel dm = DFSDataModel.getDataModel();
        Vector dataSourceSet = dm.getObComponentByBaseName(this.myFile.getProductBaseName(), this.myFile.getProductDirectory());
        if (dataSourceSet != null && !dataSourceSet.isEmpty()) {
            e2 = dataSourceSet.elements();
            while (e2.hasMoreElements()) {
                obc = (OBComponent)e2.nextElement();
                if (obc == null || !obc.isPipeProduct()) continue;
                obc.removeAssociatedReductionBlock(this);
            }
        }
        if ((dataSourceSet = this.myFile.getInputFileNames()) != null && !dataSourceSet.isEmpty()) {
            e2 = dataSourceSet.elements();
            while (e2.hasMoreElements()) {
                obc = dm.getObComponentByName((String)e2.nextElement());
                if (obc == null) continue;
                obc.removeAssociatedReductionBlock(this);
            }
        }
        if ((dataSourceSet = this.myFile.getMasterCalibFileNames()) != null && !dataSourceSet.isEmpty()) {
            e2 = dataSourceSet.elements();
            while (e2.hasMoreElements()) {
                obc = dm.getObComponentByName((String)e2.nextElement());
                if (obc == null) continue;
                obc.removeAssociatedReductionBlock(this);
            }
        }
    }

    @Override
    public Vector getProductFileNames() {
        DFSDataModel dm = DFSDataModel.getDataModel();
        Vector<String> productFileNames = new Vector<String>();
        Vector productOBComponents = dm.getObComponentByBaseName(this.myFile.getProductBaseName(), this.myFile.getProductDirectory());
        if (productOBComponents != null) {
            Enumeration e2 = productOBComponents.elements();
            while (e2.hasMoreElements()) {
                OBComponent obc = (OBComponent)e2.nextElement();
                if (obc == null || !obc.isPipeProduct()) continue;
                productFileNames.addElement(obc.getId());
            }
        }
        return productFileNames;
    }

    @Override
    public Vector getInputFileNames() {
        return this.myFile.getInputFileNames();
    }

    @Override
    public Vector getMasterCalibFileNames() {
        return this.myFile.getMasterCalibFileNames();
    }

    @Override
    public int getStatus() {
        return this.myFile.getStatus();
    }

    private void registerToNotifier(DataModelChangeNotifier n) {
        if (this.eventSource != n) {
            if (this.eventSource != null) {
                this.eventSource.removeDataModelChangeListener(this);
            }
            if (n != null) {
                n.addDataModelChangeListener(this);
            }
            this.eventSource = n;
        }
    }

    @Override
    public int update() {
        if (this.myFile.dataRefreshRequired()) {
            if (this.getStatus() == 3) {
                this.removeFromDataModel();
            }
            this.myFile.readData();
            this.insertInDataModel();
        }
        return this.getStatus();
    }

    @Override
    public DFSFile getSourceFile() {
        return this.myFile;
    }

    @Override
    public void dataModelChanged(DataModelEvent e2) {
        if (e2.getEvent() == 0 || e2.getEvent() == 1 || e2.getEvent() == 2) {
            if (PropertyDB.getInstance().isDebug(6)) {
                System.out.println(this.getId() + " received dataModelChangeEvent.");
            }
            this.insertInDataModel();
        }
    }

    @Override
    public JComponent getDisplayComponent() {
        JComponent rc = null;
        if (this.myFile.readFile() == 1) {
            if (!DFSDataModel.getDataModel().isUpdating()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DFSDataModel.getDataModel().update();
                    }
                }).start();
            }
            rc = new JLabel("The file has been slyly removed from the filesystem", 0);
            return rc;
        }
        rc = new DFSTextFileDisplay(this.toString(), this.myFile.getData());
        this.myFile.freeData();
        return rc;
    }

    @Override
    public JComponent getTreeCellComponent() {
        JLabel cell = dataLabel;
        cell.setText(new String(this.toString()));
        cell.setForeground(Color.gray);
        cell.setFont(this.getLabelFont());
        return cell;
    }

    @Override
    public String getId() {
        return this.myFile.getAddress();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.registerToNotifier(null);
        this.removeFileAssociations();
    }
}

