/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.properties;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eso.oca.properties.OCAPropertiesException;

public class OCAProperties {
    private static Logger logger = Logger.getLogger(OCAProperties.class);
    private static Properties props;
    private static OCAProperties ocaProps;

    private OCAProperties() {
    }

    public void loadProperties(String cfFile) throws OCAPropertiesException {
        logger.debug("Loading properties from " + cfFile);
        this.load(cfFile);
    }

    public static synchronized OCAProperties getInstance() {
        if (ocaProps == null) {
            ocaProps = new OCAProperties();
        }
        return ocaProps;
    }

    private boolean load(String filePath) throws OCAPropertiesException {
        props = new Properties();
        boolean debug = false;
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(filePath);
            props.load(fileStream);
        }
        catch (IOException ioe) {
            logger.debug("Failed to read properties from " + filePath);
            throw new OCAPropertiesException("Failed to read properties from " + filePath);
        }
        return true;
    }

    public String getProperty(String name) throws OCAPropertiesException {
        if (props == null) {
            logger.debug("Properties not initialized. Trying to get property " + name);
            throw new OCAPropertiesException("Properties not initialized");
        }
        String p = props.getProperty(name);
        if (p == null) {
            logger.debug("Failed to get property " + name);
            throw new OCAPropertiesException("Failed to get property " + name);
        }
        return p;
    }
}

