/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.ReplicationRequest;
import org.eso.util.dal.ReplicationRequestDAO;
import org.eso.util.dal.SybaseConnectionService;

public class ReplicationRequestDAOSyb
implements ReplicationRequestDAO {
    static final Logger logger = Logger.getLogger(ReplicationRequestDAOSyb.class);
    private static String FILEID_KW = "file_id";
    private static String FILEVERSION_KW = "file_version";
    private static String DISKID_KW = "disk_id";
    private static String SUBMITTERID_KW = "submitter_id";
    private static String SUBMISSIONTIME_KW = "submission_time";
    private static String PRIORITY_KW = "priority";
    private static String STATUSID_KW = "status_id";
    private static String MESSAGE_KW = "message";
    private static String LASTUPDATETIME_KW = "last_update_time";
    private String d_dbUrl = null;
    private String d_dbUsername = null;
    private String d_dbPassword = null;
    private String d_dbTable = null;
    private Connection d_connection = null;

    public ReplicationRequestDAOSyb(String dbUrl, String dbUsername, String dbPassword, String dbTable) {
        this.d_dbUrl = dbUrl;
        this.d_dbUsername = dbUsername;
        this.d_dbPassword = dbPassword;
        this.d_dbTable = dbTable;
    }

    @Override
    public void delete(ReplicationRequest request) throws DAOException {
        ReplicationRequest.validate(request);
        String query = "delete from " + this.d_dbTable + " where " + FILEID_KW + "='" + request.getFileId() + "'";
        this.executeQuery(query);
    }

    @Override
    public List<ReplicationRequest> findByStatus(ReplicationRequest.Status status) throws DAOException {
        String query = "SELECT * from " + this.d_dbTable + " WHERE " + STATUSID_KW + "= " + status.getCode() + " ORDER BY " + SUBMISSIONTIME_KW + " DESC";
        return this.executeQuery(query);
    }

    @Override
    public void insert(ReplicationRequest request) throws DAOException {
        ReplicationRequest.validate(request);
        String query = "insert into " + this.d_dbTable + " " + ReplicationRequestDAOSyb.formatForInsert(request);
        this.executeQuery(query);
    }

    @Override
    public void update(ReplicationRequest request) throws DAOException {
        ReplicationRequest.validate(request);
        String query = "update " + this.d_dbTable + " " + ReplicationRequestDAOSyb.formatForUpdate(request) + " where " + FILEID_KW + "='" + request.getFileId() + "'";
        this.executeQuery(query);
    }

    public static List<ReplicationRequest> toReplicationRequestList(ResultSet rs) throws DAOException {
        ArrayList<ReplicationRequest> res = new ArrayList<ReplicationRequest>();
        try {
            while (rs.next()) {
                ReplicationRequest rr = new ReplicationRequest();
                rr.setFileId(rs.getString(FILEID_KW));
                rr.setFileVersion(rs.getInt(FILEVERSION_KW));
                rr.setDiskId(rs.getString(DISKID_KW));
                rr.setSubmitterId(rs.getString(SUBMITTERID_KW));
                rr.setSubmissionTime(rs.getDate(SUBMISSIONTIME_KW));
                rr.setPriority(rs.getInt(PRIORITY_KW));
                rr.setStatusId(ReplicationRequest.Status.get(rs.getInt(STATUSID_KW)));
                rr.setLastUpdateTime(rs.getDate(LASTUPDATETIME_KW));
                rr.setMessage(rs.getString(MESSAGE_KW));
                res.add(rr);
            }
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return res;
    }

    private List<ReplicationRequest> executeQuery(String query) throws DAOException {
        try {
            List<ReplicationRequest> res = null;
            if (this.d_connection == null) {
                Connection conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
                res = ReplicationRequestDAOSyb.toReplicationRequestList(SybaseConnectionService.executeStatement(conn, query));
                SybaseConnectionService.closeConnection(conn);
            } else {
                res = ReplicationRequestDAOSyb.toReplicationRequestList(SybaseConnectionService.executeStatement(this.d_connection, query));
            }
            return res;
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (IllegalArgumentException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (Throwable e4) {
            logger.warn("ReplicationRequestDAOSyb::executeQuery - unexpected exception");
            throw new DAOException(e4.getMessage());
        }
    }

    public static String formatForUpdate(ReplicationRequest rr) {
        String res = "";
        if (rr.getFileId() != null) {
            res = res + " set file_id='" + rr.getFileId() + "'";
        }
        if (rr.getFileVersion() != null) {
            res = res + ", file_version=" + rr.getFileVersion();
        }
        if (rr.getDiskId() != null) {
            res = res + ", disk_id ='" + rr.getDiskId() + "'";
        }
        if (rr.getSubmitterId() != null) {
            res = res + ", submitter_id ='" + rr.getSubmitterId() + "'";
        }
        if (rr.getSubmissionTime() != null) {
            res = res + ", submission_time ='" + rr.getSubmissionTime() + "'";
        }
        if (rr.getPriority() != null) {
            res = res + ", priority =" + rr.getPriority();
        }
        if (rr.getStatusId() != null) {
            res = res + ", status_id=" + rr.getStatusId().getCode();
        }
        if (rr.getLastUpdateTime() != null) {
            res = res + ", last_update_time ='" + rr.getLastUpdateTime() + "'";
        }
        if (rr.getMessage() != null) {
            res = res + ", message ='" + rr.getMessage() + "'";
        }
        return res;
    }

    public static String formatForInsert(ReplicationRequest rr) {
        String first = "(";
        String second = "(";
        if (rr.getFileId() != null) {
            first = first + "file_id";
            second = second + "'" + rr.getFileId() + "'";
        }
        if (rr.getFileVersion() != null) {
            first = first + "file_version";
            second = second + rr.getFileVersion();
        }
        if (rr.getDiskId() != null) {
            first = first + "disk_id";
            second = second + "'" + rr.getDiskId() + "'";
        }
        if (rr.getSubmitterId() != null) {
            first = first + ", submitter_id";
            second = second + ", '" + rr.getSubmitterId() + "'";
        }
        if (rr.getSubmissionTime() != null) {
            first = first + ", submission_time";
            second = second + ", '" + rr.getSubmissionTime() + "'";
        }
        if (rr.getPriority() != null) {
            first = first + "priority";
            second = second + rr.getPriority();
        }
        if (rr.getStatusId() != null) {
            first = first + "status_id";
            second = second + rr.getStatusId().getCode();
        }
        if (rr.getLastUpdateTime() != null) {
            first = first + ", last_update_time";
            second = second + ", '" + rr.getLastUpdateTime() + "'";
        }
        if (rr.getMessage() != null) {
            first = first + ", message";
            second = second + ", '" + rr.getMessage() + "'";
        }
        first = first + ")";
        second = second + ")";
        return first + " values " + second;
    }
}

