/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.datatransfer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

public class SybaseConnectionService {
    static final Logger logger = Logger.getLogger(SybaseConnectionService.class);
    private BasicDataSource dataSource;

    public SybaseConnectionService(String serverUrl, String userName, String userPassword) {
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName("com.sybase.jdbc3.jdbc.SybDriver");
        this.dataSource.setUsername(userName);
        this.dataSource.setPassword(userPassword);
        this.dataSource.setUrl("jdbc:sybase:Tds:" + serverUrl);
    }

    public SybaseConnectionService(String databaseAlias) throws Exception {
        throw new Exception("ArchiveService::ArchiveService(String databaseAlias) - to be implemented.");
    }

    public boolean executeQuery(String query) {
        return this.executeQuery(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeQuery(String query, ResultSet[] resultSet) {
        boolean result = false;
        String logHead = "ArchiveService::executeQuery() - ";
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            logger.debug(logHead + "Acquired connection to the database.");
            Statement statement = connection.createStatement();
            if (statement.execute(query) && resultSet != null) {
                resultSet[0] = statement.getResultSet();
            }
            logger.debug(logHead + "Query successfully executed (" + query + ").");
            result = true;
        }
        catch (SQLException e2) {
            logger.error(logHead + "Error while executing query. Reason: " + e2.getMessage());
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                    logger.debug(logHead + "Released connection to the database.");
                }
            }
            catch (Exception e3) {
                logger.error(logHead + "Cannot release connection to the database. Reason: " + e3.getMessage());
            }
        }
        return result;
    }
}

