/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.stream;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eso.util.stream.Message;
import org.eso.util.stream.Module;

public class Stream {
    static final Logger logger = Logger.getLogger(Stream.class);
    private static final String classLogName = "Stream";
    private boolean streamOpen = false;
    private final LinkedList<Module> modules = new LinkedList();

    public Stream() {
        String methodLogName = "Stream::Stream()";
        logger.trace("Stream::Stream()");
    }

    public final synchronized void open() {
        String methodLogName = "Stream::open()";
        logger.trace("Stream::open()");
        logger.debug("Stream::open() - opening stream.");
        Iterator currentModule = this.modules.iterator();
        while (currentModule.hasNext()) {
            ((Module)currentModule.next()).open();
        }
        this.streamOpen = true;
    }

    public final boolean isOpen() {
        String methodLogName = "Stream::isOpen()";
        logger.trace("Stream::isOpen()");
        return this.streamOpen;
    }

    public final synchronized void close() {
        String methodLogName = "Stream::close()";
        logger.trace("Stream::close()");
        logger.debug("Stream::close() - closing stream.");
        Iterator currentModule = this.modules.iterator();
        while (currentModule.hasNext()) {
            ((Module)currentModule.next()).close();
        }
        this.streamOpen = false;
    }

    public final synchronized void restart() {
        String methodLogName = "Stream::restart()";
        logger.trace("Stream::restart()");
        logger.debug("Stream::restart() - restarting stream.");
        this.close();
        this.open();
    }

    public final synchronized void push(Module module) {
        String methodLogName = "Stream::push()";
        logger.trace("Stream::push()");
        if (this.streamOpen) {
            String logMessage = "Stream::push() - stream must not be open when calling this method.";
            logger.fatal("Stream::push() - stream must not be open when calling this method.");
            throw new AssertionError((Object)"Stream::push() - stream must not be open when calling this method.");
        }
        if (!this.modules.isEmpty()) {
            Module oldHead = this.modules.getFirst();
            logger.debug("Stream::push() - connecting new head module upstream of existing head module.");
            module.connectDownstreamModule(oldHead);
            oldHead.connectUpstreamModule(module);
        }
        logger.debug("Stream::push() - pushing new head module into stream.");
        this.modules.addFirst(module);
    }

    public final synchronized Module pop() {
        String methodLogName = "Stream::pop()";
        logger.trace("Stream::pop()");
        if (this.streamOpen) {
            String logMessage = "Stream::pop() - stream must not be open when calling this method.";
            logger.fatal("Stream::pop() - stream must not be open when calling this method.");
            throw new AssertionError((Object)"Stream::pop() - stream must not be open when calling this method.");
        }
        if (!this.modules.isEmpty()) {
            logger.debug("Stream::pop() - popping old head module from stream.");
            Module oldHead = this.modules.removeFirst();
            if (!this.modules.isEmpty()) {
                logger.debug("Stream::pop() - disconnecting old head module from new head module.");
                oldHead.disconnectDownstreamModule();
                this.modules.getFirst().disconnectUpstreamModule();
            }
            return oldHead;
        }
        logger.debug("Stream::pop() - stream empty; no module to pop.");
        return null;
    }

    public void put(Message message) {
        String methodLogName = "Stream::put()";
        logger.trace("Stream::put()");
        this.modules.getFirst().getDownstreamTask().put(message);
        logger.debug("Stream::put() - message sent.");
    }

    public Message get() {
        String methodLogName = "Stream::get()";
        logger.trace("Stream::get()");
        Message message = this.modules.getFirst().getUpstreamTask().get();
        if (message == null) {
            logger.debug("Stream::get() - no message retrieved.");
        } else {
            logger.debug("Stream::get() - message retrieved.");
        }
        return message;
    }

    public Message get(long timeout) {
        String methodLogName = "Stream::get(long)";
        logger.trace("Stream::get(long)");
        Message message = this.modules.getFirst().getUpstreamTask().get(timeout);
        if (message == null) {
            logger.debug("Stream::get(long) - no message retrieved.");
        } else {
            logger.debug("Stream::get(long) - message retrieved.");
        }
        return message;
    }
}

