/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the SetEndEntityStatusRestRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SetEndEntityStatusRestRequest{}

// SetEndEntityStatusRestRequest Use one of allowed values as property(see enum values below). Available TOKEN - USERGENERATED, P12, BCFKS, JKS, PEM;  Available STATUS - NEW, FAILED, INITIALIZED, INPROCESS, GENERATED, REVOKED, HISTORICAL, KEYRECOVERY, WAITINGFORADDAPPROVAL;
type SetEndEntityStatusRestRequest struct {
	// Password
	Password *string `json:"password,omitempty"`
	// Token type property
	Token *string `json:"token,omitempty"`
	// End entity status property
	Status               *string `json:"status,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _SetEndEntityStatusRestRequest SetEndEntityStatusRestRequest

// NewSetEndEntityStatusRestRequest instantiates a new SetEndEntityStatusRestRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSetEndEntityStatusRestRequest() *SetEndEntityStatusRestRequest {
	this := SetEndEntityStatusRestRequest{}
	return &this
}

// NewSetEndEntityStatusRestRequestWithDefaults instantiates a new SetEndEntityStatusRestRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSetEndEntityStatusRestRequestWithDefaults() *SetEndEntityStatusRestRequest {
	this := SetEndEntityStatusRestRequest{}
	return &this
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *SetEndEntityStatusRestRequest) GetPassword() string {
	if o == nil || isNil(o.Password) {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SetEndEntityStatusRestRequest) GetPasswordOk() (*string, bool) {
	if o == nil || isNil(o.Password) {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *SetEndEntityStatusRestRequest) HasPassword() bool {
	if o != nil && !isNil(o.Password) {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *SetEndEntityStatusRestRequest) SetPassword(v string) {
	o.Password = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *SetEndEntityStatusRestRequest) GetToken() string {
	if o == nil || isNil(o.Token) {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SetEndEntityStatusRestRequest) GetTokenOk() (*string, bool) {
	if o == nil || isNil(o.Token) {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *SetEndEntityStatusRestRequest) HasToken() bool {
	if o != nil && !isNil(o.Token) {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *SetEndEntityStatusRestRequest) SetToken(v string) {
	o.Token = &v
}

// GetStatus returns the Status field value if set, zero value otherwise.
func (o *SetEndEntityStatusRestRequest) GetStatus() string {
	if o == nil || isNil(o.Status) {
		var ret string
		return ret
	}
	return *o.Status
}

// GetStatusOk returns a tuple with the Status field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SetEndEntityStatusRestRequest) GetStatusOk() (*string, bool) {
	if o == nil || isNil(o.Status) {
		return nil, false
	}
	return o.Status, true
}

// HasStatus returns a boolean if a field has been set.
func (o *SetEndEntityStatusRestRequest) HasStatus() bool {
	if o != nil && !isNil(o.Status) {
		return true
	}

	return false
}

// SetStatus gets a reference to the given string and assigns it to the Status field.
func (o *SetEndEntityStatusRestRequest) SetStatus(v string) {
	o.Status = &v
}

func (o SetEndEntityStatusRestRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SetEndEntityStatusRestRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.Password) {
		toSerialize["password"] = o.Password
	}
	if !isNil(o.Token) {
		toSerialize["token"] = o.Token
	}
	if !isNil(o.Status) {
		toSerialize["status"] = o.Status
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *SetEndEntityStatusRestRequest) UnmarshalJSON(bytes []byte) (err error) {
	varSetEndEntityStatusRestRequest := _SetEndEntityStatusRestRequest{}

	if err = json.Unmarshal(bytes, &varSetEndEntityStatusRestRequest); err == nil {
		*o = SetEndEntityStatusRestRequest(varSetEndEntityStatusRestRequest)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "password")
		delete(additionalProperties, "token")
		delete(additionalProperties, "status")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableSetEndEntityStatusRestRequest struct {
	value *SetEndEntityStatusRestRequest
	isSet bool
}

func (v NullableSetEndEntityStatusRestRequest) Get() *SetEndEntityStatusRestRequest {
	return v.value
}

func (v *NullableSetEndEntityStatusRestRequest) Set(val *SetEndEntityStatusRestRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableSetEndEntityStatusRestRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableSetEndEntityStatusRestRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSetEndEntityStatusRestRequest(val *SetEndEntityStatusRestRequest) *NullableSetEndEntityStatusRestRequest {
	return &NullableSetEndEntityStatusRestRequest{value: val, isSet: true}
}

func (v NullableSetEndEntityStatusRestRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSetEndEntityStatusRestRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
