// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package nodeattestorv1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// NodeAttestorClient is the client API for NodeAttestor service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NodeAttestorClient interface {
	// AidAttestation facilitates attestation by returning the attestation
	// payload and participating in attestation challenge/response.
	//
	// The attestation flow is as follows:
	// 1. SPIRE Agent opens up a stream to the plugin via FetchAttestationData.
	// 2. The plugin returns a response with the payload.
	// 3. SPIRE Agent sends the payload to SPIRE Server.
	// 4. Optionally, SPIRE Server responds with a challenge:
	//   4a. SPIRE Agent sends the challenge to the plugin.
	//   4b. The plugin responds with the challenge response.
	//   4c. SPIRE Agent sends the challenge response to SPIRE Server.
	//   4d. Step 4 is repeated until SPIRE Server is satisfied and does not
	//       respond with an additional challenge.
	// 5. SPIRE Agent closes the stream.
	//
	// Note that SPIRE Agent does NOT send a request down the stream unless it
	// needs to issue the challenge returned by SPIRE Server (step 4a).
	//
	// Plugins that do not need challenge/response as part of the attestation
	// process may close the stream as soon as they send the attestation
	// payload (step 2).
	AidAttestation(ctx context.Context, opts ...grpc.CallOption) (NodeAttestor_AidAttestationClient, error)
}

type nodeAttestorClient struct {
	cc grpc.ClientConnInterface
}

func NewNodeAttestorClient(cc grpc.ClientConnInterface) NodeAttestorClient {
	return &nodeAttestorClient{cc}
}

func (c *nodeAttestorClient) AidAttestation(ctx context.Context, opts ...grpc.CallOption) (NodeAttestor_AidAttestationClient, error) {
	stream, err := c.cc.NewStream(ctx, &NodeAttestor_ServiceDesc.Streams[0], "/spire.plugin.agent.nodeattestor.v1.NodeAttestor/AidAttestation", opts...)
	if err != nil {
		return nil, err
	}
	x := &nodeAttestorAidAttestationClient{stream}
	return x, nil
}

type NodeAttestor_AidAttestationClient interface {
	Send(*Challenge) error
	Recv() (*PayloadOrChallengeResponse, error)
	grpc.ClientStream
}

type nodeAttestorAidAttestationClient struct {
	grpc.ClientStream
}

func (x *nodeAttestorAidAttestationClient) Send(m *Challenge) error {
	return x.ClientStream.SendMsg(m)
}

func (x *nodeAttestorAidAttestationClient) Recv() (*PayloadOrChallengeResponse, error) {
	m := new(PayloadOrChallengeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// NodeAttestorServer is the server API for NodeAttestor service.
// All implementations must embed UnimplementedNodeAttestorServer
// for forward compatibility
type NodeAttestorServer interface {
	// AidAttestation facilitates attestation by returning the attestation
	// payload and participating in attestation challenge/response.
	//
	// The attestation flow is as follows:
	// 1. SPIRE Agent opens up a stream to the plugin via FetchAttestationData.
	// 2. The plugin returns a response with the payload.
	// 3. SPIRE Agent sends the payload to SPIRE Server.
	// 4. Optionally, SPIRE Server responds with a challenge:
	//   4a. SPIRE Agent sends the challenge to the plugin.
	//   4b. The plugin responds with the challenge response.
	//   4c. SPIRE Agent sends the challenge response to SPIRE Server.
	//   4d. Step 4 is repeated until SPIRE Server is satisfied and does not
	//       respond with an additional challenge.
	// 5. SPIRE Agent closes the stream.
	//
	// Note that SPIRE Agent does NOT send a request down the stream unless it
	// needs to issue the challenge returned by SPIRE Server (step 4a).
	//
	// Plugins that do not need challenge/response as part of the attestation
	// process may close the stream as soon as they send the attestation
	// payload (step 2).
	AidAttestation(NodeAttestor_AidAttestationServer) error
	mustEmbedUnimplementedNodeAttestorServer()
}

// UnimplementedNodeAttestorServer must be embedded to have forward compatible implementations.
type UnimplementedNodeAttestorServer struct {
}

func (UnimplementedNodeAttestorServer) AidAttestation(NodeAttestor_AidAttestationServer) error {
	return status.Errorf(codes.Unimplemented, "method AidAttestation not implemented")
}
func (UnimplementedNodeAttestorServer) mustEmbedUnimplementedNodeAttestorServer() {}

// UnsafeNodeAttestorServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NodeAttestorServer will
// result in compilation errors.
type UnsafeNodeAttestorServer interface {
	mustEmbedUnimplementedNodeAttestorServer()
}

func RegisterNodeAttestorServer(s grpc.ServiceRegistrar, srv NodeAttestorServer) {
	s.RegisterService(&NodeAttestor_ServiceDesc, srv)
}

func _NodeAttestor_AidAttestation_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(NodeAttestorServer).AidAttestation(&nodeAttestorAidAttestationServer{stream})
}

type NodeAttestor_AidAttestationServer interface {
	Send(*PayloadOrChallengeResponse) error
	Recv() (*Challenge, error)
	grpc.ServerStream
}

type nodeAttestorAidAttestationServer struct {
	grpc.ServerStream
}

func (x *nodeAttestorAidAttestationServer) Send(m *PayloadOrChallengeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *nodeAttestorAidAttestationServer) Recv() (*Challenge, error) {
	m := new(Challenge)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// NodeAttestor_ServiceDesc is the grpc.ServiceDesc for NodeAttestor service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NodeAttestor_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "spire.plugin.agent.nodeattestor.v1.NodeAttestor",
	HandlerType: (*NodeAttestorServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "AidAttestation",
			Handler:       _NodeAttestor_AidAttestation_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "spire/plugin/agent/nodeattestor/v1/nodeattestor.proto",
}
