/*-
 * Copyright (c) 2001 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: csparse.h,v 1.6 2004/03/11 09:36:00 vlm Exp $
 */
#ifndef	__CSPARSE_H__
#define	__CSPARSE_H__

int csparse(char *string, char **retArg);

/* Unpriviledged commands */
#define	CS_HELP	0x03	/* help */

/* view-only permissions */
#define	CS_SVER	0x10	/* show version */
#define	CS_STAT	0x11	/* stat */
#define	CS_SIA	0x12	/* show ip accounting */
#define	CS_SIAC	0x13	/* show ip accounting checkpoint */
#define	CS_SICF	0x15	/* show ip cache flow */
#define	CS_SIN	0x14	/* show interface */

/* default permissions */
#define	CS_CIA	0x21	/* clear ip accounting */
#define	CS_CIAC	0x22	/* clear ip accounting checkpoint */

/* backup permissions */
#define	CS_DUMP	0x30	/* dump */
#define	CS_REST	0x31	/* restore */
#define	CS_IMPT	0x32	/* import */

/* admin permissions */
#define	CS_SHUT	0x50	/* shutdown */


#endif	/* __CSPARSE_H__ */
