/********************************************************************

    This file is part of ETSwitch
    Copyright (C) 2004, 2005, 2006  Nicklas Larsson - etswitch@gmail.com - All rights reserved.

    $Id: conf.c,v 1.1 2005/04/14 18:42:18 larsson Exp $

    etswitch - switch to desktop

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

********************************************************************/

#if HAVE_CONFIG_H
# include <config.h>		/* autotool generated ifdef's */
#endif

#include <fcntl.h>		/* locking over nfs */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/ioctl.h>		/* for sending/geting data from special device */
#include <sys/file.h>		/* bsd? */


/* audio */
#include <sys/ioctl.h>		/* +term detect */
#ifdef FREEBSD
#include <machine/soundcard.h>
#endif
#ifdef LINUX
#include <linux/soundcard.h>
#endif

#include <dirent.h>		/* for scandir usage */
#include <libgen.h>		/* dirname / basename */

#include <pwd.h>		/* for getting home/user dir/settings */
#include <sys/types.h>

#include <sys/stat.h>		/* for file info/stat */

#include <X11/X.h>		/* X11 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/xpm.h>		/* xpm */

#include <X11/Xos.h>
#include <X11/Xmu/WinUtil.h>	/* hmm.. revoce this? FIXME */
#include <X11/keysym.h>

/* for gamma and audio constants */
#define GAME 1
#define DESKTOP 0

#include <malloc.h>
#include <linux/limits.h>

#include <signal.h>		/* signal handler */
#include <sys/time.h>
#include <sys/types.h>		/* kill */

#include <sys/resource.h>	/* resources */

#include "etswitch.h" 		/* etswitch */
#include "conf.h" 		/* .h */

#include <errno.h>
extern int errno;

KeySym read_conf(){
    char *home;    
    char *file;
    char *bin;
    int read_n = 16; /* fix me */
    int fp;
    int r;
    size_t max;
    KeySym key;
    struct stat stat_ptr;

    home = (char *)getenv("HOME_ETC");
    if(home == NULL)
	home = (char *)getenv("HOME");
    
    max = strlen((char *)home) + 23;	/* restructure this */
    file = calloc(max, 1);

    snprintf((char *)file, (size_t)max, "%s/.etswitch/etswitch.rc", (char *)home);

    if (!(fp = open((char *)file,O_RDONLY))){
	fprintf(stderr, "fopen read failed: %s, at line: %d\n", strerror(errno),__LINE__);
    }else{
	if(stat((char *)file, &stat_ptr) == 0){
	    read_n = stat_ptr.st_size;		/* size of file */

	    bin = calloc(read_n + 1, 1);	/* just in case */
	    if((char *)bin == NULL)
		fprintf(stderr, "conf malloc failed: %i\n",read_n+1);
		/* abort? */
		
	    r = read(fp, (char *)bin, read_n);
	    if(r == read_n){
		key = XStringToKeysym((char *)bin);
	    }else{
		fprintf(stderr,"Error reading file '%s'.\n", file);
	    }
	    free(bin);

	}else{
	    fprintf(stderr,"Can't read/stat file '%s'\n", (char *)file);
	}
    }
    if(key == NoSymbol){
	critical_info(MESSAGE_PLEASE_CONFIGURE);
	key = XK_F10;		/* default to F10 */
	write_conf("F10");	/* create default .rc file */
    }

    free(file);

    return(key);
}

void write_conf(char *key_string){

    char *file, *dir, *home;
    struct stat dir_stat;	/* test path */

    int fp;
    int result;
    int write_n;

    file = calloc(PATH_MAX+NAME_MAX+1,1);
    dir = calloc(PATH_MAX+1,1);			/* change to malloc the req length only */

    home = (char *)getenv("HOME_ETC");
    if(home == NULL){				/* fixme */
    	home = (char *)getenv("HOME");
    }
    
    if((char *)file == NULL || (char *)dir == NULL){
	fprintf(stderr, "malloc failed: %s, at line: %d\n", strerror(errno),__LINE__);
	exit(EXIT_FAILURE);
    }
    /* change to get pw */
    snprintf((char *)dir, PATH_MAX, "%s/.etswitch", (char *)home);
    snprintf((char *)file, PATH_MAX+NAME_MAX, "%s/etswitch.rc", (char *)dir);
    if (stat((char *)dir, &dir_stat)!=-1){
	if (!S_ISDIR (dir_stat.st_mode)){    /* the name is a directory, and it exists  */
	    fprintf(stderr,"'%s' exists but it's not a directory, can't save config.\n", (char *)dir);
	}
    }else{
	fprintf(stdout,"Creating missing directory, '%s'.\n", (char *)dir);
	mkdir((char *)dir, S_IRWXU);
    }
    if (!(fp = open((char *)file, O_CREAT | O_TRUNC | O_WRONLY, S_IRWXU))){
        fprintf(stderr, "fopen read failed: %s, at line: %d\n", strerror(errno),__LINE__);
    }else{
        write_n = strlen(key_string);
        result = write(fp, key_string, write_n);
        if(result != write_n){
    	    printf("Hmm.. error '%i' writing to conf, make sure the path '%s' exists.\n", result,(char *)file);
	}
	close(fp);
    }
    free(file);
    free(dir);

}

