/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.CategoryFactory;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.RootCategory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Category
implements AppenderAttachable {
    static final int DISABLE_OFF = -1;
    static final int DISABLE_OVERRIDE = -21;
    private static String DEFAULT_FQN = "org.apache.log4j.Category";
    protected static String instanceFQN;
    protected static int disable;
    static boolean emittedNoAppenderWarning;
    static boolean emittedNoResourceBundleWarning;
    public static final Hierarchy defaultHierarchy;
    public static final String DEFAULT_CONFIGURATION_FILE = "log4j.properties";
    public static final String DEFAULT_CONFIGURATION_KEY = "log4j.configuration";
    public static final String DEFAULT_INIT_OVERRIDE_KEY = "log4j.defaultInitOverride";
    protected ResourceBundle resourceBundle;
    protected Hierarchy myContext;
    protected String name;
    protected Priority priority;
    protected Category parent;
    AppenderAttachableImpl aai;
    protected boolean additive = true;
    private static /* synthetic */ Class class$Lorg$apache$log4j$Category;

    public synchronized void addAppender(Appender appender) {
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender(appender);
    }

    public void assert(boolean bl, String string) {
        if (!bl) {
            this.error(string);
        }
    }

    public void callAppenders(LoggingEvent loggingEvent) {
        int n = 0;
        Category category = this;
        while (category != null) {
            Category category2 = category;
            synchronized (category2) {
                if (category.aai != null) {
                    n += category.aai.appendLoopOnAppenders(loggingEvent);
                }
                if (!category.additive) {
                    Object var5_5 = null;
                    break;
                }
            }
            category = category.parent;
        }
        if (!emittedNoAppenderWarning && n == 0) {
            LogLog.error("No appenders could be found for category (" + this.getName() + ").");
            LogLog.error("Please initialize the log4j system properly.");
            emittedNoAppenderWarning = true;
        }
    }

    synchronized void closeNestedAppenders() {
        Enumeration enumeration = this.getAllAppenders();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Appender appender = (Appender)enumeration.nextElement();
                if (!(appender instanceof AppenderAttachable)) continue;
                appender.close();
            }
        }
    }

    public void debug(Object object) {
        if (disable >= 10000) {
            return;
        }
        if (Priority.DEBUG.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(instanceFQN, Priority.DEBUG, object, null);
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (disable >= 10000) {
            return;
        }
        if (Priority.DEBUG.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(instanceFQN, Priority.DEBUG, object, throwable);
        }
    }

    public void error(Object object) {
        if (disable >= 40000) {
            return;
        }
        if (this.isEnabledFor(Priority.ERROR)) {
            this.forcedLog(instanceFQN, Priority.ERROR, object, null);
        }
    }

    public void error(Object object, Throwable throwable) {
        if (disable >= 40000) {
            return;
        }
        if (this.isEnabledFor(Priority.ERROR)) {
            this.forcedLog(instanceFQN, Priority.ERROR, object, throwable);
        }
    }

    public static Category exists(String string) {
        return defaultHierarchy.exists(string);
    }

    public void fatal(Object object) {
        if (disable >= 50000) {
            return;
        }
        if (Priority.FATAL.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(instanceFQN, Priority.FATAL, object, null);
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (disable >= 50000) {
            return;
        }
        if (Priority.FATAL.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(instanceFQN, Priority.FATAL, object, throwable);
        }
    }

    protected void forcedLog(String string, Priority priority, Object object, Throwable throwable) {
        String string2 = object instanceof String ? (String)object : this.myContext.rendererMap.findAndRender(object);
        this.callAppenders(new LoggingEvent(string, this, priority, string2, throwable));
    }

    public boolean getAdditivity() {
        return this.additive;
    }

    public Enumeration getAllAppenders() {
        if (this.aai == null) {
            return NullEnumeration.getInstance();
        }
        return this.aai.getAllAppenders();
    }

    public Appender getAppender(String string) {
        if (this.aai == null || string == null) {
            return null;
        }
        return this.aai.getAppender(string);
    }

    public Priority getChainedPriority() {
        Category category = this;
        while (category != null) {
            if (category.priority != null) {
                return category.priority;
            }
            category = category.parent;
        }
        return null;
    }

    public static Enumeration getCurrentCategories() {
        Vector vector = new Vector(Category.defaultHierarchy.ht.size());
        Enumeration enumeration = Category.defaultHierarchy.ht.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof Category)) continue;
            vector.addElement(v);
        }
        return vector.elements();
    }

    public static Hierarchy getDefaultHierarchy() {
        return defaultHierarchy;
    }

    public static Category getInstance(String string) {
        return defaultHierarchy.getInstance(string);
    }

    public static Category getInstance(Class clazz) {
        return Category.getInstance(clazz.getName());
    }

    public static Category getInstance(String string, CategoryFactory categoryFactory) {
        return defaultHierarchy.getInstance(string, categoryFactory);
    }

    public final String getName() {
        return this.name;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public static final Category getRoot() {
        return defaultHierarchy.getRoot();
    }

    public ResourceBundle getResourceBundle() {
        Category category = this;
        while (category != null) {
            if (category.resourceBundle != null) {
                return category.resourceBundle;
            }
            category = category.parent;
        }
        return null;
    }

    protected String getResourceBundleString(String string) {
        ResourceBundle resourceBundle = this.getResourceBundle();
        if (resourceBundle == null) {
            if (!emittedNoResourceBundleWarning) {
                this.error("No resource bundle has been set for category " + this.name);
                emittedNoResourceBundleWarning = true;
            }
            return null;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            this.error("No resource is associated with key \"" + string + "\".");
            return null;
        }
    }

    public void info(Object object) {
        if (disable >= 20000) {
            return;
        }
        if (Priority.INFO.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(instanceFQN, Priority.INFO, object, null);
        }
    }

    public void info(Object object, Throwable throwable) {
        if (disable >= 20000) {
            return;
        }
        if (Priority.INFO.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(instanceFQN, Priority.INFO, object, throwable);
        }
    }

    public boolean isDebugEnabled() {
        if (disable >= 10000) {
            return false;
        }
        return Priority.DEBUG.isGreaterOrEqual(this.getChainedPriority());
    }

    public boolean isEnabledFor(Priority priority) {
        if (disable >= priority.level) {
            return false;
        }
        return priority.isGreaterOrEqual(this.getChainedPriority());
    }

    public boolean isInfoEnabled() {
        if (disable >= 20000) {
            return false;
        }
        return Priority.INFO.isGreaterOrEqual(this.getChainedPriority());
    }

    public void l7dlog(Priority priority, String string, Throwable throwable) {
        if (disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            String string2 = this.getResourceBundleString(string);
            if (string2 == null) {
                string2 = string;
            }
            this.callAppenders(new LoggingEvent(instanceFQN, this, priority, string2, throwable));
        }
    }

    public void l7dlog(Priority priority, String string, Object[] objectArray, Throwable throwable) {
        if (disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            String string2 = this.getResourceBundleString(string);
            String string3 = string2 == null ? string : MessageFormat.format(string2, objectArray);
            this.callAppenders(new LoggingEvent(instanceFQN, this, priority, string3, throwable));
        }
    }

    public void log(Priority priority, Object object, Throwable throwable) {
        if (disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(instanceFQN, priority, object, throwable);
        }
    }

    public void log(Priority priority, Object object) {
        if (disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(instanceFQN, priority, object, null);
        }
    }

    public void log(String string, Priority priority, Object object, Throwable throwable) {
        if (disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(string, priority, object, throwable);
        }
    }

    public synchronized void removeAllAppenders() {
        if (this.aai != null) {
            this.aai.removeAllAppenders();
            this.aai = null;
        }
    }

    public synchronized void removeAppender(Appender appender) {
        if (appender == null || this.aai == null) {
            return;
        }
        this.aai.removeAppender(appender);
    }

    public synchronized void removeAppender(String string) {
        if (string == null || this.aai == null) {
            return;
        }
        this.aai.removeAppender(string);
    }

    public void setAdditivity(boolean bl) {
        this.additive = bl;
    }

    final void setHierarchy(Hierarchy hierarchy) {
        this.myContext = hierarchy;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public static void shutdown() {
        defaultHierarchy.shutdown();
    }

    public void warn(Object object) {
        if (this.isEnabledFor(Priority.WARN)) {
            this.forcedLog(instanceFQN, Priority.WARN, object, null);
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.isEnabledFor(Priority.WARN)) {
            this.forcedLog(instanceFQN, Priority.WARN, object, throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Category(String string) {
        this.name = string;
        instanceFQN = DEFAULT_FQN;
    }

    static {
        disable = -1;
        emittedNoAppenderWarning = false;
        emittedNoResourceBundleWarning = false;
        defaultHierarchy = new Hierarchy(new RootCategory(Priority.DEBUG));
        String string = null;
        try {
            string = System.getProperty(DEFAULT_INIT_OVERRIDE_KEY, string);
        }
        catch (SecurityException securityException) {
            LogLog.debug("Could not read system property \"log4j.defaultInitOverride\".", securityException);
        }
        if (string == null || "false".equalsIgnoreCase(string)) {
            URL uRL;
            String string2;
            block7: {
                string2 = System.getProperty(DEFAULT_CONFIGURATION_KEY, DEFAULT_CONFIGURATION_FILE);
                uRL = null;
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    ClassLoader classLoader;
                    uRL = (class$Lorg$apache$log4j$Category != null ? class$Lorg$apache$log4j$Category : (class$Lorg$apache$log4j$Category = Category.class$("org.apache.log4j.Category"))).getResource(string2);
                    if (uRL != null || (classLoader = (class$Lorg$apache$log4j$Category != null ? class$Lorg$apache$log4j$Category : (class$Lorg$apache$log4j$Category = Category.class$("org.apache.log4j.Category"))).getClassLoader()) == null) break block7;
                    uRL = classLoader.getResource(string2);
                }
            }
            if (uRL != null) {
                OptionConverter.selectAndConfigure(uRL, defaultHierarchy);
            } else {
                LogLog.debug("Could not find resource: [" + string2 + "].");
            }
        }
    }
}

