/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.profiler.model.ThreadInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J3\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/Stack;", "FrameType", "", "thread", "Lcom/intellij/profiler/model/ThreadInfo;", "frames", "", "value", "", "<init>", "(Lcom/intellij/profiler/model/ThreadInfo;Ljava/util/List;J)V", "getThread", "()Lcom/intellij/profiler/model/ThreadInfo;", "getFrames", "()Ljava/util/List;", "getValue", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.common"})
public final class Stack<FrameType> {
    @NotNull
    private final ThreadInfo thread;
    @NotNull
    private final List<FrameType> frames;
    private final long value;

    public Stack(@NotNull ThreadInfo thread, @NotNull List<? extends FrameType> frames, long value) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        this.thread = thread;
        this.frames = frames;
        this.value = value;
    }

    @NotNull
    public final ThreadInfo getThread() {
        return this.thread;
    }

    @NotNull
    public final List<FrameType> getFrames() {
        return this.frames;
    }

    public final long getValue() {
        return this.value;
    }

    @NotNull
    public final ThreadInfo component1() {
        return this.thread;
    }

    @NotNull
    public final List<FrameType> component2() {
        return this.frames;
    }

    public final long component3() {
        return this.value;
    }

    @NotNull
    public final Stack<FrameType> copy(@NotNull ThreadInfo thread, @NotNull List<? extends FrameType> frames, long value) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        return new Stack<FrameType>(thread, frames, value);
    }

    public static /* synthetic */ Stack copy$default(Stack stack, ThreadInfo threadInfo, List list, long l, int n, Object object) {
        if ((n & 1) != 0) {
            threadInfo = stack.thread;
        }
        if ((n & 2) != 0) {
            list = stack.frames;
        }
        if ((n & 4) != 0) {
            l = stack.value;
        }
        return stack.copy(threadInfo, list, l);
    }

    @NotNull
    public String toString() {
        return "Stack(thread=" + this.thread + ", frames=" + this.frames + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result2 = this.thread.hashCode();
        result2 = result2 * 31 + ((Object)this.frames).hashCode();
        result2 = result2 * 31 + Long.hashCode(this.value);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Stack)) {
            return false;
        }
        Stack stack = (Stack)other;
        if (!Intrinsics.areEqual((Object)this.thread, (Object)stack.thread)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.frames, stack.frames)) {
            return false;
        }
        return this.value == stack.value;
    }
}

