/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.threadview;

import com.intellij.profiler.ui.threadview.ThreadMetric;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0002J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\u000e\u0010\u0015\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u000eH\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadMetricValue;", "T", "", "metric", "Lcom/intellij/profiler/ui/threadview/ThreadMetric;", "data", "<init>", "(Lcom/intellij/profiler/ui/threadview/ThreadMetric;Ljava/lang/Comparable;)V", "getMetric", "()Lcom/intellij/profiler/ui/threadview/ThreadMetric;", "getData", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "representation", "", "getRepresentation", "()Ljava/lang/String;", "compareTo", "", "other", "component1", "component2", "copy", "(Lcom/intellij/profiler/ui/threadview/ThreadMetric;Ljava/lang/Comparable;)Lcom/intellij/profiler/ui/threadview/ThreadMetricValue;", "equals", "", "", "hashCode", "toString", "intellij.profiler.common"})
public final class ThreadMetricValue<T extends Comparable<? super T>>
implements Comparable<ThreadMetricValue<T>> {
    @NotNull
    private final ThreadMetric<T> metric;
    @NotNull
    private final T data;
    @NotNull
    private final String representation;

    public ThreadMetricValue(@NotNull ThreadMetric<T> metric, @NotNull T data) {
        Intrinsics.checkNotNullParameter(metric, (String)"metric");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.metric = metric;
        this.data = data;
        this.representation = this.metric.represent(this.data);
    }

    @NotNull
    public final ThreadMetric<T> getMetric() {
        return this.metric;
    }

    @NotNull
    public final T getData() {
        return this.data;
    }

    @NotNull
    public final String getRepresentation() {
        return this.representation;
    }

    @Override
    public int compareTo(@NotNull ThreadMetricValue<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (this.metric != other.metric) {
            throw new IllegalStateException("Comparison of different metrics: " + this.metric + ", " + other.metric);
        }
        return this.metric.getComparator().compare(this.data, other.data);
    }

    @NotNull
    public final ThreadMetric<T> component1() {
        return this.metric;
    }

    @NotNull
    public final T component2() {
        return this.data;
    }

    @NotNull
    public final ThreadMetricValue<T> copy(@NotNull ThreadMetric<T> metric, @NotNull T data) {
        Intrinsics.checkNotNullParameter(metric, (String)"metric");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return new ThreadMetricValue<T>(metric, data);
    }

    public static /* synthetic */ ThreadMetricValue copy$default(ThreadMetricValue threadMetricValue, ThreadMetric threadMetric, Comparable comparable, int n, Object object) {
        if ((n & 1) != 0) {
            threadMetric = threadMetricValue.metric;
        }
        if ((n & 2) != 0) {
            comparable = threadMetricValue.data;
        }
        return threadMetricValue.copy(threadMetric, comparable);
    }

    @NotNull
    public String toString() {
        return "ThreadMetricValue(metric=" + this.metric + ", data=" + this.data + ")";
    }

    public int hashCode() {
        int result2 = this.metric.hashCode();
        result2 = result2 * 31 + this.data.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThreadMetricValue)) {
            return false;
        }
        ThreadMetricValue threadMetricValue = (ThreadMetricValue)other;
        if (!Intrinsics.areEqual(this.metric, threadMetricValue.metric)) {
            return false;
        }
        return Intrinsics.areEqual(this.data, threadMetricValue.data);
    }
}

