/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.github;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditorKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.NotebookLanguageDetector;
import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.DefaultGithubGistContentsCollector;
import org.jetbrains.plugins.github.api.data.request.GithubGistRequest;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0014J\u0013\u0010\u0010\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0011*\u00020\u0007H\u0002J\u0012\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\nH\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/github/JupyterGithubGistContentsCollector;", "Lorg/jetbrains/plugins/github/DefaultGithubGistContentsCollector;", "<init>", "()V", "getGistFileName", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "getContentFromEditor", "", "Lorg/jetbrains/plugins/github/api/data/request/GithubGistRequest$FileContent;", "file", "toJupyter", "Lorg/jetbrains/annotations/NotNull;", "createFileNameForSelection", "notebookFile", "getFileContentInternal", "intellij.jupyter.github"})
@SourceDebugExtension(value={"SMAP\nJupyterGithubGistContentsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterGithubGistContentsCollector.kt\ncom/intellij/jupyter/github/JupyterGithubGistContentsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
final class JupyterGithubGistContentsCollector
extends DefaultGithubGistContentsCollector {
    @Nullable
    public String getGistFileName(@Nullable Editor editor, @Nullable VirtualFile[] files) {
        Editor editor2 = editor;
        if (editor2 == null || (editor2 = this.toJupyter(editor2)) == null) {
            return null;
        }
        Editor jupyterEditor = editor2;
        VirtualFile[] virtualFileArray = files;
        if (virtualFileArray == null || (virtualFileArray = (VirtualFile[])ArraysKt.singleOrNull((Object[])virtualFileArray)) == null) {
            return null;
        }
        VirtualFile[] onlyFile = virtualFileArray;
        if (this.getSelectedText(jupyterEditor) == null) {
            return null;
        }
        return this.createFileNameForSelection((VirtualFile)onlyFile);
    }

    @Nullable
    protected List<GithubGistRequest.FileContent> getContentFromEditor(@NotNull Editor editor, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Editor editor2 = this.toJupyter(editor);
        if (editor2 == null) {
            return super.getContentFromEditor(editor, file);
        }
        Editor jupyterEditor = editor2;
        String string = this.getSelectedText(jupyterEditor);
        if (string == null) {
            return null;
        }
        String selectedText = string;
        String string2 = FileDocumentManager.getInstance().getLineSeparator(file, editor.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLineSeparator(...)");
        String lineSeparator = string2;
        Regex cellSeparatorRegex = new Regex("^#%%[^\\n\\r]*((" + lineSeparator + ")?)", RegexOption.MULTILINE);
        String cleanText = cellSeparatorRegex.replace((CharSequence)selectedText, JupyterGithubGistContentsCollector::getContentFromEditor$lambda$0);
        if (StringsKt.isBlank((CharSequence)cleanText)) {
            return null;
        }
        String fileNameWithExtension = this.createFileNameForSelection(file);
        return CollectionsKt.listOf((Object)new GithubGistRequest.FileContent(fileNameWithExtension, cleanText));
    }

    private final Editor toJupyter(Editor $this$toJupyter) {
        EditorWindow editorWindow;
        EditorWindow editorWindow2 = $this$toJupyter instanceof EditorWindow ? (EditorWindow)$this$toJupyter : null;
        if (editorWindow2 == null || (editorWindow2 = editorWindow2.getDelegate()) == null) {
            editorWindow2 = $this$toJupyter;
        }
        EditorWindow it = editorWindow = editorWindow2;
        boolean bl = false;
        return JupyterFileEditorKt.isJupyter((Editor)it) ? editorWindow : null;
    }

    private final String createFileNameForSelection(VirtualFile notebookFile) {
        Object object;
        String fileName;
        Language notebookLanguage = NotebookLanguageDetector.INSTANCE.detectLanguage(notebookFile);
        VirtualFile virtualFile = notebookFile;
        String string = virtualFile != null ? virtualFile.getNameWithoutExtension() : null;
        if (string == null) {
            string = fileName = "";
        }
        if ((object = notebookLanguage) == null || (object = object.getAssociatedFileType()) == null || (object = object.getDefaultExtension()) == null) {
            String string2 = PlainTextFileType.INSTANCE.getDefaultExtension();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefaultExtension(...)");
        }
        Object extension = object;
        String fileNameWithExtension = fileName + "." + (String)extension;
        return fileNameWithExtension;
    }

    @Nullable
    protected String getFileContentInternal(@NotNull VirtualFile file) {
        VirtualFileWindow topLevelFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFileWindow virtualFileWindow = file instanceof VirtualFileWindow ? (VirtualFileWindow)file : null;
        if (virtualFileWindow == null || (virtualFileWindow = virtualFileWindow.getDelegate()) == null) {
            virtualFileWindow = file;
        }
        if (Intrinsics.areEqual((Object)(topLevelFile = virtualFileWindow).getFileType(), (Object)JupyterFileType.INSTANCE)) {
            return JupyterFileExtensionsKt.getNotebookJsonText((VirtualFile)topLevelFile);
        }
        return super.getFileContentInternal(file);
    }

    private static final CharSequence getContentFromEditor$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)it.getGroupValues().get(1);
    }
}

