/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.intellij.docker.agent.util.PlatformKt;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/agent/util/Platform;", "", "<init>", "()V", "OS_NAME", "", "OS_VERSION", "OS_ARCH", "_OS_NAME", "arch", "Lcom/intellij/docker/agent/util/Platform$Arch;", "getArch", "()Lcom/intellij/docker/agent/util/Platform$Arch;", "isWindows", "", "()Z", "isMac", "isLinux", "isFreeBSD", "isUnix", "isOsVersionAtLeast", "version", "Arch", "intellij.clouds.docker.agent"})
public final class Platform {
    @NotNull
    public static final Platform INSTANCE = new Platform();
    @NotNull
    private static final String OS_NAME;
    @NotNull
    private static final String OS_VERSION;
    @NotNull
    private static final String OS_ARCH;
    @NotNull
    private static final String _OS_NAME;
    @Nullable
    private static final Arch arch;
    private static final boolean isWindows;
    private static final boolean isMac;
    private static final boolean isLinux;
    private static final boolean isFreeBSD;
    private static final boolean isUnix;

    private Platform() {
    }

    @Nullable
    public final Arch getArch() {
        return arch;
    }

    public final boolean isWindows() {
        return isWindows;
    }

    public final boolean isMac() {
        return isMac;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    public final boolean isFreeBSD() {
        return isFreeBSD;
    }

    public final boolean isUnix() {
        return isUnix;
    }

    public final boolean isOsVersionAtLeast(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return PlatformKt.access$compareVersionNumbers(OS_VERSION, version2) >= 0;
    }

    static {
        String name2 = null;
        name2 = System.getProperty("os.name");
        Object version2 = null;
        String string = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        version2 = string2;
        String string3 = name2;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"element");
        if (StringsKt.startsWith$default((String)string3, (String)"Windows", (boolean)false, (int)2, null)) {
            String string4 = name2;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"element");
            Object object = string4;
            if (new Regex("Windows \\d+").matches((CharSequence)object)) {
                object = INSTANCE;
                try {
                    Object $this$_init__u24lambda_u240 = object;
                    boolean bl = false;
                    String string5 = name2;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"element");
                    String string6 = string5;
                    int n = 8;
                    String string7 = string6.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                    String version22 = string7 + ".0";
                    if (Float.parseFloat(version22) > Float.parseFloat((String)version2)) {
                        version2 = version22;
                    }
                    Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                name2 = "Windows";
            }
        }
        OS_ARCH = System.getProperty("os.arch");
        OS_NAME = name2;
        OS_VERSION = version2;
        String string8 = OS_NAME.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        _OS_NAME = string8;
        arch = Arch.Companion.fromName(OS_ARCH);
        isWindows = StringsKt.startsWith$default((String)_OS_NAME, (String)"windows", (boolean)false, (int)2, null);
        isMac = StringsKt.startsWith$default((String)_OS_NAME, (String)"mac", (boolean)false, (int)2, null);
        isLinux = StringsKt.startsWith$default((String)_OS_NAME, (String)"linux", (boolean)false, (int)2, null);
        isFreeBSD = StringsKt.startsWith$default((String)_OS_NAME, (String)"freebsd", (boolean)false, (int)2, null);
        isUnix = !isWindows;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001d\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001,B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0003J\u0019\u0010'\u001a\u0004\u0018\u00010\u00032\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b)J\u0014\u0010*\u001a\u0004\u0018\u00010\u00032\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0014J\b\u0010+\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006-"}, d2={"Lcom/intellij/docker/agent/util/Platform$Arch;", "", "realName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getRealName", "()Ljava/lang/String;", "i386", "X86_64", "ARM64", "ARM", "AMD64P32", "ARM_BE", "ARM64_BE", "PPC64", "PPC64LE", "LOONG64", "MIPS", "MIPS_LE", "MIPS64", "MIPS64_LE", "MIPS64P32", "MIPS64P32_LE", "PPC", "RISCV", "RISCV64", "S390", "S390X", "SPARC", "SPARC64", "WASM", "nameVariants", "", "getNameVariants", "()Ljava/util/Set;", "is", "", "value", "normalizeVariant", "variant", "normalizeVariant$intellij_clouds_docker_agent", "doNormalizeVariant", "toString", "Companion", "intellij.clouds.docker.agent"})
    public static final class Arch
    extends Enum<Arch> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String realName;
        @NotNull
        private final Set<String> nameVariants;
        public static final /* enum */ Arch i386;
        public static final /* enum */ Arch X86_64;
        public static final /* enum */ Arch ARM64;
        public static final /* enum */ Arch ARM;
        public static final /* enum */ Arch AMD64P32;
        public static final /* enum */ Arch ARM_BE;
        public static final /* enum */ Arch ARM64_BE;
        public static final /* enum */ Arch PPC64;
        public static final /* enum */ Arch PPC64LE;
        public static final /* enum */ Arch LOONG64;
        public static final /* enum */ Arch MIPS;
        public static final /* enum */ Arch MIPS_LE;
        public static final /* enum */ Arch MIPS64;
        public static final /* enum */ Arch MIPS64_LE;
        public static final /* enum */ Arch MIPS64P32;
        public static final /* enum */ Arch MIPS64P32_LE;
        public static final /* enum */ Arch PPC;
        public static final /* enum */ Arch RISCV;
        public static final /* enum */ Arch RISCV64;
        public static final /* enum */ Arch S390;
        public static final /* enum */ Arch S390X;
        public static final /* enum */ Arch SPARC;
        public static final /* enum */ Arch SPARC64;
        public static final /* enum */ Arch WASM;
        private static final /* synthetic */ Arch[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Arch(String realName) {
            this.realName = realName;
            this.nameVariants = SetsKt.emptySet();
        }

        @NotNull
        public final String getRealName() {
            return this.realName;
        }

        @NotNull
        protected Set<String> getNameVariants() {
            return this.nameVariants;
        }

        public final boolean is(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Set set = SetsKt.plus(this.getNameVariants(), (Object)this.realName);
            String string = value.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return set.contains(string);
        }

        @Nullable
        public final String normalizeVariant$intellij_clouds_docker_agent(@Nullable String variant) {
            String string;
            String string2 = variant;
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            return this.doNormalizeVariant(string);
        }

        @Nullable
        protected String doNormalizeVariant(@Nullable String variant) {
            return variant;
        }

        @NotNull
        public String toString() {
            return this.realName;
        }

        public static Arch[] values() {
            return (Arch[])$VALUES.clone();
        }

        public static Arch valueOf(String value) {
            return Enum.valueOf(Arch.class, value);
        }

        @NotNull
        public static EnumEntries<Arch> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Arch(String $enum$name, int $enum$ordinal, String realName, DefaultConstructorMarker $constructor_marker) {
            this(realName);
        }

        static {
            i386 = new i386("i386", 0);
            X86_64 = new X86_64("X86_64", 1);
            ARM64 = new ARM64("ARM64", 2);
            ARM = new ARM("ARM", 3);
            AMD64P32 = new Arch("amd64p32");
            ARM_BE = new Arch("armbe");
            ARM64_BE = new Arch("arm64be");
            PPC64 = new Arch("ppc64");
            PPC64LE = new Arch("ppc64le");
            LOONG64 = new Arch("loong64");
            MIPS = new Arch("mips");
            MIPS_LE = new Arch("mipsle");
            MIPS64 = new Arch("mips64");
            MIPS64_LE = new Arch("mips64le");
            MIPS64P32 = new Arch("mips64p32");
            MIPS64P32_LE = new Arch("mips64p32le");
            PPC = new Arch("ppc");
            RISCV = new Arch("riscv");
            RISCV64 = new Arch("riscv64");
            S390 = new Arch("s390");
            S390X = new Arch("s390x");
            SPARC = new Arch("sparc");
            SPARC64 = new Arch("sparc64");
            WASM = new Arch("wasm");
            $VALUES = archArray = new Arch[]{Arch.i386, Arch.X86_64, Arch.ARM64, Arch.ARM, Arch.AMD64P32, Arch.ARM_BE, Arch.ARM64_BE, Arch.PPC64, Arch.PPC64LE, Arch.LOONG64, Arch.MIPS, Arch.MIPS_LE, Arch.MIPS64, Arch.MIPS64_LE, Arch.MIPS64P32, Arch.MIPS64P32_LE, Arch.PPC, Arch.RISCV, Arch.RISCV64, Arch.S390, Arch.S390X, Arch.SPARC, Arch.SPARC64, Arch.WASM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0014\u00a8\u0006\u0005"}, d2={"com/intellij/docker/agent/util/Platform.Arch.ARM", "Lcom/intellij/docker/agent/util/Platform$Arch;", "doNormalizeVariant", "", "variant", "intellij.clouds.docker.agent"})
        static final class ARM
        extends Arch {
            /*
             * WARNING - void declaration
             */
            ARM() {
                void var1_1;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @Nullable
            protected String doNormalizeVariant(@Nullable String variant) {
                Object object;
                String string = variant;
                if (string != null) {
                    int n = -1;
                    switch (string.hashCode()) {
                        case 0: {
                            if (!string.equals("")) break;
                            n = 1;
                            break;
                        }
                        case 53: {
                            if (!string.equals("5")) break;
                            n = 2;
                            break;
                        }
                        case 54: {
                            if (!string.equals("6")) break;
                            n = 2;
                            break;
                        }
                        case 55: {
                            if (!string.equals("7")) break;
                            n = 1;
                            break;
                        }
                        case 56: {
                            if (!string.equals("8")) break;
                            n = 2;
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            return "v7";
                        }
                        case 2: {
                            object = "v" + variant;
                            return object;
                        }
                    }
                }
                object = variant;
                return object;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0014R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"com/intellij/docker/agent/util/Platform.Arch.ARM64", "Lcom/intellij/docker/agent/util/Platform$Arch;", "nameVariants", "", "", "getNameVariants", "()Ljava/util/Set;", "doNormalizeVariant", "variant", "intellij.clouds.docker.agent"})
        static final class ARM64
        extends Arch {
            @NotNull
            private final Set<String> nameVariants = SetsKt.setOf((Object)"aarch64");

            /*
             * WARNING - void declaration
             */
            ARM64() {
                void var1_1;
            }

            @Override
            @NotNull
            protected Set<String> getNameVariants() {
                return this.nameVariants;
            }

            @Override
            @Nullable
            protected String doNormalizeVariant(@Nullable String variant) {
                Object[] objectArray = new String[]{"8", "v8"};
                return CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)variant) ? null : variant;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/util/Platform$Arch$Companion;", "", "<init>", "()V", "isKnown", "", "arch", "", "fromName", "Lcom/intellij/docker/agent/util/Platform$Arch;", "name", "intellij.clouds.docker.agent"})
        @SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\ncom/intellij/docker/agent/util/Platform$Arch$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isKnown(@NotNull String arch) {
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                return this.fromName(arch) != null;
            }

            @Nullable
            public final Arch fromName(@NotNull String name2) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Iterable iterable = (Iterable)Arch.getEntries();
                    for (Object t : iterable) {
                        Arch it = (Arch)((Object)t);
                        boolean bl = false;
                        if (!it.is(name2)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0014R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"com/intellij/docker/agent/util/Platform.Arch.X86_64", "Lcom/intellij/docker/agent/util/Platform$Arch;", "nameVariants", "", "", "getNameVariants", "()Ljava/util/Set;", "doNormalizeVariant", "variant", "intellij.clouds.docker.agent"})
        static final class X86_64
        extends Arch {
            @NotNull
            private final Set<String> nameVariants;

            /*
             * WARNING - void declaration
             */
            X86_64() {
                void var1_1;
                Object[] objectArray = new String[]{"x86_64", "x86-64"};
                this.nameVariants = SetsKt.setOf((Object[])objectArray);
            }

            @Override
            @NotNull
            protected Set<String> getNameVariants() {
                return this.nameVariants;
            }

            @Override
            @Nullable
            protected String doNormalizeVariant(@Nullable String variant) {
                return Intrinsics.areEqual((Object)variant, (Object)"v1") ? null : variant;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0014R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"com/intellij/docker/agent/util/Platform.Arch.i386", "Lcom/intellij/docker/agent/util/Platform$Arch;", "nameVariants", "", "", "getNameVariants", "()Ljava/util/Set;", "doNormalizeVariant", "variant", "intellij.clouds.docker.agent"})
        static final class i386
        extends Arch {
            @NotNull
            private final Set<String> nameVariants = SetsKt.setOf((Object)"i386");

            /*
             * WARNING - void declaration
             */
            i386() {
                void var1_1;
            }

            @Override
            @NotNull
            protected Set<String> getNameVariants() {
                return this.nameVariants;
            }

            @Override
            @Nullable
            protected String doNormalizeVariant(@Nullable String variant) {
                return null;
            }
        }
    }
}

