/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRegistryManagerState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@State(name="DockerRegistry", storages={@Storage(value="docker-registry.xml")}, category=SettingsCategory.TOOLS)
public class DockerRegistryManager
implements PersistentStateComponent<DockerRegistryManagerState> {
    private final List<DockerRegistryConfiguration> myRegistries = new ArrayList<DockerRegistryConfiguration>();

    public static DockerRegistryManager getInstance() {
        return (DockerRegistryManager)ApplicationManager.getApplication().getService(DockerRegistryManager.class);
    }

    public @Unmodifiable List<DockerRegistryConfiguration> getRegistries() {
        return List.copyOf(this.myRegistries);
    }

    @Nls
    public static String generateUniqueRegistryName() {
        @Nls String defaultName = DockerBundle.message("RegistrySelectionEditor.default.name.docker.registry", new Object[0]);
        return UniqueNameGenerator.generateUniqueName((String)defaultName, s -> {
            for (DockerRegistryConfiguration server : DockerRegistryManager.getInstance().getRegistries()) {
                if (!server.getName().equals(s)) continue;
                return false;
            }
            return true;
        });
    }

    @Nullable
    public DockerRegistryManagerState getState() {
        DockerRegistryManagerState state = new DockerRegistryManagerState();
        state.myRegistries.addAll(this.myRegistries);
        return state;
    }

    public void loadState(@NotNull DockerRegistryManagerState state) {
        if (state == null) {
            DockerRegistryManager.$$$reportNull$$$0(0);
        }
        this.myRegistries.clear();
        for (DockerRegistryConfiguration next : state.myRegistries) {
            next.migrateToPasswordSafe();
            this.myRegistries.add(next);
        }
    }

    public void addRegistry(@NotNull DockerRegistryConfiguration registry) {
        if (registry == null) {
            DockerRegistryManager.$$$reportNull$$$0(1);
        }
        this.myRegistries.add(registry);
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(Listener.TOPIC)).registryAdded(registry);
    }

    public void removeRegistry(@NotNull DockerRegistryConfiguration registry) {
        if (registry == null) {
            DockerRegistryManager.$$$reportNull$$$0(2);
        }
        this.myRegistries.remove((Object)registry);
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(Listener.TOPIC)).registryRemoved(registry);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/registry/DockerRegistryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addRegistry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeRegistry";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public static final Topic<Listener> TOPIC = Topic.create((String)"DockerRegistryManager.topic", Listener.class);

        public void registryAdded(@NotNull DockerRegistryConfiguration var1);

        public void registryRemoved(@NotNull DockerRegistryConfiguration var1);
    }
}

