/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.time.interval;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/commons/time/interval/NiceTimeInterval;", "", "()V", "AUTO_INTERVALS", "", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "[Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "AUTO_STEPS_MS", "", "forMillis", "interval", "", "plot-base"})
public final class NiceTimeInterval {
    @NotNull
    public static final NiceTimeInterval INSTANCE = new NiceTimeInterval();
    @NotNull
    private static final double[] AUTO_STEPS_MS;
    @NotNull
    private static final TimeInterval[] AUTO_INTERVALS;

    private NiceTimeInterval() {
    }

    @NotNull
    public final TimeInterval forMillis(double interval) {
        if (interval <= AUTO_STEPS_MS[0]) {
            return AUTO_INTERVALS[0];
        }
        TimeInterval result2 = AUTO_INTERVALS[AUTO_STEPS_MS.length - 1];
        int n = AUTO_STEPS_MS.length;
        for (int i = 1; i < n; ++i) {
            if (!(AUTO_STEPS_MS[i] >= interval)) continue;
            double deltaDown = interval - AUTO_STEPS_MS[i - 1];
            double deltaUp = AUTO_STEPS_MS[i] - interval;
            if (deltaDown < deltaUp) {
                result2 = AUTO_INTERVALS[i - 1];
                break;
            }
            result2 = AUTO_INTERVALS[i];
            break;
        }
        return result2;
    }

    static {
        Object[] objectArray = new double[]{1000.0, 5000.0, 15000.0, 30000.0, 60000.0, 300000.0, 900000.0, 1800000.0, 3600000.0, 1.08E7, 2.16E7, 4.32E7, 8.64E7, 1.728E8, 6.048E8, 2.592E9, 7.776E9, 3.1536E10};
        AUTO_STEPS_MS = objectArray;
        objectArray = new TimeInterval[18];
        objectArray[0] = (double)TimeInterval.Companion.seconds(1);
        objectArray[1] = (double)TimeInterval.Companion.seconds(5);
        objectArray[2] = (double)TimeInterval.Companion.seconds(15);
        objectArray[3] = (double)TimeInterval.Companion.seconds(30);
        objectArray[4] = (double)TimeInterval.Companion.minutes(1);
        objectArray[5] = (double)TimeInterval.Companion.minutes(5);
        objectArray[6] = (double)TimeInterval.Companion.minutes(15);
        objectArray[7] = (double)TimeInterval.Companion.minutes(30);
        objectArray[8] = (double)TimeInterval.Companion.hours(1);
        objectArray[9] = (double)TimeInterval.Companion.hours(3);
        objectArray[10] = (double)TimeInterval.Companion.hours(6);
        objectArray[11] = (double)TimeInterval.Companion.hours(12);
        objectArray[12] = (double)TimeInterval.Companion.days(1);
        objectArray[13] = (double)TimeInterval.Companion.days(2);
        objectArray[14] = (double)TimeInterval.Companion.weeks(1);
        objectArray[15] = (double)TimeInterval.Companion.months(1);
        objectArray[16] = (double)TimeInterval.Companion.months(3);
        objectArray[17] = (double)TimeInterval.Companion.years(1);
        AUTO_INTERVALS = (TimeInterval[])objectArray;
    }
}

