/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.history.LocalHistory;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.Consumer;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.plugins.webDeployment.AlwaysAsk;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.IgnoreOverwritingStrategy;
import com.jetbrains.plugins.webDeployment.PreserveRemoteChangeLocal;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.RemoteHostTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.OverwriteRemoteWarningDialog;
import com.jetbrains.plugins.webDeployment.ui.RerunTransferTask;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransferTask
extends RemoteHostTask {
    private static final Logger LOG = Logger.getInstance(TransferTask.class);
    private final boolean myIsServerSideModification;
    private final boolean myUpdateLocalHistory;
    protected final PublishConfig myPublishConfig;
    private final boolean myCancellable;
    protected List<TransferOperation> failedOperations;
    protected final Map<String, AtomicInteger> myProcessedCounters;
    protected AtomicInteger myTotalProcessed;
    protected AtomicInteger myFailed;
    private final AtomicLong myTotalSize;

    public TransferTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, Deployable serverConfig, @NlsContexts.ProgressTitle String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker) {
        if (connectionOwner == null) {
            TransferTask.$$$reportNull$$$0(0);
        }
        if (revisionTracker == null) {
            TransferTask.$$$reportNull$$$0(1);
        }
        this(project, connectionOwner, serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker, DeploymentMode.CUSTOM);
    }

    public TransferTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, Deployable serverConfig, @NlsContexts.ProgressTitle String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker, DeploymentMode mode) {
        if (connectionOwner == null) {
            TransferTask.$$$reportNull$$$0(2);
        }
        if (revisionTracker == null) {
            TransferTask.$$$reportNull$$$0(3);
        }
        super(project, connectionOwner, serverConfig, publishConfig, title, background, revisionTracker, mode);
        this.myProcessedCounters = Collections.synchronizedMap(new TreeMap((s1, s2) -> s1.compareToIgnoreCase((String)s2)));
        this.myTotalProcessed = new AtomicInteger(0);
        this.myFailed = new AtomicInteger(0);
        this.myTotalSize = new AtomicLong(0L);
        this.myIsServerSideModification = serverSideModification;
        this.myUpdateLocalHistory = updateLocalHistory;
        this.myCancellable = cancellable;
        this.myPublishConfig = publishConfig.clone();
    }

    protected boolean isServerSideModification() {
        return this.myIsServerSideModification;
    }

    protected abstract boolean isMultipleOperations();

    protected abstract boolean prepareOperations(ExecutionContext var1) throws FileSystemException;

    @Nullable
    protected abstract TransferOperation getNextOperation(ExecutionContext var1);

    protected abstract int getDoneStepsNumber();

    protected abstract int getTotalStepsNumber();

    protected abstract void assertAllExecuted(int var1, int var2);

    @Override
    protected boolean executeOperations(final ExecutionContextBase contextBase, RemoteConnection connection) {
        TransferOperation operation;
        boolean notEmpty;
        ExecutionContext context;
        long startTime = System.currentTimeMillis();
        try {
            connection.resolveRoot();
            context = new ExecutionContext(){
                @NotNull
                private IgnoreOverwritingStrategy myIgnoreOverwriteStrategy = AlwaysAsk.INSTANCE;
                private OverwriteRemoteWarningDialog.OverwriteOption myOverwriteOption;

                @Override
                public PublishConfig getConfig() {
                    return TransferTask.this.myPublishConfig;
                }

                @Override
                public void incCounter(String counterTitle) {
                    AtomicInteger value = TransferTask.this.myProcessedCounters.get(counterTitle);
                    if (value == null) {
                        value = new AtomicInteger(1);
                        TransferTask.this.myProcessedCounters.put(counterTitle, value);
                    } else {
                        value.incrementAndGet();
                    }
                    TransferTask.this.myTotalProcessed.incrementAndGet();
                }

                @Override
                public void incBytesTransmitted(long bytes) {
                    TransferTask.this.myTotalSize.accumulateAndGet(bytes, Math::addExact);
                }

                @Override
                public void console(String message, ConsoleViewContentType type) {
                    TransferTask.this.print(message, type);
                }

                @Override
                public boolean isMultipleOperations() {
                    return TransferTask.this.isMultipleOperations();
                }

                @Override
                public synchronized boolean promptForOverwrite(@Nullable FileObject source, @NotNull FileObject target) throws IOException {
                    if (target == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    IgnoreOverwritingStrategy strategy = this.myIgnoreOverwriteStrategy;
                    if (this.isServerSideModification()) {
                        Boolean shouldIgnore = strategy.ignoreRemoteOverwriting(target);
                        return shouldIgnore != null ? shouldIgnore.booleanValue() : this.promptForRemoteOverwrite(source, target);
                    }
                    Boolean shouldIgnore = strategy.ignoreLocalOverwriting(target);
                    return shouldIgnore != null ? shouldIgnore.booleanValue() : this.promptForLocalOverwrite(target.getName());
                }

                private boolean promptForLocalOverwrite(@NotNull FileName name) {
                    if (name == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (TransferTask.this.myDeploymentMode != DeploymentMode.CUSTOM || !TransferTask.this.myPublishConfig.isPromptOnLocalOverwrite()) {
                        return true;
                    }
                    Ref result = new Ref();
                    Runnable showDialog = () -> {
                        String fileName = DeploymentPathUtils.getLocalPath(name);
                        result.set((Object)Messages.showDialog((Project)TransferTask.this.myProject, (String)WDBundle.message("overwrite.local.dialog.text", fileName), (String)WDBundle.message("overwrite.local.dialog.title", this.getServer().getName()), (String[])OverwriteOptions.getNames(), (int)OverwriteOptions.YES.ordinal(), (Icon)Messages.getWarningIcon()));
                    };
                    WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)showDialog);
                    OverwriteOptions option = OverwriteOptions.fromOrdinal((Integer)result.get());
                    if (option != null) {
                        return switch (option) {
                            default -> throw new IncompatibleClassChangeError();
                            case OverwriteOptions.YES -> true;
                            case OverwriteOptions.NO -> false;
                            case OverwriteOptions.ALWAYS -> {
                                this.myIgnoreOverwriteStrategy = new PreserveRemoteChangeLocal(this.myIgnoreOverwriteStrategy, true);
                                yield true;
                            }
                            case OverwriteOptions.NEVER -> {
                                this.myIgnoreOverwriteStrategy = new PreserveRemoteChangeLocal(this.myIgnoreOverwriteStrategy, false);
                                yield false;
                            }
                            case OverwriteOptions.CANCEL -> throw new ProcessCanceledException();
                        };
                    }
                    throw new ProcessCanceledException();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private boolean promptForRemoteOverwrite(FileObject source, FileObject target) throws IOException {
                    if (source == null) return true;
                    if (TransferTask.this.myPublishConfig.getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.NONE) return true;
                    if (this.getDeploymentMode() != DeploymentMode.CUSTOM) {
                        return true;
                    }
                    String previousText = this.getProgressIndicator().getText();
                    DeploymentRevisionTracker.Revision baseRevision = this.getRevisionTracker().getBaseRevision(DeploymentPathUtils.getLocalPath(source), this.getServer());
                    if (baseRevision == null) {
                        return true;
                    }
                    this.getProgressIndicator().setText(WDBundle.message("checking.remote.revision", target.getName().getBaseName()));
                    try {
                        byte[] currentRemoteContent;
                        long currentRemoteTimestamp;
                        if (TransferTask.this.myPublishConfig.getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
                            currentRemoteTimestamp = target.getContent().getLastModifiedTime();
                            if (TransferOperation.areTimestampsEqual(baseRevision.timestamp, currentRemoteTimestamp, target.getFileSystem().getLastModTimeAccuracy()) && target.getContent().getSize() == (long)baseRevision.content.length) {
                                boolean bl = true;
                                return bl;
                            }
                            currentRemoteContent = FileTransferUtil.getContent(target, this.getProgressIndicator());
                        } else {
                            currentRemoteContent = FileTransferUtil.getContent(target, this.getProgressIndicator());
                            if (Arrays.equals(baseRevision.content, currentRemoteContent)) {
                                boolean bl = true;
                                return bl;
                            }
                            currentRemoteTimestamp = target.getContent().getLastModifiedTime();
                        }
                        Ref result1 = new Ref();
                        if (this.myOverwriteOption != null) {
                            result1.set((Object)this.myOverwriteOption);
                        } else {
                            Ref doNotAsk = new Ref((Object)false);
                            TransferTask.showUi(() -> {
                                OverwriteRemoteWarningDialog dialog = OverwriteRemoteWarningDialog.createInstance(TransferTask.this.myConnectionOwner, target, this.getServer(), true);
                                dialog.show();
                                result1.set((Object)dialog.getResult());
                                doNotAsk.set((Object)dialog.isRememberForUpload());
                            });
                            if (((Boolean)doNotAsk.get()).booleanValue()) {
                                this.myOverwriteOption = (OverwriteRemoteWarningDialog.OverwriteOption)((Object)result1.get());
                            }
                        }
                        switch ((OverwriteRemoteWarningDialog.OverwriteOption)((Object)result1.get())) {
                            case OVERWRITE: {
                                boolean doNotAsk = true;
                                return doNotAsk;
                            }
                            case SKIP: {
                                boolean doNotAsk = false;
                                return doNotAsk;
                            }
                            case MERGE: {
                                Ref result3;
                                VirtualFile localFile;
                                DeploymentPathUtils.refreshRemoteFile(target, this);
                                long newTimestamp = target.getContent().getLastModifiedTime();
                                if (!TransferOperation.areTimestampsEqual(newTimestamp, currentRemoteTimestamp, target.getFileSystem().getLastModTimeAccuracy()) || target.getContent().getSize() != (long)currentRemoteContent.length) {
                                    currentRemoteTimestamp = newTimestamp;
                                    currentRemoteContent = FileTransferUtil.getContent(target, this.getProgressIndicator());
                                }
                                LOG.assertTrue((localFile = LocalFileSystem.getInstance().findFileByPath(DeploymentPathUtils.getLocalPath(source))) != null && !localFile.isDirectory(), (Object)("virtual file '" + String.valueOf(source) + "' is not part of VFS while uploading it"));
                                byte[] baseContent = baseRevision.content;
                                do {
                                    boolean merged;
                                    byte[] localContent = localFile.contentsToByteArray();
                                    byte[] remoteContent = currentRemoteContent;
                                    Ref successRef = new Ref();
                                    TransferTask.showUi(() -> {
                                        String windowTitle = WDBundle.message("merge.on.upload.title", localFile.getName(), this.getServer().getName());
                                        List<String> titles = Arrays.asList(WDBundle.message("merge.on.upload.local.version.title", localFile.getPresentableUrl()), WDBundle.message("merge.on.upload.result.title", new Object[0]), WDBundle.message("merge.on.upload.remote.version.title", this.getServer().getPresentablePath(target)));
                                        List contents = Arrays.asList(localContent, baseContent, remoteContent);
                                        Consumer callback = result -> {
                                            Document document = FileDocumentManager.getInstance().getCachedDocument(localFile);
                                            if (document != null) {
                                                FileDocumentManager.getInstance().saveDocument(document);
                                            }
                                            successRef.set((Object)(result != MergeResult.CANCEL ? 1 : 0));
                                        };
                                        try {
                                            TextMergeRequest request = DiffRequestFactory.getInstance().createTextMergeRequest(TransferTask.this.myProject, localFile, contents, windowTitle, titles, callback);
                                            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE, (Object)Couple.of((Object)DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]), (Object)WDBundle.message("merge.dialog.cancel.prompt", localFile.getName())));
                                            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, PublishUtils.getMergeResolveCaptions());
                                            DiffManager.getInstance().showMerge(TransferTask.this.myProject, (MergeRequest)request);
                                        }
                                        catch (InvalidDiffRequestException e) {
                                            LOG.error((Throwable)e);
                                        }
                                    });
                                    boolean bl = merged = successRef.get() == Boolean.TRUE;
                                    if (!merged) {
                                        boolean bl2 = false;
                                        return bl2;
                                    }
                                    DeploymentPathUtils.refreshRemoteFile(target, this);
                                    newTimestamp = target.getContent().getLastModifiedTime();
                                    if (TransferOperation.areTimestampsEqual(newTimestamp, currentRemoteTimestamp, target.getFileSystem().getLastModTimeAccuracy()) && target.getContent().getSize() == (long)currentRemoteContent.length) {
                                        boolean bl3 = true;
                                        return bl3;
                                    }
                                    currentRemoteTimestamp = newTimestamp;
                                    currentRemoteContent = FileTransferUtil.getContent(target, this.getProgressIndicator());
                                    result3 = new Ref();
                                    TransferTask.showUi(() -> result3.set((Object)TransferTask.showDialog(TransferTask.this.myConnectionOwner, WDBundle.message("merge.on.upload.file.changed.while.merge", localFile.getName(), this.getServer().getName()), WDBundle.message("merge.on.upload.title", localFile.getName(), this.getServer().getName()), new String[]{WDBundle.message("merge.again", new Object[0]), WDBundle.message("overwrite.remote.dialog.skip.action.name", new Object[0])})));
                                } while ((Integer)result3.get() != 1);
                                boolean bl = false;
                                return bl;
                            }
                        }
                        LOG.error("Unexpected result: " + String.valueOf(result1.get()));
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.getProgressIndicator().setText(previousText);
                    }
                }

                @Override
                public ProgressIndicator getProgressIndicator() {
                    return contextBase.getProgressIndicator();
                }

                @Override
                public void addAffectedRoot(FileName fileName, boolean remote) {
                    contextBase.addAffectedRoot(fileName, remote);
                }

                @Override
                public boolean isServerSideModification() {
                    return TransferTask.this.isServerSideModification();
                }

                @Override
                public Deployable getServer() {
                    return contextBase.getServer();
                }

                @Override
                public FileObject findRemoteFile(@NotNull WebServerConfig.RemotePath path, boolean refreshUpRecursively) throws FileSystemException {
                    if (path == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return contextBase.findRemoteFile(path, refreshUpRecursively);
                }

                @Override
                @NotNull
                public FileName findRemoteFileName(@NotNull WebServerConfig.RemotePath path) throws FileSystemException {
                    if (path == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    FileName fileName = contextBase.findRemoteFileName(path);
                    if (fileName == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return fileName;
                }

                @Override
                public FileObject resolveFileName(@NotNull FileName name, boolean refreshUpRecursively) throws FileSystemException {
                    if (name == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return contextBase.resolveFileName(name, refreshUpRecursively);
                }

                @Override
                public boolean isTolerateSetPermissionsErrors() {
                    return TransferTask.this.isTolerateSetPermissionsErrors();
                }

                @Override
                public Project getProject() {
                    return TransferTask.this.myProject;
                }

                @Override
                public boolean isCancellable() {
                    return TransferTask.this.myCancellable;
                }

                @Override
                public void scheduleForSelection(WebServerConfig.RemotePath remotePath, Object requestor) {
                    contextBase.scheduleForSelection(remotePath, requestor);
                }

                @Override
                public void setCurrentFileFraction(double fraction) {
                    assert (0.0 <= fraction);
                    assert (fraction <= 1.0);
                    this.getProgressIndicator().setFraction(((double)TransferTask.this.getDoneStepsNumber() + fraction) / (double)TransferTask.this.getTotalStepsNumber());
                }

                @Override
                public void setIgnoreOverwritingStrategy(@NotNull IgnoreOverwritingStrategy strategy) {
                    if (strategy == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    this.myIgnoreOverwriteStrategy = strategy;
                }

                @Override
                public void increaseFailureCount() {
                    TransferTask.this.myFailed.incrementAndGet();
                }

                @Override
                public DeploymentMode getDeploymentMode() {
                    return TransferTask.this.myDeploymentMode;
                }

                @Override
                public DeploymentRevisionTracker getRevisionTracker() {
                    return TransferTask.this.myRevisionTracker;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 4 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "target";
                            break;
                        }
                        case 1: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "name";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferTask$1";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "strategy";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferTask$1";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "findRemoteFileName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "promptForOverwrite";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "promptForLocalOverwrite";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "findRemoteFile";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "findRemoteFileName";
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            objectArray = objectArray;
                            objectArray[2] = "resolveFileName";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray;
                            objectArray[2] = "setIgnoreOverwritingStrategy";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 4 -> new IllegalStateException(string);
                    };
                }
            };
            context.getProgressIndicator().setText(WDBundle.message("collecting.files", new Object[0]));
            notEmpty = this.prepareOperations(context);
        }
        catch (FileSystemException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            LOG.warn((Throwable)e);
            String message = WDBundle.message("collect.files.failed", PublishUtils.getMessage(e, true));
            this.print(message, ConsoleViewContentType.ERROR_OUTPUT);
            this.showBalloon(MessageType.ERROR, message, true);
            return false;
        }
        if (!notEmpty) {
            this.printExcludedMessage();
            this.print(WDBundle.message("nothing.to.transfer", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
            this.showBalloon(MessageType.INFO, WDBundle.message("nothing.to.transfer", new Object[0]), true);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting " + (this.isServerSideModification() ? "server-side modification" : "local modification"));
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            LOG.debug("Publish config:\n" + outputter.outputString(XmlSerializer.serialize((Object)this.myPublishConfig.getState())));
            LOG.debug(Deployable.getDebugDescription(context.getServer().clone(), outputter));
        }
        if (this.myUpdateLocalHistory) {
            if (this.isServerSideModification() && this.myProject != null) {
                LocalHistory.getInstance().putSystemLabel(this.myProject, this.getTitle());
            } else {
                this.myLocalHistoryAction = LocalHistory.getInstance().startAction(this.getTitle());
            }
        }
        long uploadStartTime = System.currentTimeMillis();
        this.failedOperations = new ArrayList<TransferOperation>();
        while ((operation = this.getNextOperation(context)) != null) {
            if (this.myCancellable) {
                context.getProgressIndicator().checkCanceled();
            }
            try {
                operation.prepare(context);
                context.getProgressIndicator().setText(operation.getProgressText(context));
                context.getProgressIndicator().setIndeterminate(false);
                this.print(operation.getDetailedText(context), ConsoleViewContentType.NORMAL_OUTPUT);
                operation.execute(context);
                context.getProgressIndicator().setFraction(((double)this.getDoneStepsNumber() + 1.0) / (double)this.getTotalStepsNumber());
            }
            catch (FileSystemException e) {
                this.failedOperations.add(operation);
                LOG.warn(String.valueOf(operation) + " failed", (Throwable)e);
                String text = operation.getErrorMessage(context, PublishUtils.getMessage(e, true));
                this.print(text, ConsoleViewContentType.ERROR_OUTPUT);
                if (this.isMultipleOperations() && !PublishUtils.isFatal(e)) {
                    context.increaseFailureCount();
                    continue;
                }
                String shortText = operation.getErrorMessage(context, PublishUtils.getMessage(e, false));
                this.showBalloon(MessageType.ERROR, WDBundle.message("operation.failed", this.getTitle(), shortText), true);
                return false;
            }
        }
        LOG.debug("finished");
        this.assertAllExecuted(this.myTotalProcessed.get(), this.myFailed.get());
        long time = System.currentTimeMillis() - startTime + 1L;
        long uploadTime = System.currentTimeMillis() - uploadStartTime + 1L;
        this.printResultMessage(time, uploadTime);
        if (!this.failedOperations.isEmpty()) {
            this.addRetryLink(this.failedOperations, context);
        }
        this.showBalloon(this.getResultMessageType(), this.getResultMessage(this.getTitle(), this.myProcessedCounters, this.myFailed.get(), this.myTotalSize.get(), time, uploadTime, false), true);
        return this.myTotalProcessed.get() > 0;
    }

    protected void addRetryLink(@NotNull List<TransferOperation> failedOperations, @NotNull ExecutionContextBase context) {
        if (failedOperations == null) {
            TransferTask.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TransferTask.$$$reportNull$$$0(5);
        }
        RerunTransferTask rerunTask = new RerunTransferTask(failedOperations, this.myProject, this.myConnectionOwner, this.myIsServerSideModification, this.myPublishConfig, context.getServer(), this.getRerunTitle(), this.myUpdateLocalHistory, this.shouldStartInBackground(), this.myCancellable, this.myRevisionTracker, this.myDeploymentMode);
        FileTransferToolWindow.addRetryLink(this.myProject, context.getServer(), rerunTask);
    }

    @NotNull
    @NlsContexts.ProgressTitle
    protected String getRerunTitle() {
        String string = WDBundle.message("rerun.title", this.getTitle());
        if (string == null) {
            TransferTask.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected void printResultMessage(long time, long uploadTime) {
        this.print(this.getResultMessage(this.getTitle(), this.myProcessedCounters, this.myFailed.get(), this.myTotalSize.get(), time, uploadTime, true), ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    protected void printExcludedMessage() {
        AtomicInteger excluded = this.myProcessedCounters.get("transfer.details.excluded");
        if (excluded == null || excluded.get() == 0) {
            return;
        }
        this.print(WDBundle.message("transfer.details.excluded", excluded, excluded), ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    protected MessageType getResultMessageType() {
        return this.myFailed.get() == 0 ? MessageType.INFO : (this.myTotalProcessed.get() > 0 ? MessageType.WARNING : MessageType.ERROR);
    }

    protected boolean isTolerateSetPermissionsErrors() {
        return false;
    }

    @NlsContexts.NotificationContent
    protected String getResultMessage(String title, Map<String, AtomicInteger> processed, int failed, long totalSize, long totalTime, long transferTime, boolean details) {
        return TransferTask.getResultMessageStatic(title, processed, failed, totalSize, totalTime, transferTime, details);
    }

    @NlsContexts.NotificationContent
    public static String getResultMessageStatic(String title, Map<String, AtomicInteger> processed, int failed, long totalSize, long totalTime, long transferTime, boolean details) {
        StringBuilder statistics = new StringBuilder();
        for (Map.Entry<String, AtomicInteger> entry : processed.entrySet()) {
            if (!statistics.isEmpty()) {
                statistics.append(", ");
            }
            statistics.append(WDBundle.message(entry.getKey(), entry.getValue(), entry.getValue().get() > 1 ? 2 : 1));
        }
        if (failed > 0) {
            if (!statistics.isEmpty()) {
                statistics.append(", ");
            }
            statistics.append(WDBundle.message("transfer.details.failed", TransferTask.getItemsMessage(failed)));
        }
        if (!statistics.isEmpty()) {
            statistics.insert(0, ": ");
        }
        StringBuilder sb = new StringBuilder();
        if (details) {
            sb.append(WDBundle.message("operation.finished.in", title, NlsMessages.formatDurationApproximate((long)totalTime), statistics));
        } else {
            sb.append(WDBundle.message("operation.finished", title, statistics));
        }
        if (details && totalSize > 0L) {
            float bps = (float)totalSize / (float)transferTime * 1000.0f;
            sb.append(PublishUtils.formatSize(bps, "transfer.bit.p.s", "transfer.kilobit.p.s", "transfer.mega.bit.p.s"));
        }
        return sb.toString();
    }

    private static void showUi(Runnable r) {
        try {
            ApplicationManager.getApplication().invokeAndWait(r);
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
        }
    }

    private static int showDialog(ConnectionOwner connectionOwner, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String[] options) {
        Project project = connectionOwner.getProjectForDialogCreation();
        Component component = connectionOwner.getComponentForDialogCreation();
        if (project != null || component == null) {
            return Messages.showDialog((Project)project, (String)message, (String)title, (String[])options, (int)0, (Icon)Messages.getWarningIcon());
        }
        return Messages.showDialog((Component)component, (String)message, (String)title, (String[])options, (int)0, (Icon)Messages.getWarningIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionTracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedOperations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/TransferTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/TransferTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRerunTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRetryLink";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static enum OverwriteOptions {
        YES(WDBundle.messagePointer("yes", new Object[0])),
        NO(WDBundle.messagePointer("no", new Object[0])),
        ALWAYS(WDBundle.messagePointer("always", new Object[0])),
        NEVER(WDBundle.messagePointer("never", new Object[0])),
        CANCEL(WDBundle.messagePointer("cancel", new Object[0]));

        private final Supplier<String> myTitle;

        private OverwriteOptions(Supplier<String> title) {
            this.myTitle = title;
        }

        @Nullable
        static OverwriteOptions fromOrdinal(int ordinal) {
            return (OverwriteOptions)((Object)ContainerUtil.find((Object[])OverwriteOptions.values(), o -> o.ordinal() == ordinal));
        }

        static String[] getNames() {
            return (String[])Arrays.stream(OverwriteOptions.values()).map(o -> o.myTitle.get()).toArray(String[]::new);
        }
    }

    public static abstract class ListBased
    extends TransferTask {
        private List<? extends TransferOperation> myOperations;
        private int size;
        private boolean myErrorsDuringPrepare;
        private int myIndex;

        public ListBased(@NotNull Project project, boolean serverSideModification, PublishConfig publishConfig, Deployable serverConfig, @NlsContexts.ProgressTitle String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker) {
            if (project == null) {
                ListBased.$$$reportNull$$$0(0);
            }
            if (revisionTracker == null) {
                ListBased.$$$reportNull$$$0(1);
            }
            this(project, ConnectionOwnerFactory.createConnectionOwner(project), serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker, DeploymentMode.CUSTOM);
        }

        public ListBased(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, Deployable serverConfig, @NlsContexts.ProgressTitle String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker) {
            if (connectionOwner == null) {
                ListBased.$$$reportNull$$$0(2);
            }
            if (revisionTracker == null) {
                ListBased.$$$reportNull$$$0(3);
            }
            this(project, connectionOwner, serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker, DeploymentMode.CUSTOM);
        }

        public ListBased(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, boolean serverSideModification, PublishConfig publishConfig, Deployable serverConfig, @NlsContexts.ProgressTitle String title, boolean updateLocalHistory, boolean background, boolean cancellable, @NotNull DeploymentRevisionTracker revisionTracker, @NotNull DeploymentMode mode) {
            if (connectionOwner == null) {
                ListBased.$$$reportNull$$$0(4);
            }
            if (revisionTracker == null) {
                ListBased.$$$reportNull$$$0(5);
            }
            if (mode == null) {
                ListBased.$$$reportNull$$$0(6);
            }
            super(project, connectionOwner, serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker, mode);
            this.size = 0;
        }

        @NotNull
        protected abstract ResultWithErrors buildOperationsList(ExecutionContext var1) throws FileSystemException;

        @Override
        protected boolean isMultipleOperations() {
            return this.getTotalStepsNumber() > 1;
        }

        @Override
        protected boolean prepareOperations(ExecutionContext context) throws FileSystemException {
            ResultWithErrors result = this.buildOperationsList(context);
            this.myOperations = result.operations;
            for (String string : result.errorMessages) {
                this.print(string, ConsoleViewContentType.ERROR_OUTPUT);
            }
            for (String string : result.excludedPaths) {
                this.print(WDBundle.message("excluded.message", string), ConsoleViewContentType.NORMAL_OUTPUT);
                context.incCounter("transfer.details.excluded");
            }
            this.myErrorsDuringPrepare = !result.errorMessages.isEmpty();
            this.size = 0;
            for (TransferOperation transferOperation : this.myOperations) {
                if (transferOperation instanceof TransferOperation.ParallelFilesUpload) {
                    this.size += ((TransferOperation.ParallelFilesUpload)transferOperation).getSize();
                    continue;
                }
                ++this.size;
            }
            return !this.myOperations.isEmpty();
        }

        @Override
        protected String getResultMessage(String title, Map<String, AtomicInteger> processed, int failed, long totalSize, long totalTime, long transferTime, boolean details) {
            String s = super.getResultMessage(title, processed, failed, totalSize, totalTime, transferTime, details);
            return this.myErrorsDuringPrepare && !details ? WDBundle.message("errors.during.prepare", new Object[0]) + "\n" + s : s;
        }

        @Override
        protected void printResultMessage(long time, long uploadTime) {
            if (this.myErrorsDuringPrepare) {
                this.print(WDBundle.message("errors.during.prepare", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            super.printResultMessage(time, uploadTime);
        }

        @Override
        protected MessageType getResultMessageType() {
            return this.myFailed.get() == 0 && !this.myErrorsDuringPrepare ? MessageType.INFO : (this.myTotalProcessed.get() > 0 ? MessageType.WARNING : MessageType.ERROR);
        }

        @Override
        @Nullable
        protected TransferOperation getNextOperation(ExecutionContext context) {
            return this.myIndex < this.myOperations.size() ? this.myOperations.get(this.myIndex++) : null;
        }

        @Override
        protected int getDoneStepsNumber() {
            return this.myTotalProcessed.get();
        }

        @Override
        protected int getTotalStepsNumber() {
            return this.size;
        }

        @Override
        protected void assertAllExecuted(int totalProcessed, int failed) {
            LOG.assertTrue(this.myOperations.size() <= this.myTotalProcessed.get() + this.myFailed.get(), (Object)("total: " + this.myOperations.size() + ", processed: " + String.valueOf(this.myProcessedCounters)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "revisionTracker";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connectionOwner";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mode";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/TransferTask$ListBased";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class ResultWithErrors {
            public final List<? extends TransferOperation> operations;
            public final Collection<@Nls String> errorMessages;
            public final Collection<String> excludedPaths;

            public ResultWithErrors(List<? extends TransferOperation> operations, DeploymentPathUtils.ErrorsAndExclusions errorsAndExclusions) {
                this.operations = operations;
                this.errorMessages = new ArrayList<String>();
                this.errorMessages.addAll(errorsAndExclusions.getReadOnlyErrors());
                this.excludedPaths = new ArrayList<String>();
                this.excludedPaths.addAll(errorsAndExclusions.getReadOnlyPaths());
            }
        }
    }
}

