/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.UploadCommitOptions;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.UploadFilesAction;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadCheckinHandlerFactory
extends CheckinHandlerFactory {
    private static final Logger LOG = Logger.getInstance(UploadCheckinHandlerFactory.class);

    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            UploadCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            UploadCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        final PublishConfig publishConfig = PublishConfig.getInstance(panel.getProject());
        return new CheckinHandler(){
            private final ServerOrGroup myTempSelected = new ServerOrGroup();

            public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
                return new UploadCommitOptions(panel.getProject(), publishConfig, this.myTempSelected);
            }

            public void checkinSuccessful() {
                Pair<WebServerGroupingWrap, WebServerConfig> serverAndGroup;
                ServerOrGroup idAndName = publishConfig.isPersistUploadOnCheckin() ? publishConfig.getUploadOnCheckin() : this.myTempSelected;
                if (idAndName.hasServer()) {
                    WebServerConfig server = GroupedServersConfigManager.getInstance(panel.getProject()).findServer(idAndName.getServerId());
                    this.tryToUpload(server);
                } else if (idAndName.hasGroup() && (serverAndGroup = GroupedServersConfigManager.getInstance(panel.getProject()).findByName(idAndName.getGroupName())) != null && serverAndGroup.first != null) {
                    for (WebServerConfig server : ((WebServerGroupingWrap)serverAndGroup.getFirst()).getServers()) {
                        this.tryToUpload(server);
                    }
                }
            }

            private void tryToUpload(@Nullable WebServerConfig server) {
                if (server == null || !server.needsTransfer()) {
                    return;
                }
                String error = server.getFileTransferConfig().validateFast();
                if (error != null) {
                    FileTransferToolWindow.printWithTimestamp(panel.getProject(), server, WDBundle.message("0.n.failed.1", WDBundle.message("upload.on.commit", server.getName(), panel.getCommitMessage()), error), ConsoleViewContentType.ERROR_OUTPUT, publishConfig.getTraceLevel());
                    return;
                }
                FileTransferToolWindow.printWithTimestamp(panel.getProject(), server, WDBundle.message("upload.on.commit", server.getName(), panel.getCommitMessage()), ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
                final Collection changes = panel.getSelectedChanges();
                ApplicationManager.getApplication().invokeLater(() -> {
                    Project project = panel.getProject();
                    ProgressManager.getInstance().run((Task)new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig, Deployable.create(server, project), WDBundle.message("upload.to", server.getName()), true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

                        @Override
                        @NotNull
                        protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                            TransferTask.ListBased.ResultWithErrors resultWithErrors = UploadCheckinHandlerFactory.doScanFiles(context, changes, UploadFilesAction.isSpeculativeQuickUploadMode());
                            if (resultWithErrors == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return resultWithErrors;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory$1$1", "buildOperationsList"));
                        }
                    });
                });
            }
        };
    }

    public static TransferTask.ListBased.ResultWithErrors doScanFiles(ExecutionContext context, Collection<? extends Change> changes, boolean speculatively) throws FileSystemException {
        ArrayList<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>(changes.size());
        for (Change change : changes) {
            changeInfos.add(new ChangeInfo(change));
        }
        Collections.sort(changeInfos);
        List<TransferOperation> result = new ArrayList<TransferOperation>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ChangeInfo change : changeInfos) {
            context.getProgressIndicator().checkCanceled();
            String itemPath = change.beforePath != null && !context.getConfig().isExcludedByName(change.beforePath) ? change.beforePath : change.afterPath;
            context.getProgressIndicator().setText(WDBundle.message("processing.0", itemPath));
            try {
                UploadCheckinHandlerFactory.processChange(change, context, result, speculatively);
            }
            catch (FileSystemException e) {
                if (changeInfos.size() == 1 || PublishUtils.isFatal(e)) {
                    throw e;
                }
                LOG.warn((Throwable)e);
                arrayList.add(WDBundle.message("failed.to.process.change", itemPath, PublishUtils.getMessage(e, false)));
            }
        }
        result = DeploymentPathUtils.mergeIfNeeded(context, result);
        return new TransferTask.ListBased.ResultWithErrors(result, DeploymentPathUtils.ErrorsAndExclusions.reportErrors(arrayList));
    }

    private static void processChange(ChangeInfo change, ExecutionContext context, List<TransferOperation> result, boolean speculatively) throws FileSystemException {
        if (change.beforePath == null || context.getConfig().isExcludedByName(change.beforePath)) {
            UploadCheckinHandlerFactory.processCreate(context, result, change.afterPath, change.isDirectory, speculatively);
        } else if (change.afterPath == null || context.getConfig().isExcludedByName(change.afterPath)) {
            UploadCheckinHandlerFactory.processDelete(context, result, change.beforePath, change.isDirectory, speculatively);
        } else {
            DeploymentPathMapping mappingBefore = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(change.beforePath, false, true, false, (Mappable)context.getServer()).getFirst();
            DeploymentPathMapping mappingAfter = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(change.afterPath, false, true, false, (Mappable)context.getServer()).getFirst();
            if (mappingBefore != null && mappingAfter != null) {
                WebServerConfig.RemotePath targetBefore = mappingBefore.mapToDeployPath(change.beforePath, (Mappable)context.getServer());
                WebServerConfig.RemotePath targetAfter = mappingAfter.mapToDeployPath(change.afterPath, (Mappable)context.getServer());
                if (change.isDirectory) {
                    if (!(change.beforePath.equals(change.afterPath) || UploadCheckinHandlerFactory.isEmptyDirectory(change.afterPath) && !context.getConfig().isCreateEmptyDirectories())) {
                        result.add(new TransferOperation.RemoteMoveOrUpload(change.afterPath, targetBefore, targetAfter, true));
                    }
                } else {
                    FileObject sourceAfter = DeploymentPathUtils.getLocalFile(change.afterPath);
                    if (targetBefore.equals(targetAfter)) {
                        if (context.getServer().isUseRsync()) {
                            result.add(new TransferOperation.RsyncCopy(sourceAfter, targetAfter));
                        } else {
                            result.add(new TransferOperation.Copy(sourceAfter, targetAfter));
                        }
                    } else {
                        result.add(new TransferOperation.RemoteMoveOrUpload(change.afterPath, targetBefore, targetAfter, false));
                    }
                }
            } else if (mappingBefore != null) {
                UploadCheckinHandlerFactory.processCreate(context, result, change.afterPath, true, speculatively);
            } else if (mappingAfter != null) {
                UploadCheckinHandlerFactory.processDelete(context, result, change.beforePath, change.isDirectory, speculatively);
            }
        }
    }

    private static void processCreate(ExecutionContext context, List<TransferOperation> result, String path, boolean isDirectory, boolean speculatively) throws FileSystemException {
        if (isDirectory) {
            DeploymentPathMapping mapping;
            if (context.getConfig().isCreateEmptyDirectories() && (mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst()) != null && UploadCheckinHandlerFactory.isEmptyDirectory(path)) {
                WebServerConfig.RemotePath targetPath = mapping.mapToDeployPath(path, (Mappable)context.getServer());
                if (speculatively) {
                    result.add(new TransferOperation.CreateFolder(targetPath));
                } else {
                    result.add(new TransferOperation.CreateFolder(context.findRemoteFile(targetPath, true)));
                }
            }
        } else {
            DeploymentPathMapping mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst();
            if (mapping != null) {
                FileObject source = DeploymentPathUtils.getLocalFile(path);
                WebServerConfig.RemotePath targetPath = mapping.mapToDeployPath(path, (Mappable)context.getServer());
                if (speculatively) {
                    if (context.getServer().isUseRsync()) {
                        result.add(new TransferOperation.RsyncCopy(source, targetPath));
                    } else {
                        result.add(new TransferOperation.Copy(source, targetPath));
                    }
                } else {
                    FileObject target = context.findRemoteFile(targetPath, true);
                    result.add(new TransferOperation.Copy(source, target));
                }
            }
        }
    }

    private static void processDelete(ExecutionContext context, List<TransferOperation> result, String path, boolean isDirectory, boolean speculatively) throws FileSystemException {
        DeploymentPathMapping mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst();
        if (mapping != null) {
            WebServerConfig.RemotePath targetPath = mapping.mapToDeployPath(path, (Mappable)context.getServer());
            if (speculatively) {
                result.add(new TransferOperation.Delete(targetPath, isDirectory, true));
            } else {
                FileObject target = context.findRemoteFile(targetPath, true);
                result.add(new TransferOperation.Delete(target, isDirectory, true));
            }
        }
    }

    private static boolean isEmptyDirectory(String path) {
        String[] list = new File(path).list();
        return list != null && list.length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "panel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "commitContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory";
        objectArray[2] = "createHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ChangeInfo
    implements Comparable<ChangeInfo> {
        @Nullable
        public String beforePath;
        @Nullable
        public String afterPath;
        public final boolean isDirectory;

        private ChangeInfo(Change change) {
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            this.beforePath = before != null ? before.getFile().getPresentableUrl() : null;
            this.afterPath = after != null ? after.getFile().getPresentableUrl() : null;
            this.isDirectory = before != null ? before.getFile().isDirectory() : after.getFile().isDirectory();
        }

        @Override
        public int compareTo(@NotNull ChangeInfo o) {
            if (o == null) {
                ChangeInfo.$$$reportNull$$$0(0);
            }
            return StringUtil.compare((String)this.beforePath, (String)o.beforePath, (boolean)SystemInfo.isFileSystemCaseSensitive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory$ChangeInfo", "compareTo"));
        }
    }
}

