/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.chain;

import ai.grazie.detector.ChainLanguageDetector;
import ai.grazie.detector.DetectedLanguage;
import ai.grazie.detector.LanguageDetector;
import ai.grazie.detector.LanguageFilter;
import ai.grazie.detector.chain.ChainDetectorImpl;
import ai.grazie.detector.heuristics.list.ListDetector;
import ai.grazie.detector.heuristics.rule.RuleDetector;
import ai.grazie.detector.heuristics.rule.RuleFilter;
import ai.grazie.detector.ngram.NgramDetector;
import ai.grazie.detector.ngram.NgramDetectorBuilder;
import ai.grazie.detector.ngram.WordBloomFilter;
import ai.grazie.detector.utils.StatisticsKt;
import ai.grazie.detector.utils.UtilsKt;
import ai.grazie.detector.utils.filter.TextFilter;
import ai.grazie.nlp.langs.Language;
import ai.grazie.utils.CollectionFactory;
import ai.grazie.utils.CollectionsKt;
import ai.grazie.utils.mpp.DataLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'BQ\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0016\u0010!\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0005H\u0016R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lai/grazie/detector/chain/ChainDetectorImpl;", "Lai/grazie/detector/ChainLanguageDetector;", "", "languages", "Ljava/util/LinkedHashSet;", "Lai/grazie/nlp/langs/Language;", "Lkotlin/collections/LinkedHashSet;", "rule", "Lai/grazie/detector/heuristics/rule/RuleDetector;", "list", "Lai/grazie/detector/heuristics/list/ListDetector;", "filter", "Lai/grazie/detector/heuristics/rule/RuleFilter;", "ngram", "Lai/grazie/detector/ngram/NgramDetector;", "blooms", "", "Lai/grazie/detector/ngram/WordBloomFilter;", "(Ljava/util/LinkedHashSet;Lai/grazie/detector/heuristics/rule/RuleDetector;Lai/grazie/detector/heuristics/list/ListDetector;Lai/grazie/detector/heuristics/rule/RuleFilter;Lai/grazie/detector/ngram/NgramDetector;Ljava/util/Map;)V", "detectWithDetails", "Lai/grazie/detector/chain/ChainDetectorImpl$CommentedChainDetectionResult;", "input", "isReliable", "", "hasTooLowDetectableFraction", "text", "", "hasTooManyUnknownWords", "language", "isMixedLanguageText", "isOnlyRecognizedByLanguage", "word", "recognizedByLanguage", "tooShortWordsForNaturalText", "words", "", "vetoes", "detected", "CommentedChainDetectionResult", "Companion", "nlp-detect"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nChainDetectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainDetectorImpl.kt\nai/grazie/detector/chain/ChainDetectorImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,143:1\n12364#2,2:144\n1734#3,3:146\n774#3:149\n865#3,2:150\n774#3:152\n865#3,2:153\n2632#3,3:155\n774#3:158\n865#3,2:159\n774#3:161\n865#3,2:162\n1279#3,2:164\n1293#3,2:166\n774#3:168\n865#3,2:169\n1296#3:171\n503#4,7:172\n503#4,7:179\n*S KotlinDebug\n*F\n+ 1 ChainDetectorImpl.kt\nai/grazie/detector/chain/ChainDetectorImpl\n*L\n79#1:144,2\n106#1:146,3\n113#1:149\n113#1:150,2\n126#1:152\n126#1:153,2\n127#1:155,3\n131#1:158\n131#1:159,2\n132#1:161\n132#1:162,2\n133#1:164,2\n133#1:166,2\n133#1:168\n133#1:169,2\n133#1:171\n133#1:172,7\n134#1:179,7\n*E\n"})
public final class ChainDetectorImpl
extends ChainLanguageDetector<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashSet<Language> languages;
    @NotNull
    private final RuleDetector rule;
    @NotNull
    private final ListDetector list;
    @NotNull
    private final RuleFilter filter;
    @NotNull
    private final NgramDetector ngram;
    @NotNull
    private final Map<Language, WordBloomFilter> blooms;

    public ChainDetectorImpl(@NotNull LinkedHashSet<Language> languages2, @NotNull RuleDetector rule, @NotNull ListDetector list, @NotNull RuleFilter filter2, @NotNull NgramDetector ngram, @NotNull Map<Language, WordBloomFilter> blooms) {
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)ngram, (String)"ngram");
        Intrinsics.checkNotNullParameter(blooms, (String)"blooms");
        this.languages = languages2;
        this.rule = rule;
        this.list = list;
        this.filter = filter2;
        this.ngram = ngram;
        this.blooms = blooms;
    }

    @NotNull
    public CommentedChainDetectionResult detectWithDetails(@NotNull String input, boolean isReliable) {
        boolean bl;
        LanguageFilter.FilterResult ruleFiltering;
        LanguageDetector.DetectionResult freqDetection;
        LanguageDetector.DetectionResult rulesDetection;
        LinkedHashSet<LanguageDetector.DetectionResult> all2;
        List<String> words2;
        CharSequence textWithoutPrefix;
        CharSequence text2;
        ArrayList<Object> comments;
        block14: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            comments = new ArrayList<Object>();
            CharSequence charSequence = text2 = isReliable ? TextFilter.Companion.getReliable().filter(input) : TextFilter.Companion.getDefault().filter(input);
            if (this.hasTooLowDetectableFraction(text2, input)) {
                comments.add("hasTooLowDetectableFraction");
                return new CommentedChainDetectionResult(LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.Rule), new LinkedHashSet<LanguageDetector.DetectionResult>(), (List<String>)comments);
            }
            textWithoutPrefix = UtilsKt.dropPrefix(text2);
            words2 = isReliable ? UtilsKt.wordsLower(textWithoutPrefix) : UtilsKt.wordsLower(text2);
            all2 = new LinkedHashSet<LanguageDetector.DetectionResult>();
            rulesDetection = this.rule.detect(words2, isReliable);
            ((Collection)all2).add(rulesDetection);
            if (rulesDetection.getPreferred() != Language.UNKNOWN) {
                return new CommentedChainDetectionResult(rulesDetection, all2, (List<String>)comments);
            }
            freqDetection = this.list.detect(isReliable ? textWithoutPrefix : text2, isReliable);
            ((Collection)all2).add(freqDetection);
            if (freqDetection.getPreferred() != Language.UNKNOWN && this.hasTooManyUnknownWords(text2, freqDetection.getPreferred())) {
                comments.add("Vetoed List " + freqDetection.getPreferred() + " via hasTooManyUnknownWords");
                freqDetection = LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.List);
            }
            if (freqDetection.getPreferred() != Language.UNKNOWN) {
                if (freqDetection.getDetected().length > 1 && freqDetection.getDetected()[1].getProbability() > 0.5) {
                    double firstDelta = freqDetection.getDetected()[0].getProbability() - freqDetection.getDetected()[1].getProbability();
                    if (firstDelta > 0.1) {
                        return new CommentedChainDetectionResult(freqDetection, all2, (List<String>)comments);
                    }
                    comments.add("Skipped List due to too similar top results for " + freqDetection.getDetected()[0].getLang() + " and " + freqDetection.getDetected()[1].getLang());
                } else {
                    return new CommentedChainDetectionResult(freqDetection, all2, (List<String>)comments);
                }
            }
            ruleFiltering = this.filter.filter(words2);
            DetectedLanguage[] $this$all$iv = ruleFiltering.getDetected();
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                DetectedLanguage element$iv;
                DetectedLanguage it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (!this.languages.contains((Object)it.getLang())) continue;
                bl = false;
                break block14;
            }
            bl = true;
        }
        if (bl) {
            return new CommentedChainDetectionResult(freqDetection, all2, (List<String>)comments);
        }
        if (this.tooShortWordsForNaturalText(words2)) {
            comments.add("tooShortWordsForNaturalText");
            return new CommentedChainDetectionResult(LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.Rule), new LinkedHashSet<LanguageDetector.DetectionResult>(), (List<String>)comments);
        }
        DetectedLanguage[][] $i$f$all = new DetectedLanguage[][]{freqDetection.getDetected(), ruleFiltering.getDetected()};
        Map<Language, Double> weights = StatisticsKt.toMap(kotlin.collections.CollectionsKt.toList((Iterable)StatisticsKt.unite(rulesDetection.getDetected(), $i$f$all)));
        LanguageDetector.DetectionResult ngramDetection = this.ngram.detect(isReliable ? textWithoutPrefix : text2, isReliable, weights);
        ((Collection)all2).add(ngramDetection);
        if (ngramDetection.getPreferred() != Language.UNKNOWN) {
            if (this.hasTooManyUnknownWords(text2, ngramDetection.getPreferred())) {
                comments.add("Vetoed Ngram " + ngramDetection.getPreferred() + " via hasTooManyUnknownWords");
                ngramDetection = LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.Ngram);
            } else if (this.isMixedLanguageText(text2)) {
                comments.add("Vetoed Ngram " + ngramDetection.getPreferred() + " via isMixedLanguageText");
                ngramDetection = LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.Ngram);
            }
        }
        return new CommentedChainDetectionResult(ngramDetection, all2, (List<String>)comments);
    }

    private final boolean tooShortWordsForNaturalText(List<String> words2) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = words2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (it.length() == 1) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean hasTooLowDetectableFraction(CharSequence text2, String input) {
        return text2.length() < input.length() / 5;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTooManyUnknownWords(CharSequence text2, Language language) {
        void $this$filterTo$iv$iv;
        WordBloomFilter wordBloomFilter = this.blooms.get((Object)language);
        if (wordBloomFilter == null) {
            return false;
        }
        WordBloomFilter bloom = wordBloomFilter;
        List<String> words2 = UtilsKt.wordsLower(text2);
        Iterable $this$filter$iv = words2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(it.length() <= 10 && language.getAlphabet().matchAny(it) && !bloom.mayContain(it) && !this.list.mayBeTypo(language, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unknown = (List)destination$iv$iv;
        double score = (double)kotlin.collections.CollectionsKt.distinct((Iterable)unknown).size() / (double)words2.size();
        return score > 0.15;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean recognizedByLanguage(String word, Language language) {
        if (!language.getAlphabet().matchEntire(word)) return false;
        WordBloomFilter wordBloomFilter = this.blooms.get((Object)language);
        Intrinsics.checkNotNull((Object)wordBloomFilter);
        if (wordBloomFilter.mayContain(word)) return true;
        if (!this.list.mayBeTypo(language, word)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOnlyRecognizedByLanguage(String word, Language language) {
        Language it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.languages;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Language it2 = (Language)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it2 != language && WordBloomFilter.Companion.getSupported().contains((Object)it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherLanguages = (List)destination$iv$iv;
        if (!this.recognizedByLanguage(word, language)) return false;
        Iterable $this$none$iv = otherLanguages;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        object = $this$none$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            it = (Language)((Object)element$iv);
            boolean bl = false;
        } while (!this.recognizedByLanguage(word, it));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMixedLanguageText(CharSequence text2) {
        Map langMap;
        Map $this$filterValues$iv;
        Map $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = UtilsKt.wordsLower(text2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(it.length() <= 10)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List words2 = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = this.languages;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            if (!WordBloomFilter.Companion.getSupported().contains((Object)it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv3;
            Language it = (Language)((Object)element$iv$iv);
            Object e = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv3 = words2;
            boolean $i$f$filter3 = false;
            Iterable iterable2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                void language;
                String it2 = (String)element$iv$iv2;
                boolean bl2 = false;
                if (!this.isOnlyRecognizedByLanguage(it2, (Language)language)) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            Integer n = ((List)destination$iv$iv3).size();
            map.put(e, n);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!(it != 0)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = langMap = (Map)result$iv;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!(it > (int)Math.ceil((double)words2.size() * 0.1))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).size() > 1;
    }

    @Override
    public boolean vetoes(@NotNull String input, @NotNull Language detected) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)((Object)detected), (String)"detected");
        return this.hasTooManyUnknownWords(TextFilter.Companion.getReliable().filter(input), detected);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0005j\b\u0012\u0004\u0012\u00020\u0003`\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lai/grazie/detector/chain/ChainDetectorImpl$CommentedChainDetectionResult;", "Lai/grazie/detector/ChainLanguageDetector$ChainDetectionResult;", "result", "Lai/grazie/detector/LanguageDetector$DetectionResult;", "all", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "comments", "", "", "(Lai/grazie/detector/LanguageDetector$DetectionResult;Ljava/util/LinkedHashSet;Ljava/util/List;)V", "getComments", "()Ljava/util/List;", "nlp-detect"})
    public static final class CommentedChainDetectionResult
    extends ChainLanguageDetector.ChainDetectionResult {
        @NotNull
        private final List<String> comments;

        public CommentedChainDetectionResult(@NotNull LanguageDetector.DetectionResult result2, @NotNull LinkedHashSet<LanguageDetector.DetectionResult> all2, @NotNull List<String> comments) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Intrinsics.checkNotNullParameter(all2, (String)"all");
            Intrinsics.checkNotNullParameter(comments, (String)"comments");
            super(result2, all2);
            this.comments = comments;
        }

        @NotNull
        public final List<String> getComments() {
            return this.comments;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lai/grazie/detector/chain/ChainDetectorImpl$Companion;", "", "()V", "create", "Lai/grazie/detector/ChainLanguageDetector;", "", "languages", "Ljava/util/LinkedHashSet;", "Lai/grazie/nlp/langs/Language;", "Lkotlin/collections/LinkedHashSet;", "loader", "Lai/grazie/utils/mpp/DataLoader;", "(Ljava/util/LinkedHashSet;Lai/grazie/utils/mpp/DataLoader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nlp-detect"})
    @SourceDebugExtension(value={"SMAP\nChainDetectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainDetectorImpl.kt\nai/grazie/detector/chain/ChainDetectorImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n774#2:144\n865#2,2:145\n774#2:147\n865#2,2:148\n774#2:150\n865#2,2:151\n774#2:153\n865#2,2:154\n*S KotlinDebug\n*F\n+ 1 ChainDetectorImpl.kt\nai/grazie/detector/chain/ChainDetectorImpl$Companion\n*L\n29#1:144\n29#1:145,2\n30#1:147\n30#1:148,2\n32#1:150\n32#1:151,2\n34#1:153\n34#1:154,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final Object create(@NotNull LinkedHashSet<Language> var1_1, @NotNull DataLoader var2_2, @NotNull Continuation<? super ChainLanguageDetector<String>> $completion) {
            if (!($completion instanceof create.1)) ** GOTO lbl-1000
            var22_4 = $completion;
            if ((var22_4.label & -2147483648) != 0) {
                var22_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.create(null, null, (Continuation<? super ChainLanguageDetector<String>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var24_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$filter$iv = languages;
                    $i$f$filter = false;
                    var7_10 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Language)element$iv$iv;
                        $i$a$-filter-ChainDetectorImpl$Companion$create$rule$1 = false;
                        if (!RuleDetector.Companion.getSupported().contains((Object)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    var23_31 = CollectionsKt.toLinkedSet((List)destination$iv$iv);
                    rule = new RuleDetector(var23_31);
                    $i$f$filter = languages;
                    var18_33 = ListDetector.Companion;
                    $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (E element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Language)element$iv$iv;
                        $i$a$-filter-ChainDetectorImpl$Companion$create$list$1 = false;
                        if (!ListDetector.Companion.getSupported().contains((Object)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $continuation.L$0 = languages;
                    $continuation.L$1 = loader;
                    $continuation.L$2 = rule;
                    $continuation.label = 1;
                    v0 = var18_33.create(CollectionsKt.toLinkedSet((List)destination$iv$iv), loader, (Continuation<? super ListDetector>)$continuation);
                    if (v0 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl53
                }
                case 1: {
                    rule = (RuleDetector)$continuation.L$2;
                    loader = (DataLoader)$continuation.L$1;
                    languages = (LinkedHashSet)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl53:
                    // 2 sources

                    list = (ListDetector)v0;
                    filter = new RuleFilter(languages);
                    $this$filterTo$iv$iv = languages;
                    var19_37 /* !! */  = loader;
                    var18_33 = NgramDetectorBuilder.Companion;
                    $i$f$filter = false;
                    $i$f$filterTo = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Language)element$iv$iv;
                        $i$a$-filter-ChainDetectorImpl$Companion$create$ngram$1 = false;
                        if (!NgramDetector.Companion.getSupported().contains((Object)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    var20_41 = (List)destination$iv$iv;
                    $continuation.L$0 = languages;
                    $continuation.L$1 = loader;
                    $continuation.L$2 = rule;
                    $continuation.L$3 = list;
                    $continuation.L$4 = filter;
                    $continuation.label = 2;
                    v1 = var18_33.standardForLanguage((DataLoader)var19_37 /* !! */ , CollectionsKt.toLinkedSet((Iterable)var20_41), (Continuation<? super NgramDetector>)$continuation);
                    if (v1 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl88
                }
                case 2: {
                    filter = (RuleFilter)$continuation.L$4;
                    list = (ListDetector)$continuation.L$3;
                    rule = (RuleDetector)$continuation.L$2;
                    loader = (DataLoader)$continuation.L$1;
                    languages = (LinkedHashSet)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl88:
                    // 2 sources

                    ngram = (NgramDetector)v1;
                    $this$filter$iv = languages;
                    $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Language)element$iv$iv;
                        $i$a$-filter-ChainDetectorImpl$Companion$create$supportedLanguages$1 = false;
                        if (!WordBloomFilter.Companion.getSupported().contains((Object)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    supportedLanguages = (List)destination$iv$iv;
                    blooms = CollectionFactory.INSTANCE.smallMemoryFootprintMap(supportedLanguages.size());
                    var10_22 = supportedLanguages.iterator();
lbl104:
                    // 2 sources

                    while (var10_22.hasNext()) {
                        var19_37 /* !! */  = language = (Language)var10_22.next();
                        var18_33 = blooms;
                        $continuation.L$0 = languages;
                        $continuation.L$1 = loader;
                        $continuation.L$2 = rule;
                        $continuation.L$3 = list;
                        $continuation.L$4 = filter;
                        $continuation.L$5 = ngram;
                        $continuation.L$6 = blooms;
                        $continuation.L$7 = var10_22;
                        $continuation.L$8 = var18_33;
                        $continuation.L$9 = var19_37 /* !! */ ;
                        $continuation.label = 3;
                        v2 = WordBloomFilter.Companion.load(language, loader, (Continuation<? super WordBloomFilter>)$continuation);
                        if (v2 == var24_6) {
                            return var24_6;
                        }
                        ** GOTO lbl136
                    }
                    break;
                }
                case 3: {
                    var19_37 /* !! */  = (Language)$continuation.L$9;
                    var18_33 = (Map)$continuation.L$8;
                    var10_22 = (Iterator<E>)$continuation.L$7;
                    blooms = (Map<Language, WordBloomFilter>)$continuation.L$6;
                    ngram = (NgramDetector)$continuation.L$5;
                    filter = (RuleFilter)$continuation.L$4;
                    list = (ListDetector)$continuation.L$3;
                    rule = (RuleDetector)$continuation.L$2;
                    loader = (DataLoader)$continuation.L$1;
                    languages = (LinkedHashSet)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl136:
                    // 2 sources

                    var20_41 = v2;
                    var18_33.put(var19_37 /* !! */ , (WordBloomFilter)var20_41);
                    ** GOTO lbl104
                }
            }
            return new ChainDetectorImpl(languages, rule, list, filter, ngram, blooms);
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

