/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.Tools;

public class CompoundRule
extends AbstractCompoundRule {
    private static volatile CompoundRuleData compoundData;
    private static final Language AMERICAN_ENGLISH;
    private static final List<DisambiguationPatternRule> ANTI_PATTERNS;
    private final Language english;

    public CompoundRule(ResourceBundle messages, Language english, UserConfig userConfig) throws IOException {
        super(messages, english, userConfig, "This word is normally spelled with a hyphen.", "This word is normally spelled as one.", "This expression is normally spelled as one or with a hyphen.", "Compound");
        this.english = english;
        super.useSubRuleSpecificIds();
        this.addExamplePair(Example.wrong("I now have a <marker>part time</marker> job."), Example.fixed("I now have a <marker>part-time</marker> job."));
        this.setUrl(Tools.getUrl("https://languagetool.org/insights/post/hyphen/"));
    }

    @Override
    public String getId() {
        return "EN_COMPOUNDS";
    }

    @Override
    public String getDescription() {
        return "Hyphenated words: $match";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundRuleData getCompoundRuleData() {
        CompoundRuleData data2 = compoundData;
        if (data2 != null) return data2;
        Class<CompoundRule> clazz = CompoundRule.class;
        synchronized (CompoundRule.class) {
            data2 = compoundData;
            if (data2 != null) return data2;
            compoundData = data2 = new CompoundRuleData("/en/compounds.txt");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data2;
        }
    }

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        return ANTI_PATTERNS;
    }

    @Override
    public boolean isMisspelled(String word) throws IOException {
        return Objects.requireNonNull(this.english.getDefaultSpellingRule()).isMisspelled(word);
    }

    static {
        AMERICAN_ENGLISH = Languages.getLanguageForShortCode("en-US");
        ANTI_PATTERNS = CompoundRule.makeAntiPatterns(Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.tokenRegex("['\u2019`\u00b4\u2018]"), PatternRuleBuilderHelper.token("re")), Arrays.asList(new PatternTokenBuilder().posRegex("SENT_START|CC|PCT").build(), PatternRuleBuilderHelper.tokenRegex("we|you|they|I|s?he|it"), PatternRuleBuilderHelper.token("well"), new PatternTokenBuilder().posRegex("VB.*").build()), Arrays.asList(PatternRuleBuilderHelper.token("how"), PatternRuleBuilderHelper.token("well"), new PatternTokenBuilder().posRegex("VB.*").build()), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("and|&"), PatternRuleBuilderHelper.token("co")), Arrays.asList(PatternRuleBuilderHelper.token("power"), PatternRuleBuilderHelper.token("off"), PatternRuleBuilderHelper.token("key")), Arrays.asList(PatternRuleBuilderHelper.token("see"), PatternRuleBuilderHelper.token("saw"), PatternRuleBuilderHelper.token("seen")), Arrays.asList(PatternRuleBuilderHelper.token("forward"), PatternRuleBuilderHelper.token("looking"), new PatternTokenBuilder().posRegex("IN|TO").build()), Arrays.asList(PatternRuleBuilderHelper.token("store"), PatternRuleBuilderHelper.token("front"), PatternRuleBuilderHelper.tokenRegex("doors?")), Arrays.asList(PatternRuleBuilderHelper.token("from"), PatternRuleBuilderHelper.token("surface"), PatternRuleBuilderHelper.token("to"), PatternRuleBuilderHelper.token("surface")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("senior|junior"), PatternRuleBuilderHelper.token("year"), PatternRuleBuilderHelper.token("end")), Arrays.asList(PatternRuleBuilderHelper.token("under"), PatternRuleBuilderHelper.token("investment"), PatternRuleBuilderHelper.token("banking")), Arrays.asList(PatternRuleBuilderHelper.token("spring"), PatternRuleBuilderHelper.tokenRegex("cleans?|cleaned|cleaning"), PatternRuleBuilderHelper.tokenRegex("up|the|my|our|his|her")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex("series?"), PatternRuleBuilderHelper.tokenRegex("a")), Arrays.asList(PatternRuleBuilderHelper.token("hard"), PatternRuleBuilderHelper.token("time"), new PatternTokenBuilder().pos("VBG").build()), Arrays.asList(PatternRuleBuilderHelper.token("first"), PatternRuleBuilderHelper.tokenRegex("ever"), PatternRuleBuilderHelper.tokenRegex("green")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex(".+"), PatternRuleBuilderHelper.token("."), PatternRuleBuilderHelper.tokenRegex("(com|io|de|nl|co|net|org|es)"))), AMERICAN_ENGLISH);
    }
}

