/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tec.uom.lib.common.function.ValueSupplier;
import tech.units.indriya.AbstractConverter;

public final class AddConverter
extends AbstractConverter
implements ValueSupplier<Double> {
    private static final long serialVersionUID = -2981335308595652284L;
    private final double offset;

    public AddConverter(double offset) {
        this.offset = offset;
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    public boolean isIdentity() {
        return this.offset == 0.0;
    }

    @Override
    protected boolean isSimpleCompositionWith(AbstractConverter that) {
        return that instanceof AddConverter;
    }

    @Override
    protected AbstractConverter simpleCompose(AbstractConverter that) {
        return new AddConverter(this.offset + ((AddConverter)that).offset);
    }

    @Override
    public AddConverter inverseWhenNotIdentity() {
        return new AddConverter(-this.offset);
    }

    @Override
    public double convertWhenNotIdentity(double value) {
        return value + this.offset;
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.add(BigDecimal.valueOf(this.offset), ctx);
    }

    @Override
    public String transformationLiteral() {
        return String.format("x -> x %s %s", this.offset < 0.0 ? "-" : "+", Math.abs(this.offset));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AddConverter) {
            AddConverter other = (AddConverter)obj;
            return Objects.equals(this.offset, other.offset);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.offset);
    }

    @Override
    public boolean isLinear() {
        return this.isIdentity();
    }

    @Override
    public Double getValue() {
        return this.offset;
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof AddConverter) {
            return this.getValue().compareTo(((AddConverter)o).getValue());
        }
        return -1;
    }
}

