/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputSelectorDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final LanguageFileType myFileType;
    protected JPanel myMainPanel;
    private NameSuggestionsField selectorField;

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.selectorField;
    }

    public InputSelectorDialog(@NotNull Project project, @NotNull LanguageFileType targetFileType, String[] selectorVariants) {
        if (project == null) {
            InputSelectorDialog.$$$reportNull$$$0(0);
        }
        if (targetFileType == null) {
            InputSelectorDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myProject = project;
        this.myFileType = targetFileType;
        this.setTitle(CssBundle.message("create.selector.dialog.title", new Object[0]));
        this.setModal(true);
        this.setupControls(selectorVariants);
        this.init();
    }

    private void setupControls(String[] suggestions) {
        this.selectorField = new NameSuggestionsField(suggestions, this.myProject, (FileType)this.myFileType);
        this.myMainPanel = JBUI.Panels.simplePanel((Component)this.selectorField);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String editorValue = this.selectorField.getEnteredName();
        if (StringUtil.isEmptyOrSpaces((String)editorValue) || !this.isSelectorValid(editorValue, this.myFileType)) {
            return new ValidationInfo(CssBundle.message("create.selector.dialog.error.message", new Object[0]), (JComponent)this.selectorField);
        }
        return super.doValidate();
    }

    private boolean isSelectorValid(@NotNull String value, LanguageFileType fileType) {
        if (value == null) {
            InputSelectorDialog.$$$reportNull$$$0(2);
        }
        try {
            CssSelectorList list = CssElementFactory.getInstance(this.myProject).createSelectorList(value, fileType.getLanguage());
            return value.trim().equals(list.getText());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @NotNull
    public String getValue() {
        String string = this.selectorField.getEnteredName();
        if (string == null) {
            InputSelectorDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/ruleset/InputSelectorDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/ruleset/InputSelectorDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelectorValid";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

