/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt;

import com.intellij.dbt.DbtUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.FileSearchUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/dbt/DbtDirectories;", "", "<init>", "()V", "Companion", "intellij.dbt"})
public final class DbtDirectories {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dbt/DbtDirectories$Companion;", "", "<init>", "()V", "getModelsDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getSeedsDirectory", "getModelFileName", "", "modelName", "getSeedFileName", "findModel", "Lcom/intellij/psi/PsiFile;", "findSeedFile", "seedName", "intellij.dbt"})
    public static final class Companion {
        private Companion() {
        }

        private final VirtualFile getModelsDirectory(Module module) {
            VirtualFile virtualFile = DbtUtils.Companion.getDbtDirectory(module);
            return virtualFile != null ? VirtualFileUtil.findDirectory((VirtualFile)virtualFile, (String)"models") : null;
        }

        private final VirtualFile getSeedsDirectory(Module module) {
            VirtualFile virtualFile = DbtUtils.Companion.getDbtDirectory(module);
            return virtualFile != null ? VirtualFileUtil.findDirectory((VirtualFile)virtualFile, (String)"seeds") : null;
        }

        private final String getModelFileName(String modelName) {
            return modelName + ".sql";
        }

        private final String getSeedFileName(String modelName) {
            return modelName + ".csv";
        }

        @Nullable
        public final PsiFile findModel(@NotNull String modelName, @NotNull Module module) {
            PsiFile psiFile;
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile virtualFile2 = this.getModelsDirectory(module);
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile modelsDirectory = virtualFile2;
            VirtualFile virtualFile3 = virtualFile = (VirtualFile)FileSearchUtil.findFileRecursively((VirtualFile)modelsDirectory, (String)this.getModelFileName(modelName), (int)5, (long)1000L).findFirst();
            if (virtualFile3 != null) {
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                psiFile = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile3, (Project)project);
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        @Nullable
        public final PsiFile findSeedFile(@NotNull String seedName, @NotNull Module module) {
            PsiFile psiFile;
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)seedName, (String)"seedName");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile virtualFile2 = this.getSeedsDirectory(module);
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile seedsDirectory = virtualFile2;
            VirtualFile virtualFile3 = virtualFile = (VirtualFile)FileSearchUtil.findFileRecursively((VirtualFile)seedsDirectory, (String)this.getSeedFileName(seedName), (int)5, (long)1000L).findFirst();
            if (virtualFile3 != null) {
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                psiFile = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile3, (Project)project);
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

