/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.run;

import com.intellij.dbt.console.commands.DbtCommand;
import com.intellij.dbt.fus.DbtRunConfigurationCounterCollector;
import com.intellij.dbt.run.DbtRunConfigurationEditor;
import com.intellij.dbt.run.DbtRunConfigurationKt;
import com.intellij.dbt.run.DbtRunConfigurationOptions;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ModuleBasedConfigurationOptions;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessHandlerFactory;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000e2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/dbt/run/DbtRunConfiguration;", "Lcom/intellij/execution/configurations/ModuleBasedConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationModule;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "configurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "getOptions", "Lcom/intellij/dbt/run/DbtRunConfigurationOptions;", "getDbtOption", "setDbtCommand", "", "dbtCommand", "Lcom/intellij/dbt/console/commands/DbtCommand;", "setDbtArguments", "dbtAdditionalArguments", "", "", "getDbtCommand", "isForFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getConfigurationEditor", "Lcom/intellij/dbt/run/DbtRunConfigurationEditor;", "getValidModules", "", "Lcom/intellij/openapi/module/Module;", "intellij.dbt"})
public final class DbtRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule, Element> {
    public DbtRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory configurationFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurationFactory, (String)"configurationFactory");
        super(new RunConfigurationModule(project), configurationFactory);
    }

    @NotNull
    protected DbtRunConfigurationOptions getOptions() {
        ModuleBasedConfigurationOptions moduleBasedConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)moduleBasedConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.dbt.run.DbtRunConfigurationOptions");
        return (DbtRunConfigurationOptions)moduleBasedConfigurationOptions;
    }

    @NotNull
    public final DbtRunConfigurationOptions getDbtOption() {
        return this.getOptions();
    }

    public final void setDbtCommand(@NotNull DbtCommand dbtCommand) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbtCommand), (String)"dbtCommand");
        this.getOptions().setDbtCommand(dbtCommand);
    }

    public final void setDbtArguments(@NotNull List<String> dbtAdditionalArguments) {
        Intrinsics.checkNotNullParameter(dbtAdditionalArguments, (String)"dbtAdditionalArguments");
        this.getOptions().setDbtAdditionalArguments(CollectionsKt.toMutableList((Collection)dbtAdditionalArguments));
    }

    public static /* synthetic */ void setDbtArguments$default(DbtRunConfiguration dbtRunConfiguration, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        dbtRunConfiguration.setDbtArguments(list);
    }

    @Nullable
    public final DbtCommand getDbtCommand() {
        return this.getOptions().getDbtCommand();
    }

    public final boolean isForFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int n = this.getOptions().getDbtAdditionalArguments().size() - 1;
        for (int i = 0; i < n; ++i) {
            if (!DbtRunConfigurationKt.getDBT_COMMAND_ARGUMENT_SELECT_VARIANTS().contains(this.getOptions().getDbtAdditionalArguments().get(i))) continue;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return StringsKt.endsWith$default((String)string, (String)this.getOptions().getDbtAdditionalArguments().get(i + 1), (boolean)false, (int)2, null);
        }
        return false;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Module module = this.getConfigurationModule().getModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        return (RunProfileState)new CommandLineState(environment, this, module2){
            final /* synthetic */ DbtRunConfiguration this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super($environment);
            }

            protected ProcessHandler startProcess() {
                DbtRunConfigurationCounterCollector.INSTANCE.logRunEvent(this.this$0.getDbtOption().getCommand());
                Map<String, String> envVars = this.this$0.getDbtOption().getEnvVars();
                GeneralCommandLine generalCommandLine = this.this$0.getDbtOption().getCommandLine(this.$module).withEnvironment(envVars);
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withEnvironment(...)");
                GeneralCommandLine commandLine = generalCommandLine;
                OSProcessHandler oSProcessHandler = ProcessHandlerFactory.getInstance().createColoredProcessHandler(commandLine);
                Intrinsics.checkNotNullExpressionValue((Object)oSProcessHandler, (String)"createColoredProcessHandler(...)");
                OSProcessHandler processHandler = oSProcessHandler;
                ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler));
                return (ProcessHandler)processHandler;
            }
        };
    }

    @NotNull
    public DbtRunConfigurationEditor getConfigurationEditor() {
        return new DbtRunConfigurationEditor();
    }

    @NotNull
    public Collection<Module> getValidModules() {
        return new ArrayList();
    }
}

