/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting.dictionary;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.generator.SpellCheckerDictionaryGenerator;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JSGenerateDictionaryAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile nodeModules;
        Project project;
        if (e == null) {
            JSGenerateDictionaryAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        VirtualFile projectRoot = project.getBasePath() != null ? VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)project.getBasePath())) : null;
        VirtualFile virtualFile = nodeModules = projectRoot != null ? projectRoot.findChild("node_modules") : null;
        if (nodeModules == null) {
            return;
        }
        final ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        SpellCheckerDictionaryGenerator generator = new SpellCheckerDictionaryGenerator(project, project.getBasePath() + "/dicts", "javascript"){

            protected void processFile(PsiFile file, final HashSet<String> seenNames) {
                if (index.isExcluded(file.getVirtualFile())) {
                    return;
                }
                if (!(file instanceof JSFile)) {
                    return;
                }
                file.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                    @Override
                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof JSNamedElement) {
                            if (element instanceof JSVariable && ((JSVariable)element).isLocal()) {
                                return;
                            }
                            this.processLeafsNames(element, seenNames);
                        }
                        super.visitElement(element);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/dictionary/JSGenerateDictionaryAction$1$1", "visitElement"));
                    }
                });
                VirtualFile root = NodeModuleUtil.findMainModuleRoot(project, file.getVirtualFile());
                if (root != null) {
                    String name = root.getName();
                    PlainTextSplitter.getInstance().split(name, new TextRange(0, name.length()), range -> this.addSeenWord(seenNames, range.substring(name), (Language)JavascriptLanguage.INSTANCE));
                }
            }

            protected void addSeenWord(HashSet<String> seenNames, String word, Language language) {
                if (word.startsWith("\u0275")) {
                    return;
                }
                super.addSeenWord(seenNames, word, language);
            }
        };
        generator.addFolder("javascript", LocalFileSystem.getInstance().findFileByIoFile(TypeScriptUtil.getTypeScriptExternalFolderFile()));
        for (VirtualFile module : nodeModules.getChildren()) {
            generator.addFolder(module.getName(), module);
        }
        generator.generate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/highlighting/dictionary/JSGenerateDictionaryAction", "actionPerformed"));
    }
}

