/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split.diff;

import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.platform.vcs.common.split.TextDiffSettingsExKt;
import com.intellij.platform.vcs.frontend.split.diff.DiffEditorHighlightingSynchronizer;
import com.intellij.platform.vcs.frontend.split.diff.UnifiedBlocksModel;
import com.intellij.platform.vcs.frontend.split.diff.UnifiedChangedBlock;
import com.intellij.platform.vcs.frontend.split.diff.UtilKt;
import com.intellij.util.IntPair;
import com.jetbrains.rd.ide.model.BeUnifiedDiffViewer;
import com.jetbrains.rd.ide.model.DiffFoldingSettings;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.thinclient.editors.gutter.ThinClientEditorGutterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntPredicate;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker;", "", "viewModel", "Lcom/jetbrains/rd/ide/model/BeUnifiedDiffViewer;", "contentPanel", "Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/ide/model/BeUnifiedDiffViewer;Ljavax/swing/JComponent;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getViewModel", "()Lcom/jetbrains/rd/ide/model/BeUnifiedDiffViewer;", "getContentPanel", "()Ljavax/swing/JComponent;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "disposable", "Lcom/intellij/openapi/Disposable;", "blocksModel", "Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedBlocksModel;", "foldingModel", "Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker$MyFoldingModel;", "isShouldScrollToCaret", "", "onBlocksChanges", "", "getAllLineRanges", "", "Lcom/intellij/util/IntPair;", "MyFoldingModel", "intellij.platform.vcs.frontend.split"})
@SourceDebugExtension(value={"SMAP\nUnifiedDiffViewerControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnifiedDiffViewerControl.kt\ncom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n774#2:114\n865#2,2:115\n1557#2:117\n1628#2,3:118\n*S KotlinDebug\n*F\n+ 1 UnifiedDiffViewerControl.kt\ncom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker\n*L\n80#1:114\n80#1:115,2\n80#1:117\n80#1:118,3\n*E\n"})
final class UnifiedHighlightingTracker {
    @NotNull
    private final BeUnifiedDiffViewer viewModel;
    @NotNull
    private final JComponent contentPanel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final UnifiedBlocksModel blocksModel;
    @NotNull
    private final MyFoldingModel foldingModel;
    private boolean isShouldScrollToCaret;

    public UnifiedHighlightingTracker(@NotNull BeUnifiedDiffViewer viewModel, @NotNull JComponent contentPanel, @NotNull EditorEx editor, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)contentPanel, (String)"contentPanel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.viewModel = viewModel;
        this.contentPanel = contentPanel;
        this.editor = editor;
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
        this.blocksModel = new UnifiedBlocksModel(lifetime, this.editor, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                UnifiedHighlightingTracker.access$onBlocksChanges((UnifiedHighlightingTracker)this.receiver);
            }
        }));
        this.foldingModel = new MyFoldingModel(this.editor.getProject(), CollectionsKt.listOf((Object)this.editor), this.disposable);
        this.isShouldScrollToCaret = true;
        new DiffEditorHighlightingSynchronizer(lifetime, this.editor);
        Editor editor2 = (Editor)this.editor;
        IntPredicate intPredicate = this.foldingModel.hideLineNumberPredicate(0);
        Intrinsics.checkNotNullExpressionValue((Object)intPredicate, (String)"hideLineNumberPredicate(...)");
        ThinClientEditorGutterManager.Companion.setFoldingHiddenLines(editor2, lifetime, intPredicate);
        this.viewModel.getFoldingSettings().view(lifetime, (arg_0, arg_1) -> UnifiedHighlightingTracker._init_$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public final BeUnifiedDiffViewer getViewModel() {
        return this.viewModel;
    }

    @NotNull
    public final JComponent getContentPanel() {
        return this.contentPanel;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    private final void onBlocksChanges() {
        DiffFoldingSettings diffFoldingSettings = (DiffFoldingSettings)this.viewModel.getFoldingSettings().getValueOrNull();
        if (diffFoldingSettings == null || (diffFoldingSettings = TextDiffSettingsExKt.fromRdModel((DiffFoldingSettings)diffFoldingSettings)) == null) {
            FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings((TextDiffSettingsHolder.TextDiffSettings)TextDiffSettingsHolder.TextDiffSettings.Companion.getSettings());
            diffFoldingSettings = settings;
            Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"getFoldingModelSettings(...)");
        }
        DiffFoldingSettings foldingSettings = diffFoldingSettings;
        FoldingModelSupport.Data foldingState = this.foldingModel.createState(this.getAllLineRanges(), (FoldingModelSupport.Settings)foldingSettings);
        this.foldingModel.updateContext((FoldingModelSupport.Settings)foldingSettings);
        this.foldingModel.install(foldingState, (FoldingModelSupport.Settings)foldingSettings);
        if (this.isShouldScrollToCaret) {
            DiffUtil.scrollToCaret((Editor)((Editor)this.editor), (boolean)false);
            this.isShouldScrollToCaret = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IntPair> getAllLineRanges() {
        void $this$mapTo$iv$iv;
        UnifiedChangedBlock it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.blocksModel.getChangedBlocks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UnifiedChangedBlock)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UnifiedChangedBlock)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilKt.getLineRange(it));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit _init_$lambda$0(UnifiedHighlightingTracker this$0, Lifetime lifetime, DiffFoldingSettings value) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.foldingModel.expandAll(value.isExpandByDefault());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$onBlocksChanges(UnifiedHighlightingTracker $this) {
        $this.onBlocksChanges();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker$MyFoldingModel;", "Lcom/intellij/diff/tools/util/FoldingModelSupport;", "project", "Lcom/intellij/openapi/project/Project;", "editors", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/Disposable;)V", "context", "Lcom/intellij/openapi/util/UserDataHolderBase;", "updateContext", "", "settings", "Lcom/intellij/diff/tools/util/FoldingModelSupport$Settings;", "install", "data", "Lcom/intellij/diff/tools/util/FoldingModelSupport$Data;", "createState", "changedLines", "Lcom/intellij/util/IntPair;", "MyfFoldingBuilder", "intellij.platform.vcs.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nUnifiedDiffViewerControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnifiedDiffViewerControl.kt\ncom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker$MyFoldingModel\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,113:1\n37#2:114\n36#2,3:115\n*S KotlinDebug\n*F\n+ 1 UnifiedDiffViewerControl.kt\ncom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker$MyFoldingModel\n*L\n84#1:114\n84#1:115,3\n*E\n"})
    private final class MyFoldingModel
    extends FoldingModelSupport {
        @NotNull
        private final UserDataHolderBase context;

        public MyFoldingModel(@NotNull Project project, @NotNull List<? extends EditorEx> editors, Disposable disposable) {
            Intrinsics.checkNotNullParameter(editors, (String)"editors");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Collection $this$toTypedArray$iv = editors;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            super(project, thisCollection$iv.toArray(new EditorEx[0]), disposable);
            this.context = new UserDataHolderBase();
        }

        public final void updateContext(@NotNull FoldingModelSupport.Settings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.updateContext((UserDataHolder)this.context, settings);
        }

        public final void install(@Nullable FoldingModelSupport.Data data, @NotNull FoldingModelSupport.Settings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.install(data, (UserDataHolder)this.context, settings);
        }

        @Nullable
        public final FoldingModelSupport.Data createState(@NotNull List<IntPair> changedLines, @NotNull FoldingModelSupport.Settings settings) {
            Intrinsics.checkNotNullParameter(changedLines, (String)"changedLines");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Iterator it = FoldingModelSupport.map(changedLines, arg_0 -> MyFoldingModel.createState$lambda$1(MyFoldingModel::createState$lambda$0, arg_0));
            if (it == null || settings.range == -1) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)this.myEditors, (String)"myEditors");
            MyfFoldingBuilder builder = new MyfFoldingBuilder(this.myEditors, settings);
            return builder.build(it);
        }

        private static final int[] createState$lambda$0(IntPair range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            int[] nArray = new int[]{range.first, range.second};
            return nArray;
        }

        private static final int[] createState$lambda$1(Function1 $tmp0, Object p0) {
            return (int[])$tmp0.invoke(p0);
        }

        public static final /* synthetic */ int[] access$countLines$s242298663(EditorEx[] p0) {
            return FoldingModelSupport.countLines((EditorEx[])p0);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker$MyFoldingModel$MyfFoldingBuilder;", "Lcom/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilderBase;", "editors", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "settings", "Lcom/intellij/diff/tools/util/FoldingModelSupport$Settings;", "<init>", "(Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedHighlightingTracker$MyFoldingModel;[Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/diff/tools/util/FoldingModelSupport$Settings;)V", "getDescription", "Lcom/intellij/diff/tools/util/FoldingModelSupport$FoldedRangeDescription;", "project", "Lcom/intellij/openapi/project/Project;", "lineNumber", "", "index", "intellij.platform.vcs.frontend.split"})
        private final class MyfFoldingBuilder
        extends FoldingModelSupport.FoldingBuilderBase {
            public MyfFoldingBuilder(@NotNull EditorEx[] editors, FoldingModelSupport.Settings settings) {
                Intrinsics.checkNotNullParameter((Object)editors, (String)"editors");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                super(MyFoldingModel.access$countLines$s242298663(editors), settings);
            }

            @Nullable
            protected FoldingModelSupport.FoldedRangeDescription getDescription(@NotNull Project project, int lineNumber, int index) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        }
    }
}

