/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.target.TargetConfigurationWithLocalFsAccess;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.TargetConfigurationWithLocalFsAccessExKt;
import com.jetbrains.python.sdk.AddInterpreterOnTargetAction;
import com.jetbrains.python.sdk.AddLocalInterpreterAction;
import com.jetbrains.python.sdk.ModuleOrProject;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0013"}, d2={"collectAddInterpreterActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "moduleOrProject", "Lcom/jetbrains/python/sdk/ModuleOrProject;", "onSdkCreated", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/projectRoots/Sdk;", "collectNewInterpreterOnTargetActions", "project", "Lcom/intellij/openapi/project/Project;", "targetTypeModuleSitsOn", "Lcom/intellij/execution/target/TargetConfigurationWithLocalFsAccess;", "switchToSdk", "", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "currentSdk", "intellij.python.community.impl"})
@JvmName(name="AddInterpreterActions")
@SourceDebugExtension(value={"SMAP\nAddInterpreterActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddInterpreterActions.kt\ncom/jetbrains/python/sdk/AddInterpreterActions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n774#2:106\n865#2,2:107\n774#2:109\n865#2,2:110\n827#2:112\n855#2,2:113\n1557#2:115\n1628#2,3:116\n*S KotlinDebug\n*F\n+ 1 AddInterpreterActions.kt\ncom/jetbrains/python/sdk/AddInterpreterActions\n*L\n51#1:106\n51#1:107,2\n52#1:109\n52#1:110,2\n54#1:112\n54#1:113,2\n55#1:115\n55#1:116,3\n*E\n"})
public final class AddInterpreterActions {
    @NotNull
    public static final List<AnAction> collectAddInterpreterActions(@NotNull ModuleOrProject moduleOrProject, @NotNull Consumer<Sdk> onSdkCreated) {
        TargetConfigurationWithLocalFsAccess targetConfigurationWithLocalFsAccess;
        Intrinsics.checkNotNullParameter((Object)moduleOrProject, (String)"moduleOrProject");
        Intrinsics.checkNotNullParameter(onSdkCreated, (String)"onSdkCreated");
        Object object = moduleOrProject;
        if (object instanceof ModuleOrProject.ModuleAndProject) {
            targetConfigurationWithLocalFsAccess = PythonInterpreterTargetEnvironmentFactory.Companion.getTargetModuleResidesOn(((ModuleOrProject.ModuleAndProject)moduleOrProject).getModule());
        } else if (object instanceof ModuleOrProject.ProjectOnly) {
            targetConfigurationWithLocalFsAccess = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TargetConfigurationWithLocalFsAccess targetModuleSitsOn = targetConfigurationWithLocalFsAccess;
        Object $this$collectAddInterpreterActions_u24lambda_u240 = object = (List)new ArrayList();
        boolean bl = false;
        if (targetModuleSitsOn == null) {
            $this$collectAddInterpreterActions_u24lambda_u240.add(new AddLocalInterpreterAction(moduleOrProject, onSdkCreated::accept));
        }
        $this$collectAddInterpreterActions_u24lambda_u240.addAll((Collection)AddInterpreterActions.collectNewInterpreterOnTargetActions(moduleOrProject.getProject(), targetModuleSitsOn, onSdkCreated::accept));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<AnAction> collectNewInterpreterOnTargetActions(Project project, TargetConfigurationWithLocalFsAccess targetTypeModuleSitsOn, Consumer<Sdk> onSdkCreated) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        PythonInterpreterTargetEnvironmentFactory it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = PythonInterpreterTargetEnvironmentFactory.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PythonInterpreterTargetEnvironmentFactory)element$iv$iv;
            boolean bl = false;
            if (!it.getTargetType().isSystemCompatible()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PythonInterpreterTargetEnvironmentFactory)element$iv$iv;
            boolean bl = false;
            if (!(targetTypeModuleSitsOn == null || TargetConfigurationWithLocalFsAccessExKt.allowCreationTargetOfThisType(targetTypeModuleSitsOn, it.getTargetType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (PythonInterpreterTargetEnvironmentFactory)element$iv$iv;
            boolean bl = false;
            if (project.isDefault() && it.needAssociateWithModule()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PythonInterpreterTargetEnvironmentFactory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AddInterpreterOnTargetAction(project, it.getTargetType(), onSdkCreated));
        }
        return (List)destination$iv$iv;
    }

    public static final void switchToSdk(@NotNull Module module, @NotNull Sdk sdk2, @Nullable Sdk currentSdk) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        SdkTypeId sdkTypeId = sdk2.getSdkType();
        Intrinsics.checkNotNull((Object)sdkTypeId, (String)"null cannot be cast to non-null type com.jetbrains.python.sdk.PythonSdkType");
        ((PythonSdkType)sdkTypeId).setupSdkPaths(sdk2);
        PyTransferredSdkRootsKt.removeTransferredRootsFromModulesWithInheritedSdk(project2, currentSdk);
        PySdkExtKt.setPythonSdk(project2, sdk2);
        PyTransferredSdkRootsKt.transferRootsToModulesWithInheritedSdk(project2, sdk2);
        PyTransferredSdkRootsKt.removeTransferredRoots(module, currentSdk);
        PySdkExtKt.setPythonSdk(module, sdk2);
        PyTransferredSdkRootsKt.transferRoots(module, sdk2);
    }
}

