/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.common;

import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\bf\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0018J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH&J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H&R\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0019\u00c0\u0006\u0003"}, d2={"Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "RequestType", "Lcom/intellij/httpClient/execution/common/CommonClientRequest;", "", "supportedMethods", "", "", "project", "Lcom/intellij/openapi/project/Project;", "canProcess", "", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "getRequestConverter", "Lcom/intellij/httpClient/execution/common/RequestConverter;", "needsScheme", "getNeedsScheme", "()Z", "supportedSchemes", "", "getSupportedSchemes", "()Ljava/util/List;", "All", "intellij.httpClient.executor"})
public interface RequestExecutionSupport<RequestType extends CommonClientRequest> {
    @NotNull
    public static final All All = com.intellij.httpClient.execution.common.RequestExecutionSupport$All.$$INSTANCE;

    @NotNull
    default public Collection<String> supportedMethods(@Nullable Project project) {
        return this.supportedMethods();
    }

    @NotNull
    public Collection<String> supportedMethods();

    public boolean canProcess(@NotNull RequestContext var1);

    @NotNull
    public RequestHandler<RequestType> getRequestHandler();

    @NotNull
    public RequestConverter<RequestType> getRequestConverter();

    default public boolean getNeedsScheme() {
        return false;
    }

    @NotNull
    default public List<String> getSupportedSchemes() {
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u001a2\u0006\u0010\u001e\u001a\u00020\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/httpClient/execution/common/RequestExecutionSupport$All;", "", "<init>", "()V", "ignoreAssertions", "", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "getEP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "forContext", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "allSupportedMethods", "", "", "project", "Lcom/intellij/openapi/project/Project;", "forMethod", "", "method", "", "forSchema", "schema", "getDefaultScheme", "getDefaultMethod", "scheme", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nRequestExecutionSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestExecutionSupport.kt\ncom/intellij/httpClient/execution/common/RequestExecutionSupport$All\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n774#2:175\n865#2,2:176\n1557#2:178\n1628#2,3:179\n774#2:182\n865#2,2:183\n774#2:185\n865#2,2:186\n1#3:188\n15#4:189\n*S KotlinDebug\n*F\n+ 1 RequestExecutionSupport.kt\ncom/intellij/httpClient/execution/common/RequestExecutionSupport$All\n*L\n51#1:175\n51#1:176,2\n59#1:178\n59#1:179,3\n75#1:182\n75#1:183,2\n80#1:185\n80#1:186,2\n38#1:189\n*E\n"})
    public static final class All {
        static final /* synthetic */ All $$INSTANCE;
        private static volatile boolean ignoreAssertions;
        @ApiStatus.Internal
        @NotNull
        private static final ExtensionPointName<RequestExecutionSupport<?>> EP_NAME;
        @NotNull
        private static final Logger LOG;

        private All() {
        }

        @NotNull
        public final ExtensionPointName<RequestExecutionSupport<?>> getEP_NAME() {
            return EP_NAME;
        }

        @IntellijInternalApi
        public static /* synthetic */ void getEP_NAME$annotations() {
        }

        @IntellijInternalApi
        @TestOnly
        public final void ignoreAssertions(@NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            ignoreAssertions = true;
            Disposer.register((Disposable)disposable, All::ignoreAssertions$lambda$0);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final RequestExecutionSupport<?> forContext(@NotNull RequestContext requestContext) {
            RequestExecutionSupport it;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
            Iterable $this$filter$iv = EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (RequestExecutionSupport)element$iv$iv;
                boolean bl = false;
                if (!it.canProcess(requestContext)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List executionSupports = (List)destination$iv$iv;
            if (executionSupports.isEmpty()) {
                LOG.info("No suitable execution support is available for given context: " + requestContext);
            }
            if (!ignoreAssertions) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$filter$iv = executionSupports;
                RequestContext requestContext2 = requestContext;
                boolean bl = executionSupports.size() <= 1;
                Logger logger = LOG;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (RequestExecutionSupport)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getClass().getName());
                }
                collection = (List)destination$iv$iv;
                logger.assertTrue(bl, (Object)("Ambiguous context " + requestContext2 + ", too many suitable execution supports: " + (List)collection));
            }
            return (RequestExecutionSupport)CollectionsKt.firstOrNull((List)executionSupports);
        }

        @NotNull
        public final Collection<String> allSupportedMethods(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)EP_NAME.getExtensionList()), arg_0 -> All.allSupportedMethods$lambda$3(project, arg_0))));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RequestExecutionSupport<?>> forMethod(@Nullable CharSequence method, @Nullable Project project) {
            void $this$filterTo$iv$iv;
            if (method == null) {
                return CollectionsKt.emptyList();
            }
            String strMethod = ((Object)method).toString();
            Iterable $this$filter$iv = EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RequestExecutionSupport it = (RequestExecutionSupport)element$iv$iv;
                boolean bl = false;
                if (!it.supportedMethods(project).contains(strMethod)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List forMethod$default(All all, CharSequence charSequence, Project project, int n, Object object) {
            if ((n & 2) != 0) {
                project = null;
            }
            return all.forMethod(charSequence, project);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RequestExecutionSupport<?>> forSchema(@NotNull String schema) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Iterable $this$filter$iv = EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RequestExecutionSupport executor = (RequestExecutionSupport)element$iv$iv;
                boolean bl = false;
                if (!executor.getSupportedSchemes().contains(schema)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final String getDefaultScheme(@NotNull String method, @NotNull Project project) {
            Object v2;
            Object v0;
            block5: {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Iterable iterable = EP_NAME.getExtensionList();
                for (Object object : iterable) {
                    RequestExecutionSupport extension = (RequestExecutionSupport)object;
                    boolean bl = false;
                    if (!extension.supportedMethods(project).contains(method)) continue;
                    v0 = object;
                    break block5;
                }
                v0 = null;
            }
            RequestExecutionSupport requestExecutionSupport = v0;
            if (requestExecutionSupport != null) {
                RequestExecutionSupport support = requestExecutionSupport;
                boolean bl = false;
                String string = (String)CollectionsKt.firstOrNull(support.getSupportedSchemes());
                if (string != null) {
                    Object object;
                    Object it = object = string;
                    boolean bl2 = false;
                    v2 = support.getNeedsScheme() ? object : null;
                } else {
                    v2 = null;
                }
            } else {
                v2 = null;
            }
            return v2;
        }

        @Nullable
        public final String getDefaultMethod(@NotNull String scheme, @NotNull Project project) {
            Object object;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Iterable iterable = EP_NAME.getExtensionList();
                for (Object t : iterable) {
                    RequestExecutionSupport it = (RequestExecutionSupport)t;
                    boolean bl = false;
                    if (!it.getSupportedSchemes().contains(scheme)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return (object = (RequestExecutionSupport)v0) != null && (object = object.supportedMethods(project)) != null ? (String)CollectionsKt.firstOrNull((Iterable)((Iterable)object)) : null;
        }

        private static final void ignoreAssertions$lambda$0() {
            ignoreAssertions = true;
        }

        private static final Iterable allSupportedMethods$lambda$3(Project $project, RequestExecutionSupport it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.supportedMethods($project);
        }

        static {
            $$INSTANCE = new All();
            EP_NAME = ExtensionPointName.Companion.create("com.intellij.httpClient.requestExecutionSupport");
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RequestExecutionSupport.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static <RequestType extends CommonClientRequest> Collection<String> supportedMethods(@NotNull RequestExecutionSupport<RequestType> $this, @Nullable Project project) {
            return ((RequestExecutionSupport)$this).supportedMethods(project);
        }

        @Deprecated
        public static <RequestType extends CommonClientRequest> boolean getNeedsScheme(@NotNull RequestExecutionSupport<RequestType> $this) {
            return ((RequestExecutionSupport)$this).getNeedsScheme();
        }

        @Deprecated
        @NotNull
        public static <RequestType extends CommonClientRequest> List<String> getSupportedSchemes(@NotNull RequestExecutionSupport<RequestType> $this) {
            return ((RequestExecutionSupport)$this).getSupportedSchemes();
        }
    }
}

